/* checkenv.m4,v 1.2 2000-02-22 00:23:13-05 rl Exp */

/*************************************************************************
 *                                                                       *
 * checkenv.cmd                                                          *
 * Checks environment variable like %PATH% for non existing directories  *
 * 2000-02-16, Rolf Lochbuehler                                          *
 *                                                                       *
 *************************************************************************/

verbose = 0

parse arg opts
uOpts = translate( opts )

if opts = '' then
  do
  call help
  exit 1
  end
else if (1 = words(uOpts)) & (1 = verify(uOpts,'/-')) then
  env = opts
else
  do
  env = ''
  do while words(uOpts) > 0
    parse var uOpts x uOpts
    select
      when (x = '/H') | (x = '-H') then
        do
        call help
        exit 1
        end
      when (x = '/V') | (x = '-V') then
        verbose = 1
      otherwise
        env = x
    end   /* select */
  end   /* while */
  if (env = '') | (1 \= verify(env,'/-')) then
    do
    say ''
    say '*Error* Invalid arguments'
    call help
    exit 1
    end
  end  

env = strip( env, , '%' )
uEnv = translate( env )

calldir = directory()
call check env, uEnv, verbose
call directory calldir

exit 0


/*************************************************************************
 *                                                                       *
 * check                                                                 *
 * Check entries                                                         *
 *                                                                       *
 *************************************************************************/
check : procedure

  parse arg env, uEnv, verbose

  val = value( env, , 'OS2ENVIRONMENT' )

  if val = '' then
    do
    say ''
    say '*Error* Environment variable %'uEnv'% not found'
    exit 1
    end

  if verbose then
    say 'Checking %'uEnv'%'...
  
  header = 1

  do while length(val) > 0

    parse var val entry ';' val

    if '' = directory(entry) then
      /* No directory */
      do

      if '' = stream(entry,'command','query exists') then
        /* Neither directory nor file */
        do

        if verbose then
          say 'not found:' entry
        else
          do
          if header then
            do
            say 'These directories in %'uEnv'% do not exist:'
            header = 0
            end
          say '  'entry
          end
  
        end
      else
        /* File exists */
        do

        if verbose then
          say '       ok:' entry

        end

      end
    else
      /* Directory exists */
      do

      if verbose then
        say '       ok:' entry

      end

  end

  if header then
    say 'All entries in %'uEnv'% are ok'

  return


/*************************************************************************
 *                                                                       *
 * help()                                                                *
 * Print help text                                                       *
 *                                                                       *
 *************************************************************************/
help : procedure

  say ''
  say 'CheckEnv 1.2, Rolf Lochbuehler <rolf@weitewelt.net>'
  say 'Purpose:'
  say '  Checks environment variables like %PATH% or %CLASSPATH% for non existing'
  say '  entries, i.e. non existing directories or files.'
  say 'Usage:'
  say '  checkenv [/H] | [[/V] Variable]'
  say 'Arguments:'
  say '  (none)     Print this help text, then abort'
  say '  /H         Print this help text, then abort'
  say '  /V         Verbose, show all entries [default: only non existing entries]'
  say '  Variable   Environment variable'
  say 'Example:'
  say '  checkenv /v path'
  say ''

  return

