/* An example of hiding and showing a window
*/

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE

/* =============== Create "Main Window" ================= */
/* First Group is PUSH */
RXTYPE.1 = 'PUSH'

/* Use of a control in this group causes RXDLG to return */
RXFLAGS.1 = 'END'

/* Label */
RXLABEL.1 = 'Hide/Show'

/* TotalControls, ControlsPerLine, WidthOfControls */
RXINFO.1 = '1 1 0'

/* Default */
RXVAL.1 = ''

/* Position */
RXX.1 = 7
RXY.1 = 6

/* Default size and position (also gives us sizing and max button) */
RXWIN1 = ''

RXDLG 1 '"Main Window"' 'RXWIN1' 'NOCLOSE'




/* ================== Create "Child 1" dialog ================== */
/* First Group is TEXT */
RXTYPE.1 = 'TEXT'

/* DEFAULT */
RXFLAGS.1 = ''

/* Phrases */
RXLABEL.1 = 'Hi!'

/* TotalPhrases, PhrasesPerLine, 0 width and between */
RXINFO.1 = '1 1'

/* Default choice for PushButton is nothing */
RXVAL.1 = ''

/* Position */
RXX.1 = 10
RXY.1 = 10

RXWIN2 = '60 60 100 100'
RXDLG 1 '"Child 1"' 'RXWIN2' 'NOCLOSE'

/* Right now it's shown */
shown=1

more:

/* Do user interaction */
RXDLG

/* If the main window, handle it */
IF RXWIND = 'Main Window' THEN DO
   /* Did user click on the CLOSE ICON of Main Window? Exit */
   IF RXID < 0 THEN EXIT

   /* Must be the button. Show\Hide Child */
   IF shown=1 THEN DO
       shown=0
       RXSET '"Child 1"' 'HIDE'
   END
   ELSE DO
       shown=1
       RXSET '"Child 1"' 'SHOW'
   END
END

/* Must be Child's CLOSE ICON. Just hide it */
ELSE DO
   shown=0
   RXSET '"Child 1"' 'HIDE'
END

SIGNAL more

/* ========================== Done ========================== */

FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
