/* rx.h
 * DLL function declarations, structure declarations, and global external variables declarations
 */

/* Error # bases */
#define ERRAPP		      20000
#define DISPLAYLEVEL	 50




/* REXXSPEC Handlers */
typedef VOID (_System _FUNC)();
typedef _FUNC *PFUNC;

/* REXXSPEC Flags */
#define THROWAWAY 0x01 /* Prevent user from selecting/using any control in any window */
#define EXECUTING    0x80 /* A REXX script has been launched with RexxRunScript() and is executing */

/* DLL structure that each app is given */
typedef struct _REXXSPEC
{
    UCHAR * OutStr;	 /* ptr to string buffer that REXX sends us for output (ie, result string). DLL also uses to set Rexx vars */
    UCHAR * InStr;	   /* ptr to string buffer that REXX sends us for input (ie, cmd). DLL also uses it to store parsed args */
    UCHAR * FromStr;	/* ptr to string to be parsed by DLL's parse routines */
    UCHAR * ErrStr;	   /* ptr to error msg that we return to REXX */
    HAB 	Hab;	      /* PM anchor block */
    PFUNC * Handlers;  /* Handle to app's REXX routines */
    UCHAR * Cmds;	/* Ptr to app's REXX commands */
    UCHAR * Prefix;	  /* Ptr to app's prefix for REXX commands */
    HWND     Hwnd;	  /* Main Window */
    HWND     Modal;	  /* Any Modal dialog */
    ULONG    NextDlg;	 /* For linked list of DLGSPEC's */
    ULONG    Device;	   /* Ptr to first DLGDEVSPEC */
    UCHAR * BlockEnd;	/* Ptr to end of Main Window's memory block (ie, after device strings) */
    LONG      ErrNum;	   /* 0 if no error */
    USHORT  DlgID;	   /* ID after last control in Main Window */
    USHORT  ChildID;	  /* ID for child dialogs */
    UCHAR    ErrType;	   /* Whether strings or numbers are returned to script for errors */
    UCHAR    ErrReturn;   /* RXSUBCOM_OK, RXSUBCOM_ERROR, or RXSUBCOM_FAILURE */
    UCHAR    Flags;
    UCHAR    NumDevs;	/* # of DLGDEVSPEC's */
} REXXSPEC;




/* ============== DLL C-app-accessable variables ================ */
extern REXXSPEC RexxSpec;
extern UCHAR	    RexxVersion[16];

/* ================ DLL C-app-callable functions ================= */
extern VOID EXPENTRY	     RexxSkipSpaces(VOID);
extern UCHAR EXPENTRY	  RexxParseArg3(VOID);
extern UCHAR EXPENTRY	  RexxParseArg2(VOID);
extern UCHAR EXPENTRY	  RexxParseArg(VOID);
extern VOID EXPENTRY	     RexxReturnNum(LONG num);
extern UCHAR EXPENTRY	  RexxSetNumVar(UCHAR *var_name, LONG val);
extern UCHAR * EXPENTRY  RexxAppendStem(UCHAR *var_name, UCHAR *buffer, ULONG var_stem);
extern UCHAR EXPENTRY	  RexxFetchStemVar(UCHAR *var_name, ULONG var_stem);
extern UCHAR EXPENTRY	  RexxFetchVar(UCHAR *var_name);
extern UCHAR EXPENTRY	  RexxSetVar(UCHAR *var_name);
extern LONG EXPENTRY	   DlgAsciiToNum(UCHAR *buf, UCHAR **next, UCHAR format);
extern UCHAR * EXPENTRY  DlgNumToAscii(LONG num, UCHAR *buf, UCHAR flag);
extern VOID EXPENTRY	     RexxFree(VOID);
extern ULONG EXPENTRY	  RexxSet(VOID);
extern MRESULT EXPENTRY DlgCheckModal(HWND hwnd, MPARAM mp1);
extern ULONG EXPENTRY	  RexxRunScript(UCHAR *scriptname);
extern VOID EXPENTRY	     DlgErrMsg(ULONG msgNum, ULONG errNum);
extern VOID EXPENTRY	     DlgMsgStr(UCHAR * msg, ULONG errNum, UCHAR severity);
