XYZ_WriteLog:

File  = strip(arg(1));  /* Log-Filename         		*/
What  = strip(arg(2));  /* Text                 		*/
OldTS = strip(arg(3));  /* previous timestamp (ohne '>')  	*/

if What = "TOF" | What = "BOF" | What = "" then RETURN 0;

signal on Error   Name Error;
signal on Failure Name Failure;
signal on Syntax  Name Syntax;

parse Source . . FileSpec;

ok = VRMethod("Application", "GetVar", "YGlob.LogFN.Main.X");

YErrFile = YGlob.LogFN.Main.X;
YPrev_ID = "_Prev";

ok = VRMethod("Application", "GetVar", "INIFile");
LogfLimit  = SysIni(INIFile, "Settings", "LogfLimit"  );	/* hole File-Limit in kilobytes	*/
LogfWrArnd = SysIni(INIFile, "Settings", "LogfWrArnd" );	/* Wraparound requested?	*/

if Datatype(LogfLimit) <> "NUM" then LogfLimit = 0;


/* -------------------------------	*/
/* Ist dieser Log-Level gewnscht?	*/
/* -------------------------------	*/
if File = YGlob.LogFN.Main.X then NOP;	/* Main-X wird immer verarbeitet	     	*/
else;do
   /* Phase-1: Bilden vollstndige Liste der Loglevels lt. Settings:			*/
   LogLevls = translate( SysIni(INIFile, "Settings", "LogLevls" ) );    /* 'Mz Cy Uz'   */
   AddLevls = "";
   do i = 1 to words( LogLevls );
      Class = left(  word(LogLevls,i), 1);
      Levl = right( word(LogLevls,i), 1);
      if Levl = "Y" then AddLevls = AddLevls Class||"X";
      if Levl = "Z" then AddLevls = AddLevls Class||"X" Class||"Y";
   end;
   LogLevls = LogLevls AddLevls
   /* Phase-2: absuchen Liste der Loglevels nach aktuellem:	*/
   parse value File with Name "." Ext;
   Aux = translate( right(Name,2) );	/* 'Mx'			*/
   do i = 1 to words( LogLevls );
     if word(LogLevls,i) = Aux then LEAVE;	/* du sollst es sein		*/
   end;
   if i > words( LogLevls ) then RETURN -1;	/* du warst nicht in der Liste	*/
end;
/* -------------------------------		*/

LogTime = time("LONG");	/* hh:mm:ss.nn0000	*/

parse value LogTime with hhmmss "." uu0000;
if right(uu0000,4) = "0000" then
   Frac = left(uu0000,2);
else
   Frac = uu0000;

Timestamp = hhmmss"."Frac;	/* hh:mm:ss.nn		*/

/* Erzielen hhere Genauigkeit im Selbstbau-Verfahren:	*/

if Timestamp = left(OldTS, length(Timestamp)) then do
   zz = right( OldTS,2 ) +1;
   zz = left("", 2-length(zz), "0") || zz;	/* PadZero(zz,2)	*/
   Timestamp = Timestamp || zz;		/* anfgen lfd. Nr.		*/
end;
else;
   Timestamp = Timestamp || "00";	/* einfach auffllen auf .nn00	*/

What = Timestamp"> "What;

/* ---------------------------			*/
/* Swap-/FileLimit-Verwaltung:			*/
/* ---------------------------			*/
ok = SysFileTree( File, "files.", "F" );
FileSize = word(files.1,3);

if(0) then do /* -------------- leider nok! ---	*/
/* Alternativer Weg um Filesize zu bekommen:	*/
FileSize2 = 0;
hnd = FileOpen( File,"r" );
if hnd > 0 then do
   err = FileGetInfo( hnd, "Info", "SIZE" );
   if err = 0 then
      FileSize2 = Info.0;
   ok  = FileClose( hnd );
end;
if err > 0 | hnd = 0 then
   Call XSay "Error retrieving filesize of '"File"' hnd="hnd",err="err"!", "ERR";
/* nimm die grssere der beiden Filesizes:	*/
FileSize = max(FileSize,FileSize2);
end; /* -------------- leider nok! ----------	*/

if(0) then say "FileSize, (LogfLimit*1024)="FileSize", "||LogfLimit*1024||"("File")";

if FileSize > (LogfLimit*1024) & LogfLimit > 0 then do
   /* ---------------------------		*/
   /* Logfile Size Limit reached:		*/
   /* ---------------------------		*/
   if LogfWrArnd = "1" then do
      Posi = Lastpos(".",File);
      Aux = left(File,Posi-1);	/* exkl. '.'	*/
      FType = right(File, length(File)-Posi);
      PrevFileSpec = Aux||YPrev_ID||"."FType;
      ok = stream(File,"c","close");
      if left(ok,6) <> "READY:" & ok <> "" then Call XSay "Error closing '"File"', ok="ok"!", "ERR";
      else;do
         /* erst alte Prev-Datei lschen:	*/
         ok = SysFileDelete(PrevFileSpec);
         if ok = 0 | ok = 2 then do	/* 2: file not found	*/
            /* Datei wurde gelscht:	*/
            err = FileMoveFile(File,PrevFileSpec);
            if err <> 0 then do
               Txt="(unknown code="err")";
               if err =   2 then Txt="File not found";
               if err =   3 then Txt="Path not found";
               if err =   5 then Txt="Access denied";
               if err =  32 then Txt="Sharing violation";
               if err = 112 then Txt="Disk is full";
               if err = 206 then Txt="Filename too long";
	       Call XSay "Error renaming '"File"'->'"PrevFileSpec"': "||Txt, "ERR";
            end;
            else;do
               Call XSay "Actual Logfile "File" copied to "PrevFileSpec".", "MSG";
            end;
         end;
         else;
            Call XSay "Error deleting previous logfile '"PrevFileSpec"', code="ok"!", "ERR";
      end;
   end;
   else;
      ok = SysFileDelete(File);

end;

/* ------------------------------	*/
/* Ist ein neuer Tag?			*/
/* ------------------------------	*/
if OldTS = "" | left(OldTS,8) > left(What,8) then	/* vrgl. nur hh:mm:ss	*/
   ok = LineOut( File, left(time("LONG"),13) "New Date="date("S") );

ok = LineOut(File, What);

return strip( word(What,1),"T",">");	/* Rckgabe des aktuellen Timestamp	*/

---------------------------------
Error:
Failure:
Syntax:
	signal off Error;
	signal off Failure;
	signal off Syntax;
	Call XSay ,
	     left(time("LONG"),11)||": Program interrupt in "FileSpec" on line "SIGL"=>"sourceline(sigl)"<=", "ERR";
	return o;

---------------------------------
XSay: procedure Expose YErrFile
What  = strip(arg(1));
Type  = strip(arg(2));

if Type = "" then Type = "---";

What = left(time("LONG"),11)||"- LOG"Type": "What;

ok = LineOut(YErrFile, What);

return ok;
