/* $Id: Configure.cmd,v 1.1.1.1 2003/07/02 13:56:04 eleph Exp $
 *
 * Configuration script.
 * Generates global makefile.inc.
 *
 * (C) 2000-2002 InnoTek Systemberatung GmbH
 *
 */
    call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
    call SysLoadFuncs;

    /* check for silent argument */
    parse arg fNonInteractive
    if (fNonInteractive <> '') then
        fInteractive = 0;
    else
        fInteractive = 1;

    /* strings */
    sIncFile='..\Makefile.inc';

    /* Status */
    if (fInteractive) then
        say 'Configuring the ALSA driver make system...';


    /* delete old makefile.inc file */
    call SysFileDelete sIncFile;

    /* open target file */
    if (stream(sIncFile, 'c', 'open write' ) <> '') then
    do
        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '# Generated by 'directory()'\configure.cmd'
        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, ''
        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '# ALSA basedirectories'
        call lineout sIncFile, '# Note! These should be absolute paths!'
        call lineout sIncFile, '################################################################################'
        sAlsaBase = directory();
        call lineout sIncFile, 'ALSA_BASE      =' sAlsaBase;
        call lineout sIncFile, 'ALSA_SRC       =' sAlsaBase'\src';
        call lineout sIncFile, 'ALSA_LIB_      =' sAlsaBase'\lib';
        call lineout sIncFile, 'ALSA_BIN_      =' sAlsaBase'\bin';
        call lineout sIncFile, '!ifdef 32BIT'
        call lineout sIncFile, 'ALSA_INCLUDE   =' sAlsaBase'\include';
        call lineout sIncFile, 'ALSA_TOOLS     =' sAlsaBase'\tools';
        call lineout sIncFile, '!else'
        call lineout sIncFile, 'ALSA_INCLUDE   =' sAlsaBase'\OCO\include';
        call lineout sIncFile, 'ALSA_TOOLS     =' sAlsaBase'\OCO\tools';
        call lineout sIncFile, '!endif'
        call lineout sIncFile, ''
        say 'Enter DDK base directory (e.g. c:\ddk\base)';
        sDDKPath = linein();
        call lineout sIncFile, 'DDK_BASE       =' sDDKPath;

        say 'Enter Watcom directory (e.g. c:\watcom)';
        sWatcomPath = linein();
        call lineout sIncFile, 'WATCOM         =' sWatcomPath;

        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '# Include the right watcom makefile'
        call lineout sIncFile, '################################################################################'
        call lineout sIncFile, '!ifdef 32BIT'
        call lineout sIncFile, '!include 'sAlsaBase'\include\watcom32.mk'
        call lineout sIncFile, '!include 'sAlsaBase'\include\watcom32.mak'
        call lineout sIncFile, '!else'
        call lineout sIncFile, '!include 'sAlsaBase'\OCO\include\watcom16.mk'
        call lineout sIncFile, '!include 'sAlsaBase'\OCO\include\watcom16.mak'
        call lineout sIncFile, '!endif'
        call lineout sIncFile, ''

        call lineout sIncFile, ''

        call stream sIncFile, 'c', 'close';


        call directory(sOldDir);


        /*
         * Display start info.
         */
        if (fInteractive = 1) then
        do
            say 'Configuration completed!'
            say ''
            say 'To build the ALSA driver do:'
            say '   WMAKE -f makefile.os2 /ms'
        end
    end
    else
    do
        say 'oops, failed to open outputfile,' sIncFile;
        exit 1;
    end
    exit 0;



/*****************/
/* function area */
/*****************/


/**
 * SearchPaths
 * Parameters:
 *   Takes pair of <envionment variable name> and <filename> as parameters
 *   As final optional parameter you may specify a question to request the string from the user.
 * Returns:
 *   sPath-sFile ignoring '..\'s in sFile.
 */
SearchPaths: procedure expose fInteractive;
    i = 1;
    sEnv  = arg(i);
    sFile = arg(i+1);
    sPath = '';
    do while (sPath == '' & sEnv <> '' & sFile <> '')
        sPath = SysSearchPath(sEnv, sFile);
        /* debug: say 'sEnv:'sEnv 'sFile:'sFile 'sPath:'sPath 'i:'i */
        i = i + 2;
        sEnv  = arg(i);
        sFile = arg(i+1);
    end

    if (sPath == '' & sEnv <> '' & sFile == '') then
    do
        say sEnv;
        if (fInteractive = 1) then
            sPath = linein();
        else
            say '!ignored!';
    end
    else
    do
        if sPath <> '' then do
            /*  */
            i = lastpos('..\', sFile);
            if i <> 0 then
                sFile = substr(sFile, i + 2);

            /* cut equally */
            i = lastpos(sFile, sPath);
            if i == 0 then
                say '!error! sFile:'sFile  'sPath:'sPath;
            /* debug: say 'sPath:'sPath  'sFile:'sFile */
            sPath = substr(sPath, 1, i-1);
        end
    end

    return sPath;
