/*
 * $Source: d:/source/driver/perf/RCS/scsiopt.c,v $
 * $Revision: 1.3 $
 * $Date: 1998/02/15 13:29:55 $
 * $Locker:  $
 *
 * Displays messages from SCSIOpt.flt.
 *
 * Compile with...
 * IBM CSet++ 2.1	- icc -Q -W2all -O [-Gd] dperf.c
 * IBM VAC++ 3.00	- icc -Q -W2all -O [-Gd] dperf.c
 * GNU C 2.7.*		- gcc -Wall -O3 [-Zcrtdll] dperf.c
 * WatCom C/C++ 10.5	- wcl386 -zq -bt=os2v2 -3s -wx -oax dperf.c
 *
 * $Log: scsiopt.c,v $
 * Revision 1.3  1998/02/15 13:29:55  vitus
 * - corrected name of filter driver
 *
 * Revision 1.2  1997/12/16 02:49:46  vitus
 * - renamed source files
 * - renamed driver
 *
 * Revision 1.1  1997/12/11 01:55:35  vitus
 * Initial revision
 *
 */
static char const id[]="$Id: scsiopt.c,v 1.3 1998/02/15 13:29:55 vitus Exp $";

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define INCL_DOS
#include <os2.h>

#include "scsioptpub.h"




#define DEVICENAME	"SCSIOPT$"		/* SCSIOpt.flt is actual... */

#define MODE_MESSAGE	2


/*
 * Global variables
 */
char	szPrgName[_MAX_PATH];
char	fVerbose = 0;
char	fMode = MODE_MESSAGE;



void
usage(void)
{
    printf("usage: %s [-?]\n", szPrgName);
}
void
help(void)
{
    usage();
    printf("\nDisplays messages generated by SCSIOpt.flt\n");
}




void
DumpBuffer(PUCHAR buf,size_t siz)
{
    for(; siz; --siz, ++buf )
	printf(" %02x", *buf);
}




/*#
 * NAME
 *	DisplayVersion
 * CALL
 *	DisplayVersion(hd)
 * PARAMETER
 *	hd		handle to open device
 * RETURNS
 *	OS error code
 * GLOBAL
 *	none
 * DESPRIPTION
 *	Displays driver version.
 * REMARKS
 */
int
DisplayVersion(HFILE hd)
{
    APIRET		rc;
    DSKPF_VER_DATA	data;
    ULONG		datasize;

    do
    {
	datasize = sizeof(data);
	rc = DosDevIOCtl(hd, IOCTL_DSKPERF_CATEGORY, DSKPF_QUERY_VERSION,
			 NULL, 0, NULL, &data, datasize, &datasize);
	if( rc )
	{
	    fprintf(stderr, "DSKPF_QUERY_VERSION - error %lu\n", rc);
	    break;
	}

	printf("Installed: SCSIOPT.FLT %u.%02u\n",
	       HIBYTE(data.version), LOBYTE(data.version));
    }
    while( 0 );

    return (int)rc;
}




/*#
 * NAME
 *	DisplayMessages
 * CALL
 *	DisplayMessages(hd)
 * PARAMETER
 *	hd		handle to open device
 * RETURNS
 *	OS error code
 * GLOBAL
 *	none
 * DESPRIPTION
 *	Displays messages saved during driver startup.
 * REMARKS
 */
int
DisplayMessages(HFILE hd)
{
    APIRET	rc;
    USHORT	cb = 0;				/* keep compiler happy */
    unsigned	i;
    ULONG	datasize;
    DSKPF_MSGS_DATA * data = NULL;

    do
    {
	/* First: read size of stored messages */

	datasize = sizeof(cb);
	rc = DosDevIOCtl(hd, IOCTL_DSKPERF_CATEGORY, DSKPF_READ_MSGS,
			 NULL, 0, NULL, &cb, datasize, &datasize);
	if( rc )
	{
	    fprintf(stderr, "DSKPF_READ_MSGS - error %lu\n", rc);
	    break;
	}

	/* Second: allocate buffer big enough to hold
	 * those messages (but not a single byte more) */

	datasize = FIELDOFFSET(DSKPF_MSGS_DATA,msg) + (ULONG)cb;
	data = malloc(datasize);
	if( data == NULL )
	{
	    fprintf(stderr, "out of memory\n");
	    rc = (APIRET)-3;
	    break;
	}

	/* Third: read and display messages */

	rc = DosDevIOCtl(hd, IOCTL_DSKPERF_CATEGORY, DSKPF_READ_MSGS,
			 NULL, 0, NULL, data, datasize, &datasize);
	if( rc )
	{
	    fprintf(stderr, "DSKPF_READ_MSGS - error %lu\n", rc);
	    break;
	}

	printf("------------------------------"
	       "------------------------------\n");
	for( i = 0;
	    i < data->cb - FIELDOFFSET(DSKPF_MSGS_DATA,msg);
	    i += strlen(&data->msg[i])+1 )
	{
	    printf("%s\n", &data->msg[i]);
	}
	printf("------------------------------"
	       "------------------------------\n");
    }
    while( 0 );

    if( data != NULL )
	free(data);
    return (int)rc;
}




/*#
 * NAME
 *	main
 * CALL
 *	main(argc,argv)
 * PARAMETER
 *	argc,argv	as usual
 * RETURNS
 *	0		OK
 *	/0		some error
 * GLOBAL
 *	szPrgName, fVerbose
 * DESPRIPTION
 *	Main routine, parses parameter and calls requested
 *	subfunctions.
 * REMARKS
 */
int
main(int argc,char *argv[])
{
    HFILE	hd = 0;
    ULONG	action_taken;
    APIRET	rc;
    int		result;

    strcpy(szPrgName, argv[0]);
    while( argc > 1  &&  argv[1][0] == '-' )
    {
	switch( argv[1][1] )
	{
	  case '?':
	    help();
	    return 0;

	  case 'v':
	    fVerbose = 1;
	    break;

	  default:
	    fprintf(stderr, "%s: unknown arg \"%s\"\n", szPrgName, argv[1]);
	    return -1;
	}
	--argc;
	++argv;
    }

    /* Open device driver, no special settings.  Use DENYNONE
     * so other processes (daemon?) may open concurrently. */

    rc = DosOpen(DEVICENAME, &hd, &action_taken,
		 0, 0,
		 OPEN_ACTION_FAIL_IF_NEW|OPEN_ACTION_OPEN_IF_EXISTS,
		 OPEN_SHARE_DENYNONE|OPEN_ACCESS_READWRITE,
		 NULL);
    if( rc )
    {
	fprintf(stderr, "DosOpen(%s) - error %lu\n", DEVICENAME, rc);
	return (int)rc;
    }

    DisplayVersion(hd);				/* always display version */
    switch( fMode )
    {
      case MODE_MESSAGE:
	if( argc != 1 )
	{
	    fprintf(stderr, "argument count error\n");
	    result = -1;
	}
	else
	    result = DisplayMessages(hd);
	break;

      default:
	result = -1;
	break;
    }

    DosClose(hd);				/* be a nice guy */

    return result;
}
