/***************************************************************************\
 *
 * PROGRAMMNAME: AMOUDLL
 * -------------
 *
 * VERSION: 2.70
 * --------
 *
 * MODULNAME: AMOUHWND
 * ----------
 *
 * BESCHREIBUNG:
 * -------------
 *   This DLL is registered at the OS/2 Presentation Manager. It starts
 *   the WheelThread after establishing the semaphores and shared memory
 *   necessary for communication with the WPS class
 *
 * FUNKTIONEN:
 * -----------
 *
 *
 *
 *
 *  Ver.    Date      Comment
 *  ----    --------  -------
 *  1.00    20-02-00  First release
 *  2.00    06-16-01  WheelThread in separate process
 *  2.10    05-12-02  Handling of shift-keys
 *  2.20    10-03-02  USB support added
 *  2.40    02-01-03  support for 2 wheels; wildcards for process name
 *  2.50    04-20-03  application behaviour support added; memory leak removed
 *  2.60    06-13-04  remove unused settings pages from mouse object
 *  2.70    10-23-04  support for 7 buttons added
 *
 *  Copyright (C) noller & breining software 2001...2004
 *
\******************************************************************************/
#define INCL_DOSSEMAPHORES
#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#include <os2.h>

#include <malloc.h>
#include <memory.h>

#include <Log.h>
#include "AMouData.h"

/*******************************************************************\
  local data segment (process specific)
\*******************************************************************/
PARHWND parHwnd = NULL;

/*******************************************************************\
  global data segment
\*******************************************************************/
#pragma data_seg(GLOBAL_SEG)

PWINDOWDATA findWindowPtr (HWND hwnd)
    {
    PWINDOWDATA pWindowData;
    LONG    l;
    BOOL    bRC = FALSE;

    if (parHwnd == NULL)
        return NULL;

    pWindowData = parHwnd->arWindow;

    // search for empty entry and insert new window handle
    for (l = 0; l < parHwnd->ulcHwnd; l++)
        {
        if (pWindowData[l].hwnd == hwnd)
            return &(pWindowData[l]);
        }

    return NULL;
    }

BOOL findWindowHandle (HWND hwnd, PULONG pflWindow)
    {
    PWINDOWDATA pWindow = findWindowPtr (hwnd);

    if (pWindow)
        *pflWindow = pWindow->flWindow;

    return (pWindow == NULL ? FALSE : TRUE);
    }

BOOL removeWindowHandle (HWND hwnd)
    {
    PWINDOWDATA pWindow = findWindowPtr (hwnd);

    if (pWindow)
        {
        if (parHwnd->ulcHwnd == 1)
            {
            DebugE ("removeWindowHandle", "remove memory array");
            free (parHwnd);
            parHwnd = NULL;
            }
        else
            {
            DebugUL ("removeWindowHandle", "copy size", sizeof (ARHWND) + sizeof (WINDOWDATA) * (parHwnd->ulcHwnd - 1) - ((PBYTE)pWindow - (PBYTE)parHwnd));
            memmove (pWindow,
                     pWindow + 1,
                     sizeof (ARHWND) + sizeof (WINDOWDATA) * (parHwnd->ulcHwnd - 1) - ((PBYTE)pWindow - (PBYTE)parHwnd));
            parHwnd->ulcHwnd--;
            }
        return TRUE;
        }

    return FALSE;
    }

/*******************************************************************\
    addWindowHandle: adds a window handle to a registration list
                     of windows, that will receive WM_MOUSEWHEEL-
                     messages. The list is a linked list of
                     4k-pages, that contain the window handles.
                     empty entries contain NULLHANDLE
                     (HWND_DESKTOP never registers for this messages).
    Input:  hwnd: window to be registered
    Return: TRUE, if successful
\*******************************************************************/
BOOL addWindowHandle (HWND hwnd, ULONG flWindow)
    {
    PARHWND pHwndArray;
    PHWND   pHwnd;
    LONG    l;
    PID     pid;
    TID     tid;
    PPIB    ppib = NULL;

    DebugE ("addWindowHandle", "Entry");

    // is hwnd valid window handle? Window must have been created by current process
    if (hwnd == NULLHANDLE)
        return FALSE;
    DebugE ("addWindowHandle", "WinIsWindow");
    if (WinIsWindow (hab, hwnd) == FALSE)
        return FALSE;
    DebugE ("addWindowHandle", "WinQueryWindowProcess");
    if (WinQueryWindowProcess (hwnd, &pid, &tid) == FALSE)
        return FALSE;
    DebugE ("addWindowHandle", "DosGetInfoBlocks");
    DosGetInfoBlocks (NULL, &ppib);
    if (ppib->pib_ulpid != pid)
        return FALSE;

    DebugE ("addWindowHandle", "Allocate memory");

    // see if array is allocated; allocate, if not
    if (parHwnd == NULL)
        {
        DebugE ("addWindowHandle", "NULL");
        switch (_heapchk ())
            {
            case _HEAPBADBEGIN:
                DebugE ("addWindowHandle", "_HEAPBADBEGIN");
                break;
            case _HEAPBADNODE:
                DebugE ("addWindowHandle", "_HEAPBADNODE");
                break;
            case _HEAPEMPTY:
                DebugE ("addWindowHandle", "_HEAPEMPTY");
                break;
            case _HEAPOK:
                DebugE ("addWindowHandle", "_HEAPOK");
                break;
            default:
                DebugE ("addWindowHandle", "other");
            }

        parHwnd = malloc (sizeof (ARHWND));
        DebugUL ("addWindowHandle", "pointer = ", parHwnd);
        if (parHwnd == NULL)
            return FALSE;
        DebugE ("addWindowHandle", "set to 1");
        parHwnd->ulcHwnd = 1;
        }
    else
        {
        DebugE ("addWindowHandle", "not NULL");
        // is hwnd alread in list?
        if (findWindowPtr (hwnd))
            return FALSE;

        // add new entry to end of array
        parHwnd = realloc (parHwnd, sizeof (ARHWND) + sizeof (WINDOWDATA) * (parHwnd->ulcHwnd + 1));
        if (parHwnd == NULL)
            return FALSE;
        parHwnd->ulcHwnd++;
        }

    DebugE ("addWindowHandle", "add new entry");

    // insert a new window handle to the end of the array
    parHwnd->arWindow[parHwnd->ulcHwnd - 1].hwnd     = hwnd;
    parHwnd->arWindow[parHwnd->ulcHwnd - 1].flWindow = flWindow;

    return TRUE;
    }


