/*
 * getversion.c		- Get a file version on an ext2 file system
 *
 * Copyright (C) 1993, 1994  Remy Card <card@masi.ibp.fr>
 *                           Laboratoire MASI, Institut Blaise Pascal
 *                           Universite Pierre et Marie Curie (Paris VI)
 *
 * This file can be redistributed under the terms of the GNU Library General
 * Public License
 */

/*
 * History:
 * 93/10/30	- Creation
 */

#if HAVE_ERRNO_H
#include <errno.h>
#endif
#include <sys/ioctl.h>
#ifdef OS2
#include <os2/vfsapi.h>
#endif
#include "e2p.h"

int getversion (int fd, unsigned long * version)
{
#if HAVE_EXT2_IOCTLS
#ifndef OS2
	return ioctl (fd, EXT2_IOC_GETVERSION, version);
#else
	int err, r;
	r = vfs_ioctl (fd, EXT2_OS2_IOCTL_EXT2_IOC_GETVERSION, version, sizeof(int), &err);
	if (r == -1)
	    errno = err;
	return r;
#endif
#else /* ! HAVE_EXT2_IOCTLS */
	extern int errno;
	errno = EOPNOTSUPP;
	return -1;
#endif /* ! HAVE_EXT2_IOCTLS */
}
