/* $Id: requires.c,v 1.1.2.1 2003/02/10 16:54:08 root Exp $ */

/* A helper program to locate the necessary DLLs for packaging */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <os2emx.h>

/* dqhi.h - donated anonymously, courtesy of osFree TPE team */

INT Dos32QueryHeaderInfo(ULONG r1, ULONG r2, PVOID buf, ULONG szbuf, ULONG fnum);

#define DQHI_QUERYLIBPATHSIZE      4
#define DQHI_QUERYLIBPATH          5

/* Retrieves an import module list from an LX file (NULL == none) */

char **get_mods(char *name)
{
 FILE *stream;
 static char buf[12];
 int fetch;
 char **rc, *prc;
 unsigned int i, mcnt=0;
 int l, ppos;
 unsigned long p, ps, pe, pc;

 if((stream=fopen(name, "rb"))==NULL)
  return(NULL);
 if(fread(buf, 1, 2, stream)==2&&!memcmp(buf, "LX", 2))
  p=0;
 else
 {
  fseek(stream, 0x3C, SEEK_SET);
  if(fread(&p, 1, 4, stream)<4)
  {
   fclose(stream);
   return(NULL);
  }
  fseek(stream, p, SEEK_SET);
  if(fread(buf, 1, 2, stream)<2||memcmp(buf, "LX", 2))
  {
   fclose(stream);
   return(NULL);
  }
 }
 /* Acquire the start/end pointers */
 fseek(stream, p+0x70, SEEK_SET);
 fread(&ps, 1, 4, stream);
 fseek(stream, p+0x78, SEEK_SET);
 fread(&pe, 1, 4, stream);
 l=0;
 for(pc=ps; pc<pe; pc+=l+1)
 {
  fseek(stream, p+pc, SEEK_SET);
  l=fgetc(stream);
  mcnt++;
 }
 rc=(char **)malloc(sizeof(char **)*(mcnt+1)+pe-ps+1);
 prc=(char *)rc+sizeof(char **)*(mcnt+1);
 fseek(stream, ps+p, SEEK_SET);
 fread(prc, 1, pe-ps, stream);
 prc[pe-ps]='\0';
 for(i=ppos=0; i<mcnt; i++)
 {
  rc[i]=(char *)prc+ppos+1;
  ppos+=prc[ppos]+1;
  *(rc[i]-1)='\0';
 }
 rc[mcnt]=NULL;
 fclose(stream);
 return(rc);
}

/* LIBPATH lookup */

int libpath_lookup(char *name)
{
 static int reccount=0;
 ULONG pl;
 char *pathptr, *p, *f;
 int i, j;
 char tmp_name[CCHMAXPATH];
 char **dep_dlls;

 if(reccount>128)
  return(1);
 reccount++;
 if(!Dos32QueryHeaderInfo(0, 0, &pl, 4, DQHI_QUERYLIBPATHSIZE)&&
    (pathptr=(char *)malloc(pl+1))!=NULL&&
    !Dos32QueryHeaderInfo(0, 0, pathptr, pl, DQHI_QUERYLIBPATH))
 {
  p=pathptr;
  do
  {
   /* Extract the next pathspec chunk */
   f=strchr(p, ';');
   if(f==NULL)
    i=strlen(p);
   else
    i=f-p;
   if(i>0&&i<CCHMAXPATH)
   {
    memcpy(tmp_name, p, i);
    /* Canonicalize to the DOS specification */
    if(tmp_name[i-1]!='\\'&&tmp_name[i-1]!='/')
     tmp_name[i++]='\\';
    tmp_name[i]='\0';
    strcpy(tmp_name+i, name);
    if(strchr(name, '.')==NULL)
     strcat(tmp_name, ".dll");
    if(!access(tmp_name, 0))
    {
     puts(tmp_name);
     if((dep_dlls=get_mods(tmp_name))!=NULL)
     {
      for(j=0; dep_dlls[j]!=NULL; j++)
       libpath_lookup(dep_dlls[j]);
      free(dep_dlls);
     }
    }
   }
   p=f+1; 
  } while(f!=NULL);
  free(pathptr);
 }
 reccount--;
 return(0);
}

/* Main routine */

int main(int argc, char **argv)
{
 char **pmods;
 int rc=0;
 int i, j;
 char **dep_dlls;

 if(argc<2)
 {
  printf("Usage: %s <filename.ext> [<filename.ext> ...]\n", argv[0]);
  return(1);
 }
 while(--argc>=1)
 {
  if((dep_dlls=get_mods(argv[argc]))!=NULL)
  {
   for(j=0; dep_dlls[j]!=NULL; j++)
    rc+=libpath_lookup(dep_dlls[j]);
   free(dep_dlls);
  }
 }
 return(rc);
}
