/* config2.h --- configuration file for OS/2 EMX
   Thomas Epting <tepting@swol.de> --- Feb 1997  */

/* This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.  */

#ifndef _CONFIG2_H
#define _CONFIG2_H

/* This file lives in the emx/ subdirectory, which is only included
 * in your header search path if you use emx/Makefile (with GNU make
 * for OS/2). Thus, this is the right place to put configuration
 * information for OS/2.
 */
#include <stdio.h>
#include <io.h>
#include <sys/types.h>
#include <sys/stat.h>

/* Under OS/2, filenames are case-insensitive, and both / and \
   are path component separators.  */
#define FOLD_FN_CHAR(c) (OS2_filename_classes[(unsigned char) (c)])
extern unsigned char OS2_filename_classes[];

/* Is the character C a path name separator?  Under OS/2, you can use
   either / or \.  */
#define ISDIRSEP(c) (FOLD_FN_CHAR(c) == '/')

/* Like strcmp, but with the appropriate tweaks for file names.
   Under OS/2, filenames are case-insensitive but case-preserving,
   and both \ and / are path element separators.  */
extern int fncmp (const char *n1, const char *n2);

/* Fold characters in FILENAME to their canonical forms.
   If FOLD_FN_CHAR is not #defined, the system provides a default
   definition for this.  */
extern void fnfold (char *FILENAME);

/* This is where old bits go to die under OS/2 as well as WinNT.  */
#define DEVNULL "nul"

#define START_SERVER os2_start_server
#define SHUTDOWN_SERVER os2_shutdown_server

extern void START_SERVER (int *tofd, int *fromfd,
			  char *client_user,
			  char *server_user,
			  char *server_host,
			  char *server_cvsroot);
extern void SHUTDOWN_SERVER (int fd);

/* Call our own os2_initialize function */
#define SYSTEM_INITIALIZE(pargc,pargv) os2_initialize (pargc, pargv)
extern void os2_initialize (int *pargc, char ***pargv);
#define CONCEALED_PATH
char *get_my_name();

/* Under EMX, we already have popen() and pclose()... */
/* #undef USE_OWN_POPEN */
/* ... and we too have no need for popenRW to start the rsh server. */
/* #define START_RSH_WITH_POPEN_RW */

/* Socket handles and file handles share a command handle space under EMX. */
/* #undef NO_SOCKET_TO_FD */



#define CVS_STAT     os2_stat
#define CVS_CHDIR    os2_chdir
#define CVS_FNMATCH  os2_fnmatch
#define CVS_CHMOD    os2_chmod
#define CVS_RENAME   os2_rename

extern int os2_stat(const char *name, struct stat *buffer);
extern int os2_chdir(const char *name);
extern int os2_fnmatch(const char *pattern, const char *name, int flags);
extern int os2_chmod(const char* name, int mode);
extern int os2_rename(const char* oldname, const char* newname);

/* Pipes need to be put into binary mode using setmode ().  */
#define USE_SETMODE_BINARY 1

/* The reason for this is that we don't know whether to pass -b to
   rsh.  The system-supplied rsh on OS/2 wants it.  Some other rsh
   replacement might not accept it.  Historically, the NT port of CVS
   has not passed -b, and the OS/2 port has.  What a mess.  If we can
   get away with just not accepting :ext: until we can figure out how
   we should deal with this, then it will avoid having people rely on
   behaviors which will need to change.  */
#undef NO_EXT_METHOD

/* See above; we can't use rsh without -b.  */
#define RSH_NOT_TRANSPARENT 1
/* But it won't be transparent unless we ask it nicely! */
#define RSH_NEEDS_BINARY_FLAG 1

#define RSHD_NOT_TRANSPARENT 1

/* See discussion at xchmod in filesubr.c.  */
#undef CHMOD_BROKEN

#define _fileno fileno

#define chdir os2_chdir

#define S_ISBLK(mode) 0

extern int os2_spawnvp (int mode, char const* path, char const* argv[]);
extern FILE* os2_popen (char const* command, char const* mode);

#define SYSTEM_SPAWNVP(mode, path, argv) \
	os2_spawnvp((mode), (path), (char const**)(argv))
#define SYSTEM_POPEN(command, mode) \
	os2_popen((command), (mode))

extern int emx_rmdir (char * path);
#define CVS_RMDIR( path ) emx_rmdir( path )

#ifdef FSEEK_BUG
extern int emx_fseek (FILE *stream, long offset, int origin);
#define FSEEK( fp, offset, from ) emx_fseek( (fp), (offset), (from) )
#endif

/* the number of pending output bytes on stream `fp' */
#define PENDING_OUTPUT_N_BYTES ( fp ? fp->_ptr - fp->_buffer : 0 )

#define ISABSOLUTE(s) (ISDIRSEP(s[0]) || FOLD_FN_CHAR(s[0]) >= 'a' && FOLD_FN_CHAR(s[0]) <= 'z' && s[1] == ':' && ISDIRSEP(s[2]))

#define __GETCWD_PREFIX rpl_

typedef unsigned int uint32_t;
typedef int socklen_t;
typedef int mbstate_t;

#endif
