#ifndef _P9050_LIB_H_
#define _P9050_LIB_H_

#ifdef __KERNEL__
    #include "../../../include/kdstdlib.h"
#endif //__KERNEL__
#include "../../../include/windrvr.h"
#include "../../../samples/shared/pci_regs.h"
#include "../../../samples/shared/bits.h"

#ifdef __cplusplus
extern "C" {
#endif

// PLX register definitions 
enum {
    P9050_LAS0RR  = 0x00,
    P9050_LAS1RR  = 0x04,
    P9050_LAS2RR  = 0x08,
    P9050_LAS3RR  = 0x0c,
    P9050_EROMRR  = 0x10,
    P9050_LAS0BA  = 0x14,
    P9050_LAS1BA  = 0x18,
    P9050_LAS2BA  = 0x1c,
    P9050_LAS3BA  = 0x20,
    P9050_EROMBA  = 0x24,
    P9050_LAS0BRD = 0x28,
    P9050_LAS1BRD = 0x2c,
    P9050_LAS2BRD = 0x30,
    P9050_LAS3BRD = 0x34,
    P9050_EROMBRD = 0x38,
    P9050_CS0BASE = 0x3c,
    P9050_CS1BASE = 0x40,
    P9050_CS2BASE = 0x44,
    P9050_CS3BASE = 0x48,
    P9050_INTCSR  = 0x4c,
    P9050_CNTRL   = 0x50
};

typedef enum
{
    P9050_MODE_BYTE   = 0,
    P9050_MODE_WORD   = 1,
    P9050_MODE_DWORD  = 2
} P9050_MODE;

typedef enum
{
    P9050_ADDR_REG     = AD_PCI_BAR0,
    P9050_ADDR_REG_IO  = AD_PCI_BAR1,
    P9050_ADDR_SPACE0  = AD_PCI_BAR2,
    P9050_ADDR_SPACE1  = AD_PCI_BAR3,
    P9050_ADDR_SPACE2  = AD_PCI_BAR4,
    P9050_ADDR_SPACE3  = AD_PCI_BAR5,
    P9050_ADDR_EPROM   = AD_PCI_BAR_EPROM,
} P9050_ADDR;


enum { P9050_RANGE_REG = 0x00000080 };

typedef struct P9050_STRUCT *P9050_HANDLE;
typedef P9050_HANDLE P9050HANDLE;

typedef struct
{
    DWORD dwCounter;   // number of interrupts received
    DWORD dwLost;      // number of interrupts not yet dealt with
    BOOL fStopped;     // was interrupt disabled during wait
    DWORD dwStatusReg; // value of status register when interrupt occured
} P9050_INT_RESULT;

typedef void (WINAPI *P9050_INT_HANDLER)( P9050_HANDLE hPlx, P9050_INT_RESULT *intResult);

// options for PLX_Open
enum { P9050_OPEN_USE_INT  =   0x1 };
enum { P9050_OPEN_FIX_BIT7 =   0x2 };

DWORD P9050_CountCards (DWORD dwVendorID, DWORD dwDeviceID);
BOOL P9050_Open (P9050_HANDLE *phPlx, DWORD dwVendorID, DWORD dwDeviceID, DWORD nCardNum, DWORD options);
void P9050_Close (P9050_HANDLE hPlx);
BOOL P9050_IsAddrSpaceActive(P9050_HANDLE hPlx, P9050_ADDR addrSpace);
void P9050_GetPciSlot(P9050_HANDLE hPlx, WD_PCI_SLOT *pPciSlot);

void P9050_ReadWriteBlock (P9050_HANDLE hPlx, DWORD dwLocalAddr, PVOID buf, 
                    DWORD dwBytes, BOOL fIsRead, P9050_ADDR addrSpace, P9050_MODE mode);
void P9050_ReadBlock (P9050_HANDLE hPlx, DWORD dwLocalAddr, PVOID buf, 
                    DWORD dwBytes, P9050_ADDR addrSpace, P9050_MODE mode);
void P9050_WriteBlock (P9050_HANDLE hPlx, DWORD dwLocalAddr, PVOID buf, 
                    DWORD dwBytes, P9050_ADDR addrSpace, P9050_MODE mode);
BYTE P9050_ReadByte (P9050_HANDLE hPlx, P9050_ADDR addrSpace, DWORD dwLocalAddr);
void P9050_WriteByte (P9050_HANDLE hPlx, P9050_ADDR addrSpace, DWORD dwLocalAddr, BYTE data);
WORD P9050_ReadWord (P9050_HANDLE hPlx, P9050_ADDR addrSpace, DWORD dwLocalAddr);
void P9050_WriteWord (P9050_HANDLE hPlx, P9050_ADDR addrSpace, DWORD dwLocalAddr, WORD data);
DWORD P9050_ReadDWord (P9050_HANDLE hPlx, P9050_ADDR addrSpace, DWORD dwLocalAddr);
void P9050_WriteDWord (P9050_HANDLE hPlx, P9050_ADDR addrSpace, DWORD dwLocalAddr, DWORD data);

void P9050_ReadWriteSpaceBlock (P9050_HANDLE hPlx, DWORD dwOffset, PVOID buf, 
                    DWORD dwBytes, BOOL fIsRead, P9050_ADDR addrSpace, P9050_MODE mode);
void P9050_ReadSpaceBlock (P9050_HANDLE hPlx, DWORD dwOffset, PVOID buf, 
                    DWORD dwBytes, P9050_ADDR addrSpace, P9050_MODE mode);
void P9050_WriteSpaceBlock (P9050_HANDLE hPlx, DWORD dwOffset, PVOID buf, 
                    DWORD dwBytes, P9050_ADDR addrSpace, P9050_MODE mode);
BYTE P9050_ReadSpaceByte (P9050_HANDLE hPlx, P9050_ADDR addrSpace, DWORD dwOffset);
void P9050_WriteSpaceByte (P9050_HANDLE hPlx, P9050_ADDR addrSpace, DWORD dwOffset, BYTE data);
WORD P9050_ReadSpaceWord (P9050_HANDLE hPlx, P9050_ADDR addrSpace, DWORD dwOffset);
void P9050_WriteSpaceWord (P9050_HANDLE hPlx, P9050_ADDR addrSpace, DWORD dwOffset, WORD data);
DWORD P9050_ReadSpaceDWord (P9050_HANDLE hPlx, P9050_ADDR addrSpace, DWORD dwOffset);
void P9050_WriteSpaceDWord (P9050_HANDLE hPlx, P9050_ADDR addrSpace, DWORD dwOffset, DWORD data);

BOOL P9050_IntIsEnabled (P9050_HANDLE hPlx);
BOOL P9050_IntEnable (P9050_HANDLE hPlx, P9050_INT_HANDLER funcIntHandler);
void P9050_IntDisable (P9050_HANDLE hPlx);

DWORD P9050_ReadReg (P9050_HANDLE hPlx, DWORD dwReg);
void P9050_WriteReg (P9050_HANDLE hPlx, DWORD dwReg, DWORD dwData);

BOOL P9050_EEPROMReadWord(P9050_HANDLE hPlx, DWORD dwOffset, PWORD pwData);
BOOL P9050_EEPROMWriteWord(P9050_HANDLE hPlx, DWORD dwOffset, WORD wData);
BOOL P9050_EEPROMReadDWord(P9050_HANDLE hPlx, DWORD dwOffset, PDWORD pdwData);
BOOL P9050_EEPROMWriteDWord(P9050_HANDLE hPlx, DWORD dwOffset, DWORD dwData);
BOOL P9050_EEPROMValid(P9050_HANDLE hPlx);

DWORD P9050_ReadPCIReg(P9050_HANDLE hPlx, DWORD dwReg);
void P9050_WritePCIReg(P9050_HANDLE hPlx, DWORD dwReg, DWORD dwData);

// this string is set to an error message, if one occurs
extern CHAR P9050_ErrorString[];

#ifdef __cplusplus
}
#endif

#endif
