/* internal.c */

/* Perform internal checks. */

#include <stdio.h>
#include <limits.h>
#include <sys/builtin.h>        /* For <sys/fmutex.h> */
#include <sys/fmutex.h>
#include <sys/rmutex.h>
#include <sys/smutex.h>
#include <emx/thread.h>
#include <emx/time.h>


static int result;


static void check (const char *what, unsigned actual, unsigned correct)
{
  if (actual != correct)
    {
      printf ("%s is %u, should be %u\n", what, actual, correct);
      result = 1;
    }
}

#define CHECK(WHAT,CORRECT) check (#WHAT, WHAT, CORRECT)


int main (void)
{
  result = 0;

  /* Changing the size or layout of struct _FILE breaks dynamically
     linked programs which use stdin, stdout, or stderr. */

  CHECK (sizeof (struct _FILE), 48);

  /* struct _thread should fit into one page. */

  CHECK (sizeof (struct _thread), 4096);

  /* Changing these values breaks dynamically linked programs which
     use <sys/fmutex.h>. */

  CHECK (_FMS_UNINIT, 0);
  CHECK (_FMS_AVAILABLE, 1);
  CHECK (_FMS_OWNED_SIMPLE, 2);
  CHECK (_FMS_OWNED_HARD, 3);

  /* The size of types which can be used for objects (ie, not for
     pointers only) must not change. */

  CHECK (sizeof (_smutex), 1);
  CHECK (sizeof (_fmutex), 5);
  CHECK (sizeof (_rmutex), 16);

  CHECK (_year_day[_YEARS], INT_MAX);

  return result;
}
