/* call2.c (emx+gcc) */

/* Regression test for calling conventions. */

#ifdef ATTR1
#define CALL1 __attribute__((ATTR1))
#else
#define CALL1
#endif

#define CALL2 __attribute__((__emxcall__))

struct small
{
  int x, y;
};

struct big
{
  int a[3];
};

struct small s;
struct big b;

extern void CALL2 dummy (const void *);

int CALL1 fun1 (int x)
{
  return x;
}

struct small CALL1 fun2 (int x, int y)
{
  s.x = x;
  s.y = y;
  return s;
}

struct big CALL1 fun3 (int x)
{
  b.a[0] = x;
  return b;
}

int CALL1 fun4 (int x, ...)
{
  return x;
}

struct small CALL1 fun5 (int x, ...)
{
  s.x = x;
  return s;
}

struct big CALL1 fun6 (int x, ...)
{
  b.a[0] = x;
  return b;
}

void CALL2 call1 (void)
{
  int x = fun1 (1);
  dummy (&x);
}

void CALL2 call2 (void)
{
  struct small r = fun2 (1, 2);
  dummy (&r);
}

void CALL2 call3 (void)
{
  struct big r = fun3 (1);
  dummy (&r);
}

void CALL2 call4 (void)
{
  int x = fun4 (1, 2);
  dummy (&x);
}

void CALL2 call5 (void)
{
  struct small r = fun5 (1, 2);
  dummy (&r);
}

void CALL2 call6 (void)
{
  struct big r = fun6 (1, 2);
  dummy (&r);
}

void CALL2 call7 (long long x, long long y)
{
  long long r = x / y;
  dummy (&r);
}
