/* winmgr1.h */

#define FALSE 0
#define TRUE  1

#define WM_USED 0x6d77fa10

struct _wm_window
{
  int used;               /* WM_USED, if this slot is used                 */
  int visible;            /* TRUE, if whole window is visible              */
  int display;            /* open && update_flag                           */
  int update_flag;        /* TRUE, if updating screen immediately          */
  int update_req;         /* TRUE, if screen window has to be updated      */
  int open;               /* TRUE, if window open                          */
  int wrap;               /* TRUE, if end-of-line-wrap is activated        */
  char *data;             /* Window contents                               */
  char *mask;             /* Visible characters of window (FALSE/TRUE)     */
  int masksize;           /* Length of mask array                          */
  int x0, y0, x1, y1;     /* Usable area of window                         */
  int bx0, by0, bx1, by1; /* Whole window including border                 */
  int ax, ay;             /* x0-bx0 and y0-by0 (border width 0 or 1)       */
  int border;             /* Border flag                                   */
  int battr;              /* Border attributes                             */
  int wattr;              /* Window contents attributes                    */
  int x, y;               /* Cursor position                               */
  int width;              /* Window width                                  */
  int height;             /* Window height                                 */
  int bwidth;             /* Window width including border                 */
  int bheight;            /* Window height including border                */
  int c_vis;              /* TRUE: visible cursor, FALSE: invisible cursor */
  int c_start, c_end;     /* Cursor type                                   */
};

extern wm_handle _wm_tab;
extern wm_handle *_wm_idx;

extern char *_wm_screen;
extern char *_wm_line;

extern int _wm_width;
extern int _wm_height;
extern int _wm_count;
extern int _wm_max;
extern int _wm_saved_cstart;
extern int _wm_saved_cend;
extern int _wm_saved_x;
extern int _wm_saved_y;

extern wm_handle _wm_cursor;           /* Window selected by wm_cursor */
extern int _wm_c_hide;                 /* Cursor mode                  */

#define MIN(a,b) ((a) < (b) ? (a) : (b))
#define MAX(a,b) ((a) > (b) ? (a) : (b))

#define DATA(wh,x,y) ((wh)->data[2*((x)+(y)*(wh)->bwidth)])
#define MASK(wh,x,y) ((wh)->mask[(x)+(y)*(wh)->bwidth])

void _wm_puts_len (wm_handle wh, const char *p, int len);

void _wm_cursor1 (void);
void _wm_put1 (wm_handle wh);
void _wm_clrline1 (wm_handle wh, int y, int x0, int x1);
void _wm_clr1 (wm_handle wh);
int  _wm_idx1 (wm_handle wh);
void _wm_unhide1 (wm_handle wh, wm_handle new_wh);
void _wm_copy1 (wm_handle wh, wm_handle old_wh);
void _wm_hide1 (void);
int  _wm_jam1 (wm_handle wh1, wm_handle wh2);
void _wm_store1 (wm_handle wh, int x, int y, char c, int a);
void _wm_line1 (wm_handle wh, int y);
void _wm_hide2 (wm_handle wh1, wm_handle wh2);
void _wm_border1 (wm_handle wh, int title_flag, int title_attr,
    const char *title);
void _wm_allvisible (wm_handle wh);

void _wm_putc2 (char c, int x, int y, int a);
void _wm_puts2 (char *dst, const char *src, int cnt, int a);
void _wm_putsa2 (char *dst, const char *src, int cnt);
void _wm_puta2 (char *dst, int a, int cnt);
void _wm_move2 (char *data, int y, int x0, int x1, int dir);
void _wm_line2 (char *mask, char *data, int y, int x0, int x1);
void _wm_copy2 (char *mask, char *dst, char *src, int width);
void _wm_clrline2 (char *dst, int width, char a);
