/* sys/raise.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#define INCL_DOSEXCEPTIONS
#include <os2emx.h>
#include <string.h>
#include <errno.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int __raise (int signo)
{
  thread_data *tp;

  if (signo < 1 || signo >= NSIG || !_sys_sig_valid[signo])
    {
      errno = EINVAL;
      return -1;
    }
  tp = SYS_THREAD;
  if (tp == NULL)
    {
      errno = EINVAL;
      return -1;
    }
  if (tp->signals[signo].sa_handler != SIG_IGN)
    {
      __sigaddset (&tp->sig_pending, signo);
      _sys_deliver_pending_signals (tp);
    }
  return 0;
}
