/* string.c (emx+gcc) */

/* Regression test for memory and string functions. */

#include <assert.h>
#include <stdio.h>
#include <strings.h>

int main (void)
{
  char buf1[] = "this is a test string";
  char buf2[sizeof (buf1)];
  int i, n;

  n = strlen (buf1);
  assert (n == sizeof (buf1) - 1);
  assert (strcmp ("a", "a") == 0);
  assert (strcmp ("a", "b") < 0);
  assert (strcmp ("b", "a") > 0);
  assert (strcmp ("ab", "ac") < 0);
  assert (strcmp ("xc", "xb") > 0);
  assert (strcmp ("xx", "xxa") < 0);
  assert (strcmp ("xxa", "xx") > 0);
  assert (strcmp ("\xff", "\x01") > 0);
  assert (strcmp ("\xff", "\xfe") > 0);
  assert (strcmp ("\x01", "\xff") < 0);
  assert (strcmp ("\xfe", "\xff") < 0);

  assert (strncmp ("a", "ab", 1) == 0);
  assert (strncmp ("a", "ab", 2) < 0);
  assert (strncmp ("ab", "a", 1) == 0);
  assert (strncmp ("ab", "a", 2) > 0);
  assert (strncmp ("\xff", "\x01", 1) > 0);
  assert (strncmp ("\xff", "\xfe", 1) > 0);
  assert (strncmp ("\x01", "\xff", 1) < 0);
  assert (strncmp ("\xfe", "\xff", 1) < 0);

  assert (memchr (buf1, 'x', n) == NULL);
  assert (memchr (buf1, ' ', 0) == NULL);
  assert (memchr (buf1, 't', n) == buf1);
  assert (memchr (buf1, 't', 0) == NULL);
  assert (memchr (buf1, 'g', n) == buf1+n-1);
  assert (memchr (buf1, 's', 3) == NULL);
  assert (memchr (buf1, 's', 4) == buf1+3);

  assert (strcpy (buf2, buf1) == buf2);

  assert (memmove (buf1+0, buf1+1, n) == buf1+0);
  assert (memcmp (buf1, buf2+1, n) == 0);
  assert (memmove (buf1+1, buf1+0, n) == buf1+1);

  buf1[0] = buf2[0];
  assert (memcmp (buf1, buf2, n+1) == 0);

  assert (_memcount (buf1, 't', strlen (buf1)) == 4);

  assert (memicmp (buf1, "ThIs", 4) == 0);
  assert (memicmp (buf1, "ThIT", 4) < 0);
  assert (memicmp (buf1, "ThIr", 4) > 0);

  assert (strchr (buf1, 'X') == NULL);
  assert (strchr (buf1, 0) == buf1 + n);
  assert (strchr (buf1, 't') == buf1 + 0);
  assert (strchr (buf1, 'a') == buf1 + 8);
  buf1[7] = 0;
  assert (strchr (buf1, 'a') == NULL);
  assert (strchr (buf1 + 7, 0) == buf1 + 7);

  buf1[7] = ' ';
  assert (strrchr (buf1, 'X') == NULL);
  assert (strrchr (buf1, 0) == buf1 + n);
  assert (strrchr (buf1, 'g') == buf1 + n - 1);
  assert (strrchr (buf1, 'a') == buf1 + 8);
  buf1[7] = 0;
  assert (strrchr (buf1, 'a') == NULL);
  buf1[7] = ' ';
  assert (strrchr (buf1, 't') == buf1 + 16);
  buf1[0] = 'X';
  assert (strrchr (buf1, 'X') == buf1);
  assert (strrchr (buf1+1, 'X') == NULL);

  buf1[0] = 't';
  assert (strstr (buf1, "") == buf1);
  assert (strstr (buf1, "x") == NULL);
  assert (strstr (buf1, buf1) == buf1);
  assert (strstr (buf1, "t") == buf1);
  assert (strstr (buf1, "te") == buf1+10);
  assert (strstr (buf1, "ti") == NULL);
  assert (strstr (buf1, "g") == buf1+n-1);

  assert (_memrchr (buf1, 'x', n) == NULL);
  assert (_memrchr (buf1, 't', 0) == NULL);
  assert (_memrchr (buf1, 'g', n) == buf1 + 20);
  assert (_memrchr (buf1, 'n', n) == buf1 + 19);
  assert (_memrchr (buf1, 'i', n) == buf1 + 18);
  assert (_memrchr (buf1, 't', n) == buf1 + 16);
  assert (memcpy (buf2, buf1, sizeof (buf1)) == buf2);
  buf2[0] = 'y';
  assert (_memrchr (buf2, 'y', sizeof (buf2)) == buf2);
  assert (_memrchr (buf2, 'h', sizeof (buf2)) == buf2 + 1);

  strset (buf2, '*');
  _memswap (buf2, buf1, n+1);
  assert (strcmp (buf2, "this is a test string") == 0);
  _memswap (buf2, buf1, n+1);

  memset (buf1, '*', n);
  assert (strcmp (buf1, buf2) == 0);

  assert (memcmp ("a", "b", 1) < 0);
  assert (memcmp ("b", "a", 1) > 0);
  assert (memcmp ("\xff", "\x01", 1) > 0);
  assert (memcmp ("\xff", "\xfe", 1) > 0);
  assert (memcmp ("\x01", "\xff", 1) < 0);
  assert (memcmp ("\xfe", "\xff", 1) < 0);

  assert (ffs (0) == 0);
  assert (ffs (-1) == 1);
  for (i = 0; i < 32; ++i)
    assert (ffs (1 << i) == i + 1);
  assert (ffs (6) == 2);

  assert (_memdif ("a", "b", 0) == _MEMDIF_EQ);
  assert (_memdif ("ab", "xx", 2) == 0);
  assert (_memdif ("ab", "ac", 2) == 1);
  assert (_memdif ("ab", "ab", 2) == _MEMDIF_EQ);

  return 0;
}
