/* ftwtest.c (emx+gcc) */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ftw.h>

static char *pmode (int m)
{
  static char buf[16], *p;
  int i, n;

  switch (m & S_IFMT)
    {
    case S_IFREG:
      buf[0] = ' ';
      break;
    case S_IFDIR:
      buf[0] = 'd';
      break;
    default:
      buf[0] = '?';
      break;
    }
  p = buf+1; n = m & 0777;
  for (i = 0; i < 3; ++i)
    {
      *p++ = (n & S_IREAD  ? 'r' : '-');
      *p++ = (n & S_IWRITE ? 'w' : '-');
      *p++ = (n & S_IEXEC  ? 'x' : '-');
      n <<= 3;
    }
  buf[10] = 0;
  return buf;
}


static int walker (const char *name, const struct stat *st, int flag)
{
  if (flag == FTW_NS)
    printf ("           %s\n", name);
  else
    printf ("%s %s\n", pmode ((int)st->st_mode), name);
  return 0;
}


int main (int argc, char *argv[])
{
  int i, rc;

  for (i = 1; i < argc; ++i)
    {
      rc = ftw (argv[i], walker, 10);
      if (rc < 0)
        {
          perror (argv[i]);
          return 1;
        }
    }
  return 0;
}
