/* sys/sleep.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#define INCL_DOSMISC
#define INCL_DOSPROCESS
#include <os2emx.h>
#include <emx/syscalls.h>
#include "syscalls.h"

unsigned __sleep (unsigned sec)
{
  if (sec == 0)
    {
      DosSleep (0);
      return 0;
    }
  else
    {
      ULONG start, stop, elapsed;

      DosQuerySysInfo (QSV_TIME_LOW, QSV_TIME_LOW, &start, sizeof (start));
      if (DosSleep (1000 * sec) == 0)
        return 0;
      DosQuerySysInfo (QSV_TIME_LOW, QSV_TIME_LOW, &stop, sizeof (stop));
      elapsed = stop - start;
      if (sec < elapsed)
        return 0;
      return sec - elapsed;
    }
}
