/* sys/kill.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#define INCL_DOSEXCEPTIONS
#include <os2emx.h>
#include <errno.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int __kill (int pid, int sig)
{
  ULONG rc;
  ULONG n;

  if (pid == __getpid ())
    {
      if (sig == 0)
        return 0;
      return __raise (sig);
    }
  else if (sig == SIGINT || sig == SIGBREAK)
    {
      if (sig == SIGINT)
        n = XCPT_SIGNAL_INTR;
      else
        n = XCPT_SIGNAL_BREAK;
      rc = DosSendSignalException (pid, n);
      if (rc != 0)
        {
          _sys_set_errno (rc);
          return -1;
        }
      return 0;
    }
  errno = EINVAL;
  return -1;
}
