/* sys/chmod.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include <string.h>
#include <errno.h>
#include <os2emx.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int __chmod (const char *name, int flag, int attr)
{
  ULONG rc;
  FILESTATUS3 info;

  if (flag < 0 || flag > 1)
    {
      errno = EINVAL;
      return -1;
    }
  if ((name[0] == '/' || name[0] == '\\') && strlen (name) >= 6 &&
      memicmp (name+1, "pipe", 4) == 0 && (name[5] == '/' || name[5] == '\\'))
    {
      errno = ENOENT;
      return -1;
    }
  rc = DosQueryPathInfo (name, FIL_STANDARD, &info, sizeof (info));
  if (rc != 0)
    {
      _sys_set_errno (rc);
      return -1;
    }
  if (flag == 0)
    return info.attrFile;
  info.attrFile = attr;
  rc = DosSetPathInfo (name, FIL_STANDARD, &info, sizeof (info), 0);
  if (rc != 0)
    {
      _sys_set_errno (rc);
      return -1;
    }
  return 0;
}
