/* Host-dependent code for emx
   Copyright 1995-1996 Eberhard Mattes.

This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "defs.h"
#include "breakpoint.h"
#include <sys/ioctl.h>


char *
absfname (filename)
     char *filename;
{
  char tmp[512];

  if (_fullpath (tmp, filename, sizeof (tmp)) == 0)
    {
      strlwr (tmp);
      filename = tmp;
    }
  return strsave (filename);
}

char *
tilde_expand (filename)
     char *filename;
{
  return (strsave (filename));
}


char *
append_exe (filename)
     char *filename;
{
  char *p;
  if (_getext (filename) != NULL)
    return NULL;
  p = xmalloc (strlen (filename) + 5);
  strcpy (p, filename);
  strcat (p, ".exe");
  return p;
}

int emx_isatty (int fd)
{
#if 0
  int ht;

  return (ioctl (fd, FGETHTYPE, &ht) >= 0 && ht != HT_FILE);
#else
  return _isterm (fd);
#endif
}


char *getcwd (char *buffer, size_t size)
{
  return _getcwd2 (buffer, size);
}


int chdir (const char *name)
{
  return _chdir2 (name);
}


void emx_host_create_breakpoint_hook (struct breakpoint *bpt)
{
  if (annotation_level > 1)
    printf_filtered ("\n\032\032breakpoint-new %d\n", bpt->number);
}


void
_initialize_emx_host ()
{
  create_breakpoint_hook = emx_host_create_breakpoint_hook;
}
