/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that: (1) source distributions retain this entire copyright
 * notice and comment, and (2) distributions including binaries display
 * the following acknowledgement:  ``This product includes software
 * developed by the University of California, Berkeley and its contributors''
 * in the documentation or other materials provided with the distribution
 * and in all advertising materials mentioning features or use of this
 * software. Neither the name of the University nor the names of its
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#include <sys/time.h>
#include "hertz.h"


#ifdef __MSDOS__
#define HERTZ 18
#endif
#ifdef __EMX__
#include <stdlib.h>
#define HERTZ (_osmode == OS2_MODE ? 1000 : 1024)
#endif

int
hertz ()
{
#ifdef HERTZ
  return HERTZ;
#else
  struct itimerval tim;

  tim.it_interval.tv_sec = 0;
  tim.it_interval.tv_usec = 1;
  tim.it_value.tv_sec = 0;
  tim.it_value.tv_usec = 0;
  setitimer (ITIMER_REAL, &tim, 0);
  setitimer (ITIMER_REAL, 0, &tim);
  if (tim.it_interval.tv_usec < 2)
    {
      return HZ_WRONG;
    }
  return 1000000 / tim.it_interval.tv_usec;
#endif
}
