#define INCL_WIN
#define INCL_GPI
#define INCL_DOSPROCESS

#include <stdio.h>
#include <os2.h>                        /* PM header file               */
#include "footprnt.h"                   /* Resource symbolic identifiers*/
#include "fpdemo.h"                     /* Dialog box symbolic ids      */

#define STRINGLENGTH 64                 /* Length of string             */

/*
 * Function prototypes
 */
MRESULT EXPENTRY MyWindowProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY DlgAboutProc( HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY DlgWelcomeProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY DlgIsUpProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY DlgMonitorProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY DlgTraceProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY DlgIsItOnProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY DlgBit1Proc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY DlgBit2Proc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY DlgBit3Proc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY DlgNoneProc( HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2 );
VOID APIENTRY HSSExit( VOID );
VOID HandleError( char *szErrorMsg );
                                        /* Define parameters by type    */
HAB  hab;                               /* PM anchor block handle       */
PSZ  pszErrMsg;
/*----------------------------------------------------------------
     This is the Footprints Handle.  It is global because all
     modules use this when they make any Footprints calls
 ----------------------------------------------------------------*/
HFPHANDLE hfpFPHandle;

/**************************************************************************
 *
 *  Name       : main()
 *
 *  Description: Initializes the process for OS/2 PM services and
 *               process the application message queue until a
 *               WM_QUIT message is received.  It then destroys all
 *               OS/2 PM resources and terminates.
 *
 *  Concepts   : - obtains anchor block handle and creates message
 *                   queue
 *               - creates the main frame window which creates the
 *                   main client window
 *               - polls the message queue via Get/Dispatch Msg loop
 *               - upon exiting the loop, exits
 *
 *  API's      :   WinInitialize
 *                 WinCreateMsgQueue
 *                 WinTerminate
 *                 WinSetWindowPos
 *                 WinSetWindowText
 *                 WinRegisterClass
 *                 WinCreateStdWindow
 *                 WinGetMsg
 *                 WinDispatchMsg
 *                 WinDestroyWindow
 *                 WinDestroyMsgQueue
 *
 *  Parameters :  [none]
 *
 *  Return     :  1 - if successful execution completed
 *                0 - if error
 *
 *************************************************************************/
INT main (VOID)
{
  HMQ  hmq;                             /* Message queue handle         */
  HWND hwndClient = NULLHANDLE;         /* Client area window handle    */
  HWND hwndFrame = NULLHANDLE;          /* Frame window handle          */
  QMSG qmsg;                            /* Message from message queue   */
  ULONG flCreate;                       /* Window creation control flags*/
  ULONG ulRC;
  APIRET dosRC;
  FILE *fp;

  /*---------------------------
       Initialize Footprints
   ---------------------------*/
  /*+-----------------------------------------------------------------------+
    | The first argument is the process id "Demo".  This name will appear   |
    | in the FP.EXE window as the process name once the demo program is     |
    | started.  The second argument is the address of a Footprints handle.  |
    | This must be passed to any Footprints call made from this program.  It|
    | is this handle that Footprints uses to know what process is calling   |
    | it.                                                                   |
    +-----------------------------------------------------------------------+*/
  if( ulRC = HfpInit( "Demo", &hfpFPHandle )) 
  {
     DosBeep( 600L, 200L );
     fp = fopen( "fpdemo.err", "w" );
     if (fp != NULL ) 
     {
        fprintf( fp, "Initialization error = %d\n", ulRC );
        fclose( fp );
     }
     return( 1 );
  }
  /*-----------------------------------------------------------------------
      Register Exit list - This is a must with Footprints, since in the
      event of a trap, you lose all your traced data - unless you use
      this.  Since a trap is precisely when you want to view your
      Footprints data, it is stupid not to use the Exit list.
  -----------------------------------------------------------------------*/
  if( dosRC = DosExitList( 1, (PFNEXITLIST)HSSExit ))
  {
     HfpTrace( hfpFPHandle, &dosRC, sizeof(dosRC), "Exitlist", 0 );
     HSSExit();
     return( 1 );
  }
  if ((hab = WinInitialize(0)) == 0L) /* Initialize PM     */
  {
     HandleError( "WinInit" );
     DosExit( EXIT_PROCESS, 0 );
  }

  if ((hmq = WinCreateMsgQueue( hab, 0 )) == 0L)/* Create a msg queue */
  {
     HandleError( "WinCMsgQ" );
     DosExit( EXIT_PROCESS, 0 );
  }

  if (!WinRegisterClass(                /* Register window class        */
     hab,                               /* Anchor block handle          */
     (PSZ)"MyWindow",                   /* Window class name            */
     (PFNWP)MyWindowProc,               /* Address of window procedure  */
     CS_SIZEREDRAW,                     /* Class style                  */
     0                                  /* No extra window words        */
     ))
  {
     HandleError( "WinRegCl" );
     DosExit( EXIT_PROCESS, 0 );
  }

   flCreate = FCF_STANDARD &            /* Set frame control flags to   */
             ~FCF_SHELLPOSITION;        /* standard except for shell    */
                                        /* positioning.                 */

  if ((hwndFrame = WinCreateStdWindow(
               HWND_DESKTOP,            /* Desktop window is parent     */
               0,                       /* STD. window styles           */
               &flCreate,               /* Frame control flag           */
               "MyWindow",              /* Client window class name     */
               "",                      /* No window text               */
               0,                       /* No special class style       */
               (HMODULE)0L,             /* Resource is in .EXE file     */
               ID_WINDOW,               /* Frame window identifier      */
               &hwndClient              /* Client window handle         */
               )) == 0L)
  {
     HandleError( "WinCrWin" );
     DosExit( EXIT_PROCESS, 0 );
  }

  WinSetWindowText(hwndFrame, "Footprints Demonstration");

  if (!WinSetWindowPos( hwndFrame,      /* Shows and activates frame    */
                   HWND_TOP,            /* window at position 100, 100, */
                   100, 100, 400, 300,  /* and size 400, 300.           */
                   SWP_SIZE | SWP_MOVE | SWP_ACTIVATE | SWP_SHOW
                 ))
  {
     HandleError( "WiSetPos" );
     DosExit( EXIT_PROCESS, 0 );
  }

/*---------------------------------------------------------------
   Get and dispatch messages from the application message queue
   until WinGetMsg returns FALSE, indicating a WM_QUIT message.
 ---------------------------------------------------------------*/

  while( WinGetMsg( hab, &qmsg, 0L, 0, 0 ) )
    WinDispatchMsg( hab, &qmsg );

  WinDestroyWindow(hwndFrame);           /* Tidy up...                   */
  WinDestroyMsgQueue( hmq );             /* Tidy up...                   */
  WinTerminate( hab );                   /* Terminate the application    */
  DosExit( EXIT_PROCESS, 0 );
} /* End of main */

/**************************************************************************
 *
 *  Name       : MyWindowProc
 *
 *  Description: The window procedure associated with the client area in
 *               the standard frame window. It processes all messages
 *               either sent or posted to the client area, depending on
 *               the message command and parameters.
 *
 *
 *  API's      :   WinLoadString
 *                 WinInvalidateRegion
 *                 WinPostMsg
 *                 WinDefWindowProc
 *                 WinBeginPaint
 *                 GpiSetColor
 *                 GpiSetBackColor
 *                 GpiSetBackMix
 *                 GpiCharStringAt
 *                 WinEndPaint
 *
 *  Parameters :  hwnd = window handle
 *                msg = message code
 *                mp1 = first message parameter
 *                mp2 = second message parameter
 *
 *  Return     :  depends on message sent
 *
 *************************************************************************/
MRESULT EXPENTRY MyWindowProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  ULONG   ulRC;
  HPS     hps;                       /* Presentation Space handle    */
  HBITMAP hbm;
  POINTL  ptl;
  static SHORT cxClient, cyClient;

  switch( msg )
  {
    case WM_COMMAND:
      {
      USHORT command;                   /* WM_COMMAND command value     */

      command = SHORT1FROMMP(mp1);      /* Extract the command value    */
      switch (command)
      {
        case ID_BEGIN:
          if( (ulRC = WinDlgBox( HWND_DESKTOP, hwnd, DlgWelcomeProc, 0L,
                     (ULONG)DLG_WELCOME, NULL)) == DID_ERROR )
          {
           ulRC = WinGetLastError( hab );
           /*+-----------------------------------------------------------+
             | Here is a call to HfpTrace - the arguments in order are:  |
             | hfpFPHandle - Footprints handle for this process          |
             | &ulRC       - The data we are tracing (by address)        |
             | sizeof(ulRC)- Trace 4 bytes of data                       |
             | "DlgBxEr1"  - The label for this trace.  It is unique so  |
             |               when I look at the realtime monitor or the  |
             |               trace file, I will know where this trace    |
             |               was generated, and what it represents       |
             | 0           - The trace id number.  ID zero is always "on"|
             |               This is best used to trace error conditions |
             |               because you don't have to turn on any trace |
             |               bits from the FP.EXE user interface.        |
             |               i.e., this message will always be traced    |
             +-----------------------------------------------------------+*/
           HfpTrace( hfpFPHandle, &ulRC, sizeof(ulRC), "DlgBxEr1", 0 );
          }
          else if( ulRC == BID_OK ) /* user hit OK button */
          {
           if((ulRC = WinDlgBox( HWND_DESKTOP, hwnd, DlgIsUpProc, 0L,
                             (ULONG)DLG_IS_UP, NULL)) == DID_ERROR )
           {
            ulRC = WinGetLastError( hab );
            HfpTrace( hfpFPHandle, &ulRC, sizeof(ulRC), "DlgBxEr2", 0 );
           }
           else if( ulRC == BID_OK ) /* user hit OK button */
           {
            if((ulRC = WinDlgBox( HWND_DESKTOP, hwnd, DlgMonitorProc, 0L,
                              (ULONG)DLG_MONITOR, NULL)) == DID_ERROR )
            {
             ulRC = WinGetLastError( hab );
             HfpTrace( hfpFPHandle, &ulRC, sizeof(ulRC), "DlgBxEr3", 0 );
            }
            else if( ulRC == BID_OK ) /* user hit OK button */
            {
             if((ulRC = WinDlgBox( HWND_DESKTOP, hwnd, DlgTraceProc, 0L,
                                  (ULONG)DLG_TRACE, NULL)) == DID_ERROR )
             {
              ulRC = WinGetLastError( hab );
              HfpTrace( hfpFPHandle, &ulRC, sizeof(ulRC), "DlgBxEr4", 0 );
             }
            }
           }
          }
          break;
        case ID_EXITPROG:
          WinPostMsg( hwnd, WM_QUIT, (MPARAM)0,(MPARAM)0 );/* Cause termination*/
          break;
        case ID_ABOUT:
          if((ulRC = WinDlgBox( HWND_DESKTOP, hwnd, DlgAboutProc, 0L,
                               (ULONG)DLG_ABOUT, NULL)) == DID_ERROR )
          {
             ulRC = WinGetLastError( hab );
             HfpTrace( hfpFPHandle, &ulRC, sizeof(ulRC), "DlgBxEr2", 0 );
          }
          break;
        default:
          return WinDefWindowProc( hwnd, msg, mp1, mp2 );
      }

      break;
      }
    case WM_ERASEBACKGROUND:
      /*
       * Return TRUE to request PM to paint the window background
       * in SYSCLR_WINDOW.
       */
      return (MRESULT)( TRUE );
    case WM_PAINT:
      hps = WinBeginPaint( hwnd, 0L, NULL );
      GpiErase( hps );
      /* load the bare feet bitmap */
      hbm = GpiLoadBitmap( hps, 0, BMP_BIGFOOTS, (LONG)cxClient,
                           (LONG)cyClient );
      if( hbm )
      {
         ptl.x = 0; ptl.y = 0;             /* Set the text coordinates,    */
         WinDrawBitmap( hps, hbm, 0, &ptl, CLR_NEUTRAL, CLR_BACKGROUND,
                        DBM_NORMAL);
         GpiDeleteBitmap( hbm );
      }
      WinEndPaint( hps );                      /* Drawing is complete   */
      break;
    case WM_CLOSE:
      WinPostMsg( hwnd, WM_QUIT, (MPARAM)0,(MPARAM)0 );/* Cause termination*/
      break;
    case WM_SIZE:
      /* set the size parameters for use in WM_PAINT */
      cxClient = SHORT1FROMMP( mp2 );
      cyClient = SHORT2FROMMP( mp2 );
      break;
    default:
      return WinDefWindowProc( hwnd, msg, mp1, mp2 );
  }
  return (MRESULT)FALSE;
} /* End of MyWindowProc */


/*+-------------------------------------------------------------------------+
  |                                                                         |
  |    DlgWelcomeProc is the first dialog box.  It just gives instructions  |
  |    and provides the OK and Cancel buttons.                              |
  |                                                                         |
  +-------------------------------------------------------------------------+*/
MRESULT EXPENTRY DlgWelcomeProc( HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2 )
{
   switch (ulMsg)
   {
     case WM_COMMAND:
       switch( SHORT1FROMMP(mp1) )
       {
         case BID_CANCEL:
           WinDismissDlg( hwnd, FALSE );
           break;
         case BID_OK:
           WinDismissDlg( hwnd, TRUE );
           break;
         default:
           return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
       }
     default:
       return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
   }
}

/*+-------------------------------------------------------------------------+
  |                                                                         |
  |    DlgIsUpProc is the second dialog box.  It just gives instructions    |
  |    and provides the OK and Cancel buttons.                              |
  |                                                                         |
  +-------------------------------------------------------------------------+*/
MRESULT EXPENTRY DlgIsUpProc( HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2 )
{
   switch (ulMsg)
   {
     case WM_CREATE:
       WinSetFocus( HWND_DESKTOP, WinWindowFromID( hwnd, BID_OK ));
       break;
     case WM_COMMAND:
       switch( SHORT1FROMMP(mp1) )
       {
         case BID_CANCEL:
           WinDismissDlg( hwnd, TRUE);
           break;
         case BID_OK:
           break;
         default:
           return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
       }
     default:
       return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
   }
}

/*+-------------------------------------------------------------------------+
  |                                                                         |
  |    DlgAboutProc is the programmer's ego trip dialog box.  It just gives |
  |    the demo version number, copyright notice, and the name of yours     |
  |    truly.                                                               |
  |                                                                         |
  +-------------------------------------------------------------------------+*/
MRESULT EXPENTRY DlgAboutProc( HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2 )
{
   switch (ulMsg)
   {
     case WM_COMMAND:
       switch( SHORT1FROMMP(mp1) )
       {
         case BID_OK:
           WinDismissDlg( hwnd, TRUE );
           break;
         default:
           return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
       }
     default:
       return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
   }
}

/*+-------------------------------------------------------------------------+
  |                                                                         |
  |    DlgMonitorProc is the third dialog box.  It just gives instructions  |
  |    and provides the OK and Cancel buttons.                              |
  |                                                                         |
  +-------------------------------------------------------------------------+*/
MRESULT EXPENTRY DlgMonitorProc( HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2 )
{
   switch (ulMsg)
   {
     case WM_COMMAND:
       switch( SHORT1FROMMP(mp1) )
       {
         case BID_CANCEL:
           WinDismissDlg( hwnd, FALSE );
           break;
         case BID_OK:
           WinDismissDlg( hwnd, TRUE );
           break;
         default:
           return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
       }
     default:
       return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
   }
}

/*+-------------------------------------------------------------------------+
  |                                                                         |
  |    DlgTraceProc is the fourth dialog box.  It prompts the user to enter |
  |    a trace bit and type some text, and then hit Trace.  If he/she/or it |
  |    has set that trace bit in Footprints, the text entered in the 2nd    |
  |    entry field will be traced.  The Trace button can be hit multiple    |
  |    times.  The OK button takes the user to the HfpIsItOn dialog box,    |
  |    and Cancel dismisses this box.                                       |
  |                                                                         |
  +-------------------------------------------------------------------------+*/
MRESULT EXPENTRY DlgTraceProc( HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2 )
{
   ULONG ulRC;
   CHAR acTraceTxt[256];
   CHAR acTraceID[16];
   INT iTraceID;

   switch (ulMsg)
   {
     case WM_COMMAND:
       switch( SHORT1FROMMP(mp1) )
       {
         case BID_CANCEL:
           WinDismissDlg( hwnd, FALSE );
           break;
         case BID_OK:
           if( (ulRC = WinDlgBox( HWND_DESKTOP, hwnd, DlgIsItOnProc, 0L,
                                  (ULONG)DLG_ISITON, NULL)) == DID_ERROR )
           {
              ulRC = WinGetLastError( hab );
              HfpTrace( hfpFPHandle, &ulRC, sizeof(ulRC), "DlgBxEr6", 0 );
           }
           break;
         case BID_TRACE:
           memset( acTraceID, 0, sizeof( acTraceID ));
           WinQueryWindowText( WinWindowFromID( hwnd, EID_BITNO),
                               sizeof(acTraceID), acTraceID );
           if( ((iTraceID = atoi( acTraceID )) > 64) ||
               (iTraceID < 1) )
           {
              break;
           }
           if(( WinQueryWindowText( WinWindowFromID( hwnd, EID_TRTEXT),
                               sizeof(acTraceTxt), acTraceTxt )) == 0 )
           {
              break;
           }
           /*------------------------------------------------------------
               Here, we are tracing the text the user entered in the
               dialog box window.  The trace id # is whatever the user
               entered in that entry field.
            ------------------------------------------------------------*/
           HfpTrace( hfpFPHandle, acTraceTxt, strlen(acTraceTxt), "UserText",
                     iTraceID );
           break;
         default:
           return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
       }
     case WM_CONTROL:
       break;
     default:
       return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
   }
}

/*+-------------------------------------------------------------------------+
  |                                                                         |
  |    DlgIsItOnProc is the last dialog box.  It prompts the user to turn   |
  |    on any or all of trace bits 1, 2, or 3, and the code will check to   |
  |    see which bits have been turned on.  This simply shows how runtime   |
  |    execution can be changed by external events. Hopefully, the          |
  |    developer can use the imagination to see what kind of debug code he  |
  |    would use with this type of function.                                |
  |                                                                         |
  +-------------------------------------------------------------------------+*/
MRESULT EXPENTRY DlgIsItOnProc( HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2 )
{
   int iOneOn = FALSE;                    /* initialize no bits on */
   ULONG ulRC;

   switch (ulMsg)
   {
     case WM_COMMAND:
       switch( SHORT1FROMMP(mp1) )
       {
         case BID_CANCEL:
           WinDismissDlg( hwnd, FALSE );
           break;
         case BID_OK:
           if( HfpIsItOn( hfpFPHandle, 1 ))
           {
              if( (ulRC = WinDlgBox( HWND_DESKTOP, hwnd, DlgBit1Proc, 0L,
                                     (ULONG)DLG_BIT1, NULL)) == DID_ERROR )
              {
                 ulRC = WinGetLastError( hab );
                 HfpTrace( hfpFPHandle, &ulRC, sizeof(ulRC), "DlgBxEr7", 0 );
              }
              iOneOn = TRUE;
           }
           if( HfpIsItOn( hfpFPHandle, 2 ))
           {
              if( (ulRC = WinDlgBox( HWND_DESKTOP, hwnd, DlgBit2Proc, 0L,
                                     (ULONG)DLG_BIT2, NULL)) == DID_ERROR )
              {
                 ulRC = WinGetLastError( hab );
                 HfpTrace( hfpFPHandle, &ulRC, sizeof(ulRC), "DlgBxEr8", 0 );
              }
              iOneOn = TRUE;
           }
           if( HfpIsItOn( hfpFPHandle, 3 ))
           {
              if( (ulRC = WinDlgBox( HWND_DESKTOP, hwnd, DlgBit3Proc, 0L,
                                     (ULONG)DLG_BIT3, NULL)) == DID_ERROR )
              {
                 ulRC = WinGetLastError( hab );
                 HfpTrace( hfpFPHandle, &ulRC, sizeof(ulRC), "DlgBxEr9", 0 );
              }
              iOneOn = TRUE;
           }
           if( iOneOn == FALSE )
           {
              if( (ulRC = WinDlgBox( HWND_DESKTOP, hwnd, DlgNoneProc, 0L,
                                     (ULONG)DLG_NONE, NULL)) == DID_ERROR )
              {
                 ulRC = WinGetLastError( hab );
                 HfpTrace( hfpFPHandle, &ulRC, sizeof(ulRC), "DlgBxErA", 0 );
              }
           }
           break;
         default:
           return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
       }
       break;
     default:
       return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
   }
}

/*------------------------------------------------
    This guy is practically just a message box
    He gets called if Bit 1 has been turned on 
    with Footprints
-------------------------------------------------*/
MRESULT EXPENTRY DlgBit1Proc( HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2 )
{
   switch (ulMsg)
   {
     case WM_COMMAND:
       switch( SHORT1FROMMP(mp1) )
       {
         case BID_OK:
           WinDismissDlg( hwnd, TRUE );
           return( (MRESULT)TRUE );
           break;
         default:
           return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
       }
     default:
       return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
   }
}

/*------------------------------------------------
    This guy is practically just a message box
    He gets called if Bit 2 has been turned on 
    with Footprints
-------------------------------------------------*/
MRESULT EXPENTRY DlgBit2Proc( HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2 )
{
   switch (ulMsg)
   {
     case WM_COMMAND:
       switch( SHORT1FROMMP(mp1) )
       {
         case BID_OK:
           WinDismissDlg( hwnd, TRUE );
           return( (MRESULT)TRUE );
           break;
         default:
           return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
       }
     default:
       return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
   }
}

/*------------------------------------------------
    This guy is practically just a message box
    He gets called if Bit 3 has been turned on 
    with Footprints
-------------------------------------------------*/
MRESULT EXPENTRY DlgBit3Proc( HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2 )
{
   switch (ulMsg)
   {
     case WM_COMMAND:
       switch( SHORT1FROMMP(mp1) )
       {
         case BID_OK:
           WinDismissDlg( hwnd, TRUE );
           return( (MRESULT)TRUE );
           break;
         default:
           return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
       }
     default:
       return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
   }
}

/*------------------------------------------------
    This guy is practically just a message box
    He gets called if no bits have been turned
    on with Footprints
-------------------------------------------------*/
MRESULT EXPENTRY DlgNoneProc( HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2 )
{
   switch (ulMsg)
   {
     case WM_COMMAND:
       switch( SHORT1FROMMP(mp1) )
       {
         case BID_OK:
           WinDismissDlg( hwnd, TRUE );
           return( (MRESULT)TRUE );
           break;
         default:
           return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
       }
     default:
       return WinDefDlgProc( hwnd, ulMsg, mp1, mp2 );
   }
}


/*+-----------------------------------------------------------------------+
  |  HandleError assumes there is a bad RC from a Win API call, in which  |
  |  case it gets the last error and puts it in the Footprints trace      |
  |  using Trace id 0, which is always set.                               |
  +-----------------------------------------------------------------------+*/
VOID HandleError( char *szErrString )
{
   ERRORID Err;

   Err = WinGetLastError( hab );
   HfpTrace( hfpFPHandle, &Err, sizeof( Err ), szErrString, 0 );
   return;
}


/*+-----------------------------------------------------------------------+ 
  | HSSExit is registered with the DosExitList API call in the event of   |
  | a Trap or DosExit, this routine will be called.                       |
  | The HfpTerm function flushes out the current Footprints               |
  | trace buffer so we can view any traced info.                          |
  +-----------------------------------------------------------------------+*/
VOID APIENTRY HSSExit( VOID )
{
   FILE *fp;
   APIRET apiRC;

   /*-----------------------------------------------------------------------
       HfpTerm tells Footprints to flush all trace messages to the trace
       file and terminate this trace session.  No more HfpTrace calls
       or HfpIsItOn calls may be made using this handle unless HfpInit is
       called again.
    -----------------------------------------------------------------------*/
   if( apiRC = HfpTerm( hfpFPHandle ))
   {
      DosBeep( 600L, 200L );
      fp = fopen( "fpdemo.err", "a" );
      if (fp != NULL )
      {
         fprintf( fp, "Initialization error = %d\n", apiRC );
         fclose( fp );
      }
   }
   return;
}
 

/*********************** End of the hello.c *******************************/
