/* "Kill 'em all ... " */
/* (c)PYzone 2001-2003 */
/* OS/2 Processes monitor v2.0 */
/* To (re)create the WPS object launch this script with any parameter */

NUMERIC DIGITS 10

call RxFuncAdd 'PYRxInit', 'PYRxUtil', 'PYRxInit'
call PYRxInit ; lib_ver = result
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

parse source . . eP
parse arg restart .

p_ttl = "Kill 'em all ..."
my_pid = PYRxGo('p') ; s_pid = my_pid
my_hwnd = PYRxGo('t',p_ttl) /* set task, window title */

signal on HALT name store_pos

call set_icon restart\='' /* Initialize const-s. */
                          /* iconize, if "fresh" script file. or have non-empty prm.*/
call set_size         /* restore window size */
dskPath = PYRxGo('i') /* obtain desktop path */
if dskPath = '' then
  dskPath = NO_DATA
call get_version      /* obtain "ver /r" text */

do forever /* main loop entry point  - works after some key was pressed and additionally every ~1sec.*/
  if rt_head \= '' then  /* show new right panel head */
    call PYRxShow 0,L_WIDTH,0,left(rt_head,R_WIDTH),HEAD_ATTR
  timer = PYRxGo('i','.............?')  /* curr.timestamp */
  if timer - sys_time >= SCAN_DT - draw_time then
    do  /* ~1/sec. scan: processes list, CPU util.prm-s, sys.info */
      drop pl. pid. ppid. p_thn.
      s_thn = 0 ; sys_time = timer ; wait = SCAN_DT
      call PYRxGo 'P','*','*','pl'  /* "pl." - list of all running processes */
      do i=1 to pl.0  
        parse var pl.i pid.i ppid.i . . p_thn.i .
        s_thn = s_thn + p_thn.i
        if pid.i = s_pid then
          s_idx = i
       end
      call get_cpu        /* calculate curr. CPU utilization values */
      if rt_view = 'INFO' then
        call pre_s_info   /* when need it - obtain sys.info */
       else
        if rt_view = 'HELP' then
          call pre_help   /* help info uses same variables with "CPU" - rebuild it */
     end

  do while s_idx > pl.0   /* marker index - bounds control */
    s_idx = pl.0 ; s_pid = pid.s_idx ; s_off = 0
   end

  /* drawing loop for left panel */
  y_cur = 1 ; rt_attr = PATH_ATTR
  do i=1 to pl.0 + INF_LINES while y_cur <= INF_LINES
    mask = ' '||ppid.i||' '
    parse var chain chain (mask) +1 alive .
    if alive = '' then chain = ''
    chain = ' 'chain' 'alive' 'pid.i' '  /* make processes' "tree" view */
    if i < s_idx - s_off then
      iterate                            /* out of drawing bounds : "less" */
    if i <= pl.0 then
      call sh_p_info   /* show prc.info */
     else              /* clear screen line if out of prc.list bounds : "more" */
      call PYRxShow y_cur,0,L_WIDTH+R_WIDTH*(rt_view='PATH' | rt_view='TITLE'),' ',PATH_ATTR
    y_cur = y_cur + 1
   end

  select /* for different right panel modes : assign draw procedure & screen attributes */
    when rt_view = 'CPU' then
      sh_Fn = 'sh_cpu_info'
    when rt_view = 'THREADS' then
      do
        chain = ''
        call PYRxGo 'P',,s_pid,'tl' /* obtain threads parameters values for marked process */
        do while s_pid \= t_pid
          call drop_slots
          t_pid = s_pid ; t_mem = 0
         end
        sh_Fn = 'sh_t_info'
       end
    when rt_view = 'INFO' then
      do
        sh_Fn = 'sh_sys_info' ; rt_attr = INFO_BG
       end
    when rt_view = 'HELP' then
      do
        sh_Fn = 'sh_help' ; rt_attr = HELP_BG
       end
    otherwise
      nop
   end

  /* drawing loop for right panel - is called when some key was pressed and additionally every ~1sec.*/
  y_cur = 1
  if  rt_view \= 'PATH' & rt_view \= 'TITLE' & tl.0 \= 'TL.0' then
    do i=1 to tl.0 + INF_LINES
      if i <= tl.0 then
        interpret 'call 'sh_Fn  /* draw appropriate info */
       else
        if y_cur <= INF_LINES then
          do
            call PYRxShow y_cur,L_WIDTH,R_WIDTH,' ',rt_attr /* clear the line - out of bounds */
            y_cur = y_cur + 1
           end
     end

  if ctrl_state < 3 then /* let's provide two alternative brief info-s */
    do /* <Ctrl> mode is not set : will show common brief info, appropriate for each right panel mode */
      call PYRxShow ymx-2,0,0,left('Summary: 'pl.0' processes with 's_thn' threads',L_WIDTH),SUM_ATTR
      select
        when rt_view = 'CPU' & tl.0 \= 'TL.0' then
          v_str = cpu_txt      /* from "get_cpu" */
        when rt_view \= 'TITLE' then
          v_str = '  Process 's_pid' has 'p_thn.s_idx' thread(s)'
        otherwise
          call PYRxGO 't','....?','*','wl' /* obtain full task list */
          sl.1 = 0 ; sl.2 = 0 ; sl.4 = 0
          do i=1 to wl.0
            interpret "sl."||wl.i||"=sl."||wl.i||"+1"
           end
          v_str = '  TaskList: Vis.'||sl.4||'  Gray.'||sl.2||'  Invis.'||sl.1
       end
      call PYRxShow ymx-2,L_WIDTH,0,left(v_str,R_WIDTH),SUM_ATTR
     end
   else
    do  /* <Ctrl> mode is set : show full path or task title with "scrolling" possibility  */
      call length(mrk_txt) /* was set in "sh_p_info" */
      if mrk_x*MRK_TAB > result - xmx + 2 then
        mrk_x = (result-xmx+2)%MRK_TAB
      if (mrk_x < 0) then
        mrk_x = 0
      call PYRxShow ymx-2,0,0,substr('2011'x,(mrk_x>0)+1,1),MORE_ATTR
      call PYRxShow ,1,0,substr(mrk_txt,mrk_x*10+1,xmx-2),WIDE_ATTR
      call PYRxShow ,xmx-1,0,substr('2010'x,(mrk_x*MRK_TAB+xmx-2<length(mrk_txt))+1,1),MORE_ATTR
     end

  if tl.0 > INF_LINES & wordpos(rt_view,'PATH TITLE') = 0 then /* show brief keys info */
    BRIEF.0 = BRIEF.LR
   else
    BRIEF.0 = BRIEF.L
  v_str = brief
  interpret "brief = "||BRIEF.q_kill
  if brief \= v_str then
    call PYRxShow ymx-1,0,0,left(brief,xmx),KEY_ATTR

  call drop_slots

  draw_time = PYRxGo('i','.............?') - timer /* how long we did drawing & */
  wait = wait - draw_time
  if wait < 0 then /* do we have time for keyboard scan ? */
    iterate        /* no, too far from 1 sec loop time */
  parse value PYRxKey(wait) with char scan k_ctrl rt_head /* rt_head = '' */
  parse upper value x2c(char) with char
  select
    when scan = '00' & char = '0'x then
      if q_kill \= 0 then  /* let's provide "blinking" prompt for delete & power off */
        do
          attr = bitor(KEY_ATTR,d2c(7*((timer%SCAN_DT)//2)))
          call PYRxShow ymx-1,2,length(brief),,attr
         end
    when q_kill \= 0 then
      do  /* have key pressed for "delete" prompt, so, check it */
        if q_kill = 3 then
          do  /* power management keys are 0,1,2,3,4 */
            if pos(char,'0123') \= 0 then
              call PYRxGo 'p','-',char
            if char = 4 then
              call PYRxGo 't','-'
           end
         else /* 'Y' - kill confirmation */
          if char = 'Y' then
            if q_kill = 1 then
              call PYRxGo 'p','-',s_pid  /* "standard" */
             else
              call PYRxGo 'P','-',s_pid  /* "hard" */
        q_kill = 0  /* switch off kill & power mng. mode */
       end
    when scan = 48 then	/*Up - for left list*/
      if s_idx > 1 then
        do
	  s_idx = s_idx-1
	  s_off = s_off - (s_off > 0)
	 end
    when scan = 50 then	/*Down - for left list*/
      if s_idx < pl.0 then
        do
          s_idx = s_idx+1
	  s_off = s_off + (s_off < INF_LINES-1)
	 end
    when scan = 49 then	/*PgUp - for left list*/
      do
        s_idx = s_idx - INF_LINES
        if s_idx < 1 then s_idx = 1
        if s_idx - s_off < 1 then s_off = s_idx - 1
       end
    when scan = 51 then	/*PgDn - for left list*/
      do
        s_idx = s_idx + INF_LINES - 1
        do while s_idx > pl.0
          s_idx = pl.0
          s_off = (INF_LINES-1)*(pl.0 > INF_LINES)
         end
        if s_idx - s_off < 1 then s_off = 0
       end
    when scan = 47 then /* Home - for left list */
      do
        s_idx = s_idx - s_off
        s_off = 0
       end
    when scan = '4F' then /*End - for left list*/
      do  
        s_idx = s_idx + INF_LINES - s_off - 1
        if s_idx > pl.0 then s_idx = pl.0
        s_off = INF_LINES - 1
        if s_off > pl.0 then s_off = pl.0 - 1
       end
    when scan = 53 then	/* Del - standard kill request*/
      if s_pid \= my_pid then
        q_kill = 1 + 2*(s_pid <= 15)
       else
        call beep 4000,100
    when scan = 93 then	/* Ctrl-Del - "hard" kill request */
      if s_pid \= my_pid then
        q_kill = 2 + (s_pid <= 15)
       else
        call beep 4000,100
    when char = 'T' then /*right panel - "Threads view" request*/
      if rt_view \= 'THREADS' then
        do
          rt_view = 'THREADS' ; subview = 0 ; rt_head = THR_HEAD.0
          drop t_pid  ; t_idx = 1
         end
    when char = 'C' then /*right panel - "CPU view" request */
      if rt_view \= 'CPU' then
        do
          rt_view = 'CPU' ; rt_head = CPU_HEAD
          drop tl. ; t_idx = 1 
          call dim
         end
    when char = 'P' then /*right panel - "Exe Path names view" request*/
      if rt_view \= 'PATH' then
        call set_path_view
    when char = 'W' then /*right panel - "Task titles view" request*/
      if rt_view \= 'TITLE' then
        call set_title_view 0
    when char = 'I' then /*right panel - "System info view" request*/
      if rt_view \= 'INFO' then
        do
          rt_view = 'INFO' ; rt_head = INF_HEAD
          drop tl. ; t_idx = 1 
          call dim
         end
    when scan = '3B' then /*right panel - "F1 - control keys info" request*/
      if rt_view \= 'HELP' then
        do
          rt_view = 'HELP' ; rt_head = HLP_HEAD
          drop tl. ; t_idx = 1
          call dim
         end
    when scan = 52 | scan = 92 then     /*[Ctrl]-Ins*/
      call scr_copy   /* let's copy curr.screen into clipboard */
    when scan='0F' then			/*Tab*/
      call PYRxGo 't','.'  /* self-minimize */
    when scan = '1C' then
      if char = 'a'x then
        call set_size  /*Ctrl-Enter - for change own window's size */
       else
        call p_switch  /*Enter - try to switch into marked process window*/
    when scan='01' then			/*Esc*/
      signal store_pos /* do exit sequence */
    when wordpos(scan,'4B 4D') \= 0 then /*Left\Right*/
      select  /* walk through showing parameters sets - subviews */
        when rt_view = 'THREADS' then
          do
            if xmx < 100 then
              subview = 1 - subview
            rt_head = THR_HEAD.subview
           end
        when rt_view = 'PATH' then /* also possible switch to "title" view */
          call set_title_view (scan ='4B')*(2-(xmx >= 100))
        when rt_view \= 'TITLE' then
          nop
        otherwise
          if scan ='4B' then /* let's provide different "walk" directions */
            tmp_s = '1230'
           else
            tmp_s = '3012'
          subview = translate(subview,'0123',tmp_s)
          if subview > (2-(xmx >= 100)) then
            call set_path_view /* also possible switch to "path" view */
           else
            call set_title_view subview
       end
    when wordpos(scan,'73 74') \= 0 then /*Left\Right +Ctrl*/
      mrk_x = mrk_x + 1 - 2*(scan = 73)  /*for "scrolling" of full path or title */
    when tl.0 = 'TL.0' then
      nop
    when scan = 77 then /* Ctrl-Home */
      if wordpos(rt_view,'PATH TITLE') \= 0 then
        mrk_x = 0  /* show full path/title head */
       else
        t_idx = 1  /* show right list beginning */
    when scan = 75 then /*Ctrl-End*/
      if wordpos(rt_view,'PATH TITLE') \= 0 then
        mrk_x = 30  /*show full path/title tail (30*mrk_tab > MAX_PATH_LENGTH)*/
       else
        if tl.0 > INF_LINES then
          t_idx = tl.0 - INF_LINES + 1  /* show right list end */
    when wordpos(rt_view,'PATH TITLE') \= 0 then
      nop
    when scan = '8D' then /*Ctrl-Up - for right list*/
      if t_idx > 1 then
        t_idx = t_idx-1
    when scan = 91 then	/*Ctrl-Down - for right list*/
      if t_idx <= tl.0 - INF_LINES then
        t_idx = t_idx+1
    when scan = 84 then /*Ctrl-PgUp - for right list*/
      do
        t_idx = t_idx - INF_LINES
        if t_idx < 1 then
          t_idx = 1
       end
    when scan = 76 then /*Ctrl-PgDn - for right list*/
      if t_idx <= tl.0 - INF_LINES then
        t_idx = t_idx + INF_LINES
    otherwise
      nop
   end /*select*/

  s_pid = pid.s_idx
  if s_pid_mem \= s_pid then /* marker line was moved */
    if rt_view = 'THREADS' then
      t_idx = 1  /* threads list will shown from beginning */
     else
      if rt_view = 'PATH' | rt_view = 'TITLE' then
        mrk_x = 0  /* full path/title will shown from beginning */
  s_pid_mem = s_pid
    /* ctrl_state controls brief line contents */
  if scan \= '00' | char \= '0'x then
     ctrl_state = translate(ctrl_state,'151','240')
  if PYRxGo('t','@') = my_hwnd then /* check only if own window is active */
    if substr(k_ctrl,14,1) = 1 then
      ctrl_state = translate(ctrl_state,'24','03')
     else
      ctrl_state = translate(ctrl_state,'3003','2415')

 end /* do forever */

  /* query & store in EAs own window's screen position */
store_pos:  /* entry point from main program */
  scan = 'FF'
check_pos:  /* entry point from "set_size" procedure */
  call PYRxGo 't','%',my_hwnd,'cur_pos' /* obtain wnd. prm-s */
  parse var cur_pos xmx ymx x_sz y_sz . . . dskX dskY
  call SysGetEA eP,'X_POS','x_win'
  if result \= 0 | \datatype(x_win,'w') then
    x_win = xmx
  call SysGetEA eP,'Y_POS','y_win'
  if result \= 0 | \datatype(y_win,'w') then
    y_win = ymx
  if scan = 'FF' then
    do
      call SysPutEA eP,'X_POS',xmx
      call SysPutEA eP,'Y_POS',ymx
     end
 return

/**/

set_path_view: /* for 'P' key or for left/right walking in "title" mode*/
  rt_view = 'PATH' ; rt_head = EXE_HEAD
  t_idx = 1 ; mrk_x = 0 ; marking = rt_view 
 return

set_title_view: /* for 'W' key or for left/right walking in "path" mode*/
  subview = arg(1)
  rt_head = WIN_HEAD.subview
  rt_view = 'TITLE' ; t_idx = 1
  if subview = 0 then
    do
      marking = rt_view ; mrk_x = 0
     end
 return

dim:  /* visual effect to force user's waiting */
  do i=1 to INF_LINES
    call PYRxShow i,L_WIDTH,R_WIDTH,'',DIM_ATTR
   end
 return

sh_p_info:
/* extracts & shows parameters values for one process */
/* on left list - always same common set for any program mode */
/* on right list - appropriate path/task (sub)view in "path" or "title" mode only */
/* handles marker, adds to it a "guide" arrow image, when it's upper or lower line */
/* calls "stripe_show" to colour background of left text to visualize slices utilization */
/* fills "mrk_txt" for full output on brief line */
  parse var pl.i . . p_typ p_ses p_thn p_st p_time , /* obtain process parameters */
       		'"' p_pth '" ' p_hwnd '01'x dt_sys dt_usr dt_idle p_dt
  p_time = t_conv(p_time*SLICE)
  peak = ((SLICE*(dt_sys+dt_usr))/p_dt)*100  /* utilization percentage */
  if peak >= 100.0 then
    peak = ' --.-- '
   else
    peak = format(peak,3,2)'%'
  attr = P_I_FG ; lf_p_attr = PATH_ATTR ; d_sign = '  '
  if s_idx = i then 
    do    /* "guide" arrow & "mrk_txt" */
      attr = P_I_SEL ; lf_p_attr = P_I_SEL ; mrk_txt = p_pth
      if (y_cur = 1 & s_idx > 1) | s_idx = pl.0 then 
        d_sign = '2018'x
       else
        if (s_off = INF_LINES-1 & s_idx < pl.0) | s_idx = 1 then
          d_sign = '2019'x
     end
  v_str = right(pid.i,5)||right(ppid.i,6)||right(p_typ,4)||p_time||peak||d_sign
  act  = format(((dt_sys+dt_usr-dt_idle)*L_WIDTH*SLICE)/p_dt,,0)
  idle = format((dt_idle*L_WIDTH*SLICE)/p_dt,,0)
  bt_attr = ACT_BG ; dk_attr = IDLE_BG
  y_view = y_cur ; x_view = 0 ; sz_view = L_WIDTH
  call stripe_show  /* show all this on left panel */
  if rt_view = 'PATH' then
    do              /* make full path "tree" view */
      ch_x = 2*(words(chain)-1)
      v_str = strip(right(p_pth,R_WIDTH-ch_x-2))
      if v_str \= p_pth then
        v_str = '..'v_str
      v_str = left(left("",ch_x)||v_str,R_WIDTH)
      call PYRxShow ,L_WIDTH,0,v_str,lf_p_attr /* show on right panel */
     end
  if rt_view = 'TITLE' then
    do  /* "title" mode right panel info depends on "subview" */
      v_str = ''
      do while datatype(p_hwnd,'w') & p_hwnd \= 0 /* p_hwnd was obtained from processes prm-s - legal ? */
          /* obtain some (task) parameters for that (p_hwnd) window */
        parse value PYRxGo('T','?...???????',p_hwnd) with wl.1 wl.2 wl.3 wl.4 wl.13 wl.14 '22'x wl.5 '2201'x .
        if lf_p_attr = P_I_SEL & marking = rt_view then
          mrk_txt = wl.5   /* fill "mrk_txt" with task title */
        if wl.1 \= p_hwnd then
          leave
        if \datatype(PYRxGo('t','%',wl.1,'p_hwnd'),'w') then /* try to obtain current presentation prm-s */
          leave
        parse var p_hwnd wl.11 wl.10 wl.9 wl.8 . wl.7 wl.6 .
        wl.12 = right(wl.11,7)||right(wl.10,8-(xmx=100))||right(wl.9,6-(xmx=100))||right(wl.8,6-(xmx=100))
        select
          when subview = 0 then
            v_str = wl.5        /* task title */
          when subview = 2 then
            v_str = wl.1||' '||wl.12  /* hWnd  ||  x, y, sx, sy */
          otherwise  /* subview = 1 , hWnd , task characteristics, wnd. - hidden, min-max, active, top */
            v_str = wl.1'  'wl.2' 'wl.3'  '||word('### Hdn',wl.6)||' '||word('### Min Max',wl.7+1),
                     ||' '||word('### Vis',wl.4+1)||' '||word('# A',wl.14+1)||' '||word('# T',wl.13+1)
            v_str = translate(v_str,' ','#')
            if xmx >= 100 then
              v_str = v_str||wl.12  /* mix all wnd. prm-s for wide screen */
         end
        tmp_s = R_WIDTH + 1
        parse var v_str v_str =(tmp_s) tmp_s
        if tmp_s \= '' then
          v_str = overlay('..',v_str,R_WIDTH-1)
       end
      call PYRxShow ,L_WIDTH,0,left(v_str,R_WIDTH),lf_p_attr /* show on right panel */
     end
  return
  
t_conv: procedure
 /* converts ULONG system timer value into readable format */
  parse arg tim
  sec = tim%1000 ; msec = right(tim//1000,3,'0')
  min = sec % 60 ;  sec = right(sec//60,2,'0')
  hour = min % 60 ; min = right(min//60,2,'0')
  day = hour%24 ;  hour = right(hour//24,2,'0')
  if day > 99 then
    return ' --:--:--:--.---'
  return right(day,3)||':'hour':'min':'sec'.'msec
  
drop_slots:
 /* clear some variables */
  do while t_slots \= ''
    parse var t_slots slot t_slots
    drop ut.slot st.slot
   end
  t_slots = chain
 return
  
sh_t_info:
/* parses  "tl.i" variable */
/* extracts & shows on right list parameters' values for one thread of marked process */
/* supports two subviews if window has <= 100 chars/line */
/* calls "stripe_show" to colour text background to visualize slices utilization */
  parse var tl.i . tid slot sleep prio state t_st t_ut t_tim
  mask = ' 'slot' ' ;  chain = ' 'chain||mask
  parse var t_slots t_slots (mask) +1 alive mask ; t_slots = t_slots||mask
  if alive \= '' & t_st >= st.slot & t_ut >= ut.slot then
    do
      dt_sys =  t_st - st.slot ; dt_usr = t_ut - ut.slot
     end
   else
    do
      dt_sys =  t_st ; dt_usr = t_ut
     end
  st.slot = t_st ; ut.slot = t_ut
  if tid = 1 then
    t_dt = t_tim - t_mem 
  t_mem = t_tim ;
  if i < t_idx | y_cur > INF_LINES then 
    return
  peak = ((SLICE*(dt_sys+dt_usr))/t_dt)*100
  if peak >= 100.0 then
    peak = ' --.-- '
   else
    peak = format(peak,3,2)||'%'
  if subview = 0 then
    do
      v_str = right(tid,4)||right(slot,6)||' '||left(prio,6)||right(state,4)||right(sleep,11)||peak
      if xmx >= 100 then
        v_str = v_str||t_conv(SLICE*(t_st+t_ut))
     end
   else
    v_str = right(tid,4)||' '||left(prio,6)||right(state,5)||peak||t_conv(SLICE*(t_st+t_ut))
  idle = format((dt_sys*R_WIDTH*SLICE)/t_dt,,0)
  act = format((dt_usr*R_WIDTH*SLICE)/t_dt,,0)
  bt_attr = REG_U_BG ; dk_attr = REG_S_BG
  if pos("IDL",prio) = 1 then
    do
      bt_attr = IDL_U_BG ; dk_attr = IDL_S_BG
     end
  y_view = y_cur ; x_view = L_WIDTH ; sz_view = R_WIDTH ; attr = THR_ATTR
  call stripe_show
  y_cur = y_cur + 1
  return

delta:
 /* counts delta between two sequential measurements */
 /* takes in view possible counters overflow */
  parse arg cur, prev
  if prev > cur then
    return (1.84467441E+19 - prev) + cur  /* 1.84467441E+19 = 4294967296*4294967296 */
   else
    return (cur - prev)

get_cpu:
 /* ~once per 1 sec. obtains CPU(s) utilization counters' values in "tl." */
 /* calculates differences between two sequential measurements in percentage */
 /* stores current results for use in next measurement */
 /* prepares it for showing by "sh_cpu_info" */
  drop tl. ; call PYRxGo "i",,"tl" /* obtain CPU(s) counters into "tl." */
  if \datatype(tl.0,'w') then
    do  /* make appropriate brief text when things are wrong or good */
      cpu_txt = "Not supported OS level"
      tl.0 = 0
     end
   else 
    if tl.0 = 0 then
      cpu_txt = "Not supported CPU type"
     else
      cpu_txt = tl.0||" CPU(s) onboard"
  cpu_txt = "   CPU info: "cpu_txt  /* summary brief text */
  do i=1 to tl.0 /* for each CPU calculate utilization percentage */
    parse var tl.i ts_l ts_h idle_l idle_h busy_l busy_h int_l int_h dt
      ts_cur = 4294967296*ts_h   + ts_l
    idle_cur = 4294967296*idle_h + idle_l
    busy_cur = 4294967296*busy_h + busy_l
     int_cur = 4294967296*int_h  + int_l
    if ts_prev.i \= 'TS_PREV.'||i then  /* 1st measurement doesn't have previous results */
      do
	ts = delta(ts_cur,ts_prev.i)
	busy = right(format((delta(busy_cur,busy_prev.i)*100)/ts,,2),7)
	int = right(format((delta(int_cur,int_prev.i)*100)/ts,,2),7)
	idle = right(format((delta(idle_cur,idle_prev.i)*100)/ts,,2),7)
	freq = format(ts/(dt*F_coeff),,0)
        if freq > 999 then
          freq = format(freq/1000,,2)||" GGz."  /* more "modern" style */
         else
          freq = freq" MGz."
	tl.i = left('  'i||busy"%"int"%"idle"%  ~"freq,R_WIDTH) /* in "tl." now - readable info */
       end
      else
       tl.i = ""
    ts_prev.i = ts_cur ;     idle_prev.i = idle_cur  /* store current measurement results */
    busy_prev.i = busy_cur ; int_prev.i = int_cur    /* for each CPU */
   end
 return

sh_cpu_info:
 /* prepares CPU util. text from "tl.i" variable to draw */
 /* draws it with "stripe_show" */
  if i < t_idx | y_cur > INF_LINES then 
    return  /* when out of bounds */
  parse var tl.i v_str 1 . busy '%' int '%' .
  act = format((busy*R_WIDTH)/100,,0)
  idle = format((int*R_WIDTH)/100,,0)
  if act >= sz_view then
    do
      act = sz_view; idle = 0
     end
   else
    if idle >= sz_view then
      do
        idle = sz_view; act = 0
       end
  bt_attr = CPU_B_BG ; dk_attr = CPU_I_BG ; attr = CPU_ATTR
  y_view = y_cur ; x_view = L_WIDTH ; sz_view = R_WIDTH
  call stripe_show
  y_cur = y_cur + 1
 return

stripe_show:
 /* consequently mixes parts of v_str with 3 attributes */
 /* result string consists of pairs "char+attribute" */
 /* draws it on screen */
  tmp_s = ""
  if datatype(act,'w') then
    do
      if act > 0 then
        tmp_s = left("",act,bitor(bt_attr,bitand(attr,'f'x)))
       else
        act = 0
     end
   else
    act = 0
  if datatype(idle,'w') then
    do
      if idle > 0 then
        tmp_s = tmp_s||left("",idle,bitor(dk_attr,bitand(attr,'f'x)))
       else
        idle = 0
     end
   else
    idle = 0
  sz_attr = sz_view-act-idle
  if sz_attr > 0 then
    tmp_s = tmp_s||left("",sz_attr,attr)
  call left v_str,sz_view
  v_str = ''
  do j=1 to sz_view
    v_str = v_str||substr(result,j,1)||substr(tmp_s,j,1)
   end
  call PYRxShow y_view,x_view,-1,v_str
 return

pre_help:
 /* in "help" mode is called ~once per 1 sec. - fills "tl." after "get_cpu" */
 /* puts help lines into "tl." variables for next output with "sh_help" */
  tl.0 = 0 ; i = 1
  do forever
    call pos '0'x, help, i
    if result = 0 then
      return
    tl.0 = tl.0 + 1
    interpret "tl."tl.0" = substr(help, i, result-i)"
    i = result + 1
   end
 return

sh_help:
 /* shows 1 line of help info  from "tl.i" variable */
 /* can use 2 different attributes : */
 /* for key_name and for it description */
  if i < t_idx | y_cur > INF_LINES then 
    return  /* when out of bounds */
  parse var tl.i h_key '1'x h_k_len '1'x h_text
  if h_k_len = "" then
    h_k_len = length(h_key)
  call PYRxShow y_cur,L_WIDTH,0,left(h_key,h_k_len),HLP_KEY_ATTR
  call PYRxShow ,'+'h_k_len,0,left(h_text,R_WIDTH-h_k_len),HLP_TXT_ATTR
  y_cur = y_cur + 1
  return

get_version:
 /* issues "ver /r" command */
 /* reads its output from screen */
  version = ''
  call PYRxShow 1,0,4*xmx,' ',PATH_ATTR
  '@ver /r'
  parse value PYRxShow(1,0,'-'||(4*xmx)) with wl.1 +(xmx) wl.2 +(xmx) wl.3 +(xmx) wl.4
  do i=1 to 4
    call strip(wl.i)
    version = version||result
    if result \= '' then
      version = version||'0'x
   end
  return

pre_s_info: procedure expose tl. sys_time dskPath version dsk_hwnd dskX dskY NO_DATA lib_ver
 /* in "info" mode is called ~once per 1 sec. - fills "tl." after "get_cpu" */
 /* obtains some system variables values: */
 /*   QSV_BOOT_DRIVE QSV_DYN_PRI_VARIATION QSV_MAX_WAIT QSV_MIN_SLICE QSV_MAX_SLICE */
 /*   QSV_VERSION_MAJOR QSV_VERSION_MINOR QSV_VERSION_REVISION QSV_TOTPHYSMEM */
 /*   QSV_TOTRESMEM QSV_TOTAVAILMEM QSV_FOREGROUND_FS_SESSION QSV_FOREGROUND_PROCESS */
 /* also calls "wnd_prm" to obtain parameters of current active and topmost windows */
 /* puts results into "tl." variables for next output with "sh_s_info" */
  call PYRxGo "i","....?????.???...???....??","wl" /* request for system variables : */
  parse var version wl.14 '0'x wl.15 '0'x .
  tl.1 = 'Process monitor v2.0 (c)PYzone 2001-2003'||'010100'x
  tl.2 = '1'x||15||'1'x||date()||'  'time()||'0'x
  tl.3 = 'System timer :'||'1'x||14||'1'x||t_conv(sys_time)||'0'x
  tl.4 = '010100'x
  tl.5 = '0101'x||wl.14||'0'x
  tl.6 = '0101'x||wl.15||'0'x
  tl.7 = '0101'x||'(Maj.'||wl.6||'  Min.'||wl.7||'  Rev.'||wl.8||')'||'0'x
  tl.8 = '010100'x
  tl.9 = 'Boot drive '||'0101'x||substr(xrange('41'x,'58'x),wl.1,1)||':'||'0'x
  tl.10= '010100'x
  tl.11= 'Memory available :'||'010100'x
  tl.12= ' Physical'||'1'x||10||'1'x||wl.9||' Bytes'||'0'x
  tl.13= ' Resident'||'1'x||10||'1'x||wl.10||' Bytes'||'0'x
  tl.14= ' Total'||'1'x||10||'1'x||wl.11||' Bytes'||'0'x
  tl.15= '010100'x
  tl.16= 'Priority variation :'||'1'x||21||'1'x||word('absolute dynamic',wl.2+1)||'   '||'0'x
  tl.17= 'Maximum wait :'||'1'x||15||'1'x||wl.3||' sec.  '||'0'x
  tl.18= 'TimeSlice : Min.'||'1'x||16||'1'x||wl.4||' msec. '||'0'x||'Max.'||'1'x||wl.5||' msec.'
  tl.19= '010100'x
  tl.20= 'FG PID'||'1'x||7||'1'x||wl.13||'0'x||'    FG FS SID '||'1'x||wl.12
  tl.21= '010100'x
  tl.22= ' Desktop folder -'||'010100'x
  tl.23= '0101'x||dskPath||'0'x  /* all desktop info was obtained in "set_icon" at start */
  tl.24= '010100'x
  tl.25= 'Desktop :  hWnd='||'0101'x||dsk_hwnd||'  'dskX||'0'x||'x'||'1'x||dskY
  call wnd_prm 'Active','@',26,27,28,29,30,31,32
  call wnd_prm 'Topmost','^',result+1,result+2,result+3,result+4,result+5,result+6,result+7
  tl.0 = result
 return

sh_sys_info:
 /* shows 1 line of system info from "tl.i" variable */
 /* can use 2 different attributes : */
 /* for parameter description and for it value */
  if i < t_idx | y_cur > INF_LINES then 
    return
  attr = INFO_DATA_ATTR
  if i = 2 then  /* set colour for sys.timer */
    do
      if sys_time > 4208567295 then
        attr = bitor(INFO_BG,'5'x)
      if sys_time > 4291367295 then
        attr = bitor(INFO_BG,'c'x)
     end
  parse var tl.i h_key '1'x h_k_len '1'x h_text '0'x h_key_1 '1'x h_txt_1
  if h_k_len = "" then
    h_k_len = length(h_key)
  call PYRxShow y_cur,L_WIDTH,0,left(h_key,h_k_len),INFO_TXT_ATTR
  if h_key_1 = '' then
    h_text = left(h_text,R_WIDTH-h_k_len)
  call PYRxShow ,'+'h_k_len,0,h_text,attr
  y_cur = y_cur + 1
  if h_key_1 = '' then
    return
  parse value PYRxShow(,'+'||length(h_text),0,h_key_1,INFO_TXT_ATTR) with . h_key . h_k_len .
  call PYRxShow ,'+'||length(h_key_1),0,left(h_txt_1,h_k_len - h_key - length(h_key_1)),INFO_DATA_ATTR
  return

wnd_prm: procedure expose tl. sl. NO_DATA p_hwnd lib_ver
 /* obtains handle of currently "active" or "topmost" window */
 /* then obtains presentation and some other parameters for it */
 /* stores readable results into consequent "tl." variables */

  parse arg w_name, op, i1, i2, i3, i4, i5 . .

  tl.i1 = '010100'x
  tl.i2 = w_name' wnd.:'||'1'x||14||'1'x||NO_DATA||'0'x

  call PYRxGo 't',op,,'v_str'  /* query handle: op = '@' for active, '^' for topmost */
  if \datatype(result,'w') | result = 0 then
    return i2   /* can't obtain wnd.handle at all */
  w_hwnd = result
  parse var v_str x y sx sy . m_min hdn .
  tl.i2 = w_name' window: hWnd='||'0101'x||result
  tl.i3 = ' creator: '||'0101'x||'PID='||PYRxGo('p',op)
  v_str = word('### Hdn',hdn)||' '||word('### Min Max',m_min+1)||' '||word('Inv Vis',PYRxGo('t','%',result)+1)
  tl.i4 = '0101'x||translate(v_str,'','#')||'   '||x||' '||y||'  '||sx||'0'x||'x'||'1'x||sy

  call PYRxGo 't',,w_hwnd,'wl' /* obtain child windows info into "wl." */
  if \datatype(result,'w') then
    return i4                  /* can't get info about child windows */

  if lib_ver >= 20030627 then  /* proper PYRxUtil version ? */
    do
      if p_hwnd \= result then  /* same parent with 'Active' & proper PYRxUtil version ? */
        do                      /* no, different parents - will examine */
          p_hwnd = result       /* p_hwnd - handle of parent wnd. */
          call PYRxGo 't',,p_hwnd,'sl' /* collect info from parent */
          if \datatype(result,'w') then
            sl.0 = 0            /* error | no parent */
         end
     end
   else
    sl.0= 0

  v_str = ''
  do i=1 to wl.0      /* will try to find title among the child windows */
    parse var wl.i '22'x w_name '2201'x
    call word wl.i, words(wl.i)
    if result = '"#9"' then
      do
        v_str = w_name ; leave /* predefined win.style - titlebar is found */
       end
     else
      if w_name \= '' & v_str = '' then
        v_str = w_name         /* at least some non-empty text */
   end

  do i=1 to sl.0   /* try obtain info from parent */
    parse var sl.i . result . . tmp_s . '22'x w_name '2201'x . '22'x tl.i5
    if result \= w_hwnd then
      iterate
    call strip tl.i5, 't', '22'x /* have obtained info about this window from its parent */
    i4 = i4 + 1
    tl.i4 = ' class ID : '||'0101'x||result||'0'x  /* class id string */
    tl.i3 = tl.i3||' TID='tmp_s  /* add creator TID info */
    if v_str = '' then
      v_str  = w_name
    leave
   end

  if v_str \= '' then
    do    /* non-empty window title was found */
      i4 = i4 + 1
      tl.i4 = '0101'x||v_str||'0'x
     end
  do 2 until result \= ''
    call PYRxGo 't','.?.......??',w_hwnd
    parse var result tmp_s '22'x result '2201'x
    w_hwnd = p_hwnd
   end
  if datatype(tmp_s,'w') & tmp_s \= 0 then
    tl.i3 = tl.i3||'0'x||'  task: '||'1'x||'PID='tmp_s  /* add task process ID info */
  if result \= '' & result \= v_str then
    do    /* non-empty task title was found */
      i4 = i4 + 1
      tl.i4 = '5b0101'x||result||'005d'x
     end

 return i4

scr_copy:
 /* reads contents of entire window (without keys info line) text */
 /* removes trailing ' ' & appends EOL in each line */
 /* when "append to clipboard" requested - additionally reads clipboard text */
 /* pastes [current_clipboard_text]+screen_text into clipboard */
  h_text = '' ; h_key = xmx + 1
  call PYRxShow 0,0,'-'||(xmx*(INF_LINES+2))
  do until result = ''
    parse var result h_txt_1 =(h_key) result
    h_text = h_text||strip(h_txt_1,'t')||'0d0a'x
   end
  if scan = 92 then  /* Ctrl-Ins */
    do               /* append mode */
      call PYRxClip  /* result = current_clipboard_text */
      if result = '0'x then
        result = ''
     end
  call PYRxClip result||"0d0a2020"x||date()||"  "||time()||"  "||t_conv(sys_time),
                      ||"    Kill'em "||rt_view||" screen"||"0d0a0d0a"x||h_text
  call PYRxShow 1,0,xmx*INF_LINES,'','60'x  /* screen "flash" */
 return

p_switch: procedure expose pl. s_pid s_idx INF_LINES xmx DIM_ATTR
 /* tries WinSwitchToProgram with "s_pid" value */
 /* if window is "lost" - prompts to user and tries to "restore" it */
  call PYRxGo 'p','!',s_pid /* switch to */
  parse var pl.s_idx '"' tmp_s '" ' w_hwnd '1'x
  p_pth = strip(right(tmp_s,40))
  if p_pth \= tmp_s then
    p_pth = '..'p_pth             /* process' path */
  w_hwnd = strip(w_hwnd,'l','@')  /* process window's hWnd */
  parse value PYRxGo('t','...?.....?', w_hwnd) with type tmp_s /* process session type, task title */
  if wordpos(type,'1 4') \= 0 | \datatype(type,'w') then
    return 0  /* FS session or error */
  call PYRxShow 1,0,xmx*INF_LINES,'',DIM_ATTR /* dim screen - waiting */
  v_str = strip(left(tmp_s,30))
  if v_str \= tmp_s then
    v_str = v_str'..' /* task title */
  do 50               /* waiting 5 sec. max to new window become visible */
    call PYRxKey 100
    call PYRxGo 't','%',w_hwnd,'cur_pos'
    if result=1 then
      return          /* switching Ok */
   end
  parse var cur_pos . . x_sz y_sz .
  call PYRxMsg ,30,,,p_pth||'0000'x||"["v_str"]",w_hwnd,12,'Restore','Ignore'
  if result \= 11 then
    return            /* user doesn't want to restore window */
  call PYRxGo 't','.',w_hwnd,'0 0'
  call PYRxKey 100
  call PYRxGo 't','.',w_hwnd
  call PYRxKey 100
  call PYRxGo 't','#',w_hwnd,'0 0 '||(100*(x_sz=0)+x_sz)||' '||(100*(y_sz=0)+y_sz)
  call PYRxKey 100
  call PYRxGo 't','!',w_hwnd  /* trying to show & activate "lost" window */
 return

set_icon :
 /* is used once at start */
 /* initializes all constant variables */
 /* also decodes base64 icon code and attaches it to program file's EAs */
 /* allows to create WPS object for program - when it is "fresh" or is started with any parameter */

   /* obtain code to initialize constants and base64-coded icon from last comments of script body */
  parse value charin(eP,,100000) with '2f2a7e'x tmp_s '7e2a'x . '2a7e'x i64 '2a2f'x
  call stream eP,'c','close'

  call translate tmp_s ,'3b3b'x,'0d0a'x
  interpret result    /* initialize constants */

  call SysGetEA eP,'.ICON','ic'  /* try to obtain icon from EA */
  if \datatype(result,'w') | result \= 0 then
    ic = ''           /* getEA error */
  if length(ic) \= 6948 then
    do
      /* base64 decoding of icon code */
      i64 = translate(i64,'0000'x,'0d0a'x)
      d_code = xrange('0'x,'3f'x) ; s_code = xrange('A','Z')||xrange('a','z')||'0123456789+/'
      i = 1 ; ic = ''
      call pos '0'x,i64
      do while result \= 0
        tmp_s = ''
        if result > i then
          tmp_s = x2b(c2x(translate(substr(i64,i,result-i),d_code,s_code)))
        i = result+1
        do while tmp_s \= ''
          parse var tmp_s +2 ic.0 +6 +2 ic.1 +6 +2 ic.2 +6 +2 ic.3 +6 +2 ic.4 +6 +2 ic.5 +6 ,
                      +2 ic.6 +6 +2 ic.7 +6 +2 ic.8 +6 +2 ic.9 +6 +2 ic.10 +6 +2 ic.11 +6 tmp_s
          result = ic.0||ic.1||ic.2||ic.3||ic.4||ic.5||ic.6||ic.7||ic.8||ic.9||ic.10||ic.11
          if result \= '' then
            ic = ic||x2c(b2x(left(result,length(result)%8*8)))
         end
        call pos '0'x,i64,i
       end
     end
  if length(ic) = 6944 then
    do  /* let's store newly decoded icon into EAs */
      ic = 'F9FF'x||translate('12',d2c(length(ic),2),'21')||ic
      call SysPutEA eP,'.ICON',ic  /* store icon to EAs */
      restart = '$'
     end
  if restart \= '' then
    do  /* (re)make WPS object after prompt message */
      if length(ic) = 6948 then
        do  /* let's make a temporary icon file to show it in messagebox */
          tmp_s = SysTempFileName(left(eP,lastpos("\",eP))||'TMP?????.ICO')
          call charout tmp_s,substr(ic,5)
          call charout tmp_s
         end
       else
        tmp_s = ''
      if PYRxMsg(,,,p_ttl,'Ready to use .',tmp_s,,'Ok','Make WPS object') = 12 then
        call SysCreateObject "WPProgram",p_ttl,"<WP_DESKTOP>","EXENAME="eP,"REPLACE"
      if tmp_s \= '' then
        '@del 'tmp_s
      '@start /c /f /pgm "'eP'"'  /* restart program */
     end
   else
    return
  exit

set_size:
 /* can be called at program start or after Ctrl-Enterr pressing */
 /* deals with EA values - X_SIZE and Y_SIZE */
 /* if called at start - reads EAs and issues "mode" command with obtained values */
 /* if called after Ctrl-Enter - promts user to assign new window size */
 /* tries to issue "mode" command for new values and stores it into EAs if "mode" successful */
 /* also, reinitializes some variables, mainly corresponding to "Title" & "Threads" subviews */
  parse value PYRxShow() with . . ymx xmx . rc /* set rc='' */
  call SysGetEA eP,'X_SIZE','x_sz'
  if result \= 0 | \datatype(x_sz,'w') then
    do
      x_sz = "" ; x_win = xmx
     end
   else
    x_win = x_sz
  call SysGetEA eP,'Y_SIZE','y_sz'
  if result \= 0 | \datatype(y_sz,'w') then
    do
      y_sz = "" ; y_win = ymx
     end
   else
    y_win = y_sz
m_set:
  if char = 'a'x | x_sz = "" | y_sz = "" then
    do
      call PYRxShow 1,0,xmx*(ymx-2),'',DIM_ATTR /* dim screen - waiting */
      call PYRxMsg ,,,p_ttl,rc||'0'x||'Select window height (Y ['y_win'])',my_hwnd,,,
                   ' 10 ',' 15 ',' 20 ',' 25 ',' 30 ',' 35 ',' 40 ',' 45 ',' 50 '
      if result >= 11 then
        y_sz = 10 + 5*(result-11) /* one of proposed values was selected */
       else
        if y_sz = "" then
          y_sz = y_win            /* cancelled - will use current value */
      call PYRxMsg ,,,p_ttl,'0'x||'Select window width (X ['x_win'])',my_hwnd,,,
                   ' 80 ',' 90 ',' 100 ',' 110 ',' 120 ',' 130 '
      if result >= 11 then
        x_sz = 80 + 10*(result-11)/* same, as for Y */
       else
        if x_sz = "" then
          x_sz = x_win            /* same, as for Y */
     end
  if x_sz \= xmx | y_sz \= ymx then
    do
      '@mode co'x_sz' 'y_sz       /* trying to set new mode */
      if rc \= 0 then
        do                        /* error */
          rc = x_sz'x'y_sz' mode not supported'||'0'x
          x_sz = '' ; y_sz = ''
          signal m_set
         end
      call SysPutEA eP,'X_SIZE',x_sz  /* store new values of size */
      call SysPutEA eP,'Y_SIZE',y_sz
     end

  call check_pos  /* also gets x_win y_win x_sz y_sz dskX dskY */
  if char \= 'a'x then
    call PYRxGo 't','!',my_hwnd,x_win' 'y_win' 'x_sz' 'y_sz' 0 131' /* 131 = SWP_MOVE+SWP_SIZE+SWP_ACTIVATE */

  parse value PYRxShow(0,0,0) with . . ymx xmx .
/*  call PYRxShow 0,0,ymx*xmx,' ',PATH_ATTR*/
 /* here some var-s are initializing */
  L_WIDTH = 40 ; R_WIDTH = xmx - L_WIDTH
  INF_LINES = ymx - 3 ; brief = '' ; q_kill = 0
  sys_time = 0 ; s_off = 1 ; draw_time = 0
  k_ctrl = 0
  rt_view = 'PATH' ; rt_head = EXE_HEAD
  call PYRxShow ,,0,left(LEFT_HEAD,L_WIDTH),HEAD_ATTR
  select
    when xmx < 100 then
      do
        WIN_HEAD.1 = WIN_HEAD_1||'1a'x
        WIN_HEAD.2 = 'hWnd         'WIN_HEAD_2_80
        THR_HEAD.0 = THR_HEAD||'1a'x
       end
    when xmx = 100 then
      do
        WIN_HEAD.1 = WIN_HEAD_1||WIN_HEAD_2_100
        THR_HEAD.0 = THR_HEAD'     Time used'
       end
    otherwise
        WIN_HEAD.1 = WIN_HEAD_1||WIN_HEAD_2_80
        THR_HEAD.0 = THR_HEAD'     Time used'
   end
  call PYRxGo 't',,0,'wl' /* let's obtain handle of "Desktop" window */
  dsk_hwnd = word(wl.1,1)
 return

/** expressions below are executable in "set_icon" procedure only once at program start */
/** all constant variables are initialized here */
/*~
P_I_FG = '7'x ;    P_I_SEL = '3e'x
ACT_BG = '50'x ;   IDLE_BG = '10'x
PATH_ATTR = '7'x ; HEAD_ATTR = '72'x
SUM_ATTR = '1b'x ; KEY_ATTR = '71'x
WIDE_ATTR = '1b'x ; MORE_ATTR = '1e'x ; DIM_ATTR = '8'x
REG_U_BG = '40'x ; REG_S_BG = '60'x
IDL_U_BG = '50'x ; IDL_S_BG = '10'x ; THR_ATTR = 'b'x
CPU_B_BG = '40'x ; CPU_I_BG = '60'x ; CPU_ATTR = 'b'x
INFO_BG = '70'x ; INFO_TXT_ATTR = '70'x ; INFO_DATA_ATTR = '71'x
HELP_BG = '70'x ; HLP_KEY_ATTR = '71'x ; HLP_TXT_ATTR = '70'x

SLICE = 32 ; SCAN_DT = 1000

LEFT_HEAD = ' PID  PPID  Type   Time used     Peak'
EXE_HEAD = 'Exe Name '||'1a'x
WIN_HEAD.0 = 'TaskList title '||'1a'x
WIN_HEAD_1 =    'hWnd        TaskLst   Window Attrib.  '/* WIN_HEAD.1 will be initialized in set_size */
WIN_HEAD_2_80 = ' Xorg    Yorg    dX    dY '||'1a'x     /* WIN_HEAD.2 will be initialized in set_size */
WIN_HEAD_2_100 = 'Xorg   Yorg   dX   dY'||'1a'x         /* WIN_HEAD.2 will be initialized in set_size */
THR_HEAD   = ' TID Slot Priort State  SleepID  Peak '
THR_HEAD.1 = ' TID Priort State  Peak    Time used  '||'1a'x
CPU_HEAD = '  N   Busy    Intr    Idle    Freq'
INF_HEAD = '  System info'
HLP_HEAD = '  Control keys'

BRIEF.L = "'2018'x||' '||'19'x||' <PgUp><PgDn><Home><End>';brief=brief||right('<C>PU <I>nfo <P>ath <T>hread <W>task <F1>',xmx-length(brief)-1)"
BRIEF.LR= "'<PgUp><PgDn><Home><End> '||'18'x||' '||'19'x||' +<Ctrl>' ;brief=brief||right('<C>PU <I>nfo <P>ath <T>hread <W>task <F1>',xmx-length(brief)-1)"
BRIEF.1 = "'  Kill process (ID='s_pid') Y/N ?'"
BRIEF.2 = "'  Kill -9 process (ID='s_pid') Y/N ?'"
BRIEF.3 = "'  <0>reboot  <1>standby  <2>suspend  <3>power_off  <4>shutdown'"

help = '<Up>'||'1'x||7||'1'x||'Marker Up'||'0'x
help = help||'<Down>'||'1'x||7||'1'x||'Marker Down'||'0'x
help = help||'<PgUp>'||'1'x||7||'1'x||'Marker Page Up'||'0'x
help = help||'<PgDn>'||'1'x||7||'1'x||'Marker Page Down'||'0'x
help = help||'<Home>'||'1'x||7||'1'x||'Marker Page Top'||'0'x
help = help||'<End>'||'1'x||7||'1'x||'Marker Page Bottom'||'00010100'x
help = help||'<Ctrl>+'||'1'x||7||'0100'x
help = help||'  <Marker Key>'||'1'x||17||'1'x||'Scroll right list'||'0'x
help = help||'  <Left>,<Right>'||'1'x||17||'1'x||'Scroll path/title brief'||'00010100'x
help = help||'<Ctrl>'||'1'x||7||'1'x||'klick ~1sec : Toggle brief info'||'00010100'x
help = help||'<Left>,<Right>'||'1'x||15||'1'x||'Vary right list'||'00010100'x
help = help||'0101'x||'Right panel :'||'0'x
help = help||'  <C>'||'1'x||6||'1'x||'CPU Info'||'0'x
help = help||'  <I>'||'1'x||6||'1'x||'System Info'||'0'x
help = help||'  <P>'||'1'x||6||'1'x||'Processes Paths'||'0'x
help = help||'  <T>'||'1'x||6||'1'x||'Threads of Sel.Process'||'0'x
help = help||'  <W>'||'1'x||6||'1'x||'TaskList and windows info'||'0'x
help = help||' <F1>'||'1'x||6||'1'x||'Keys reference (this screen)'||'00010100'x
help = help||'<Del>[+<Ctrl>]'||'1'x||15||'1'x||'Kill [-9] for Sel.Process'||'0'x
help = help||'1'x||10||'1'x||'or Stop System if kill PID<=15'||'00010100'x
help = help||'<Ins>'||'1'x||12||'1'x||'Copy screen to clipboard'||'0'x
help = help||'<Ctrl><Ins>'||'1'x||12||'1'x||'Add screen to clipboard'||'00010100'x
help = help||'<Enter>'||'1'x||14||'1'x||'Switch to selected process'||'0'x
help = help||'<Ctrl><Enter>'||'1'x||14||'1'x||'Set own window size'||'0'x
help = help||'<Tab>'||'1'x||14||'1'x||'Minimize own window'||'0'x
help = help||'<Esc>'||'1'x||14||'1'x||'Quit program'||'0'x

F_coeff = 1000 ; NO_DATA = 'data unavailable'
MRK_TAB = 10 ; ctrl_state = 0

~* base64-coded icon is below
   can be decoded in "set_icon" procedure
*~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*/
