/* REXX */
SAY 'Before RxFuncAdd'
CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs
bootdrive = SysBootDrive()
/*
SAY 'OS/2 version' SysOS2Ver()
SAY 'SysBootDrive() returns' bootdrive '(filesys' SysFileSystemType(bootdrive)')'
*/
verShort = 805
destdir = bootdrive'\Tcl'verShort'\bin'
orgcsname = bootdrive'\config.sys'
orgcs = STREAM(orgcsname, 'c', 'open read')
IF orgcs \= 'READY:'
THEN
    DO
    SAY 'Couldn''t open' bootdrive'\config.sys for reading'
    exit
    END
/*
SAY bootdrive'\config.sys' orgcs
*/

newcsname =  bootdrive'\config.new'
newcs = STREAM(newcsname, 'c', 'open write')
IF newcs \= 'READY:'
THEN
    DO
    SAY 'Couldn''t open config.new for writing'
    CALL STREAM bootdrive'\config.sys', 'c', 'close'
    exit
    END
/*
SAY 'config.new' newcs
*/

/* Truncate file if it already exists */
CALL LINEOUT newcsname, , 1

SAY STREAM(orgcsname, 's')
DO WHILE STREAM(orgcsname, 's') = 'READY'
    curline = LINEIN(orgcsname)
    /* MODIFY curline */
    PARSE UPPER VAR curline word1 rest
    IF word1 = 'SET'
    THEN
        DO
            /* Can be the SET PATH= line */
            PARSE VALUE rest WITH envvar '=' path
            IF envvar = 'PATH'
            THEN
                DO
/* Check for already existing!*/
                /* make sure there's no ; on the end when we add it */
                curline = 'SET PATH='STRIP(path,'T',';')';'destdir';'
                END
        END
    ELSE
        DO
            /* Can be the LIBPATH= line */
            PARSE VALUE curline WITH envvar '=' path
            IF envvar = 'LIBPATH'
            THEN
                DO
/* Check for already existing!*/
                /* make sure there's no ; on the end when we add it */
                curline = 'LIBPATH='STRIP(path,'T',';')';'destdir';'
                END
        END
    /* END MODIFY curline */
    CALL LINEOUT newcsname, curline
    LINEOUT newcsname, 'SET TCL_LIBRARY='bootdrive'/'
END

CALL STREAM orgcsname, 'c', 'close'
CALL STREAM newcsname, 'c', 'close'

ADDRESS CMD 'RENAME 'orgcsname' config.'verShort
ADDRESS CMD 'RENAME 'newcsname' config.sys'
