#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /units/arch/src/Fnorb/orb/RCS/DSI.py,v $
# Version:      @(#)$RCSfile: DSI.py,v $ $Revision: 1.12 $
#
#############################################################################
""" Implementation of the Dynamic Skeleton Interface (DSI). """


class ServerRequest:
    """ Implementation of the PIDL ServerRequest interface. """

    def __init__(self, request_header, cursor):
	""" Constructor. """

	self.__request_header = request_header
	self.__cursor = cursor

	return

    #########################################################################
    # CORBA interface.
    #########################################################################
    
    def initialise(self, inputs, outputs, exceptions):
	""" Initialise the server request. """

	self.__inputs = inputs
	self.__outputs = outputs
	self.__exceptions = exceptions

	# The unmarshalled arguments for the request (they are unmarshalled
	# 'on demand' when the 'arguments' method is called).
	self.__arguments = None

	return

    def operation(self):
	""" Return the operation name. """

	return self.__request_header.operation

    def inputs(self):
	""" Return the input typecodes. """

	return self.__inputs

    def outputs(self):
	""" Return the output typecodes. """

	return self.__outputs

    def exceptions(self):
	""" Return the exception typecodes. """

	return self.__exceptions

    def arguments(self):
	""" Return the request arguments (as a tuple). """

	if self.__arguments is None:
	    # Unmarshal each parameter according to its typecode.
	    arguments = []
	    for tc in self.__inputs:
		arguments.append(tc._fnorb_unmarshal_value(self.__cursor))

	    self.__arguments = tuple(arguments)

	return self.__arguments

    def results(self, results):
	""" Set the results of the request. """

	self.__results = results
	return

    def exception(self, ex):
 	""" Set the exception raised by the request. """

 	self.__ex = ex
 	return

    #########################################################################
    # Fnorb-specific interface.
    #########################################################################

    def _fnorb_exception(self):
	""" Get the exception raised by the request. """

	return self.__ex

    def _fnorb_results(self):
	""" Get the results of the request. """
	return self.__results

#############################################################################
