//FILE: WINREG.INC
//VERSION: 1.0

(*$W44- *)
(*$W53- *)

(*$I winbase.inc *)

type
	REGSAM = ACCESS_MASK;
	HKEY = HANDLE;
	_HKEY = HKEY;
const
	HKEY_CLASSES_ROOT		= $80000000;
	HKEY_CURRENT_USER		= $80000001;
	HKEY_LOCAL_MACHINE		= $80000002;
	HKEY_USERS 				= $80000003;
	HKEY_PERFORMANCE_DATA	= $80000004;
	HKEY_CURRENT_CONFIG		= $80000005;
	HKEY_DYN_DATA			= $80000006;

	PROVIDER_KEEPS_VALUE_LENGTH = $1;

	//
	// Open/Create Options
	//
	REG_OPTION_RESERVED = $00000000;
	REG_OPTION_NON_VOLATILE = $00000000;
	REG_OPTION_VOLATILE = $00000001;
	REG_OPTION_CREATE_LINK = $00000002;
	REG_OPTION_BACKUP_RESTORE = $00000004;
	REG_OPTION_OPEN_LINK = $00000008;
	REG_LEGAL_OPTION = $F;

	//
	// Key creation/open disposition
	//

	REG_CREATED_NEW_KEY = $00000001;
	REG_OPENED_EXISTING_KEY = $00000002;

	//
	// Key restore flags
	//
	REG_WHOLE_HIVE_VOLATILE = $00000001;
	REG_REFRESH_HIVE = $00000002;
	REG_NO_LAZY_FLUSH = $00000004;

	//
	// Notify filter values
	//
	REG_NOTIFY_CHANGE_NAME = $00000001;
	REG_NOTIFY_CHANGE_ATTRIBUTES = $00000002;
	REG_NOTIFY_CHANGE_LAST_SET = $00000004;
	REG_NOTIFY_CHANGE_SECURITY = $00000008;
	REG_LEGAL_CHANGE_FILTER = $0000000F;

	//
	// Predefined Value Types.
	//
	REG_NONE = 0;
	REG_SZ = 1;
	REG_EXPAND_SZ = 2;
	REG_BINARY = 3;
	REG_DWORD = 4;
	REG_DWORD_LITTLE_ENDIAN = 4;
	REG_DWORD_BIG_ENDIAN = 5;
	REG_LINK = 6;
	REG_MULTI_SZ = 7;
	REG_RESOURCE_LIST = 8;
	REG_FULL_RESOURCE_DESCRIPTOR = 9;
	REG_RESOURCE_REQUIREMENTS_LIST = 10;

type
	PVALUE = packed record
		pv_valuename : LPSTR;
		pv_valuelen  : integer;
		pv_value_context : LPVOID;
		pv_type : DWORD;
	end;

	REG_PROVIDER = packed record
		pi_R0_1val : address;
		pi_R0_allvals : address;
		pi_R3_1val : address;
		pi_R3_allvals : address;
		pi_flags : DWORD;
		pi_key_context : address;
	end;

	VALENT = packed record
		ve_valuename : LPSTR;
		ve_valuelen : DWORD;
		ve_valueptr : DWORD;
		ve_type : DWORD;
	end;

const
	WIN31_CLASS = 0;

	function RegCloseKey(hKey : _HKEY) : LONG;
    	external dll='advapi32.dll' name='RegCloseKey' stdcall;

	function RegConnectRegistry(lpMachineName : address; hKey : _HKEY; var phkResult : _HKEY) : LONG;
    	external dll='advapi32.dll' name='RegConnectRegistryA' stdcall;

	function RegCreateKey(hKey : _HKEY; lpSubKey : address; var phkResult : _HKEY) : LONG;
    	external dll='advapi32.dll' name='RegCreateKeyA' stdcall;
	function RegCreateKeyEx(hKey : _HKEY; lpSubKey : address; Reserved : DWORD;
								lpClass : address; dwOptions : DWORD;
								samDesired : REGSAM; var SecurityAttributes : SECURITY_ATTRIBUTES;
								var phkResult : _HKEY; var lpdwDisposition : DWORD) : LONG;
    	external dll='advapi32.dll' name='RegCreateKeyExA' stdcall;

	function RegDeleteKey(hKey : _HKEY; lpSubKey : address) : LONG;
    	external dll='advapi32.dll' name='RegDeleteKeyA' stdcall;

	function RegDeleteValue(hKey : _HKEY; lpValueName : address) : LONG;
    	external dll='advapi32.dll' name='RegDeleteValueA' stdcall;

    function RegEnumKey(hKey : _HKEY; dwIndex : DWORD; lpName : address; cbName : DWORD) : LONG;
    	external dll='advapi32.dll' name='RegEnumKeyA' stdcall;

    function RegEnumKeyEx(hKey : _HKEY; dwIndex : DWORD; lpName : address;
    						var lpcbName, lpReserved : DWORD;
    						lpClass : address; var lpcbClass : DWORD;
    						var lpftLastWriteTime : FILETIME) : LONG;
    	external dll='advapi32.dll' name='RegEnumKeyExA' stdcall;

	function RegEnumValue(hKey : _HKEY; dwIndex : DWORD; lpValueName : address;
							var lpcbValueName, lpReserved, lpType : DWORD;
							var lpData : BYTE;
							var lpcbData : DWORD) : LONG;
    	external dll='advapi32.dll' name='RegEnumValueA' stdcall;

	function RegFlushKey(hKey : _HKEY) : LONG;
    	external dll='advapi32.dll' name='RegFlushKey' stdcall;

	function RegGetKeySecurity(hKey : _HKEY; SecurityInformation : SECURITY_INFORMATION;
								var pSecurityDescriptor : SECURITY_DESCRIPTOR;
								var lpcbSecurityDescriptor : DWORD) : LONG;
    	external dll='advapi32.dll' name='RegGetKeySecurity' stdcall;

	function RegLoadKey(hKey : _HKEY; lpSubKey, lpFile : address) : LONG;
    	external dll='advapi32.dll' name='RegLoadKeyA' stdcall;

	function RegNotifyChangeKeyValue(hKey : _HKEY; bWatchSubtree : BOOL;
										dwNotifyFilter : DWORD; hEvent : HANDLE;
										fAsynchronus : BOOL) : LONG;
    	external dll='advapi32.dll' name='RegNotifyChangeKeyValue' stdcall;

	function RegOpenKey(hKey : _HKEY; lpSubKey : address; var phkResult : _HKEY) : LONG;
    	external dll='advapi32.dll' name='RegOpenKeyA' stdcall;
	function RegOpenKeyEx(hKey : _HKEY; lpSubKey : address;
							ulOptions : DWORD; samDesired : REGSAM;
							var phkResult : _HKEY) : LONG;
    	external dll='advapi32.dll' name='RegOpenKeyExA' stdcall;

	function RegQueryInfoKey(hKey : _HKEY; lpClass : address; var lpcbClass : DWORD;
								var lpReserved, lpcSubKeys, lpcbMaxSubKeyLen, lpcbMaxClassLen,
								    lpcValues, lpcbMaxValueNameLen, lpcbMaxValueLen : DWORD;
								var lpcbSecurityDescriptor : DWORD;
								var lpftLastWriteTime : FILETIME) : LONG;
    	external dll='advapi32.dll' name='RegQueryInfoKeyA' stdcall;

	function RegQueryValue(hKey : _HKEY; lpSubKey, lpValue : address; var lpcbValue : LONG) : LONG;
    	external dll='advapi32.dll' name='RegQueryValueA' stdcall;

	function RegQueryMultipleValues(hKey : _HKEY; var val_list : VALENT; num_vals : DWORD;
									lpValueBuf : address; var ldwTotsize : DWORD) : LONG;
    	external dll='advapi32.dll' name='RegQueryMultipleValuesA' stdcall;

	function RegQueryValueEx(hKey : _HKEY; lpValueName : address; var lpReserved, lpType : DWORD;
								var lpData : BYTE; var lpcbData : DWORD) : LONG;
    	external dll='advapi32.dll' name='RegQueryValueExA' stdcall;

	function RegReplaceKey(hKey : _HKEY; lpSubKey, lpNewFile, lpOldFile : address) : LONG;
    	external dll='advapi32.dll' name='RegReplaceKeyA' stdcall;

	function RegRestoreKey(hKey : _HKEY; lpFile : address; dwFlags : DWORD) : LONG;
    	external dll='advapi32.dll' name='RegRestoreKeyA' stdcall;

	function RegSaveKey(hKey : _HKEY; lpFile : address; var lpSecurityAttributes : SECURITY_ATTRIBUTES) : LONG;
    	external dll='advapi32.dll' name='RegSaveKeyA' stdcall;

	function RegSetKeySecurity(hKey : _HKEY; SecurityInformation : SECURITY_INFORMATION;
								var pSecurityDescriptor : SECURITY_DESCRIPTOR) : LONG;
    	external dll='advapi32.dll' name='RegSetKeySecurity' stdcall;

	function RegSetValue(hKey : _HKEY; lpSubKey : address;
							dwType : DWORD; lpData : address; cbData : DWORD) : LONG;
    	external dll='advapi32.dll' name='RegSetValueA' stdcall;

	function RegSetValueEx(hKey : _HKEY; lpValueName : address;
							Reserved, dwType : DWORD;
							lpData : address; cbData : DWORD) : LONG;
    	external dll='advapi32.dll' name='RegSetValueExA' stdcall;

	function RegUnloadKey(hKey : _HKEY; lpSubKey : address) : LONG;
    	external dll='advapi32.dll' name='RegUnloadKeyA' stdcall;


	//
	// Remoteable System Shutdown APIs
	//
	function InitiateSystemShutdown
			(
				lpMachineName, lpMessage : address;
				dwTimeout : DWORD;
				bForceAppsClosed, bRebootAfterShutdown : BOOL
			) : BOOL;
    	external dll='advapi32.dll' name='InitiateSystemShutdownA' stdcall;

	function AbortSystemShutdown(lpMachineName : address) : BOOL;
    	external dll='advapi32.dll' name='AbortSystemShutdownA' stdcall;

(*$W53. *)
(*$W44. *)
