//FILE: WINDEF.INC
//VERSION: 1.0
(*$W44- *)

type
    LONG = integer;
	ULONG = word;
	UCHAR = char;
	SHORT = shortint;
	USHORT = shortword;
	PSTR = address;
	LPSTR = address;
	LPCSTR = address;
	LPWSTR = address;
	LPCWSTR = address;
	PROC = word;
	OLECHAR = char;
	LPOLESTR = LPSTR;
	LPCOLESTR = LPCSTR;
	PVOID = address;
	LPVOID = PVOID;
const 
	MAX_PATH = 260;
	MAX_CSTRING_PATH = 259;
	MAXLONG = $7fffffff;

type
	DWORD = word;
	BOOL = integer;
	FLOAT = single;
	UINT = word;

	WPARAM = UINT;
	LPARAM = LONG;
	LRESULT = LONG;

	ACESS_MASK = DWORD;
	
	HANDLE = word;
	ATOM = shortword;
	HGLOBAL = HANDLE;
	HLOCAL = HANDLE;
	GLOBALHANDLE = HANDLE;
	LOCALHANDLE = HANDLE;
	HWND = HANDLE;
	HGDIOBJ = HANDLE;

	HACCEL = HANDLE;
	HBITMAP = HANDLE;
    HBRUSH = HANDLE;
	HCOLORSPACE = HANDLE;
	HDC = HANDLE;
	HGLRC = HANDLE;
	HDESK = HANDLE;
    HENHMETAFILE = HANDLE;
	HFONT = HANDLE;
	HICON = HANDLE;
	HMENU = HANDLE;
	HMETAFILE = HANDLE;
	HINSTANCE = HANDLE;
	HMODULE = HINSTANCE;
	HPALETTE = HANDLE;
	HPEN = HANDLE;
	HRGN = HANDLE;
	HRSRC = HANDLE;
	HSTR = HANDLE;
	HTASK = HANDLE;
	HWINSTA = HANDLE;
	HKL = HANDLE;

	HFILE = integer;
	HCURSOR = HICON;
	HHOOK = HANDLE;

	COLORREF = DWORD;

	//Aliases created to avoid name clashes
	_HWND = HWND;
	_WPARAM = WPARAM;
	_LPARAM = LPARAM;
	_LRESULT = LRESULT;
	_HDC = HDC;
	_HICON = HICON;
	_HINSTANCE = HINSTANCE;
	_HKL = HKL;
	_HWINSTA = HWINSTA;
	_HCURSOR = HCURSOR;
	_HMENU = HMENU;
	_HACCEL = HACCEL;
	_HBRUSH = HBRUSH;
	_HRGN = HRGN;
	_HGLRC = HGLRC;
	_HFILE = HFILE;

	WCHAR = USHORT;

	LIST_ENTRY = packed record
   		Flink : address;
   		Blink : address;
	end;

	SINGLE_LIST_ENTRY = packed record
		Next : address;
	end;

	LARGE_INTEGER = packed record
        LowPart : DWORD;
        HighPart : LONG;
	end;

	ULARGE_INTEGER = packed record
        LowPart : DWORD;
        HighPart : DWORD;
	end;

	LUID = packed record
        LowPart : DWORD;
        HighPart : LONG;
	end;
	_LUID = LUID;

	GUID = packed record
	    Data1 : word;
    	Data2 : shortword;
	    Data3 : shortword;
    	Data4 : array[0..7] of char;
	end;
    LPGUID = address;

const
	HFILE_ERROR = -1;

type
	RECT = packed record
		left : LONG;
		top : LONG;
		right : LONG;
		bottom : LONG;
	end;

	RECTL = packed record
		left : LONG;
		top : LONG;
		right : LONG;
		bottom : LONG;
	end;

	POINT = packed record
		x : LONG;
		y : LONG;
	end;

	POINTL = packed record
		x : LONG;
		y : LONG;
	end;

	SIZE = packed record
		cx : LONG;
		cy : LONG;
	end;
	SIZEL = SIZE;

	POINTS = packed record
		x : SHORT;
		y : SHORT;
	end;

const
    LANG_NEUTRAL = $00;
    LANG_AFRIKAANS = $36;
    LANG_ALBANIAN = $1c;
    LANG_ARABIC = $01;
    LANG_BASQUE = $2d;
    LANG_BELARUSIAN = $23;
    LANG_BULGARIAN = $02;
    LANG_CATALAN = $03;
    LANG_CHINESE = $04;
    LANG_CROATIAN = $1a;
    LANG_CZECH = $05;
    LANG_DANISH = $06;
    LANG_DUTCH = $13;
    LANG_ENGLISH = $09;
    LANG_ESTONIAN = $25;
    LANG_FAEROESE = $38;
    LANG_FARSI = $29;
    LANG_FINNISH = $0b;
    LANG_FRENCH = $0c;
    LANG_GERMAN = $07;
    LANG_GREEK = $08;
    LANG_HEBREW = $0d;
    LANG_HUNGARIAN = $0e;
    LANG_ICELANDIC = $0f;
    LANG_INDONESIAN = $21;
    LANG_ITALIAN = $10;
    LANG_JAPANESE = $11;
    LANG_KOREAN = $12;
    LANG_LATVIAN = $26;
    LANG_LITHUANIAN = $27;
    LANG_NORWEGIAN = $14;
    LANG_POLISH = $15;
    LANG_PORTUGUESE = $16;
    LANG_ROMANIAN = $18;
    LANG_RUSSIAN = $19;
    LANG_SERBIAN = $1a;
    LANG_SLOVAK = $1b;
    LANG_SLOVENIAN = $24;
    LANG_SPANISH = $0a;
    LANG_SWEDISH = $1d;
    LANG_THAI = $1e;
    LANG_TURKISH = $1f;
    LANG_UKRAINIAN = $22;
    LANG_VIETNAMESE = $2a;

    SUBLANG_NEUTRAL = $00;
    SUBLANG_DEFAULT = $01;
    SUBLANG_SYS_DEFAULT = $02;
    SUBLANG_ARABIC_SAUDI_ARABIA = $01;
    SUBLANG_ARABIC_IRAQ = $02;
    SUBLANG_ARABIC_EGYPT = $03;
    SUBLANG_ARABIC_LIBYA = $04;
    SUBLANG_ARABIC_ALGERIA = $05;
    SUBLANG_ARABIC_MOROCCO = $06;
    SUBLANG_ARABIC_TUNISIA = $07;
    SUBLANG_ARABIC_OMAN = $08;
    SUBLANG_ARABIC_YEMEN = $09;
    SUBLANG_ARABIC_SYRIA = $0a;
    SUBLANG_ARABIC_JORDAN = $0b;
    SUBLANG_ARABIC_LEBANON = $0c;
    SUBLANG_ARABIC_KUWAIT = $0d;
    SUBLANG_ARABIC_UAE = $0e;
    SUBLANG_ARABIC_BAHRAIN = $0f;
    SUBLANG_ARABIC_QATAR = $10;
    SUBLANG_CHINESE_TRADITIONAL = $01;
    SUBLANG_CHINESE_SIMPLIFIED = $02;
    SUBLANG_CHINESE_HONGKONG = $03;
    SUBLANG_CHINESE_SINGAPORE = $04;
    SUBLANG_DUTCH = $01;
    SUBLANG_DUTCH_BELGIAN = $02;
    SUBLANG_ENGLISH_US = $01;
    SUBLANG_ENGLISH_UK = $02;
    SUBLANG_ENGLISH_AUS = $03;
    SUBLANG_ENGLISH_CAN = $04;
    SUBLANG_ENGLISH_NZ = $05;
    SUBLANG_ENGLISH_EIRE = $06;
    SUBLANG_ENGLISH_SOUTH_AFRICA = $07;
    SUBLANG_ENGLISH_JAMAICA = $08;
    SUBLANG_ENGLISH_CARIBBEAN = $09;
    SUBLANG_ENGLISH_BELIZE = $0a;
    SUBLANG_ENGLISH_TRINIDAD = $0b;
    SUBLANG_FRENCH = $01;
    SUBLANG_FRENCH_BELGIAN = $02;
    SUBLANG_FRENCH_CANADIAN = $03;
    SUBLANG_FRENCH_SWISS = $04;
    SUBLANG_FRENCH_LUXEMBOURG = $05;
    SUBLANG_GERMAN = $01;
    SUBLANG_GERMAN_SWISS = $02;
    SUBLANG_GERMAN_AUSTRIAN = $03;
    SUBLANG_GERMAN_LUXEMBOURG = $04;
    SUBLANG_GERMAN_LIECHTENSTEIN = $05;
    SUBLANG_ITALIAN = $01;
    SUBLANG_ITALIAN_SWISS = $02;
    SUBLANG_KOREAN = $01;
    SUBLANG_KOREAN_JOHAB = $02;
    SUBLANG_NORWEGIAN_BOKMAL = $01;
    SUBLANG_NORWEGIAN_NYNORSK = $02;
    SUBLANG_PORTUGUESE = $02;
    SUBLANG_PORTUGUESE_BRAZILIAN = $01;
    SUBLANG_SERBIAN_LATIN = $02;
    SUBLANG_SERBIAN_CYRILLIC = $03;
    SUBLANG_SPANISH = $01;
    SUBLANG_SPANISH_MEXICAN = $02;
    SUBLANG_SPANISH_MODERN = $03;
    SUBLANG_SPANISH_GUATEMALA = $04;
    SUBLANG_SPANISH_COSTA_RICA = $05;
    SUBLANG_SPANISH_PANAMA = $06;
    SUBLANG_SPANISH_DOMINICAN_REPUBLIC = $07;
    SUBLANG_SPANISH_VENEZUELA = $08;
    SUBLANG_SPANISH_COLOMBIA = $09;
    SUBLANG_SPANISH_PERU = $0a;
    SUBLANG_SPANISH_ARGENTINA = $0b;
    SUBLANG_SPANISH_ECUADOR = $0c;
    SUBLANG_SPANISH_CHILE = $0d;
    SUBLANG_SPANISH_URUGUAY = $0e;
    SUBLANG_SPANISH_PARAGUAY = $0f;
    SUBLANG_SPANISH_BOLIVIA = $10;
    SUBLANG_SPANISH_EL_SALVADOR = $11;
    SUBLANG_SPANISH_HONDURAS = $12;
    SUBLANG_SPANISH_NICARAGUA = $13;
    SUBLANG_SPANISH_PUERTO_RICO = $14;
    SUBLANG_SWEDISH = $01;
    SUBLANG_SWEDISH_FINLAND = $02;

    SORT_DEFAULT = $0;
    SORT_JAPANESE_XJIS = $0;
    SORT_JAPANESE_UNICODE = $1;
    SORT_CHINESE_BIG5 = $0;
    SORT_CHINESE_PRCP = $0;
    SORT_CHINESE_UNICODE = $1;
    SORT_CHINESE_PRC = $2;
    SORT_KOREAN_KSC = $0;
    SORT_KOREAN_UNICODE = $1;
    SORT_GERMAN_PHONE_BOOK = $1;

const
// mode selections for the device mode function
	DM_UPDATE = 1;
	DM_COPY = 2;
	DM_PROMPT = 4;
	DM_MODIFY = 8;

	DM_IN_BUFFER = DM_MODIFY;
	DM_IN_PROMPT = DM_PROMPT;
	DM_OUT_BUFFER = DM_COPY;
	DM_OUT_DEFAULT = DM_UPDATE;

// device capabilities indices
	DC_FIELDS = 1;
	DC_PAPERS = 2;
	DC_PAPERSIZE = 3;
	DC_MINEXTENT = 4;
	DC_MAXEXTENT = 5;
	DC_BINS = 6;
	DC_DUPLEX = 7;
	DC_SIZE = 8;
	DC_EXTRA = 9;
	DC_VERSION = 10;
	DC_DRIVER = 11;
	DC_BINNAMES = 12;
	DC_ENUMRESOLUTIONS = 13;
	DC_FILEDEPENDENCIES = 14;
	DC_TRUETYPE = 15;
	DC_PAPERNAMES = 16;
	DC_ORIENTATION = 17;
	DC_COPIES = 18;
    DC_BINADJUST = 19;
    DC_EMF_COMPLIANT = 20;
    DC_DATATYPE_PRODUCED = 21;
    DC_COLLATE = 22;

	//
	//  Masks for the predefined standard access types
	//
	ACCESS_DELETE = $00010000;
	ACCESS_READ_CONTROL = $00020000;
	ACCESS_WRITE_DAC = $00040000;
	ACCESS_WRITE_OWNER = $00080000;
	ACCESS_SYNCHRONIZE = $00100000;
	ACCESS_STANDARD_RIGHTS_REQUIRED = $000F0000;

	STANDARD_RIGHTS_READ = ACCESS_READ_CONTROL;
	STANDARD_RIGHTS_WRITE = ACCESS_READ_CONTROL;
	STANDARD_RIGHTS_EXECUTE = ACCESS_READ_CONTROL;
	STANDARD_RIGHTS_ALL = $001F0000;
	SPECIFIC_RIGHTS_ALL = $0000FFFF;

	ACCESS_SYSTEM_SECURITY = $01000000;

	MAXIMUM_ALLOWED = $02000000;

	GENERIC_READ	= $80000000;
	GENERIC_WRITE	= $40000000;
	GENERIC_EXECUTE	= $20000000;
	GENERIC_ALL     = $10000000;

type
	MESSAGE_RESOURCE_ENTRY = packed record
	    Length : shortword;
    	Flags : shortword;
	end;

const
	MESSAGE_RESOURCE_UNICODE = $0001;

type
	MESSAGE_RESOURCE_BLOCK = packed record
	    LowId : DWORD;
    	HighId : DWORD;
	    OffsetToEntries : DWORD;
	end;

	MESSAGE_RESOURCE_DATA = packed record
	    NumberOfBlocks : DWORD;
	end;

	RTL_CRITICAL_SECTION_DEBUG = packed record
	    Typ : shortword;
    	CreatorBackTraceIndex : shortword;
	    CriticalSection : address;
    	ProcessLocksList : LIST_ENTRY;
	    EntryCount : DWORD;
    	ContentionCount : DWORD;
	    Spare : array[0..1] of DWORD;
	end;

const
    RTL_CRITSECT_TYPE = 0;
    RTL_RESOURCE_TYPE = 1;

type
	RTL_CRITICAL_SECTION = packed record
	    DebugInfo : address;
	    LockCount : LONG;
    	RecursionCount : LONG;
	    OwningThread : HANDLE;
    	LockSemaphore : HANDLE;
	    Reserved : DWORD;
	end;

const
    DLL_PROCESS_ATTACH = 1;
    DLL_THREAD_ATTACH = 2;
    DLL_THREAD_DETACH = 3;
    DLL_PROCESS_DETACH = 0;

    EVENTLOG_SEQUENTIAL_READ = $0001;
    EVENTLOG_SEEK_READ = $0002;
    EVENTLOG_FORWARDS_READ = $0004;
    EVENTLOG_BACKWARDS_READ = $0008;

    EVENTLOG_SUCCESS = $0000;
    EVENTLOG_ERROR_TYPE = $0001;
    EVENTLOG_WARNING_TYPE = $0002;
    EVENTLOG_INFORMATION_TYPE = $0004;
    EVENTLOG_AUDIT_SUCCESS = $0008;
    EVENTLOG_AUDIT_FAILURE = $0010;
    EVENTLOG_START_PAIRED_EVENT = $0001;
    EVENTLOG_END_PAIRED_EVENT = $0002;
    EVENTLOG_END_ALL_PAIRED_EVENTS = $0004;
    EVENTLOG_PAIRED_EVENT_ACTIVE = $0008;
    EVENTLOG_PAIRED_EVENT_INACTIVE = $0010;

type
	EVENTLOGRECORD = packed record
	    Length : DWORD;
    	Reserved : DWORD;
	    RecordNumber : DWORD;
    	TimeGenerated : DWORD;
	    TimeWritten : DWORD;
    	EventID : DWORD;
	    EventType : shortword;
    	NumStrings : shortword;
	    EventCategory : shortword;
    	ReservedFlags : shortword;
	    ClosingRecordNumber : DWORD;
    	StringOffset : DWORD;
	    UserSidLength : DWORD;
    	UserSidOffset : DWORD;
	    DataLength : DWORD;
    	DataOffset : DWORD;
	end;

const
    DBG_CONTINUE = $00010002;
    DBG_TERMINATE_THREAD = $40010003;
    DBG_TERMINATE_PROCESS = $40010004;
    DBG_CONTROL_C = $40010005;
    DBG_CONTROL_BREAK = $40010008;
    DBG_EXCEPTION_NOT_HANDLED = $80010001;

	KEY_QUERY_VALUE = $0001;
	KEY_SET_VALUE = $0002;
	KEY_CREATE_SUB_KEY = $0004;
	KEY_ENUMERATE_SUB_KEYS = $0008;
	KEY_NOTIFY = $0010;
	KEY_CREATE_LINK	= $0020;

	KEY_READ = $20019;
	KEY_WRITE = $20006;
	KEY_EXECUTE = KEY_READ;
	KEY_ALL_ACCESS = $000F003F;

type
	PALETTEENTRY = packed record
    	peRed : byte;
    	peGreen : byte;
    	peBlue : byte;
    	peFlags : byte;
	end;

	LOGPALETTE = packed record
		palVersion : shortword;
		palNumEntries : shortword;
	end;

	ACL = packed record
    	AclRevision : UCHAR;
    	Sbz1 : UCHAR;
    	AclSize : USHORT;
    	AceCount : USHORT;
    	Sbz2 : USHORT;
	end;

	SECURITY_DESCRIPTOR_CONTROL = USHORT;

	SECURITY_DESCRIPTOR = packed record
    	Revision : UCHAR;
    	Sbz1 : UCHAR;
    	Control : SECURITY_DESCRIPTOR_CONTROL;
    	Owner : address;
    	Group : address;
    	Sacl : address;
    	Dacl : address;
	end;

	SID_IDENTIFIER_AUTHORITY = packed record
		Value : array[0..5] of byte;
	end;

	LUID_AND_ATTRIBUTES = packed record
	    Luid : _LUID;
    	Attributes : DWORD;
	end;

	SID = packed record
   		Revision : byte;
	   	SubAuthorityCount : byte;
  	 	IdentifierAuthority : SID_IDENTIFIER_AUTHORITY;
	end;

	SID_NAME_USE = (SidTypePlaceHolder, SidTypeUser, SidTypeGroup, SidTypeDomain,
    				SidTypeAlias, SidTypeWellKnownGroup, SidTypeDeletedAccount,
    				SidTypeInvalid, SidTypeUnknown);

	SID_AND_ATTRIBUTES = packed record
		Sid : address;
		Attributes : DWORD;
	end;

(*
	FILETIME = packed record
    	dwLowDateTime : DWORD;
    	dwHighDateTime : DWORD;
	end;

	SYSTEMTIME = packed record
    	wYear : shortword;
    	wMonth : shortword;
    	wDayOfWeek : shortword;
    	wDay : shortword;
    	wHour : shortword;
    	wMinute : shortword;
    	wSecond : shortword;
    	wMilliseconds : shortword;
	end;

	SECURITY_ATTRIBUTES = packed record
    	nLength : DWORD;
    	lpSecurityDescriptor : LPVOID;
    	bInheritHandle : BOOL;
	end;

	SECURITY_INFORMATION = DWORD;

	OVERLAPPED = packed record
	    Internal : DWORD;
    	InternalHigh : DWORD;
	    Offset : DWORD;
    	OffsetHigh : DWORD;
	    hEvent : HANDLE;
	end;

	PROCESS_INFORMATION = packed record
	    hProcess : HANDLE;
    	hThread : HANDLE;
	    dwProcessId : DWORD;
    	dwThreadId : DWORD;
	end;

	TOKEN_INFORMATION_CLASS = (
		TokenPlaceHolder, TokenUser, TokenGroups, TokenPrivileges,
    	TokenOwner, TokenPrimaryGroup, TokenDefaultDacl, TokenSource,
    	TokenType, TokenImpersonationLevel, TokenStatistics);

	ACL_INFORMATION_CLASS = (AclPlaceHolder, AclRevisionInformation, AclSizeInformation);

*)

const
	SIZE_OF_80387_REGISTERS = 80;

type
	FLOATING_SAVE_AREA = packed record
	    ControlWord : DWORD;
    	StatusWord : DWORD;
	    TagWord : DWORD;
    	ErrorOffset : DWORD;
	    ErrorSelector : DWORD;
    	DataOffset : DWORD;
	    DataSelector : DWORD;
    	RegisterArea : array[0..79] of BYTE;
	    Cr0NpxState : DWORD;
	end;

	CONTEXT = packed record
	    ContextFlags : DWORD;
    	Dr0 : DWORD;
	    Dr1 : DWORD;
    	Dr2 : DWORD;
	    Dr3 : DWORD;
    	Dr6 : DWORD;
	    Dr7 : DWORD;
    	FloatSave : FLOATING_SAVE_AREA;
    	SegGs : DWORD;
	    SegFs : DWORD;
    	SegEs : DWORD;
	    SegDs : DWORD;
    	Edi : DWORD;
	    Esi : DWORD;
    	Ebx : DWORD;
	    Edx : DWORD;
    	Ecx : DWORD;
	    Eax : DWORD;
	    Ebp : DWORD;
    	Eip : DWORD;
	    SegCs : DWORD;
    	EFlags : DWORD;
	    Esp : DWORD;
    	SegSs : DWORD;
	end;

	LDT_ENTRY = packed record
	    LimitLow : shortword;
    	BaseLow : shortword;
    	HighWord : DWORD;
	end;

const
    CONTEXT_i386 = $00010000;
    CONTEXT_i486 = $00010000;
    CONTEXT_CONTROL = $00010001;
    CONTEXT_INTEGER = $00010002;
    CONTEXT_SEGMENTS = $00010004;
    CONTEXT_FLOATING_POINT = $00010008;
    CONTEXT_DEBUG_REGISTERS = $00010010;
    CONTEXT_FULL = $00010007;

    STATUS_SEGMENT_NOTIFICATION = $40000005;
    STATUS_GUARD_PAGE_VIOLATION = $80000001;
    STATUS_INVALID_HANDLE = $C0000008;
    STATUS_WAIT_0 = $00000000;
    STATUS_ABANDONED_WAIT_0 = $00000080;
    STATUS_USER_APC = $000000C0;
    STATUS_TIMEOUT = $00000102;
    STATUS_PENDING = $00000103;
    STATUS_DATATYPE_MISALIGNMENT = $80000002;
    STATUS_BREAKPOINT = $80000003;
    STATUS_SINGLE_STEP = $80000004;
    STATUS_ACCESS_VIOLATION = $C0000005;
    STATUS_IN_PAGE_ERROR = $C0000006;
    STATUS_NO_MEMORY = $C0000017;
    STATUS_ILLEGAL_INSTRUCTION = $C000001D;
    STATUS_NONCONTINUABLE_EXCEPTION = $C0000025;
    STATUS_INVALID_DISPOSITION = $C0000026;
    STATUS_ARRAY_BOUNDS_EXCEEDED = $C000008C;
    STATUS_FLOAT_DENORMAL_OPERAND = $C000008D;
    STATUS_FLOAT_DIVIDE_BY_ZERO = $C000008E;
    STATUS_FLOAT_INEXACT_RESULT = $C000008F;
    STATUS_FLOAT_INVALID_OPERATION = $C0000090;
    STATUS_FLOAT_OVERFLOW = $C0000091;
    STATUS_FLOAT_STACK_CHECK = $C0000092;
    STATUS_FLOAT_UNDERFLOW = $C0000093;
    STATUS_INTEGER_DIVIDE_BY_ZERO = $C0000094;
    STATUS_INTEGER_OVERFLOW = $C0000095;
    STATUS_PRIVILEGED_INSTRUCTION = $C0000096;
    STATUS_STACK_OVERFLOW = $C00000FD;
    STATUS_CONTROL_C_EXIT = $C000013A;

    EXCEPTION_CONTINUABLE = 0;
    EXCEPTION_NONCONTINUABLE = $1;
    EXCEPTION_MAXIMUM_PARAMETERS = 15;

	(*
    INVALID_HANDLE_VALUE = -1;
    INVALID_FILE_SIZE = $FFFFFFFF;
    FILE_BEGIN = 0;
    FILE_CURRENT = 1;
    FILE_END = 2;
    TIME_ZONE_ID_INVALID = $FFFFFFFF;
    WAIT_FAILED = $FFFFFFFF;
    WAIT_OBJECT_0 = $00000000;
    WAIT_ABANDONED = $00000080;
    WAIT_ABANDONED_0 = $00000080;

    WAIT_TIMEOUT = STATUS_TIMEOUT;
    WAIT_IO_COMPLETION = STATUS_USER_APC;
    STILL_ACTIVE = STATUS_PENDING;
    EXCEPTION_ACCESS_VIOLATION = STATUS_ACCESS_VIOLATION;
    EXCEPTION_DATATYPE_MISALIGNMENT = STATUS_DATATYPE_MISALIGNMENT;
    EXCEPTION_BREAKPOINT = STATUS_BREAKPOINT;
    EXCEPTION_SINGLE_STEP = STATUS_SINGLE_STEP;
    EXCEPTION_ARRAY_BOUNDS_EXCEEDED = STATUS_ARRAY_BOUNDS_EXCEEDED;
    EXCEPTION_FLT_DENORMAL_OPERAND = STATUS_FLOAT_DENORMAL_OPERAND;
    EXCEPTION_FLT_DIVIDE_BY_ZERO = STATUS_FLOAT_DIVIDE_BY_ZERO;
    EXCEPTION_FLT_INEXACT_RESULT = STATUS_FLOAT_INEXACT_RESULT;
    EXCEPTION_FLT_INVALID_OPERATION = STATUS_FLOAT_INVALID_OPERATION;
    EXCEPTION_FLT_OVERFLOW = STATUS_FLOAT_OVERFLOW;
    EXCEPTION_FLT_STACK_CHECK = STATUS_FLOAT_STACK_CHECK;
    EXCEPTION_FLT_UNDERFLOW = STATUS_FLOAT_UNDERFLOW;
    EXCEPTION_INT_DIVIDE_BY_ZERO = STATUS_INTEGER_DIVIDE_BY_ZERO;
    EXCEPTION_INT_OVERFLOW = STATUS_INTEGER_OVERFLOW;
    EXCEPTION_PRIV_INSTRUCTION = STATUS_PRIVILEGED_INSTRUCTION;
    EXCEPTION_IN_PAGE_ERROR = STATUS_IN_PAGE_ERROR;
    EXCEPTION_ILLEGAL_INSTRUCTION = STATUS_ILLEGAL_INSTRUCTION;
    EXCEPTION_NONCONTINUABLE_EXCEPTION = STATUS_NONCONTINUABLE_EXCEPTION;
    EXCEPTION_STACK_OVERFLOW = STATUS_STACK_OVERFLOW;
    EXCEPTION_INVALID_DISPOSITION = STATUS_INVALID_DISPOSITION;
    EXCEPTION_GUARD_PAGE = STATUS_GUARD_PAGE_VIOLATION;
    EXCEPTION_INVALID_HANDLE = STATUS_INVALID_HANDLE;
    CONTROL_C_EXIT = STATUS_CONTROL_C_EXIT;

    FILE_FLAG_WRITE_THROUGH = $80000000;
    FILE_FLAG_OVERLAPPED = $40000000;
    FILE_FLAG_NO_BUFFERING = $20000000;
    FILE_FLAG_RANDOM_ACCESS = $10000000;
    FILE_FLAG_SEQUENTIAL_SCAN = $08000000;
    FILE_FLAG_DELETE_ON_CLOSE = $04000000;
    FILE_FLAG_BACKUP_SEMANTICS = $02000000;
    FILE_FLAG_POSIX_SEMANTICS = $01000000;
    CREATE_NEW = 1;
    CREATE_ALWAYS = 2;
    OPEN_EXISTING = 3;
    OPEN_ALWAYS = 4;
    TRUNCATE_EXISTING = 5;

    PROGRESS_CONTINUE = 0;
    PROGRESS_CANCEL = 1;
    PROGRESS_STOP = 2;
    PROGRESS_QUIET = 3;

    CALLBACK_CHUNK_FINISHED = $00000000;
    CALLBACK_STREAM_SWITCH = $00000001;
    COPY_FILE_FAIL_IF_EXISTS = $00000001;
    COPY_FILE_RESTARTABLE = $00000002;

    PIPE_ACCESS_INBOUND = $00000001;
    PIPE_ACCESS_OUTBOUND = $00000002;
    PIPE_ACCESS_DUPLEX = $00000003;
    PIPE_CLIENT_END = $00000000;
    PIPE_SERVER_END = $00000001;
    PIPE_WAIT = $00000000;
    PIPE_NOWAIT = $00000001;
    PIPE_READMODE_BYTE = $00000000;
    PIPE_READMODE_MESSAGE = $00000002;
    PIPE_TYPE_BYTE = $00000000;
    PIPE_TYPE_MESSAGE = $00000004;

    PIPE_UNLIMITED_INSTANCES = 255;
    *)

type
	EXCEPTION_RECORD = packed record
	    ExceptionCode : DWORD;
    	ExceptionFlags : DWORD;
	    ExceptionRecord : address;
    	ExceptionAddress : LPVOID;
	    NumberParameters : UINT;
    	ExceptionInformation : array[0..14] of DWORD;
	end;

	EXCEPTION_POINTERS = packed record
	    ExceptionRecord : address;
    	ContextRecord : address;
	end;

(*
	procedure RaiseException(dwExceptionCode, dwExceptionFlags, nNumberOfArguments : DWORD;
							lpArguments : address);
		external dll='kernel32.dll';
	function UnhandledExceptionFilter(var ExceptionInfo : EXCEPTION_POINTERS) : integer;
		external dll='kernel32.dll';
*)

type
	EXCEPTION_DISPOSITION = (ExceptionContinueExecution, ExceptionContinueSearch,
    							ExceptionNestedException, ExceptionCollidedUnwind);

const
    EXCEPTION_EXECUTE_HANDLER = 1;
    EXCEPTION_CONTINUE_SEARCH = 0;
    EXCEPTION_CONTINUE_EXECUTION = -1;

    SYNCHRONIZE = $00100000;
    STANDARD_RIGHTS_REQUIRED = $000F0000;

    PROCESS_TERMINATE = $0001;
    PROCESS_CREATE_THREAD = $0002;
    PROCESS_VM_OPERATION = $0008;
    PROCESS_VM_READ = $0010;
    PROCESS_VM_WRITE = $0020;
    PROCESS_DUP_HANDLE = $0040;
    PROCESS_CREATE_PROCESS = $0080;
    PROCESS_SET_QUOTA = $0100;
    PROCESS_SET_INFORMATION = $0200;
    PROCESS_QUERY_INFORMATION = $0400;
    PROCESS_ALL_ACCESS = $001F0FFF;

	MAXIMUM_PROCESSORS = 32;

    THREAD_TERMINATE = $0001;
    THREAD_SUSPEND_RESUME = $0002;
    THREAD_GET_CONTEXT = $0008;
    THREAD_SET_CONTEXT = $0010;
    THREAD_SET_INFORMATION = $0020;
    THREAD_QUERY_INFORMATION = $0040;
    THREAD_SET_THREAD_TOKEN = $0080;
    THREAD_IMPERSONATE = $0100;
    THREAD_DIRECT_IMPERSONATION = $0200;
    THREAD_ALL_ACCESS = $001F03FF;

	TLS_MINIMUM_AVAILABLE = 64;

type
	MEMORY_BASIC_INFORMATION = packed record
	    BaseAddress : PVOID;
    	AllocationBase : PVOID;
		AllocationProtect : DWORD;
	    RegionSize : DWORD;
    	State : DWORD;
	    Protect : DWORD;
    	Typ : DWORD;
	end;

const
    SECTION_QUERY = $0001;
    SECTION_MAP_WRITE = $0002;
    SECTION_MAP_READ = $0004;
    SECTION_MAP_EXECUTE = $0008;
    SECTION_EXTEND_SIZE = $0010;
    SECTION_ALL_ACCESS = $000F001F;

    PAGE_NOACCESS = $01;
    PAGE_READONLY = $02;
    PAGE_READWRITE = $04;
    PAGE_WRITECOPY = $08;
    PAGE_EXECUTE = $10;
    PAGE_EXECUTE_READ = $20;
    PAGE_EXECUTE_READWRITE = $40;
    PAGE_EXECUTE_WRITECOPY = $80;
    PAGE_GUARD = $100;
    PAGE_NOCACHE = $200;
    MEM_COMMIT = $1000;
    MEM_RESERVE = $2000;
    MEM_DECOMMIT = $4000;
    MEM_RELEASE = $8000;
    MEM_FREE = $10000;
    MEM_PRIVATE = $20000;
    MEM_MAPPED = $40000;
    MEM_RESET = $80000;
    MEM_TOP_DOWN = $100000;
    SEC_FILE = $800000;
    SEC_IMAGE = $1000000;
    SEC_RESERVE = $4000000;
    SEC_COMMIT = $8000000;
    SEC_NOCACHE = $10000000;
    MEM_IMAGE = SEC_IMAGE;

    FILE_READ_DATA = $0001;
    FILE_LIST_DIRECTORY = $0001;
    FILE_WRITE_DATA = $0002;
    FILE_ADD_FILE = $0002;
    FILE_APPEND_DATA = $0004;
    FILE_ADD_SUBDIRECTORY = $0004;
    FILE_CREATE_PIPE_INSTANCE = $0004;
    FILE_READ_EA = $0008;
    FILE_WRITE_EA = $0010;
    FILE_EXECUTE = $0020;
    FILE_TRAVERSE = $0020;
    FILE_DELETE_CHILD = $0040;
    FILE_READ_ATTRIBUTES = $0080;
    FILE_WRITE_ATTRIBUTES = $0100;
    FILE_ALL_ACCESS = $001F01FF;

	FILE_GENERIC_READ = $00120089;
	FILE_GENERIC_WRITE = $00120116;
	FILE_GENERIC_EXECUTE = $001200A0;

    FILE_SHARE_READ = $00000001;
    FILE_SHARE_WRITE = $00000002;
    FILE_SHARE_DELETE = $00000004;
    FILE_ATTRIBUTE_READONLY = $00000001;
    FILE_ATTRIBUTE_HIDDEN = $00000002;
    FILE_ATTRIBUTE_SYSTEM = $00000004;
    FILE_ATTRIBUTE_DIRECTORY = $00000010;
    FILE_ATTRIBUTE_ARCHIVE = $00000020;
    FILE_ATTRIBUTE_NORMAL = $00000080;
    FILE_ATTRIBUTE_TEMPORARY = $00000100;
    FILE_ATTRIBUTE_COMPRESSED = $00000800;
    FILE_ATTRIBUTE_OFFLINE = $00001000;
    FILE_NOTIFY_CHANGE_FILE_NAME = $00000001;
    FILE_NOTIFY_CHANGE_DIR_NAME = $00000002;
    FILE_NOTIFY_CHANGE_ATTRIBUTES = $00000004;
    FILE_NOTIFY_CHANGE_SIZE = $00000008;
    FILE_NOTIFY_CHANGE_LAST_WRITE = $00000010;
    FILE_NOTIFY_CHANGE_LAST_ACCESS = $00000020;
    FILE_NOTIFY_CHANGE_CREATION = $00000040;
    FILE_NOTIFY_CHANGE_SECURITY = $00000100;
    FILE_ACTION_ADDED = $00000001;
    FILE_ACTION_REMOVED = $00000002;
    FILE_ACTION_MODIFIED = $00000003;
    FILE_ACTION_RENAMED_OLD_NAME = $00000004;
    FILE_ACTION_RENAMED_NEW_NAME = $00000005;
    MAILSLOT_NO_MESSAGE = -1;
    MAILSLOT_WAIT_FOREVER = -1;
    FILE_CASE_SENSITIVE_SEARCH = $00000001;
    FILE_CASE_PRESERVED_NAMES = $00000002;
    FILE_UNICODE_ON_DISK = $00000004;
    FILE_PERSISTENT_ACLS = $00000008;
    FILE_FILE_COMPRESSION = $00000010;
    FILE_VOLUME_IS_COMPRESSED = $00008000;

type
	FILE_NOTIFY_INFORMATION = packed record
	    NextEntryOffset : DWORD;
    	Action : DWORD;
	    FileNameLength : DWORD;
	end;

const
    IO_COMPLETION_MODIFY_STATE = $0002;
    IO_COMPLETION_ALL_ACCESS = $001F0003;
    DUPLICATE_CLOSE_SOURCE = $00000001;
    DUPLICATE_SAME_ACCESS = $00000002;

type
	PACCESS_TOKEN = PVOID;
	PSECURITY_DESCRIPTOR = PVOID;
	PSID = PVOID;

	ACCESS_MASK = DWORD;

	GENERIC_MAPPING = packed record
	    GenericRead : ACCESS_MASK;
    	GenericWrite : ACCESS_MASK;
	    GenericExecute : ACCESS_MASK;
    	GenericAll : ACCESS_MASK;
	end;

const
    FACILITY_WINDOWS = 8;
    FACILITY_STORAGE = 3;
    FACILITY_RPC = 1;
    FACILITY_SSPI = 9;
    FACILITY_WIN32 = 7;
    FACILITY_CONTROL = 10;
    FACILITY_NULL = 0;
    FACILITY_INTERNET = 12;
    FACILITY_ITF = 4;
    FACILITY_DISPATCH = 2;
    FACILITY_CERT = 11;

    ERROR_SUCCESS = 0;
    NO_ERROR = 0;
    ERROR_INVALID_FUNCTION = 1;
    ERROR_FILE_NOT_FOUND = 2;
    ERROR_PATH_NOT_FOUND = 3;
    ERROR_TOO_MANY_OPEN_FILES = 4;
    ERROR_ACCESS_DENIED = 5;
    ERROR_INVALID_HANDLE = 6;
    ERROR_ARENA_TRASHED = 7;
    ERROR_NOT_ENOUGH_MEMORY = 8;
    ERROR_INVALID_BLOCK = 9;
    ERROR_BAD_ENVIRONMENT = 10;
    ERROR_BAD_FORMAT = 11;
    ERROR_INVALID_ACCESS = 12;
    ERROR_INVALID_DATA = 13;
    ERROR_OUTOFMEMORY = 14;
    ERROR_INVALID_DRIVE = 15;
    ERROR_CURRENT_DIRECTORY = 16;
    ERROR_NOT_SAME_DEVICE = 17;
    ERROR_NO_MORE_FILES = 18;
    ERROR_WRITE_PROTECT = 19;
    ERROR_BAD_UNIT = 20;
    ERROR_NOT_READY = 21;
    ERROR_BAD_COMMAND = 22;
    ERROR_CRC = 23;
    ERROR_BAD_LENGTH = 24;
    ERROR_SEEK = 25;
    ERROR_NOT_DOS_DISK = 26;
    ERROR_SECTOR_NOT_FOUND = 27;
    ERROR_OUT_OF_PAPER = 28;
    ERROR_WRITE_FAULT = 29;
    ERROR_READ_FAULT = 30;
    ERROR_GEN_FAILURE = 31;
    ERROR_SHARING_VIOLATION = 32;
    ERROR_LOCK_VIOLATION = 33;
    ERROR_WRONG_DISK = 34;
    ERROR_SHARING_BUFFER_EXCEEDED = 36;
    ERROR_HANDLE_EOF = 38;
    ERROR_HANDLE_DISK_FULL = 39;
    ERROR_NOT_SUPPORTED = 50;
    ERROR_REM_NOT_LIST = 51;
    ERROR_DUP_NAME = 52;
    ERROR_BAD_NETPATH = 53;
    ERROR_NETWORK_BUSY = 54;
    ERROR_DEV_NOT_EXIST = 55;
    ERROR_TOO_MANY_CMDS = 56;
    ERROR_ADAP_HDW_ERR = 57;
    ERROR_BAD_NET_RESP = 58;
    ERROR_UNEXP_NET_ERR = 59;
    ERROR_BAD_REM_ADAP = 60;
    ERROR_PRINTQ_FULL = 61;
    ERROR_NO_SPOOL_SPACE = 62;
    ERROR_PRINT_CANCELLED = 63;
    ERROR_NETNAME_DELETED = 64;
    ERROR_NETWORK_ACCESS_DENIED = 65;
    ERROR_BAD_DEV_TYPE = 66;
    ERROR_BAD_NET_NAME = 67;
    ERROR_TOO_MANY_NAMES = 68;
    ERROR_TOO_MANY_SESS = 69;
    ERROR_SHARING_PAUSED = 70;
    ERROR_REQ_NOT_ACCEP = 71;
    ERROR_REDIR_PAUSED = 72;
    ERROR_FILE_EXISTS = 80;
    ERROR_CANNOT_MAKE = 82;
    ERROR_FAIL_I24 = 83;
    ERROR_OUT_OF_STRUCTURES = 84;
    ERROR_ALREADY_ASSIGNED = 85;
    ERROR_INVALID_PASSWORD = 86;
    ERROR_INVALID_PARAMETER = 87;
    ERROR_NET_WRITE_FAULT = 88;
    ERROR_NO_PROC_SLOTS = 89;
    ERROR_TOO_MANY_SEMAPHORES = 100;
    ERROR_EXCL_SEM_ALREADY_OWNED = 101;
    ERROR_SEM_IS_SET = 102;
    ERROR_TOO_MANY_SEM_REQUESTS = 103;
    ERROR_INVALID_AT_INTERRUPT_TIME = 104;
    ERROR_SEM_OWNER_DIED = 105;
    ERROR_SEM_USER_LIMIT = 106;
    ERROR_DISK_CHANGE = 107;
    ERROR_DRIVE_LOCKED = 108;
    ERROR_BROKEN_PIPE = 109;
    ERROR_OPEN_FAILED = 110;
    ERROR_BUFFER_OVERFLOW = 111;
    ERROR_DISK_FULL = 112;
    ERROR_NO_MORE_SEARCH_HANDLES = 113;
    ERROR_INVALID_TARGET_HANDLE = 114;
    ERROR_INVALID_CATEGORY = 117;
    ERROR_INVALID_VERIFY_SWITCH = 118;
    ERROR_BAD_DRIVER_LEVEL = 119;
    ERROR_CALL_NOT_IMPLEMENTED = 120;
    ERROR_SEM_TIMEOUT = 121;
    ERROR_INSUFFICIENT_BUFFER = 122;
    ERROR_INVALID_NAME = 123;
    ERROR_INVALID_LEVEL = 124;
    ERROR_NO_VOLUME_LABEL = 125;
    ERROR_MOD_NOT_FOUND = 126;
    ERROR_PROC_NOT_FOUND = 127;
    ERROR_WAIT_NO_CHILDREN = 128;
    ERROR_CHILD_NOT_COMPLETE = 129;
    ERROR_DIRECT_ACCESS_HANDLE = 130;
    ERROR_NEGATIVE_SEEK = 131;
    ERROR_SEEK_ON_DEVICE = 132;
    ERROR_IS_JOIN_TARGET = 133;
    ERROR_IS_JOINED = 134;
    ERROR_IS_SUBSTED = 135;
    ERROR_NOT_JOINED = 136;
    ERROR_NOT_SUBSTED = 137;
    ERROR_JOIN_TO_JOIN = 138;
    ERROR_SUBST_TO_SUBST = 139;
    ERROR_JOIN_TO_SUBST = 140;
    ERROR_SUBST_TO_JOIN = 141;
    ERROR_BUSY_DRIVE = 142;
    ERROR_SAME_DRIVE = 143;
    ERROR_DIR_NOT_ROOT = 144;
    ERROR_DIR_NOT_EMPTY = 145;
    ERROR_IS_SUBST_PATH = 146;
    ERROR_IS_JOIN_PATH = 147;
    ERROR_PATH_BUSY = 148;
    ERROR_IS_SUBST_TARGET = 149;
    ERROR_SYSTEM_TRACE = 150;
    ERROR_INVALID_EVENT_COUNT = 151;
    ERROR_TOO_MANY_MUXWAITERS = 152;
    ERROR_INVALID_LIST_FORMAT = 153;
    ERROR_LABEL_TOO_LONG = 154;
    ERROR_TOO_MANY_TCBS = 155;
    ERROR_SIGNAL_REFUSED = 156;
    ERROR_DISCARDED = 157;
    ERROR_NOT_LOCKED = 158;
    ERROR_BAD_THREADID_ADDR = 159;
    ERROR_BAD_ARGUMENTS = 160;
    ERROR_BAD_PATHNAME = 161;
    ERROR_SIGNAL_PENDING = 162;
    ERROR_MAX_THRDS_REACHED = 164;
    ERROR_LOCK_FAILED = 167;
    ERROR_BUSY = 170;
    ERROR_CANCEL_VIOLATION = 173;
    ERROR_ATOMIC_LOCKS_NOT_SUPPORTED = 174;
    ERROR_INVALID_SEGMENT_NUMBER = 180;
    ERROR_INVALID_ORDINAL = 182;
    ERROR_ALREADY_EXISTS = 183;
    ERROR_INVALID_FLAG_NUMBER = 186;
    ERROR_SEM_NOT_FOUND = 187;
    ERROR_INVALID_STARTING_CODESEG = 188;
    ERROR_INVALID_STACKSEG = 189;
    ERROR_INVALID_MODULETYPE = 190;
    ERROR_INVALID_EXE_SIGNATURE = 191;
    ERROR_EXE_MARKED_INVALID = 192;
    ERROR_BAD_EXE_FORMAT = 193;
    ERROR_ITERATED_DATA_EXCEEDS_64k = 194;
    ERROR_INVALID_MINALLOCSIZE = 195;
    ERROR_DYNLINK_FROM_INVALID_RING = 196;
    ERROR_IOPL_NOT_ENABLED = 197;
    ERROR_INVALID_SEGDPL = 198;
    ERROR_AUTODATASEG_EXCEEDS_64k = 199;
    ERROR_RING2SEG_MUST_BE_MOVABLE = 200;
    ERROR_RELOC_CHAIN_XEEDS_SEGLIM = 201;
    ERROR_INFLOOP_IN_RELOC_CHAIN = 202;
    ERROR_ENVVAR_NOT_FOUND = 203;
    ERROR_NO_SIGNAL_SENT = 205;
    ERROR_FILENAME_EXCED_RANGE = 206;
    ERROR_RING2_STACK_IN_USE = 207;
    ERROR_META_EXPANSION_TOO_LONG = 208;
    ERROR_INVALID_SIGNAL_NUMBER = 209;
    ERROR_THREAD_1_INACTIVE = 210;
    ERROR_LOCKED = 212;
    ERROR_TOO_MANY_MODULES = 214;
    ERROR_NESTING_NOT_ALLOWED = 215;
    ERROR_EXE_MACHINE_TYPE_MISMATCH = 216;
    ERROR_BAD_PIPE = 230;
    ERROR_PIPE_BUSY = 231;
    ERROR_NO_DATA = 232;
    ERROR_PIPE_NOT_CONNECTED = 233;
    ERROR_MORE_DATA = 234;
    ERROR_VC_DISCONNECTED = 240;
    ERROR_INVALID_EA_NAME = 254;
    ERROR_EA_LIST_INCONSISTENT = 255;
    ERROR_NO_MORE_ITEMS = 259;
    ERROR_CANNOT_COPY = 266;
    ERROR_DIRECTORY = 267;
    ERROR_EAS_DIDNT_FIT = 275;
    ERROR_EA_FILE_CORRUPT = 276;
    ERROR_EA_TABLE_FULL = 277;
    ERROR_INVALID_EA_HANDLE = 278;
    ERROR_EAS_NOT_SUPPORTED = 282;
    ERROR_NOT_OWNER = 288;
    ERROR_TOO_MANY_POSTS = 298;
    ERROR_PARTIAL_COPY = 299;
    ERROR_MR_MID_NOT_FOUND = 317;
    ERROR_INVALID_ADDRESS = 487;
    ERROR_ARITHMETIC_OVERFLOW = 534;
    ERROR_PIPE_CONNECTED = 535;
    ERROR_PIPE_LISTENING = 536;
    ERROR_EA_ACCESS_DENIED = 994;
    ERROR_OPERATION_ABORTED = 995;
    ERROR_IO_INCOMPLETE = 996;
    ERROR_IO_PENDING = 997;
    ERROR_NOACCESS = 998;
    ERROR_SWAPERROR = 999;
    ERROR_STACK_OVERFLOW = 1001;
    ERROR_INVALID_MESSAGE = 1002;
    ERROR_CAN_NOT_COMPLETE = 1003;
    ERROR_INVALID_FLAGS = 1004;
    ERROR_UNRECOGNIZED_VOLUME = 1005;
    ERROR_FILE_INVALID = 1006;
    ERROR_FULLSCREEN_MODE = 1007;
    ERROR_NO_TOKEN = 1008;
    ERROR_BADDB = 1009;
    ERROR_BADKEY = 1010;
    ERROR_CANTOPEN = 1011;
    ERROR_CANTREAD = 1012;
    ERROR_CANTWRITE = 1013;
    ERROR_REGISTRY_RECOVERED = 1014;
    ERROR_REGISTRY_CORRUPT = 1015;
    ERROR_REGISTRY_IO_FAILED = 1016;
    ERROR_NOT_REGISTRY_FILE = 1017;
    ERROR_KEY_DELETED = 1018;
    ERROR_NO_LOG_SPACE = 1019;
    ERROR_KEY_HAS_CHILDREN = 1020;
    ERROR_CHILD_MUST_BE_VOLATILE = 1021;
    ERROR_NOTIFY_ENUM_DIR = 1022;
    ERROR_DEPENDENT_SERVICES_RUNNING = 1051;
    ERROR_INVALID_SERVICE_CONTROL = 1052;
    ERROR_SERVICE_REQUEST_TIMEOUT = 1053;
    ERROR_SERVICE_NO_THREAD = 1054;
    ERROR_SERVICE_DATABASE_LOCKED = 1055;
    ERROR_SERVICE_ALREADY_RUNNING = 1056;
    ERROR_INVALID_SERVICE_ACCOUNT = 1057;
    ERROR_SERVICE_DISABLED = 1058;
    ERROR_CIRCULAR_DEPENDENCY = 1059;
    ERROR_SERVICE_DOES_NOT_EXIST = 1060;
    ERROR_SERVICE_CANNOT_ACCEPT_CTRL = 1061;
    ERROR_SERVICE_NOT_ACTIVE = 1062;
    ERROR_FAILED_SERVICE_CONTROLLER_CONNECT = 1063;
    ERROR_EXCEPTION_IN_SERVICE = 1064;
    ERROR_DATABASE_DOES_NOT_EXIST = 1065;
    ERROR_SERVICE_SPECIFIC_ERROR = 1066;
    ERROR_PROCESS_ABORTED = 1067;
    ERROR_SERVICE_DEPENDENCY_FAIL = 1068;
    ERROR_SERVICE_LOGON_FAILED = 1069;
    ERROR_SERVICE_START_HANG = 1070;
    ERROR_INVALID_SERVICE_LOCK = 1071;
    ERROR_SERVICE_MARKED_FOR_DELETE = 1072;
    ERROR_SERVICE_EXISTS = 1073;
    ERROR_ALREADY_RUNNING_LKG = 1074;
    ERROR_SERVICE_DEPENDENCY_DELETED = 1075;
    ERROR_BOOT_ALREADY_ACCEPTED = 1076;
    ERROR_SERVICE_NEVER_STARTED = 1077;
    ERROR_DUPLICATE_SERVICE_NAME = 1078;
    ERROR_DIFFERENT_SERVICE_ACCOUNT = 1079;
    ERROR_END_OF_MEDIA = 1100;
    ERROR_FILEMARK_DETECTED = 1101;
    ERROR_BEGINNING_OF_MEDIA = 1102;
    ERROR_SETMARK_DETECTED = 1103;
    ERROR_NO_DATA_DETECTED = 1104;
    ERROR_PARTITION_FAILURE = 1105;
    ERROR_INVALID_BLOCK_LENGTH = 1106;
    ERROR_DEVICE_NOT_PARTITIONED = 1107;
    ERROR_UNABLE_TO_LOCK_MEDIA = 1108;
    ERROR_UNABLE_TO_UNLOAD_MEDIA = 1109;
    ERROR_MEDIA_CHANGED = 1110;
    ERROR_BUS_RESET = 1111;
    ERROR_NO_MEDIA_IN_DRIVE = 1112;
    ERROR_NO_UNICODE_TRANSLATION = 1113;
    ERROR_DLL_INIT_FAILED = 1114;
    ERROR_SHUTDOWN_IN_PROGRESS = 1115;
    ERROR_NO_SHUTDOWN_IN_PROGRESS = 1116;
    ERROR_IO_DEVICE = 1117;
    ERROR_SERIAL_NO_DEVICE = 1118;
    ERROR_IRQ_BUSY = 1119;
    ERROR_MORE_WRITES = 1120;
    ERROR_COUNTER_TIMEOUT = 1121;
    ERROR_FLOPPY_ID_MARK_NOT_FOUND = 1122;
    ERROR_FLOPPY_WRONG_CYLINDER = 1123;
    ERROR_FLOPPY_UNKNOWN_ERROR = 1124;
    ERROR_FLOPPY_BAD_REGISTERS = 1125;
    ERROR_DISK_RECALIBRATE_FAILED = 1126;
    ERROR_DISK_OPERATION_FAILED = 1127;
    ERROR_DISK_RESET_FAILED = 1128;
    ERROR_EOM_OVERFLOW = 1129;
    ERROR_NOT_ENOUGH_SERVER_MEMORY = 1130;
    ERROR_POSSIBLE_DEADLOCK = 1131;
    ERROR_MAPPED_ALIGNMENT = 1132;
    ERROR_SET_POWER_STATE_VETOED = 1140;
    ERROR_SET_POWER_STATE_FAILED = 1141;
    ERROR_TOO_MANY_LINKS = 1142;
    ERROR_OLD_WIN_VERSION = 1150;
    ERROR_APP_WRONG_OS = 1151;
    ERROR_SINGLE_INSTANCE_APP = 1152;
    ERROR_RMODE_APP = 1153;
    ERROR_INVALID_DLL = 1154;
    ERROR_NO_ASSOCIATION = 1155;
    ERROR_DDE_FAIL = 1156;
    ERROR_DLL_NOT_FOUND = 1157;
    ERROR_BAD_USERNAME = 2202;
    ERROR_NOT_CONNECTED = 2250;
    ERROR_OPEN_FILES = 2401;
    ERROR_ACTIVE_CONNECTIONS = 2402;
    ERROR_DEVICE_IN_USE = 2404;
    ERROR_BAD_DEVICE = 1200;
    ERROR_CONNECTION_UNAVAIL = 1201;
    ERROR_DEVICE_ALREADY_REMEMBERED = 1202;
    ERROR_NO_NET_OR_BAD_PATH = 1203;
    ERROR_BAD_PROVIDER = 1204;
    ERROR_CANNOT_OPEN_PROFILE = 1205;
    ERROR_BAD_PROFILE = 1206;
    ERROR_NOT_CONTAINER = 1207;
    ERROR_EXTENDED_ERROR = 1208;
    ERROR_INVALID_GROUPNAME = 1209;
    ERROR_INVALID_COMPUTERNAME = 1210;
    ERROR_INVALID_EVENTNAME = 1211;
    ERROR_INVALID_DOMAINNAME = 1212;
    ERROR_INVALID_SERVICENAME = 1213;
    ERROR_INVALID_NETNAME = 1214;
    ERROR_INVALID_SHARENAME = 1215;
    ERROR_INVALID_PASSWORDNAME = 1216;
    ERROR_INVALID_MESSAGENAME = 1217;
    ERROR_INVALID_MESSAGEDEST = 1218;
    ERROR_SESSION_CREDENTIAL_CONFLICT = 1219;
    ERROR_REMOTE_SESSION_LIMIT_EXCEEDED = 1220;
    ERROR_DUP_DOMAINNAME = 1221;
    ERROR_NO_NETWORK = 1222;
    ERROR_CANCELLED = 1223;
    ERROR_USER_MAPPED_FILE = 1224;
    ERROR_CONNECTION_REFUSED = 1225;
    ERROR_GRACEFUL_DISCONNECT = 1226;
    ERROR_ADDRESS_ALREADY_ASSOCIATED = 1227;
    ERROR_ADDRESS_NOT_ASSOCIATED = 1228;
    ERROR_CONNECTION_INVALID = 1229;
    ERROR_CONNECTION_ACTIVE = 1230;
    ERROR_NETWORK_UNREACHABLE = 1231;
    ERROR_HOST_UNREACHABLE = 1232;
    ERROR_PROTOCOL_UNREACHABLE = 1233;
    ERROR_PORT_UNREACHABLE = 1234;
    ERROR_REQUEST_ABORTED = 1235;
    ERROR_CONNECTION_ABORTED = 1236;
    ERROR_RETRY = 1237;
    ERROR_CONNECTION_COUNT_LIMIT = 1238;
    ERROR_LOGIN_TIME_RESTRICTION = 1239;
    ERROR_LOGIN_WKSTA_RESTRICTION = 1240;
    ERROR_INCORRECT_ADDRESS = 1241;
    ERROR_ALREADY_REGISTERED = 1242;
    ERROR_SERVICE_NOT_FOUND = 1243;
    ERROR_NOT_AUTHENTICATED = 1244;
    ERROR_NOT_LOGGED_ON = 1245;
    ERROR_CONTINUE = 1246;
    ERROR_ALREADY_INITIALIZED = 1247;
    ERROR_NO_MORE_DEVICES = 1248;
    ERROR_NOT_ALL_ASSIGNED = 1300;
    ERROR_SOME_NOT_MAPPED = 1301;
    ERROR_NO_QUOTAS_FOR_ACCOUNT = 1302;
    ERROR_LOCAL_USER_SESSION_KEY = 1303;
    ERROR_NULL_LM_PASSWORD = 1304;
    ERROR_UNKNOWN_REVISION = 1305;
    ERROR_REVISION_MISMATCH = 1306;
    ERROR_INVALID_OWNER = 1307;
    ERROR_INVALID_PRIMARY_GROUP = 1308;
    ERROR_NO_IMPERSONATION_TOKEN = 1309;
    ERROR_CANT_DISABLE_MANDATORY = 1310;
    ERROR_NO_LOGON_SERVERS = 1311;
    ERROR_NO_SUCH_LOGON_SESSION = 1312;
    ERROR_NO_SUCH_PRIVILEGE = 1313;
    ERROR_PRIVILEGE_NOT_HELD = 1314;
    ERROR_INVALID_ACCOUNT_NAME = 1315;
    ERROR_USER_EXISTS = 1316;
    ERROR_NO_SUCH_USER = 1317;
    ERROR_GROUP_EXISTS = 1318;
    ERROR_NO_SUCH_GROUP = 1319;
    ERROR_MEMBER_IN_GROUP = 1320;
    ERROR_MEMBER_NOT_IN_GROUP = 1321;
    ERROR_LAST_ADMIN = 1322;
    ERROR_WRONG_PASSWORD = 1323;
    ERROR_ILL_FORMED_PASSWORD = 1324;
    ERROR_PASSWORD_RESTRICTION = 1325;
    ERROR_LOGON_FAILURE = 1326;
    ERROR_ACCOUNT_RESTRICTION = 1327;
    ERROR_INVALID_LOGON_HOURS = 1328;
    ERROR_INVALID_WORKSTATION = 1329;
    ERROR_PASSWORD_EXPIRED = 1330;
    ERROR_ACCOUNT_DISABLED = 1331;
    ERROR_NONE_MAPPED = 1332;
    ERROR_TOO_MANY_LUIDS_REQUESTED = 1333;
    ERROR_LUIDS_EXHAUSTED = 1334;
    ERROR_INVALID_SUB_AUTHORITY = 1335;
    ERROR_INVALID_ACL = 1336;
    ERROR_INVALID_SID = 1337;
    ERROR_INVALID_SECURITY_DESCR = 1338;
    ERROR_BAD_INHERITANCE_ACL = 1340;
    ERROR_SERVER_DISABLED = 1341;
    ERROR_SERVER_NOT_DISABLED = 1342;
    ERROR_INVALID_ID_AUTHORITY = 1343;
    ERROR_ALLOTTED_SPACE_EXCEEDED = 1344;
    ERROR_INVALID_GROUP_ATTRIBUTES = 1345;
    ERROR_BAD_IMPERSONATION_LEVEL = 1346;
    ERROR_CANT_OPEN_ANONYMOUS = 1347;
    ERROR_BAD_VALIDATION_CLASS = 1348;
    ERROR_BAD_TOKEN_TYPE = 1349;
    ERROR_NO_SECURITY_ON_OBJECT = 1350;
    ERROR_CANT_ACCESS_DOMAIN_INFO = 1351;
    ERROR_INVALID_SERVER_STATE = 1352;
    ERROR_INVALID_DOMAIN_STATE = 1353;
    ERROR_INVALID_DOMAIN_ROLE = 1354;
    ERROR_NO_SUCH_DOMAIN = 1355;
    ERROR_DOMAIN_EXISTS = 1356;
    ERROR_DOMAIN_LIMIT_EXCEEDED = 1357;
    ERROR_INTERNAL_DB_CORRUPTION = 1358;
    ERROR_INTERNAL_ERROR = 1359;
    ERROR_GENERIC_NOT_MAPPED = 1360;
    ERROR_BAD_DESCRIPTOR_FORMAT = 1361;
    ERROR_NOT_LOGON_PROCESS = 1362;
    ERROR_LOGON_SESSION_EXISTS = 1363;
    ERROR_NO_SUCH_PACKAGE = 1364;
    ERROR_BAD_LOGON_SESSION_STATE = 1365;
    ERROR_LOGON_SESSION_COLLISION = 1366;
    ERROR_INVALID_LOGON_TYPE = 1367;
    ERROR_CANNOT_IMPERSONATE = 1368;
    ERROR_RXACT_INVALID_STATE = 1369;
    ERROR_RXACT_COMMIT_FAILURE = 1370;
    ERROR_SPECIAL_ACCOUNT = 1371;
    ERROR_SPECIAL_GROUP = 1372;
    ERROR_SPECIAL_USER = 1373;
    ERROR_MEMBERS_PRIMARY_GROUP = 1374;
    ERROR_TOKEN_ALREADY_IN_USE = 1375;
    ERROR_NO_SUCH_ALIAS = 1376;
    ERROR_MEMBER_NOT_IN_ALIAS = 1377;
    ERROR_MEMBER_IN_ALIAS = 1378;
    ERROR_ALIAS_EXISTS = 1379;
    ERROR_LOGON_NOT_GRANTED = 1380;
    ERROR_TOO_MANY_SECRETS = 1381;
    ERROR_SECRET_TOO_LONG = 1382;
    ERROR_INTERNAL_DB_ERROR = 1383;
    ERROR_TOO_MANY_CONTEXT_IDS = 1384;
    ERROR_LOGON_TYPE_NOT_GRANTED = 1385;
    ERROR_NT_CROSS_ENCRYPTION_REQUIRED = 1386;
    ERROR_NO_SUCH_MEMBER = 1387;
    ERROR_INVALID_MEMBER = 1388;
    ERROR_TOO_MANY_SIDS = 1389;
    ERROR_LM_CROSS_ENCRYPTION_REQUIRED = 1390;
    ERROR_NO_INHERITANCE = 1391;
    ERROR_FILE_CORRUPT = 1392;
    ERROR_DISK_CORRUPT = 1393;
    ERROR_NO_USER_SESSION_KEY = 1394;
    ERROR_LICENSE_QUOTA_EXCEEDED = 1395;
    ERROR_INVALID_WINDOW_HANDLE = 1400;
    ERROR_INVALID_MENU_HANDLE = 1401;
    ERROR_INVALID_CURSOR_HANDLE = 1402;
    ERROR_INVALID_ACCEL_HANDLE = 1403;
    ERROR_INVALID_HOOK_HANDLE = 1404;
    ERROR_INVALID_DWP_HANDLE = 1405;
    ERROR_TLW_WITH_WSCHILD = 1406;
    ERROR_CANNOT_FIND_WND_CLASS = 1407;
    ERROR_WINDOW_OF_OTHER_THREAD = 1408;
    ERROR_HOTKEY_ALREADY_REGISTERED = 1409;
    ERROR_CLASS_ALREADY_EXISTS = 1410;
    ERROR_CLASS_DOES_NOT_EXIST = 1411;
    ERROR_CLASS_HAS_WINDOWS = 1412;
    ERROR_INVALID_INDEX = 1413;
    ERROR_INVALID_ICON_HANDLE = 1414;
    ERROR_PRIVATE_DIALOG_INDEX = 1415;
    ERROR_LISTBOX_ID_NOT_FOUND = 1416;
    ERROR_NO_WILDCARD_CHARACTERS = 1417;
    ERROR_CLIPBOARD_NOT_OPEN = 1418;
    ERROR_HOTKEY_NOT_REGISTERED = 1419;
    ERROR_WINDOW_NOT_DIALOG = 1420;
    ERROR_CONTROL_ID_NOT_FOUND = 1421;
    ERROR_INVALID_COMBOBOX_MESSAGE = 1422;
    ERROR_WINDOW_NOT_COMBOBOX = 1423;
    ERROR_INVALID_EDIT_HEIGHT = 1424;
    ERROR_DC_NOT_FOUND = 1425;
    ERROR_INVALID_HOOK_FILTER = 1426;
    ERROR_INVALID_FILTER_PROC = 1427;
    ERROR_HOOK_NEEDS_HMOD = 1428;
    ERROR_GLOBAL_ONLY_HOOK = 1429;
    ERROR_JOURNAL_HOOK_SET = 1430;
    ERROR_HOOK_NOT_INSTALLED = 1431;
    ERROR_INVALID_LB_MESSAGE = 1432;
    ERROR_SETCOUNT_ON_BAD_LB = 1433;
    ERROR_LB_WITHOUT_TABSTOPS = 1434;
    ERROR_DESTROY_OBJECT_OF_OTHER_THREAD = 1435;
    ERROR_CHILD_WINDOW_MENU = 1436;
    ERROR_NO_SYSTEM_MENU = 1437;
    ERROR_INVALID_MSGBOX_STYLE = 1438;
    ERROR_INVALID_SPI_VALUE = 1439;
    ERROR_SCREEN_ALREADY_LOCKED = 1440;
    ERROR_HWNDS_HAVE_DIFF_PARENT = 1441;
    ERROR_NOT_CHILD_WINDOW = 1442;
    ERROR_INVALID_GW_COMMAND = 1443;
    ERROR_INVALID_THREAD_ID = 1444;
    ERROR_NON_MDICHILD_WINDOW = 1445;
    ERROR_POPUP_ALREADY_ACTIVE = 1446;
    ERROR_NO_SCROLLBARS = 1447;
    ERROR_INVALID_SCROLLBAR_RANGE = 1448;
    ERROR_INVALID_SHOWWIN_COMMAND = 1449;
    ERROR_NO_SYSTEM_RESOURCES = 1450;
    ERROR_NONPAGED_SYSTEM_RESOURCES = 1451;
    ERROR_PAGED_SYSTEM_RESOURCES = 1452;
    ERROR_WORKING_SET_QUOTA = 1453;
    ERROR_PAGEFILE_QUOTA = 1454;
    ERROR_COMMITMENT_LIMIT = 1455;
    ERROR_MENU_ITEM_NOT_FOUND = 1456;
    ERROR_INVALID_KEYBOARD_HANDLE = 1457;
    ERROR_HOOK_TYPE_NOT_ALLOWED = 1458;
    ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION = 1459;
    ERROR_TIMEOUT = 1460;
    ERROR_EVENTLOG_FILE_CORRUPT = 1500;
    ERROR_EVENTLOG_CANT_START = 1501;
    ERROR_LOG_FILE_FULL = 1502;
    ERROR_EVENTLOG_FILE_CHANGED = 1503;
    RPC_S_INVALID_STRING_BINDING = 1700;
    RPC_S_WRONG_KIND_OF_BINDING = 1701;
    RPC_S_INVALID_BINDING = 1702;
    RPC_S_PROTSEQ_NOT_SUPPORTED = 1703;
    RPC_S_INVALID_RPC_PROTSEQ = 1704;
    RPC_S_INVALID_STRING_UUID = 1705;
    RPC_S_INVALID_ENDPOINT_FORMAT = 1706;
    RPC_S_INVALID_NET_ADDR = 1707;
    RPC_S_NO_ENDPOINT_FOUND = 1708;
    RPC_S_INVALID_TIMEOUT = 1709;
    RPC_S_OBJECT_NOT_FOUND = 1710;
    RPC_S_ALREADY_REGISTERED = 1711;
    RPC_S_TYPE_ALREADY_REGISTERED = 1712;
    RPC_S_ALREADY_LISTENING = 1713;
    RPC_S_NO_PROTSEQS_REGISTERED = 1714;
    RPC_S_NOT_LISTENING = 1715;
    RPC_S_UNKNOWN_MGR_TYPE = 1716;
    RPC_S_UNKNOWN_IF = 1717;
    RPC_S_NO_BINDINGS = 1718;
    RPC_S_NO_PROTSEQS = 1719;
    RPC_S_CANT_CREATE_ENDPOINT = 1720;
    RPC_S_OUT_OF_RESOURCES = 1721;
    RPC_S_SERVER_UNAVAILABLE = 1722;
    RPC_S_SERVER_TOO_BUSY = 1723;
    RPC_S_INVALID_NETWORK_OPTIONS = 1724;
    RPC_S_NO_CALL_ACTIVE = 1725;
    RPC_S_CALL_FAILED = 1726;
    RPC_S_CALL_FAILED_DNE = 1727;
    RPC_S_PROTOCOL_ERROR = 1728;
    RPC_S_UNSUPPORTED_TRANS_SYN = 1730;
    RPC_S_UNSUPPORTED_TYPE = 1732;
    RPC_S_INVALID_TAG = 1733;
    RPC_S_INVALID_BOUND = 1734;
    RPC_S_NO_ENTRY_NAME = 1735;
    RPC_S_INVALID_NAME_SYNTAX = 1736;
    RPC_S_UNSUPPORTED_NAME_SYNTAX = 1737;
    RPC_S_UUID_NO_ADDRESS = 1739;
    RPC_S_DUPLICATE_ENDPOINT = 1740;
    RPC_S_UNKNOWN_AUTHN_TYPE = 1741;
    RPC_S_MAX_CALLS_TOO_SMALL = 1742;
    RPC_S_STRING_TOO_LONG = 1743;
    RPC_S_PROTSEQ_NOT_FOUND = 1744;
    RPC_S_PROCNUM_OUT_OF_RANGE = 1745;
    RPC_S_BINDING_HAS_NO_AUTH = 1746;
    RPC_S_UNKNOWN_AUTHN_SERVICE = 1747;
    RPC_S_UNKNOWN_AUTHN_LEVEL = 1748;
    RPC_S_INVALID_AUTH_IDENTITY = 1749;
    RPC_S_UNKNOWN_AUTHZ_SERVICE = 1750;
    EPT_S_INVALID_ENTRY = 1751;
    EPT_S_CANT_PERFORM_OP = 1752;
    EPT_S_NOT_REGISTERED = 1753;
    RPC_S_NOTHING_TO_EXPORT = 1754;
    RPC_S_INCOMPLETE_NAME = 1755;
    RPC_S_INVALID_VERS_OPTION = 1756;
    RPC_S_NO_MORE_MEMBERS = 1757;
    RPC_S_NOT_ALL_OBJS_UNEXPORTED = 1758;
    RPC_S_INTERFACE_NOT_FOUND = 1759;
    RPC_S_ENTRY_ALREADY_EXISTS = 1760;
    RPC_S_ENTRY_NOT_FOUND = 1761;
    RPC_S_NAME_SERVICE_UNAVAILABLE = 1762;
    RPC_S_INVALID_NAF_ID = 1763;
    RPC_S_CANNOT_SUPPORT = 1764;
    RPC_S_NO_CONTEXT_AVAILABLE = 1765;
    RPC_S_INTERNAL_ERROR = 1766;
    RPC_S_ZERO_DIVIDE = 1767;
    RPC_S_ADDRESS_ERROR = 1768;
    RPC_S_FP_DIV_ZERO = 1769;
    RPC_S_FP_UNDERFLOW = 1770;
    RPC_S_FP_OVERFLOW = 1771;
    RPC_X_NO_MORE_ENTRIES = 1772;
    RPC_X_SS_CHAR_TRANS_OPEN_FAIL = 1773;
    RPC_X_SS_CHAR_TRANS_SHORT_FILE = 1774;
    RPC_X_SS_IN_NULL_CONTEXT = 1775;
    RPC_X_SS_CONTEXT_DAMAGED = 1777;
    RPC_X_SS_HANDLES_MISMATCH = 1778;
    RPC_X_SS_CANNOT_GET_CALL_HANDLE = 1779;
    RPC_X_NULL_REF_POINTER = 1780;
    RPC_X_ENUM_VALUE_OUT_OF_RANGE = 1781;
    RPC_X_BYTE_COUNT_TOO_SMALL = 1782;
    RPC_X_BAD_STUB_DATA = 1783;
    ERROR_INVALID_USER_BUFFER = 1784;
    ERROR_UNRECOGNIZED_MEDIA = 1785;
    ERROR_NO_TRUST_LSA_SECRET = 1786;
    ERROR_NO_TRUST_SAM_ACCOUNT = 1787;
    ERROR_TRUSTED_DOMAIN_FAILURE = 1788;
    ERROR_TRUSTED_RELATIONSHIP_FAILURE = 1789;
    ERROR_TRUST_FAILURE = 1790;
    RPC_S_CALL_IN_PROGRESS = 1791;
    ERROR_NETLOGON_NOT_STARTED = 1792;
    ERROR_ACCOUNT_EXPIRED = 1793;
    ERROR_REDIRECTOR_HAS_OPEN_HANDLES = 1794;
    ERROR_PRINTER_DRIVER_ALREADY_INSTALLED = 1795;
    ERROR_UNKNOWN_PORT = 1796;
    ERROR_UNKNOWN_PRINTER_DRIVER = 1797;
    ERROR_UNKNOWN_PRINTPROCESSOR = 1798;
    ERROR_INVALID_SEPARATOR_FILE = 1799;
    ERROR_INVALID_PRIORITY = 1800;
    ERROR_INVALID_PRINTER_NAME = 1801;
    ERROR_PRINTER_ALREADY_EXISTS = 1802;
    ERROR_INVALID_PRINTER_COMMAND = 1803;
    ERROR_INVALID_DATATYPE = 1804;
    ERROR_INVALID_ENVIRONMENT = 1805;
    RPC_S_NO_MORE_BINDINGS = 1806;
    ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT = 1807;
    ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT = 1808;
    ERROR_NOLOGON_SERVER_TRUST_ACCOUNT = 1809;
    ERROR_DOMAIN_TRUST_INCONSISTENT = 1810;
    ERROR_SERVER_HAS_OPEN_HANDLES = 1811;
    ERROR_RESOURCE_DATA_NOT_FOUND = 1812;
    ERROR_RESOURCE_TYPE_NOT_FOUND = 1813;
    ERROR_RESOURCE_NAME_NOT_FOUND = 1814;
    ERROR_RESOURCE_LANG_NOT_FOUND = 1815;
    ERROR_NOT_ENOUGH_QUOTA = 1816;
    RPC_S_NO_INTERFACES = 1817;
    RPC_S_CALL_CANCELLED = 1818;
    RPC_S_BINDING_INCOMPLETE = 1819;
    RPC_S_COMM_FAILURE = 1820;
    RPC_S_UNSUPPORTED_AUTHN_LEVEL = 1821;
    RPC_S_NO_PRINC_NAME = 1822;
    RPC_S_NOT_RPC_ERROR = 1823;
    RPC_S_UUID_LOCAL_ONLY = 1824;
    RPC_S_SEC_PKG_ERROR = 1825;
    RPC_S_NOT_CANCELLED = 1826;
    RPC_X_INVALID_ES_ACTION = 1827;
    RPC_X_WRONG_ES_VERSION = 1828;
    RPC_X_WRONG_STUB_VERSION = 1829;
    RPC_X_INVALID_PIPE_OBJECT = 1830;
    RPC_X_INVALID_PIPE_OPERATION = 1831;
    RPC_X_WRONG_PIPE_VERSION = 1832;
    RPC_S_GROUP_MEMBER_NOT_FOUND = 1898;
    EPT_S_CANT_CREATE = 1899;
    RPC_S_INVALID_OBJECT = 1900;
    ERROR_INVALID_TIME = 1901;
    ERROR_INVALID_FORM_NAME = 1902;
    ERROR_INVALID_FORM_SIZE = 1903;
    ERROR_ALREADY_WAITING = 1904;
    ERROR_PRINTER_DELETED = 1905;
    ERROR_INVALID_PRINTER_STATE = 1906;
    ERROR_PASSWORD_MUST_CHANGE = 1907;
    ERROR_DOMAIN_CONTROLLER_NOT_FOUND = 1908;
    ERROR_ACCOUNT_LOCKED_OUT = 1909;
    OR_INVALID_OXID = 1910;
    OR_INVALID_OID = 1911;
    OR_INVALID_SET = 1912;
    RPC_S_SEND_INCOMPLETE = 1913;
    ERROR_NO_BROWSER_SERVERS_FOUND = 6118;
    ERROR_INVALID_PIXEL_FORMAT = 2000;
    ERROR_BAD_DRIVER = 2001;
    ERROR_INVALID_WINDOW_STYLE = 2002;
    ERROR_METAFILE_NOT_SUPPORTED = 2003;
    ERROR_TRANSFORM_NOT_SUPPORTED = 2004;
    ERROR_CLIPPING_NOT_SUPPORTED = 2005;
    ERROR_UNKNOWN_PRINT_MONITOR = 3000;
    ERROR_PRINTER_DRIVER_IN_USE = 3001;
    ERROR_SPOOL_FILE_NOT_FOUND = 3002;
    ERROR_SPL_NO_STARTDOC = 3003;
    ERROR_SPL_NO_ADDJOB = 3004;
    ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED = 3005;
    ERROR_PRINT_MONITOR_ALREADY_INSTALLED = 3006;
    ERROR_INVALID_PRINT_MONITOR = 3007;
    ERROR_PRINT_MONITOR_IN_USE = 3008;
    ERROR_PRINTER_HAS_JOBS_QUEUED = 3009;
    ERROR_SUCCESS_REBOOT_REQUIRED = 3010;
    ERROR_SUCCESS_RESTART_REQUIRED = 3011;
    ERROR_WINS_INTERNAL = 4000;
    ERROR_CAN_NOT_DEL_LOCAL_WINS = 4001;
    ERROR_STATIC_INIT = 4002;
    ERROR_INC_BACKUP = 4003;
    ERROR_FULL_BACKUP = 4004;
    ERROR_REC_NON_EXISTENT = 4005;
    ERROR_RPL_NOT_ALLOWED = 4006;
    SEVERITY_SUCCESS = 0;
    SEVERITY_ERROR = 1;
    FACILITY_NT_BIT = $10000000;
    NOERROR = 0;
    E_UNEXPECTED = $8000FFFF;
    E_NOTIMPL = $80004001;
    E_OUTOFMEMORY = $8007000E;
    E_INVALIDARG = $80070057;
    E_NOINTERFACE = $80004002;
    E_POINTER = $80004003;
    E_HANDLE = $80070006;
    E_ABORT = $80004004;
    E_FAIL = $80004005;
    E_ACCESSDENIED = $80070005;
    E_PENDING = $8000000A;
    CO_E_INIT_TLS = $80004006;
    CO_E_INIT_SHARED_ALLOCATOR = $80004007;
    CO_E_INIT_MEMORY_ALLOCATOR = $80004008;
    CO_E_INIT_CLASS_CACHE = $80004009;
    CO_E_INIT_RPC_CHANNEL = $8000400A;
    CO_E_INIT_TLS_SET_CHANNEL_CONTROL = $8000400B;
    CO_E_INIT_TLS_CHANNEL_CONTROL = $8000400C;
    CO_E_INIT_UNACCEPTED_USER_ALLOCATOR = $8000400D;
    CO_E_INIT_SCM_MUTEX_EXISTS = $8000400E;
    CO_E_INIT_SCM_FILE_MAPPING_EXISTS = $8000400F;
    CO_E_INIT_SCM_MAP_VIEW_OF_FILE = $80004010;
    CO_E_INIT_SCM_EXEC_FAILURE = $80004011;
    CO_E_INIT_ONLY_SINGLE_THREADED = $80004012;
    CO_E_CANT_REMOTE = $80004013;
    CO_E_BAD_SERVER_NAME = $80004014;
    CO_E_WRONG_SERVER_IDENTITY = $80004015;
    CO_E_OLE1DDE_DISABLED = $80004016;
    CO_E_RUNAS_SYNTAX = $80004017;
    CO_E_CREATEPROCESS_FAILURE = $80004018;
    CO_E_RUNAS_CREATEPROCESS_FAILURE = $80004019;
    CO_E_RUNAS_LOGON_FAILURE = $8000401A;
    CO_E_LAUNCH_PERMSSION_DENIED = $8000401B;
    CO_E_START_SERVICE_FAILURE = $8000401C;
    CO_E_REMOTE_COMMUNICATION_FAILURE = $8000401D;
    CO_E_SERVER_START_TIMEOUT = $8000401E;
    CO_E_CLSREG_INCONSISTENT = $8000401F;
    CO_E_IIDREG_INCONSISTENT = $80004020;
    CO_E_NOT_SUPPORTED = $80004021;
    S_OK = $00000000;
    S_FALSE = $00000001;
    OLE_E_FIRST = $80040000;
    OLE_E_LAST = $800400FF;
    OLE_S_FIRST = $00040000;
    OLE_S_LAST = $000400FF;
    OLE_E_OLEVERB = $80040000;
    OLE_E_ADVF = $80040001;
    OLE_E_ENUM_NOMORE = $80040002;
    OLE_E_ADVISENOTSUPPORTED = $80040003;
    OLE_E_NOCONNECTION = $80040004;
    OLE_E_NOTRUNNING = $80040005;
    OLE_E_NOCACHE = $80040006;
    OLE_E_BLANK = $80040007;
    OLE_E_CLASSDIFF = $80040008;
    OLE_E_CANT_GETMONIKER = $80040009;
    OLE_E_CANT_BINDTOSOURCE = $8004000A;
    OLE_E_STATIC = $8004000B;
    OLE_E_PROMPTSAVECANCELLED = $8004000C;
    OLE_E_INVALIDRECT = $8004000D;
    OLE_E_WRONGCOMPOBJ = $8004000E;
    OLE_E_INVALIDHWND = $8004000F;
    OLE_E_NOT_INPLACEACTIVE = $80040010;
    OLE_E_CANTCONVERT = $80040011;
    OLE_E_NOSTORAGE = $80040012;
    DV_E_FORMATETC = $80040064;
    DV_E_DVTARGETDEVICE = $80040065;
    DV_E_STGMEDIUM = $80040066;
    DV_E_STATDATA = $80040067;
    DV_E_LINDEX = $80040068;
    DV_E_TYMED = $80040069;
    DV_E_CLIPFORMAT = $8004006A;
    DV_E_DVASPECT = $8004006B;
    DV_E_DVTARGETDEVICE_SIZE = $8004006C;
    DV_E_NOIVIEWOBJECT = $8004006D;
    DRAGDROP_E_FIRST = $80040100;
    DRAGDROP_E_LAST = $8004010F;
    DRAGDROP_S_FIRST = $00040100;
    DRAGDROP_S_LAST = $0004010F;
    DRAGDROP_E_NOTREGISTERED = $80040100;
    DRAGDROP_E_ALREADYREGISTERED = $80040101;
    DRAGDROP_E_INVALIDHWND = $80040102;
    CLASSFACTORY_E_FIRST = $80040110;
    CLASSFACTORY_E_LAST = $8004011F;
    CLASSFACTORY_S_FIRST = $00040110;
    CLASSFACTORY_S_LAST = $0004011F;
    CLASS_E_NOAGGREGATION = $80040110;
    CLASS_E_CLASSNOTAVAILABLE = $80040111;
    MARSHAL_E_FIRST = $80040120;
    MARSHAL_E_LAST = $8004012F;
    MARSHAL_S_FIRST = $00040120;
    MARSHAL_S_LAST = $0004012F;
    DATA_E_FIRST = $80040130;
    DATA_E_LAST = $8004013F;
    DATA_S_FIRST = $00040130;
    DATA_S_LAST = $0004013F;
    VIEW_E_FIRST = $80040140;
    VIEW_E_LAST = $8004014F;
    VIEW_S_FIRST = $00040140;
    VIEW_S_LAST = $0004014F;
    VIEW_E_DRAW = $80040140;
    REGDB_E_FIRST = $80040150;
    REGDB_E_LAST = $8004015F;
    REGDB_S_FIRST = $00040150;
    REGDB_S_LAST = $0004015F;
    REGDB_E_READREGDB = $80040150;
    REGDB_E_WRITEREGDB = $80040151;
    REGDB_E_KEYMISSING = $80040152;
    REGDB_E_INVALIDVALUE = $80040153;
    REGDB_E_CLASSNOTREG = $80040154;
    REGDB_E_IIDNOTREG = $80040155;
    CACHE_E_FIRST = $80040170;
    CACHE_E_LAST = $8004017F;
    CACHE_S_FIRST = $00040170;
    CACHE_S_LAST = $0004017F;
    CACHE_E_NOCACHE_UPDATED = $80040170;
    OLEOBJ_E_FIRST = $80040180;
    OLEOBJ_E_LAST = $8004018F;
    OLEOBJ_S_FIRST = $00040180;
    OLEOBJ_S_LAST = $0004018F;
    OLEOBJ_E_NOVERBS = $80040180;
    OLEOBJ_E_INVALIDVERB = $80040181;
    CLIENTSITE_E_FIRST = $80040190;
    CLIENTSITE_E_LAST = $8004019F;
    CLIENTSITE_S_FIRST = $00040190;
    CLIENTSITE_S_LAST = $0004019F;
    INPLACE_E_NOTUNDOABLE = $800401A0;
    INPLACE_E_NOTOOLSPACE = $800401A1;
    INPLACE_E_FIRST = $800401A0;
    INPLACE_E_LAST = $800401AF;
    INPLACE_S_FIRST = $000401A0;
    INPLACE_S_LAST = $000401AF;
    ENUM_E_FIRST = $800401B0;
    ENUM_E_LAST = $800401BF;
    ENUM_S_FIRST = $000401B0;
    ENUM_S_LAST = $000401BF;
    CONVERT10_E_FIRST = $800401C0;
    CONVERT10_E_LAST = $800401CF;
    CONVERT10_S_FIRST = $000401C0;
    CONVERT10_S_LAST = $000401CF;
    CONVERT10_E_OLESTREAM_GET = $800401C0;
    CONVERT10_E_OLESTREAM_PUT = $800401C1;
    CONVERT10_E_OLESTREAM_FMT = $800401C2;
    CONVERT10_E_OLESTREAM_BITMAP_TO_DIB = $800401C3;
    CONVERT10_E_STG_FMT = $800401C4;
    CONVERT10_E_STG_NO_STD_STREAM = $800401C5;
    CONVERT10_E_STG_DIB_TO_BITMAP = $800401C6;
    CLIPBRD_E_FIRST = $800401D0;
    CLIPBRD_E_LAST = $800401DF;
    CLIPBRD_S_FIRST = $000401D0;
    CLIPBRD_S_LAST = $000401DF;
    CLIPBRD_E_CANT_OPEN = $800401D0;
    CLIPBRD_E_CANT_EMPTY = $800401D1;
    CLIPBRD_E_CANT_SET = $800401D2;
    CLIPBRD_E_BAD_DATA = $800401D3;
    CLIPBRD_E_CANT_CLOSE = $800401D4;
    MK_E_FIRST = $800401E0;
    MK_E_LAST = $800401EF;
    MK_S_FIRST = $000401E0;
    MK_S_LAST = $000401EF;
    MK_E_CONNECTMANUALLY = $800401E0;
    MK_E_EXCEEDEDDEADLINE = $800401E1;
    MK_E_NEEDGENERIC = $800401E2;
    MK_E_UNAVAILABLE = $800401E3;
    MK_E_SYNTAX = $800401E4;
    MK_E_NOOBJECT = $800401E5;
    MK_E_INVALIDEXTENSION = $800401E6;
    MK_E_INTERMEDIATEINTERFACENOTSUPPORTED = $800401E7;
    MK_E_NOTBINDABLE = $800401E8;
    MK_E_NOTBOUND = $800401E9;
    MK_E_CANTOPENFILE = $800401EA;
    MK_E_MUSTBOTHERUSER = $800401EB;
    MK_E_NOINVERSE = $800401EC;
    MK_E_NOSTORAGE = $800401ED;
    MK_E_NOPREFIX = $800401EE;
    MK_E_ENUMERATION_FAILED = $800401EF;
    CO_E_FIRST = $800401F0;
    CO_E_LAST = $800401FF;
    CO_S_FIRST = $000401F0;
    CO_S_LAST = $000401FF;
    CO_E_NOTINITIALIZED = $800401F0;
    CO_E_ALREADYINITIALIZED = $800401F1;
    CO_E_CANTDETERMINECLASS = $800401F2;
    CO_E_CLASSSTRING = $800401F3;
    CO_E_IIDSTRING = $800401F4;
    CO_E_APPNOTFOUND = $800401F5;
    CO_E_APPSINGLEUSE = $800401F6;
    CO_E_ERRORINAPP = $800401F7;
    CO_E_DLLNOTFOUND = $800401F8;
    CO_E_ERRORINDLL = $800401F9;
    CO_E_WRONGOSFORAPP = $800401FA;
    CO_E_OBJNOTREG = $800401FB;
    CO_E_OBJISREG = $800401FC;
    CO_E_OBJNOTCONNECTED = $800401FD;
    CO_E_APPDIDNTREG = $800401FE;
    CO_E_RELEASED = $800401FF;
    OLE_S_USEREG = $00040000;
    OLE_S_STATIC = $00040001;
    OLE_S_MAC_CLIPFORMAT = $00040002;
    DRAGDROP_S_DROP = $00040100;
    DRAGDROP_S_CANCEL = $00040101;
    DRAGDROP_S_USEDEFAULTCURSORS = $00040102;
    DATA_S_SAMEFORMATETC = $00040130;
    VIEW_S_ALREADY_FROZEN = $00040140;
    CACHE_S_FORMATETC_NOTSUPPORTED = $00040170;
    CACHE_S_SAMECACHE = $00040171;
    CACHE_S_SOMECACHES_NOTUPDATED = $00040172;
    OLEOBJ_S_INVALIDVERB = $00040180;
    OLEOBJ_S_CANNOT_DOVERB_NOW = $00040181;
    OLEOBJ_S_INVALIDHWND = $00040182;
    INPLACE_S_TRUNCATED = $000401A0;
    CONVERT10_S_NO_PRESENTATION = $000401C0;
    MK_S_REDUCED_TO_SELF = $000401E2;
    MK_S_ME = $000401E4;
    MK_S_HIM = $000401E5;
    MK_S_US = $000401E6;
    MK_S_MONIKERALREADYREGISTERED = $000401E7;
    CO_E_CLASS_CREATE_FAILED = $80080001;
    CO_E_SCM_ERROR = $80080002;
    CO_E_SCM_RPC_FAILURE = $80080003;
    CO_E_BAD_PATH = $80080004;
    CO_E_SERVER_EXEC_FAILURE = $80080005;
    CO_E_OBJSRV_RPC_FAILURE = $80080006;
    MK_E_NO_NORMALIZED = $80080007;
    CO_E_SERVER_STOPPING = $80080008;
    MEM_E_INVALID_ROOT = $80080009;
    MEM_E_INVALID_LINK = $80080010;
    MEM_E_INVALID_SIZE = $80080011;
    CO_S_NOTALLINTERFACES = $00080012;

    DISP_E_UNKNOWNINTERFACE = $80020001;
    DISP_E_MEMBERNOTFOUND = $80020003;
    DISP_E_PARAMNOTFOUND = $80020004;
    DISP_E_TYPEMISMATCH = $80020005;
    DISP_E_UNKNOWNNAME = $80020006;
    DISP_E_NONAMEDARGS = $80020007;
    DISP_E_BADVARTYPE = $80020008;
    DISP_E_EXCEPTION = $80020009;
    DISP_E_OVERFLOW = $8002000A;
    DISP_E_BADINDEX = $8002000B;
    DISP_E_UNKNOWNLCID = $8002000C;
    DISP_E_ARRAYISLOCKED = $8002000D;
    DISP_E_BADPARAMCOUNT = $8002000E;
    DISP_E_PARAMNOTOPTIONAL = $8002000F;
    DISP_E_BADCALLEE = $80020010;
    DISP_E_NOTACOLLECTION = $80020011;
    TYPE_E_BUFFERTOOSMALL = $80028016;
    TYPE_E_INVDATAREAD = $80028018;
    TYPE_E_UNSUPFORMAT = $80028019;
    TYPE_E_REGISTRYACCESS = $8002801C;
    TYPE_E_LIBNOTREGISTERED = $8002801D;
    TYPE_E_UNDEFINEDTYPE = $80028027;
    TYPE_E_QUALIFIEDNAMEDISALLOWED = $80028028;
    TYPE_E_INVALIDSTATE = $80028029;
    TYPE_E_WRONGTYPEKIND = $8002802A;
    TYPE_E_ELEMENTNOTFOUND = $8002802B;
    TYPE_E_AMBIGUOUSNAME = $8002802C;
    TYPE_E_NAMECONFLICT = $8002802D;
    TYPE_E_UNKNOWNLCID = $8002802E;
    TYPE_E_DLLFUNCTIONNOTFOUND = $8002802F;
    TYPE_E_BADMODULEKIND = $800288BD;
    TYPE_E_SIZETOOBIG = $800288C5;
    TYPE_E_DUPLICATEID = $800288C6;
    TYPE_E_INVALIDID = $800288CF;
    TYPE_E_TYPEMISMATCH = $80028CA0;
    TYPE_E_OUTOFBOUNDS = $80028CA1;
    TYPE_E_IOERROR = $80028CA2;
    TYPE_E_CANTCREATETMPFILE = $80028CA3;
    TYPE_E_CANTLOADLIBRARY = $80029C4A;
    TYPE_E_INCONSISTENTPROPFUNCS = $80029C83;
    TYPE_E_CIRCULARTYPE = $80029C84;
    STG_E_INVALIDFUNCTION = $80030001;
    STG_E_FILENOTFOUND = $80030002;
    STG_E_PATHNOTFOUND = $80030003;
    STG_E_TOOMANYOPENFILES = $80030004;
    STG_E_ACCESSDENIED = $80030005;
    STG_E_INVALIDHANDLE = $80030006;
    STG_E_INSUFFICIENTMEMORY = $80030008;
    STG_E_INVALIDPOINTER = $80030009;
    STG_E_NOMOREFILES = $80030012;
    STG_E_DISKISWRITEPROTECTED = $80030013;
    STG_E_SEEKERROR = $80030019;
    STG_E_WRITEFAULT = $8003001D;
    STG_E_READFAULT = $8003001E;
    STG_E_SHAREVIOLATION = $80030020;
    STG_E_LOCKVIOLATION = $80030021;
    STG_E_FILEALREADYEXISTS = $80030050;
    STG_E_INVALIDPARAMETER = $80030057;
    STG_E_MEDIUMFULL = $80030070;
    STG_E_PROPSETMISMATCHED = $800300F0;
    STG_E_ABNORMALAPIEXIT = $800300FA;
    STG_E_INVALIDHEADER = $800300FB;
    STG_E_INVALIDNAME = $800300FC;
    STG_E_UNKNOWN = $800300FD;
    STG_E_UNIMPLEMENTEDFUNCTION = $800300FE;
    STG_E_INVALIDFLAG = $800300FF;
    STG_E_INUSE = $80030100;
    STG_E_NOTCURRENT = $80030101;
    STG_E_REVERTED = $80030102;
    STG_E_CANTSAVE = $80030103;
    STG_E_OLDFORMAT = $80030104;
    STG_E_OLDDLL = $80030105;
    STG_E_SHAREREQUIRED = $80030106;
    STG_E_NOTFILEBASEDSTORAGE = $80030107;
    STG_E_EXTANTMARSHALLINGS = $80030108;
    STG_E_DOCFILECORRUPT = $80030109;
    STG_E_BADBASEADDRESS = $80030110;
    STG_E_INCOMPLETE = $80030201;
    STG_E_TERMINATED = $80030202;
    STG_S_CONVERTED = $00030200;
    STG_S_BLOCK = $00030201;
    STG_S_RETRYNOW = $00030202;
    STG_S_MONITORING = $00030203;
    RPC_E_CALL_REJECTED = $80010001;
    RPC_E_CALL_CANCELED = $80010002;
    RPC_E_CANTPOST_INSENDCALL = $80010003;
    RPC_E_CANTCALLOUT_INASYNCCALL = $80010004;
    RPC_E_CANTCALLOUT_INEXTERNALCALL = $80010005;
    RPC_E_CONNECTION_TERMINATED = $80010006;
    RPC_E_SERVER_DIED = $80010007;
    RPC_E_CLIENT_DIED = $80010008;
    RPC_E_INVALID_DATAPACKET = $80010009;
    RPC_E_CANTTRANSMIT_CALL = $8001000A;
    RPC_E_CLIENT_CANTMARSHAL_DATA = $8001000B;
    RPC_E_CLIENT_CANTUNMARSHAL_DATA = $8001000C;
    RPC_E_SERVER_CANTMARSHAL_DATA = $8001000D;
    RPC_E_SERVER_CANTUNMARSHAL_DATA = $8001000E;
    RPC_E_INVALID_DATA = $8001000F;
    RPC_E_INVALID_PARAMETER = $80010010;
    RPC_E_CANTCALLOUT_AGAIN = $80010011;
    RPC_E_SERVER_DIED_DNE = $80010012;
    RPC_E_SYS_CALL_FAILED = $80010100;
    RPC_E_OUT_OF_RESOURCES = $80010101;
    RPC_E_ATTEMPTED_MULTITHREAD = $80010102;
    RPC_E_NOT_REGISTERED = $80010103;
    RPC_E_FAULT = $80010104;
    RPC_E_SERVERFAULT = $80010105;
    RPC_E_CHANGED_MODE = $80010106;
    RPC_E_INVALIDMETHOD = $80010107;
    RPC_E_DISCONNECTED = $80010108;
    RPC_E_RETRY = $80010109;
    RPC_E_SERVERCALL_RETRYLATER = $8001010A;
    RPC_E_SERVERCALL_REJECTED = $8001010B;
    RPC_E_INVALID_CALLDATA = $8001010C;
    RPC_E_CANTCALLOUT_ININPUTSYNCCALL = $8001010D;
    RPC_E_WRONG_THREAD = $8001010E;
    RPC_E_THREAD_NOT_INIT = $8001010F;
    RPC_E_VERSION_MISMATCH = $80010110;
    RPC_E_INVALID_HEADER = $80010111;
    RPC_E_INVALID_EXTENSION = $80010112;
    RPC_E_INVALID_IPID = $80010113;
    RPC_E_INVALID_OBJECT = $80010114;
    RPC_S_CALLPENDING = $80010115;
    RPC_S_WAITONTIMER = $80010116;
    RPC_E_CALL_COMPLETE = $80010117;
    RPC_E_UNSECURE_CALL = $80010118;
    RPC_E_TOO_LATE = $80010119;
    RPC_E_NO_GOOD_SECURITY_PACKAGES = $8001011A;
    RPC_E_ACCESS_DENIED = $8001011B;
    RPC_E_REMOTE_DISABLED = $8001011C;
    RPC_E_INVALID_OBJREF = $8001011D;
    RPC_E_UNEXPECTED = $8001FFFF;
    NTE_BAD_UID = $80090001;
    NTE_BAD_HASH = $80090002;
    NTE_BAD_KEY = $80090003;
    NTE_BAD_LEN = $80090004;
    NTE_BAD_DATA = $80090005;
    NTE_BAD_SIGNATURE = $80090006;
    NTE_BAD_VER = $80090007;
    NTE_BAD_ALGID = $80090008;
    NTE_BAD_FLAGS = $80090009;
    NTE_BAD_TYPE = $8009000A;
    NTE_BAD_KEY_STATE = $8009000B;
    NTE_BAD_HASH_STATE = $8009000C;
    NTE_NO_KEY = $8009000D;
    NTE_NO_MEMORY = $8009000E;
    NTE_EXISTS = $8009000F;
    NTE_PERM = $80090010;
    NTE_NOT_FOUND = $80090011;
    NTE_DOUBLE_ENCRYPT = $80090012;
    NTE_BAD_PROVIDER = $80090013;
    NTE_BAD_PROV_TYPE = $80090014;
    NTE_BAD_PUBLIC_KEY = $80090015;
    NTE_BAD_KEYSET = $80090016;
    NTE_PROV_TYPE_NOT_DEF = $80090017;
    NTE_PROV_TYPE_ENTRY_BAD = $80090018;
    NTE_KEYSET_NOT_DEF = $80090019;
    NTE_KEYSET_ENTRY_BAD = $8009001A;
    NTE_PROV_TYPE_NO_MATCH = $8009001B;
    NTE_SIGNATURE_FILE_BAD = $8009001C;
    NTE_PROVIDER_DLL_FAIL = $8009001D;
    NTE_PROV_DLL_NOT_FOUND = $8009001E;
    NTE_BAD_KEYSET_PARAM = $8009001F;
    NTE_FAIL = $80090020;
    NTE_SYS_ERR = $80090021;
    NTE_OP_OK = 0;
    TRUST_E_PROVIDER_UNKNOWN = $800B0001;
    TRUST_E_ACTION_UNKNOWN = $800B0002;
    TRUST_E_SUBJECT_FORM_UNKNOWN = $800B0003;
    TRUST_E_SUBJECT_NOT_TRUSTED = $800B0004;
    DIGSIG_E_ENCODE = $800B0005;
    DIGSIG_E_DECODE = $800B0006;
    DIGSIG_E_EXTENSIBILITY = $800B0007;
    DIGSIG_E_CRYPTO = $800B0008;
    PERSIST_E_SIZEDEFINITE = $800B0009;
    PERSIST_E_SIZEINDEFINITE = $800B000A;
    PERSIST_E_NOTSELFSIZING = $800B000B;
    TRUST_E_NOSIGNATURE = $800B0100;
    CERT_E_EXPIRED = $800B0101;
    CERT_E_VALIDIYPERIODNESTING = $800B0102;
    CERT_E_ROLE = $800B0103;
    CERT_E_PATHLENCONST = $800B0104;
    CERT_E_CRITICAL = $800B0105;
    CERT_E_PURPOSE = $800B0106;
    CERT_E_ISSUERCHAINING = $800B0107;
    CERT_E_MALFORMED = $800B0108;
    CERT_E_UNTRUSTEDROOT = $800B0109;
    CERT_E_CHAINING = $800B010A;

(*$W44. *)
