(********************************************************************************************
** PROGRAM     : rm
** VERSION     : 1.0.0
** DESCRIPTION : Removes a file.
** AUTHOR      : Stuart King
** COPYRIGHT   : Copyright (c) Irie Tools, 2002. All Rights Reserved.
** NOTES       :
**    This sample program is distributed with Irie Pascal, and was written to provide
** an example of how to use the built-in procedure 'erase'. To make best use of this
** sample you should have a basic understanding of Pascal.
**********************************************************************************************)
//*************************************************
// This program removes (i.e. erases) a file
// First it asks for the name of the file
// Then it assigns the name to a file variable
// Finally it calls 'erase' on the file variable
//************************************************
program rm(input, output);
var
   fn : filename;
   f : binary;
begin
   write('Which file do you want to delete? ');
   readln(fn);

   //Associate the name of the file to be deleted so that 'erase' knows which
   //file to delete. NOTE: 'erase' takes a file variable as a parameter and expects
   //the name of the file to be erased to be associated with this file variable.
   assign(f, fn);

   erase(f);
end.
