implementation module EdDraw;

/*	The text drawing routines.
	The performance of the editor very much depends on the performance of
	these routines, therefore strictness annotations have been added by hand.
 */

import	StdClass;
import StdInt,StdChar,StdString, StdBool, StdArray;
import deltaPicture;

from EdTypes import TLine, CursorPos, Selection, PartSel;
from EdConstants import LinesLeft, TabStr, PictureRight;

    

/*	DrawLines yoffset height tabwidth lines:
	Draws the lines, 1st line's baseline is on yofs.
*/

DrawLines	:: !Int !Int !Int !Int ![TLine] !Picture -> Picture;
DrawLines yofs hgt tabw right [] pic =  pic;
DrawLines yofs hgt tabw right [line:lines] pic
	= 	DrawLines (yofs + hgt) hgt tabw right lines drawline;
	where {
	drawline=: DrawTLine yofs tabw right line pic;
	};

/*	Erase&DrawLines yoffset height ofs tabwidth right lines:
	Draws the lines, 1st line's baseline is on yoffset,
	erases all underneath
*/

Erase_and_DrawLines	:: !Int !Int !Int !Int !Int ![TLine] !Picture -> Picture;
Erase_and_DrawLines yofs hgt ofs tabw right [] pic
	=  EraseRectangle ((LinesLeft,y),(right,y + hgt)) pic;
	where {
	y=: yofs - ofs;
	};
Erase_and_DrawLines yofs hgt ofs tabw right [line:lines] pic
	=  Erase_and_DrawLines (yofs + hgt) hgt ofs tabw right lines pic`;
	where {
	pic`=: DrawTLine yofs tabw right line pic1;
	pic1=: EraseRectangle ((LinesLeft,y),(right,y + hgt)) pic;
	y=: yofs - ofs;
	};


/*	Erase&DrawLine yoffset height ofs tabwidth right line:
	Draws the line, line's baseline is on yoffset,
	erases all underneath
*/

Erase_and_DrawLine	:: !Int !Int !Int !Int !Int !TLine !Picture -> Picture;
Erase_and_DrawLine yofs hgt ofs tabw right line pic
	=  DrawTLine yofs tabw right line pic1;
	where {
	pic1=: EraseRectangle ((LinesLeft,y),(right,y + hgt)) pic;
	y   =: yofs - ofs;
	};


/*	DrawTLine yoffset tabwidth lines:
	Draws the line, line's baseline is on yofs.
*/

DrawTLine	:: !Int !Int !Int !TLine !Picture -> Picture;
DrawTLine yofs tabw right line pic
	=  DrawStrings 0 tabw right line pic`;
	where {
	pic`=: MovePenTo (LinesLeft,yofs) pic;
	};


/*	DrawStrings: auxiliary function, draws the strings in the TLine parameter */

DrawStrings	:: !Int !Int !Int TLine !Picture -> Picture;
DrawStrings xofs tabw right [str] pic
	| xofs > right =  pic;
	=  DrawString (str % (0, size str  - 2)) pic;
DrawStrings xofs tabw right [str:rest] pic
	| xofs > right =  pic;
	| str == TabStr = 	DrawStrings xofs` tabw right rest drawtab;
	=  DrawStrings (xofs + strw) tabw right rest drawstr;
	where {
	xofs`			=: tabw *  inc (xofs / tabw) ;
	drawtab		=: MovePen (xofs` - xofs, 0) pic;
	(strw,pic1)	=: PictureStringWidth str pic;
	drawstr		=: DrawString str pic1;
	};
DrawStrings xofs tabw right [] pic =  pic;


/*	ShiftStringsLeft/ShiftStringsRight: auxiliary functions, shift the TLine
	2nd arg. pixels to the left or the right. */

ShiftStringsRight	:: !Int !Int !Int !Int !Int !Int TLine !Picture -> Picture;
ShiftStringsRight xofs ofs y hght tabw right line pic
	=  ShiftRevStringsRight y hght tabw right rline pic`;
	where {
	(rline,pic`)=: ReverseTLine xofs ofs tabw right line [] pic;
	};

ShiftRevStringsRight	:: !Int !Int !Int !Int ![(!Int,!Int,!String)] !Picture -> Picture;
ShiftRevStringsRight y hght tabw right [] pic =  pic;
ShiftRevStringsRight y hght tabw right [(x,ofs,string) : rest] pic
	=  ShiftRevStringsRight y hght tabw x rest scroll;
	where {
	scroll=: MoveRectangle ((x,y),(right,y + hght)) (ofs,0) pic;
	};

ReverseTLine	:: !Int !Int !Int !Int !TLine ![(!Int,!Int,!String)] !Picture
	-> (![(!Int,!Int,!String)], !Picture);
ReverseTLine x ofs tabw right [] rev pic =  (rev, pic);
ReverseTLine x ofs tabw right [TabStr : rest] rev pic
	| x >= right =  (rev, pic);
	| ofs <  xtab - x  =  ReverseTLine xtab 0    tabw right rest rev pic;
	=  ReverseTLine xtab tabw tabw right rest rev pic;
	where {
	xtab=: tabw *  inc (x / tabw) ;
	};
ReverseTLine x ofs tabw right [string : rest] rev pic
	| x >= right =  (rev, pic);
	=  ReverseTLine (x + strw) ofs tabw right rest [(x,ofs,string):rev] pic`;
	where {
	(strw,pic`)=: PictureStringWidth string pic;
	};

ShiftStringsLeft	:: !Int !Int !Int !Int !Int !Int !Int TLine !Picture -> Picture;
ShiftStringsLeft x ofs y basey hght tabw right [TabStr:rest] pic
	| x > right =  pic;
	| oldxt == xtab =  erase;
	=  ShiftStringsLeft xtab (0 - tabw) y basey hght tabw right rest erase;
	where {
	erase=: EraseRectangle ((x,y),(xtab,y + hght)) pic;
	xtab =: tabw *  inc (x / tabw) ;
	oldxt=: tabw *  inc ((x - ofs) / tabw) ;
	};
ShiftStringsLeft x ofs y basey hght tabw right line=:[str:rest] pic
	| x > right =  pic;
	| fromr > right =  DrawStrings x tabw right line (MovePenTo (x,basey) erase);
	=  ShiftStringsLeft (x + strw) ofs y basey hght tabw right rest move;
	where {
	erase			=: EraseRectangle ((right + ofs,y),(right,y + hght)) move;
	move			=: MoveRectangle ((froml,y),(min fromr right,y + hght)) (ofs,0) pic`;
	(strw,pic`)	=: PictureStringWidth str pic;
	fromr			=: froml + strw;
	froml			=: x - ofs;
	};
ShiftStringsLeft x ofs y basey hght tabw right [] pic
	=  EraseRectangle ((x,y),(right,y + hght)) pic;
	
/*
::	ShiftStringsLeft !INT !INT !INT !INT !INT !INT !INT TLine !Picture -> Picture;
	ShiftStringsLeft x ofs y basey hght tabw right [TabStr:rest] pic
	-> erase, IF > x right || > ofs (- x xtab)
	-> ShiftStringsLeft xtab (- 0 tabw) y basey hght tabw right rest erase,
	erase: EraseRectangle ((x,y),(xtab,+ y hght)) pic,
	xtab : * tabw (++ (/ x tabw));
	ShiftStringsLeft x ofs y basey hght tabw right line:[str:rest] pic
	-> DrawStrings x tabw right line (MovePenTo (x,basey) scroll), IF > xfrom' right
	-> ShiftStringsLeft (+ x strw) ofs y basey hght tabw right rest scroll,
	scroll		: MoveRectangle ((xfrom,y),(xfrom',+ y hght)) (ofs,0) pic',
	xfrom'		: + xfrom strw,
	xfrom			: - x ofs;
	ShiftStringsLeft x ofs y basey hght tabw right [] pic
	-> EraseRectangle ((x,y),(right,+ y hght)) pic;
*/
/*	DrawShiftCurLine shifts the current line one char to the right */

DrawShiftCurLine	:: !Int !Int !Int !Int !Int !Char !TLine !Picture -> Picture;
DrawShiftCurLine x y hght tabw right key line pic
	=  DrawChar key (MovePenTo (x,y + (at_new + ld)) pic`);
	where {
	pic`          =: ShiftStringsRight x charw y hght tabw right line pic2; 
	(charw,pic2)  =: PictureCharWidth key pic1;
	(metrics,pic1)=: PictureFontMetrics pic;
	(at_new,dt,mw,ld) =: metrics;
	};

/*	DrawTabCurLine draws a tab (shifts the rest of the current line one tab to the right) */

DrawTabCurLine	:: !Int !Int !Int !Int !Int !Int !TLine !Picture -> Picture;
DrawTabCurLine ox nx y hght tabw right line pic
	=  ShiftStringsRight ox (nx - ox) y hght tabw right line pic;

/*	DrawRestCurLine draws a list of chars
*/

DrawRestCurLine	:: !Int !Int !Int !Int !TLine !Picture -> Picture;
DrawRestCurLine xofs y tabw right line pic
	=  DrawStrings xofs tabw right line (MovePenTo (xofs,y) pic);


/*	EraseRestCurLine erases a line from (cx,cy) */

EraseRestCurLine	:: !Int !Int !Int !Int !Picture -> Picture;
EraseRestCurLine cx cy hght right pic
	=  EraseRectangle ((cx,cy),(right,cy + hght)) pic;


/*	DrawBackspCurLine shifts the rest of the current line to the left
*/

DrawBackspCurLine	:: !Int !Int !Int !Int !Int !Int !TLine !Picture -> Picture;
DrawBackspCurLine xofs ofs y hght tabw right line pic
	=  ShiftStringsLeft xofs (0 - ofs) y (y + (at_new + ld)) hght tabw right line pic1;
	where {
	(metrics,pic1)=: PictureFontMetrics pic;
	(at_new,dt,mw,ld) =: metrics;
	};


/*	DrawCursor draws the cursor in XOR mode, arg2 is the height of the cursor */

DrawCursor	:: !CursorPos !Int !Int !Picture -> Picture;
DrawCursor (vis,x,y,u) height lead pic
	=  SetPenMode CopyMode (LinePenTo (x,dec (y` + height)) (
		                  MovePenTo (x,y`) (SetPenMode XorMode pic)));
	where {
	y`=: y + lead;
	};

/*	RemoveCursor removes the cursor, arg2 is the height */

RemoveCursor	:: !CursorPos !Int !Int !Picture -> Picture;
RemoveCursor (vis,x,y,u) height lead pic
	| vis =  SetPenMode CopyMode (LinePenTo (x,dec (y` + height)) (
		                  MovePenTo (x,y`) (SetPenMode XorMode pic)));
	=  pic;
	where {
	y`=: y + lead;
	};

/*	DrawReHilite hilites or un-hilites the Selection passed to it, arg2 = height of a line */

DrawReHilite	:: !Selection !Int !Picture -> Picture;
DrawReHilite (tsel,psel) hght pic =  DoHilite psel hght pic;

/*	DrawHilite hilites the new Selection (arg2) and un-hilites the old one (arg1)
	arg3 is the height of a line */

DrawHilite	:: !Selection !Selection !Int !Picture -> Picture;
DrawHilite (otsl,osl=:(obx,oby,oex,oey)) (ntsl,nsl=:(nbx,nby,nex,ney)) hght pic
	| (obx == nex && oby == ney) || (nbx == oex && nby == oey)
	                              =  DoHilite nsl hght (DoHilite osl hght pic);
	| obx == nbx && oby == nby =  ChangeHilite oex oey nex ney hght pic;
	=  ChangeHilite nbx nby obx oby hght pic; // IF = oex nex && oey ney

ChangeHilite	:: !Int !Int !Int !Int !Int !Picture -> Picture;
ChangeHilite bx by ex ey hght pic
	| ey < by || (ey == by && ex < bx) =  DoHilite (ex,ey,bx,by) hght pic;
	=  DoHilite (bx,by,ex,ey) hght pic; // IF > ey by || (= ey by && > ex bx)

/*	DrawReSelect is called by the update-functions to redraw the selection
	when it is within the rectangle */

DrawReSelect	:: !Rectangle !(Int,Int,Int,Int) !Int !Picture -> Picture;
DrawReSelect area (bx,by,ex,ey) hght pic
	| by == ey =  Repaint area bx by ex eyph pic;
	| byph == ey =  Repaint area bx by PictureRight byph pic1;
	=  Repaint area bx by PictureRight byph pic2;
	where {
	pic1=: Repaint area LinesLeft ey ex eyph pic;
	pic2=: Repaint area LinesLeft byph PictureRight ey pic1;
	byph=: by + hght;
	eyph=:	ey + hght;
	};

/*	Repaint: aux. function paints a rectangle determined by arg2-arg5 within the borders
	of the area */

Repaint	:: !Rectangle !Int !Int !Int !Int !Picture -> Picture;
Repaint rect bx by ex ey pic
	=  SetPenMode CopyMode (Repaint1 rect bx by ex ey (SetPenMode HiliteMode pic));
	
Repaint1	:: !Rectangle !Int !Int !Int !Int !Picture -> Picture;
Repaint1 ((lft,top),(rgt,bot)) bx by ex ey pic
	| lft > ex || top > ey || rgt < bx || bot < by =  pic;
	=  FillRectangle ((max lft bx,max top by),(min rgt ex,min bot ey)) pic;

/*	DoHilite: aux. function, paints the area to be hilited or un-hilited */

DoHilite	:: !(Int,Int,Int,Int) !Int !Picture -> Picture;
DoHilite psel hght pic =  SetPenMode CopyMode (DoHilite1 psel hght (SetPenMode HiliteMode pic));

DoHilite1	:: !(Int,Int,Int,Int) !Int !Picture -> Picture;
DoHilite1 (bx,by,ex,ey) hght pic
	| by == ey =  FillRectangle ((bx,by),(ex,eyph)) pic;
	| byph == ey =  FillRectangle ((bx,by),(PictureRight,byph)) pic1;
	=  FillRectangle ((bx,by),(PictureRight,byph)) pic2;
	where {
	pic1=: FillRectangle ((LinesLeft,ey),(ex,eyph)) pic;
	pic2=: FillRectangle ((LinesLeft,byph),(PictureRight,ey)) pic1;
	byph=: by + hght;
	eyph=:	ey + hght;
	};
