/*----------------------------------------------------------------------------------------------------
    u敗v  ȈՃTEhĐCu

  $Id: lightwind.h,v 1.3 2000/12/23 05:59:13 Sofiya Exp $
----------------------------------------------------------------------------------------------------*/
#ifndef INCL_CLASS_LIGHTWIND
#define INCL_CLASS_LIGHTWIND

#define MAX_SOUNDBUFFER_TABLE (64UL)
#define LIGHTWIND_MULTI_MAX_LAYER (32)

#ifdef __cplusplus

#include "SoundDriver.h"
#include "RingBuffer.h"

class SoundBuffer {
public:
    virtual int Mix( void *pvData, unsigned long ulDataLength ) = 0;

    /*--------------------------------------------------------------------------------------------------*/
    /* Đ                                                                                         */
    /*                                                                                                  */
    /* lVolume :  0-256  0:ʏ 256:ʍő                                                  */
    /* lLoopCount: [v(-1:Đ)                                                        */
    /* Ret: 0:s                                                                                      */
    /*      0ȊO:                                                                                  */
    /*--------------------------------------------------------------------------------------------------*/
    virtual int Play( long lVolume = 256, long lLoopCount = 1 ) = 0;

    /*--------------------------------------------------------------------------------------------------*/
    /* Đ~                                                                                   */
    /*                                                                                                  */
    /* Ret: 0:s                                                                                      */
    /*      0ȊO:                                                                                  */
    /*--------------------------------------------------------------------------------------------------*/
    virtual int Stop( void ) = 0;

    /*--------------------------------------------------------------------------------------------------*/
    /* ĐǂԂ                                                                             */
    /*                                                                                                  */
    /* Ret: 0:ĐĂȂ                                                                              */
    /*      0ȊO: ĐĂ                                                                         */
    /*--------------------------------------------------------------------------------------------------*/
    virtual int IsPlaying( void ) = 0;

    /* TEhobt@j */
    virtual void Terminate( void ) = 0;

    /*--------------------------------------------------------------------------------------------------*/
    /* {[ݒ肷                                                                             */
    /*                                                                                                  */
    /* lVolume : 0-256  0:ʏ 256:ʍő                                                       */
    /* Ret: 0:s                                                                                      */
    /*      0ȊO:                                                                                  */
    /*--------------------------------------------------------------------------------------------------*/
    virtual int SetVolume( long lVolume = 256 ) = 0;

    /*--------------------------------------------------------------------------------------------------*/
    /* p|bgݒ肷                                                                             */
    /*                                                                                                  */
    /* lPanpot: 0-128-256  --E                                                                   */
    /* Ret: 0:s                                                                                      */
    /*      0ȊO:                                                                                  */
    /*--------------------------------------------------------------------------------------------------*/
    virtual int SetPanpot( long lPanpot = 128 ) = 0;

    /*--------------------------------------------------------------------------------------------------*/
    /* [v񐔂ݒ肷                                                                             */
    /*                                                                                                  */
    /* lLoopCount: [v(-1:Đ)                                                        */
    /* Ret: 0:s                                                                                      */
    /*      0ȊO:                                                                                  */
    /*--------------------------------------------------------------------------------------------------*/
    virtual int SetLoopCount( long lLoopCount = -1 ) = 0;
};

class LIGHTWIND {
    SoundDriver *pDriver;
    static SoundBuffer* SoundBufferTable[MAX_SOUNDBUFFER_TABLE];

    static long lMasterVol;
    static long lVol;
    static float fFadeVol;

public:
    LIGHTWIND();
    ~LIGHTWIND();

    enum {
        LIGHTWIND_CREATESOUNDBUFFER_MULTILAYER = 1,
        LIGHTWIND_CREATESOUNDBUFFER_STREAM     = 2,
    };

    /*--------------------------------------------------------------------------------------------------*/
    /* TEhobt@쐬                                                                       */
    /*                                                                                                  */
    /* pszFilename:t@C                                                                           */
    /* ulMode     :쐬[h                                                                           */
    /*             LIGHTWIND_CREATESOUNDBUFFER_MULTILAYER                                               */
    /*                Wavet@ĈݑΉBʉZ̍ĐɎgp܂B                          */
    /*             LIGHTWIND_CREATESOUNDBUFFER_STREAM                                                   */
    /*                OGG`AWavet@CAPCMt@CAMP3t@CɑΉB                           */
    /*                y≹̂悤ɒ̍ĐɎgp܂B                                      */
    /* Ret: 0:쐬Ɏs                                                                                */
    /*      0ȊO:TEhobt@̃|C^                                                            */
    /*--------------------------------------------------------------------------------------------------*/
    SoundBuffer* CreateSoundBuffer( const char *pszFilename, unsigned long ulMode = LIGHTWIND_CREATESOUNDBUFFER_MULTILAYER );

    /*--------------------------------------------------------------------------------------------------*/
    /* TEhobt@j                                                                       */
    /*                                                                                                  */
    /* psb:jTEhobt@̃|C^                                                           */
    /* Ret: 0:js                                                                                  */
    /*      0ȊO:I                                                                              */
    /*--------------------------------------------------------------------------------------------------*/
    int DestroySoundBuffer( SoundBuffer *psb );

    /*--------------------------------------------------------------------------------------------------*/
    /* ĐǂԂ                                                                             */
    /*                                                                                                  */
    /* Ret: 0:ĐĂȂ                                                                              */
    /*      0ȊO: ĐĂ                                                                         */
    /*--------------------------------------------------------------------------------------------------*/
    int IsPlaying( void );

    /*--------------------------------------------------------------------------------------------------*/
    /* {[ݒ肷                                                                             */
    /*                                                                                                  */
    /* lVolume : 0-256  0:ʏ 256:ʍő                                                       */
    /* Ret: 0:s                                                                                      */
    /*      0ȊO:                                                                                  */
    /*--------------------------------------------------------------------------------------------------*/
    int SetVolume( long lVolume = 256 );

    static long MixBuffer( unsigned long ulBufferLength, void *pvBuffer );
};

extern LIGHTWIND Lightwind;
#else
/* Cp */
enum {
    LIGHTWIND_CREATESOUNDBUFFER_MULTILAYER = 1,
    LIGHTWIND_CREATESOUNDBUFFER_STREAM     = 2,
};

/*--------------------------------------------------------------------------------------------------*/
/* TEhobt@쐬                                                                       */
/*                                                                                                  */
/* pszFilename:t@C                                                                           */
/* ulMode     :쐬[h                                                                           */
/*             LIGHTWIND_CREATESOUNDBUFFER_MULTILAYER                                               */
/*                Wavet@ĈݑΉBʉZ̍ĐɎgp܂B                          */
/*             LIGHTWIND_CREATESOUNDBUFFER_STREAM                                                   */
/*                OGG`AWavet@CAPCMt@CAMP3t@CɑΉB                           */
/*                y≹̂悤ɒ̍ĐɎgp܂B                                      */
/* Ret: 0:쐬Ɏs                                                                                */
/*      0ȊO:TEhobt@̃|C^                                                            */
/*--------------------------------------------------------------------------------------------------*/
extern void* lwCreateSoundBuffer( const char *pszFilename, unsigned long ulMode );

/*--------------------------------------------------------------------------------------------------*/
/* TEhobt@j                                                                       */
/*                                                                                                  */
/* pvSoundBuffer:jTEhobt@̃|C^                                                 */
/* Ret: 0:js                                                                                  */
/*      0ȊO:I                                                                              */
/*--------------------------------------------------------------------------------------------------*/
extern int lwDestroySoundBuffer( void *pvSoundBuffer );

/*--------------------------------------------------------------------------------------------------*/
/* Đ                                                                                         */
/*                                                                                                  */
/* pvSoundBuffer: ĐTEhobt@ւ̃|C^                                              */
/* lVolume :  0-256  0:ʏ 256:ʍő                                                  */
/* lLoopCount: [v(-1:Đ)                                                        */
/* Ret: 0:s                                                                                      */
/*      0ȊO:                                                                                  */
/*--------------------------------------------------------------------------------------------------*/
extern int lwPlay( void *pvSoundBuffer, long lVolume, long lLoopCount );

/*--------------------------------------------------------------------------------------------------*/
/* Đ~                                                                                   */
/*                                                                                                  */
/* pvSoundBuffer: Đ~TEhobt@ւ̃|C^                                        */
/* Ret: 0:s                                                                                      */
/*      0ȊO:                                                                                  */
/*--------------------------------------------------------------------------------------------------*/
extern int lwStop( void *pvSoundBuffer );

/*--------------------------------------------------------------------------------------------------*/
/* ĐǂԂ                                                                             */
/*                                                                                                  */
/* pvSoundBuffer: Đǂ𒲂ׂTEhobt@ւ̃|C^                              */
/*                NULL(0)̏ꍇ́ASẴTEhobt@𒲂ׂ                                   */
/* Ret: 0:ĐĂȂ                                                                              */
/*      0ȊO: ĐĂ                                                                         */
/*--------------------------------------------------------------------------------------------------*/
extern int lwIsPlaying( void *pvSoundBuffer );

/*--------------------------------------------------------------------------------------------------*/
/* TEhobt@j                                                                       */
/*                                                                                                  */
/* pvSoundBuffer:jTEhobt@ւ̃|C^                                               */
/*--------------------------------------------------------------------------------------------------*/
extern void lwTerminate( void *pvSoundBuffer );

/*--------------------------------------------------------------------------------------------------*/
/* {[ݒ肷                                                                             */
/*                                                                                                  */
/* pvSoundBuffer: ʂݒ肷TEhobt@ւ̃|C^                                        */
/*                NULL(0)̏ꍇ́A}X^{[̐ݒƂȂ                                     */
/* lVolume : 0-256  0:ʏ 256:ʍő                                                       */
/* Ret: 0:s                                                                                      */
/*      0ȊO:                                                                                  */
/*--------------------------------------------------------------------------------------------------*/
extern int lwSetVolume( void *pvSoundBuffer, long lVolume );

/*--------------------------------------------------------------------------------------------------*/
/* p|bgݒ肷                                                                             */
/*                                                                                                  */
/* pvSoundBuffer: p|bgݒ肷TEhobt@ւ̃|C^                                  */
/* lPanpot: 0-128-256  --E                                                                   */
/* Ret: 0:s                                                                                      */
/*      0ȊO:                                                                                  */
/*--------------------------------------------------------------------------------------------------*/
extern int lwSetPanpot( void *pvSoundBuffer, long lPanpot );

/*--------------------------------------------------------------------------------------------------*/
/* [v񐔂ݒ肷                                                                             */
/*                                                                                                  */
/* pvSoundBuffer: [v񐔂ݒ肷TEhobt@ւ̃|C^                                  */
/* lLoopCount: [v(-1:Đ)                                                        */
/* Ret: 0:s                                                                                      */
/*      0ȊO:                                                                                  */
/*--------------------------------------------------------------------------------------------------*/
extern int lwSetLoopCount( void *pvSoundBuffer, long lLoopCount );

#endif

#endif
