/* rexx */
signal on error
signal on syntax  name error
signal on halt    name error
signal on failure name error
'@echo off'

line = copies('-', 79)

'cls'
say
say 'G2Immed --- Testing REXXGDB2.DLL function: G2Immediate'
say 'Simon Husin (husin@ibm.net)'
say 'Kent, Washington, U.S.A., December 1995'
say

if rxfuncquery('g2LoadFuncs') then do
   say
   say 'Loading REXXGDB2 Functions...'
   call rxfuncadd 'g2LoadFuncs', 'REXXGDB2', 'g2LoadFuncs'
   say 'Result =' g2LoadFuncs()
   end

say
call time 'R'
say 'Connecting to SAMPLE database...'
call g2connectshare 'SAMPLE'
say 'Execution time    ' time('E') / 1

/* Before Insert */
say line
say center('ORG before inserting DEPTNUMB = 99', 79)
call ShowOrg

/*
Insert a row in table ORG
*/
sql = 'insert into org (deptnumb, deptname, manager, division, location)'||,
      "       values (99, 'Europe', 290, 'World', 'Brussels')"
say
say 'Inserting Department# 99...'
call time 'R'
retcode = g2immediate(sql)
elapse = time('E')
say 'Return Code       ' retcode
say 'Execution time    ' time('E')

/* After Insert */
say line
say center('ORG after inserting DEPTNUMB = 99', 79)
call ShowOrg

/*
Delete the new row from table ORG
*/
sql = 'delete from org where deptnumb = 99'
say
say 'Deleting Department# 99...'
call time 'R'
retcode = g2immediate(sql)
elapse = time('E')
say 'Return Code       ' retcode
say 'Execution time    ' time('E')

/* After Delete */
say line
say center('ORG after deleting DEPTNUMB = 99', 79)
call ShowOrg

say
call time 'R'
say 'Rolling back...'
call g2rollback
say 'Execution time    ' time('E') / 1
return 0



ShowOrg:
sql = 'Select * from org'
stem = 'form.'
requestedrows = 999999999
nullchar      = '%'
padchar       = '_'
varcharlen    = 10

say
call time 'R'
retcode = g2selectform(sql, stem, requestedrows, nullchar, padchar, varcharlen)
elapse = time('E')
say 'Return Code       ' retcode
say 'Execution time    ' time('E')
say
say 'Stem tot# elements' form.0
if retcode = 0 | retcode = 100 then
   do i = 1 to form.0
      say 'Element FORM.'i '=' form.i
      end
say line
say 'All ORG rows have just been listed.'
say 'Press Enter to continue.'
pull answer
return



error:
say 'Error detected...'
return 10

syntax:
say 'Syntax error detected...'
return 20
