/* rexx */
/*
Set error traps
*/
signal on error
signal on syntax  name error
signal on halt    name error
signal on failure name error

/*
General initialization
*/
'@echo off'
flinit = 0 /* flag, 1=initialization has been completed */

/*
Main loop
*/
do forever
   'cls'
   say
   say 'G2Cols --- Testing program for REXXGDB2.DLL function: G2SelectCols'
   say 'Simon Husin (husin@ibm.net)'
   say 'Kent, Washington, U.S.A., December 1995'
   say
   say 'Run test number:'
   say '1   All columns of a table (ORG)'
   say '2   Count(*) on table (ORG)'
   say '3   Constant, named and numbered columns of a table (ORG)'
   say
   say 'Any other to Quit'
   say
   say 'Enter your selection and/or press Enter'
   pull choice
   if wordpos(choice, '1 2 3') = 0 then leave

   if \flinit then do
      if rxfuncquery('g2LoadFuncs') then do
         say
         say 'Loading REXXGDB2 Functions...'
         call rxfuncadd 'g2LoadFuncs', 'REXXGDB2', 'g2LoadFuncs'
         say 'Result =' g2LoadFuncs()
         end
      say
      say 'Connecting to SAMPLE database...'
      call time 'R'
      call g2connectshare 'SAMPLE'
      say 'Completed in (seconds)' time('E')
      flinit = 1
      end

   select
     when choice = 1 then call Test1
     when choice = 2 then call Test2
     otherwise            call Test3
     end
   say
   say 'Press Enter to continue...'
   pull choice
   end

/*
Release all locks with Commit
*/
if flinit then do
   say
   say 'Commiting...'
   call g2commit
   call time 'R'
   say 'Completed in (seconds)' time('E')
   end
return 0

Test1:
say center(' TEST1 ', 79, '-')
sql = 'select * from org'
say 'SQL:' sql
say 'Executing G2SelectCols(SQL, COLS.)...'
call time 'R'
retcode = g2selectcols(sql, cols.)
elapse = time('E')
say 'Return Code           ' retcode
say 'Completed in (seconds)' elapse
say
say 'Stem tot# elements    ' cols.0
if retcode = 0 | retcode = 100 then do
   do i = 1 to cols.0
      say 'Element COLS.'i '=' cols.i
      end
   end
return

Test2:
say center(' TEST2 ', 79, '-')
sql = 'select count(*) from org'
say 'SQL:' sql
say 'Executing G2SelectCols(SQL, COLS.)...'
call time 'R'
retcode = g2selectcols(sql, cols.)
elapse = time('E')
say 'Return Code           ' retcode
say 'Completed in (seconds)' elapse
say
say 'Stem tot# elements    ' cols.0
if retcode = 0 | retcode = 100 then do
   do i = 1 to cols.0
      say 'Element COLS.'i '=' cols.i
      end
   end
return

Test3:
say center(' TEST3 ', 79, '-')
sql = "select 'Test', deptnumb, count(*) from org group by deptnumb"
say 'SQL:' sql
say 'Executing G2SelectCols(SQL, COLS.)...'
call time 'R'
retcode = g2selectcols(sql, cols.)
elapse = time('E')
say 'Return Code           ' retcode
say 'Completed in (seconds)' elapse
say
say 'Stem tot# elements    ' cols.0
if retcode = 0 | retcode = 100 then do
   do i = 1 to cols.0
      say 'Element COLS.'i '=' cols.i
      end
   end
return 0



error:
say 'Error detected...'
return 10

syntax:
say 'Syntax error detected...'
return 20
