


    this is the may 18, 1993 version of clsode (c version of lsode)
    translated clsode example is located in lsode.h

    for more information about clsode,
       contact..   Woon-Chul Choi
                   choi2@chd1s0.engr.ccny.cuny.edu






   =====================================================================
    following note was prepared by original author, alan c. hindmarsh.
    some of them are not true for C version of lsode. there is a couple
    of minor differences. they are noted in the file, "lsode.h."
   =====================================================================






    this is the march 30, 1987 version of
    lsode.. livermore solver for ordinary differential equations.
    this version is in double precision.

    lsode solves the initial value problem for stiff or nonstiff
    systems of first order ode-s,
        dy/dt = f(t,y) ,  or, in component form,
        dy(i)/dt = f(i) = f(i,t,y(1),y(2),...,y(neq)) (i = 1,...,neq).
    lsode is a package based on the gear and gearb packages, and on the
    october 23, 1978 version of the tentative odepack user interface
    standard, with minor modifications.
   ---------------------------------------------------------------------- 
    reference..
        alan c. hindmarsh,  odepack, a systematized collection of ode     
        solvers, in scientific computing, r. s. stepleman et al. (eds.),  
        north-holland, amsterdam, 1983, pp. 55-64.
   ---------------------------------------------------------------------- 
    author and contact.. alan c. hindmarsh,
                         computing and mathematics research div., l-316   
                         lawrence livermore national laboratory
                         livermore, ca 94550.
   ---------------------------------------------------------------------- 
    summary of usage.

    communication between the user and the lsode package, for normal      
    situations, is summarized here. this summary describes only a subset  
    of the full set of options available.  see the full description for   
    details, including optional communication, nonstandard options,       
    and instructions for special situations.  see also the example        
    problem (with program and output) following this summary.             

    a. first provide a subroutine of the form..
                  subroutine f (neq, t, y, ydot)
                  dimension y(neq), ydot(neq)
    which supplies the vector function f by loading ydot(i) with f(i).    

    b. next determine (or guess) whether or not the problem is stiff.     
    stiffness occurs when the jacobian matrix df/dy has an eigenvalue     
    whose real part is negative and large in magnitude, compared to the   
    reciprocal of the t span of interest.  if the problem is nonstiff,    
    use a method flag mf = 10.  if it is stiff, there are four standard   
    choices for mf, and lsode requires the jacobian matrix in some form.  
    this matrix is regarded either as full (mf = 21 or 22),
    or banded (mf = 24 or 25).  in the banded case, lsode requires two    
    half-bandwidth parameters ml and mu.  these are, respectively, the    
    widths of the lower and upper parts of the band, excluding the main   
    diagonal.  thus the band consists of the locations (i,j) with
    i-ml .le. j .le. i+mu, and the full bandwidth is ml+mu+1.

    c. if the problem is stiff, you are encouraged to supply the jacobian 
    directly (mf = 21 or 24), but if this is not feasible, lsode will     
    compute it internally by difference quotients (mf = 22 or 25).
    if you are supplying the jacobian, provide a subroutine of the form.. 
                  subroutine jac (neq, t, y, ml, mu, pd, nrowpd)
                  dimension y(neq), pd(nrowpd,neq)
    which supplies df/dy by loading pd as follows..
        for a full jacobian (mf = 21), load pd(i,j) with df(i)/dy(j),
    the partial derivative of f(i) with respect to y(j).  (ignore the
    ml and mu arguments in this case.)
        for a banded jacobian (mf = 24), load pd(i-j+mu+1,j) with
    df(i)/dy(j), i.e. load the diagonal lines of df/dy into the rows of
    pd from the top down.
        in either case, only nonzero elements need be loaded.             

    d. write a main program which calls subroutine lsode once for         
    each point at which answers are desired.  this should also provide    
    for possible use of logical unit 6 for output of error messages       
    by lsode.  on the first call to lsode, supply arguments as follows..  
    f      = name of subroutine for right-hand side vector f.
             this name must be declared external in calling program.      
    neq    = number of first order ode-s.
    y      = array of initial values, of length neq.
    t      = the initial value of the independent variable.
    tout   = first point where output is desired (!= t).
    itol   = 1 or 2 according as atol (below) is a scalar or array.
    rtol   = relative tolerance parameter (scalar).
    atol   = absolute tolerance parameter (scalar or array).
             the estimated local error in y(i) will be controlled so as   
             to be roughly less (in magnitude) than                       
                ewt(i) = rtol*abs(y(i)) + atol     if itol = 1, or        
                ewt(i) = rtol*abs(y(i)) + atol(i)  if itol = 2.           
             thus the local error test passes if, in each component,      
             either the absolute error is less than atol (or atol(i)),    
             or the relative error is less than rtol.                     
             use rtol = 0.0 for pure absolute error control, and          
             use atol = 0.0 (or atol(i) = 0.0) for pure relative error    
             control.  caution.. actual (global) errors may exceed these  
             local tolerances, so choose them conservatively.             
    itask  = 1 for normal computation of output values of y at t = tout.  
    istate = integer flag (input and output).  set istate = 1.            
    iopt   = 0 to indicate no optional inputs used.
    rwork  = real work array of length at least..
                20 + 16*neq                    for mf = 10,
                22 +  9*neq + neq**2           for mf = 21 or 22,
                22 + 10*neq + (2*ml + mu)*neq  for mf = 24 or 25.
    lrw    = declared length of rwork (in user-s dimension).
    iwork  = integer work array of length at least..
                20        for mf = 10,
                20 + neq  for mf = 21, 22, 24, or 25.                     
             if mf = 24 or 25, input in iwork(1),iwork(2) the lower       
             and upper half-bandwidths ml,mu.
    liw    = declared length of iwork (in user-s dimension).              
    jac    = name of subroutine for jacobian matrix (mf = 21 or 24).      
             if used, this name must be declared external in calling      
             program.  if not used, pass a dummy name.                    
    mf     = method flag.  standard values are..                          
             10 for nonstiff (adams) method, no jacobian used.            
             21 for stiff (bdf) method, user-supplied full jacobian.      
             22 for stiff method, internally generated full jacobian.     
             24 for stiff method, user-supplied banded jacobian.          
             25 for stiff method, internally generated banded jacobian.   
    note that the main program must declare arrays y, rwork, iwork,       
    and possibly atol.                                                    
                                                                          
    e. the output from the first call (or any call) is..                  
         y = array of computed values of y(t) vector.                     
         t = corresponding value of independent variable (normally tout). 
    istate = 2  if lsode was successful, negative otherwise.              
             -1 means excess work done on this call (perhaps wrong mf).   
             -2 means excess accuracy requested (tolerances too small).   
             -3 means illegal input detected (see printed message).       
             -4 means repeated error test failures (check all inputs).    
             -5 means repeated convergence failures (perhaps bad jacobian 
                supplied or wrong choice of mf or tolerances).            
             -6 means error weight became zero during problem. (solution  
                component i vanished, and atol or atol(i) = 0.)           
                                                                          
    f. to continue the integration after a successful return, simply      
    reset tout and call lsode again.  no other parameters need be reset.  
                                                                          
   ---------------------------------------------------------------------- 
    example problem.                                                      
                                                                          
    the following is a simple example problem, with the coding            
    needed for its solution by lsode.  the problem is from chemical       
    kinetics, and consists of the following three rate equations..        
        dy1/dt = -.04*y1 + 1.e4*y2*y3                                     
        dy2/dt = .04*y1 - 1.e4*y2*y3 - 3.e7*y2**2                         
        dy3/dt = 3.e7*y2**2                                               
    on the interval from t = 0.0 to t = 4.e10, with initial conditions    
    y1 = 1.0, y2 = y3 = 0.  the problem is stiff.                         
                                                                          
    the following coding solves this problem with lsode, using mf = 21    
    and printing results at t = .4, 4., ..., 4.e10.  it uses              
    itol = 2 and atol much smaller for y2 than y1 or y3 because           
    y2 has much smaller values.                                           
    at the end of the run, statistical quantities of interest are         
    printed (see optional outputs in the full description below).         
                                                                          
        external fex) = 0.)                                               
                                                                          
    f. to continue the integration after a successful return, simply      
    reset tout and call lsode again.  no other parameters need be reset.  
                                                                          
   ---------------------------------------------------------------------- 
    example problem.                                                      
                                                                          
    the following is a simple example problem, with the coding            
    needed for its solution by lsode.  the problem is from chemical       
    kinetics, and consists of the following three rate equations..        
        dy1/dt = -.04*y1 + 1.e4*y2*y3                                     
        dy2/dt = .04*y1 - 1.e4*y2*y3 - 3.e7*y2**2                         
        dy3/dt = 3.e7*y2**2                                               
    on the interval from t = 0.0 to t = 4.e10, with initial conditions    
    y1 = 1.0, y2 = y3 = 0.  the problem is stiff.                         
                                                                          
    the following coding solves this problem with lsode, using mf = 21    
    and printing results at t = .4, 4., ..., 4.e10.  it uses              
    itol = 2 and atol much smaller for y2 than y1 or y3 because           
    y2 has much smaller values.                                           
    at the end of the run, statistical quantities of interest are         
    printed (see optional outputs in the full description below).         
                                                                          
        external fex, jex                                                 
        double precision atol, rtol, rwork, t, tout, y                    
        dimension y(3), atol(3), rwork(58), iwork(23)                     
        neq = 3                                                           
        y(1) = 1.d0                                                       
        y(2) = 0.d0                                                       
        y(3) = 0.d0                                                       
        t = 0.d0                                                          
        tout = .4d0                                                       
        itol = 2                                                          
        rtol = 1.d-4                                                      
        atol(1) = 1.d-6                                                   
        atol(2) = 1.d-10                                                  
        atol(3) = 1.d-6                                                   
        itask = 1                                                         
        istate = 1                                                        
        iopt = 0                                                          
        lrw = 58                                                          
        liw = 23                                                          
        mf = 21                                                           
        do 40 iout = 1,12                                                 
          call lsode(fex,neq,y,t,tout,itol,rtol,atol,itask,istate,        
       1     iopt,rwork,lrw,iwork,liw,jex,mf)                             
          write(6,20)t,y(1),y(2),y(3)                                     
    20    format(7h at t =,e12.4,6h   y =,3e14.6)                         
          if (istate < 0) goto 80                                         
    40    tout = tout*10.d0                                               
        write(6,60)iwork(11),iwork(12),iwork(13)                          
    60  format(/12h no. steps =,i4,11h  no. f-s =,i4,11h  no. j-s =,i4)   
        stop                                                              
    80  write(6,90)istate                                                 
    90  format(///22h error halt.. istate =,i3)                           
        stop                                                              
        end                                                               
                                                                          
        subroutine fex (neq, t, y, ydot)                                  
        double precision t, y, ydot                                       
        dimension y(3), ydot(3)                                           
        ydot(1) = -.04d0*y(1) + 1.d4*y(2)*y(3)                            
        ydot(3) = 3.d7*y(2)*y(2)                                          
        ydot(2) = -ydot(1) - ydot(3)                                      
        return                                                            
        end                                                               
                                                                          
        subroutine jex (neq, t, y, ml, mu, pd, nrpd)                      
        double precision pd, t, y                                         
        dimension y(3), pd(nrpd,3)                                        
        pd(1,1) = -.04d0                                                  
        pd(1,2) = 1.d4*y(3)                                               
        pd(1,3) = 1.d4*y(2)                                               
        pd(2,1) = .04d0                                                   
        pd(2,3) = -pd(1,3)                                                
        pd(3,2) = 6.d7*y(2)                                               
        pd(2,2) = -pd(1,2) - pd(3,2)                                      
        return                                                            
        end                                                               
                                                                          
    the output of this program (on a cdc-7600 in single precision)        
    is as follows..                                                       
                                                                          
      at t =  4.0000e-01   y =  9.851726e-01  3.386406e-05  1.479357e-02  
      at t =  4.0000e+00   y =  9.055142e-01  2.240418e-05  9.446344e-02  
      at t =  4.0000e+01   y =  7.158050e-01  9.184616e-06  2.841858e-01  
      at t =  4.0000e+02   y =  4.504846e-01  3.222434e-06  5.495122e-01  
      at t =  4.0000e+03   y =  1.831701e-01  8.940379e-07  8.168290e-01  
      at t =  4.0000e+04   y =  3.897016e-02  1.621193e-07  9.610297e-01  
      at t =  4.0000e+05   y =  4.935213e-03  1.983756e-08  9.950648e-01  
      at t =  4.0000e+06   y =  5.159269e-04  2.064759e-09  9.994841e-01  
      at t =  4.0000e+07   y =  5.306413e-05  2.122677e-10  9.999469e-01  
      at t =  4.0000e+08   y =  5.494529e-06  2.197824e-11  9.999945e-01  
      at t =  4.0000e+09   y =  5.129458e-07  2.051784e-12  9.999995e-01  
      at t =  4.0000e+10   y = -7.170586e-08 -2.868234e-13  1.000000e+00  
                                                                          
      no. steps = 330  no. f-s = 405  no. j-s =  69                       
   ---------------------------------------------------------------------- 
    full description of user interface to lsode.                          
                                                                          
    the user interface to lsode consists of the following parts.          
                                                                          
    i.   the call sequence to subroutine lsode, which is a driver         
         routine for the solver.  this includes descriptions of both      
         the call sequence arguments and of user-supplied routines.       
         following these descriptions is a description of                 
         optional inputs available through the call sequence, and then    
         a description of optional outputs (in the work arrays).          
                                                                          
    ii.  descriptions of other routines in the lsode package that may be  
         (optionally) called by the user.  these provide the ability to   
         alter error message handling, save and restore the internal      
         common, and obtain specified derivatives of the solution y(t).   
                                                                          
    iii. descriptions of common blocks to be declared in overlay          
         or similar environments, or to be saved when doing an interrupt  
         of the problem and continued solution later.                     
                                                                          
    iv.  description of two routines in the lsode package, either of      
         which the user may replace with his own version, if desired.     
         these relate to the measurement of errors.                       
                                                                          
   ---------------------------------------------------------------------- 
    part i.  call sequence.                                               
                                                                          
    the call sequence parameters used for input only are                  
        f, neq, tout, itol, rtol, atol, itask, iopt, lrw, liw, jac, mf,   
    and those used for both input and output are                          
         optional inputs available through the call sequence, and then    
         a description of optional outputs (in the work arrays).          
                                                                          
    ii.  descriptions of other routines in the lsode package that may be  
         (optionally) called by the user.  these provide the ability to   
         alter error message handling, save and restore the internal      
         common, and obtain specified derivatives of the solution y(t).   
                                                                          
    iii. descriptions of common blocks to be declared in overlay          
         or similar environments, or to be saved when doing an interrupt  
         of the problem and continued solution later.                     
                                                                          
    iv.  description of two routines in the lsode package, either of      
         which the user may replace with his own version, if desired.     
         these relate to the measurement of errors.                       
                                                                          
   ---------------------------------------------------------------------- 
    part i.  call sequence.                                               
                                                                          
    the call sequence parameters used for input only are                  
        f, neq, tout, itol, rtol, atol, itask, iopt, lrw, liw, jac, mf,   
    and those used for both input and output are                          
        y, t, istate.                                                     
    the work arrays rwork and iwork are also used for conditional and     
    optional inputs and optional outputs.  (the term output here refers   
    to the return from subroutine lsode to the user-s calling program.)   
                                                                          
    the legality of input parameters will be thoroughly checked on the    
    initial call for the problem, but not checked thereafter unless a     
    change in input parameters is flagged by istate = 3 on input.         
                                                                          
    the descriptions of the call arguments are as follows.                
                                                                          
    f      = the name of the user-supplied subroutine defining the        
             ode system.  the system must be put in the first-order       
             form dy/dt = f(t,y), where f is a vector-valued function     
             of the scalar t and the vector y.  subroutine f is to        
             compute the function f.  it is to have the form              
                  subroutine f (neq, t, y, ydot)                          
                  dimension y(1), ydot(1)                                 
             where neq, t, and y are input, and the array ydot = f(t,y)   
             is output.  y and ydot are arrays of length neq.             
             (in the dimension statement above, 1 is a dummy              
             dimension.. it can be replaced by any value.)                
             subroutine f should not alter y(1),...,y(neq).               
             f must be declared external in the calling program.          
                                                                          
             subroutine f may access user-defined quantities in           
             neq(2),... and/or in y(neq(1)+1),... if neq is an array      
             (dimensioned in f) and/or y has length exceeding neq(1).     
             see the descriptions of neq and y below.                     
                                                                          
             if quantities computed in the f routine are needed           
             externally to lsode, an extra call to f should be made       
             for this purpose, for consistent and accurate results.       
             if only the derivative dy/dt is needed, use intdy instead.   
                                                                          
    neq    = the size of the ode system (number of first order            
             ordinary differential equations).  used only for input.      
             neq may be decreased, but not increased, during the problem. 
             if neq is decreased (with istate = 3 on input), the          
             remaining components of y should be left undisturbed, if     
             these are to be accessed in f and/or jac.                    
                                                                          
             normally, neq is a scalar, and it is generally referred to   
             as a scalar in this user interface description.  however,    
             neq may be an array, with neq(1) set to the system size.     
             (the lsode package accesses only neq(1).)  in either case,   
             this parameter is passed as the neq argument in all calls    
             to f and jac.  hence, if it is an array, locations           
             neq(2),... may be used to store other integer data and pass  
             it to f and/or jac.  subroutines f and/or jac must include   
             neq in a dimension statement in that case.                   
                                                                          
    y      = a real array for the vector of dependent variables, of       
             length neq or more.  used for both input and output on the   
             first call (istate = 1), and only for output on other calls. 
             on the first call, y must contain the vector of initial      
             values.  on output, y contains the computed solution vector, 
             evaluated at t.  if desired, the y array may be used         
             for other purposes between calls to the solver.              
                                                                          
             this array is passed as the y argument in all calls to       
             f and jac.  hence its length may exceed neq, and locations   
             y(neq+1),... may be used to store other real data and        
             pass it to f and/or jac.  (the lsode package accesses only   
             y(1),...,y(neq).)                                            
                                                                          
    t      = the independent variable.  on input, t is used only on the   
             first call, as the initial point of the integration.         
             on output, after each call, t is the value at which a        
             computed solution y is evaluated (usually the same as tout). 
             on an error return, t is the farthest point reached.         
                                                                          
    tout   = the next value of t at which a computed solution is desired. 
             used only for input.                                         
                                                                          
             when starting the problem (istate = 1), tout may be equal    
             to t for one call, then should != t for the next call.       
             for the initial t, an input value of tout != t is used       
             in order to determine the direction of the integration       
             (i.e. the algebrai    sign of the step sizes) and the rough  
             scale of the problem.  integration in either direction       
             (forward or backward in t) is permitted.                     
                                                                          
             if itask = 2 or 5 (one-step modes), tout is ignored after    
             the first call (i.e. the first call with tout != t).         
             otherwise, tout is required on every call.                   
                                                                          
             if itask = 1, 3, or 4, the values of tout need not be        
             monotone, but a value of tout which backs up is limited      
             to the current internal t interval, whose endpoints are      
             tcur - hu and tcur (see optional outputs, below, for         
             tcur and hu).                                                
                                                                          
    itol   = an indicator for the type of error control.  see             
             description below under atol.  used only for input.          
                                                                          
    rtol   = a relative error tolerance parameter, either a scalar or     
             an array of length neq.  see description below under atol.   
             input only.                                                  
                                                                          
    atol   = an absolute error tolerance parameter, either a scalar or    
             an array of length neq.  input only.                         
                                                                          
                the input parameters itol, rtol, and atol determine       
             the error control performed by the solver.  the solver will  
             control the vector e = (e(i)) of estimated local errors      
             in y, according to an inequality of the form                 
                         rms-norm of ( e(i)/ewt(i) )   .le.   1,          
             where       ewt(i) = rtol(i)*abs(y(i)) + atol(i),            
             and the rms-norm (root-mean-square norm) here is             
             rms-norm(v) = sqrt(sum v(i)**2 / neq).  here ewt = (ewt(i))  
             is a vector of weights which must always be positive, and    
             the values of rtol and atol should all be non-negative.      
             the following table gives the types (scalar/array) of        
             rtol and atol, and the corresponding form of ewt(i).         
                                                                          
                itol    rtol       atol          ewt(i)                   
                 1     scalar     scalar     rtol*abs(y(i)) + atol        
                 2     scalar     array      rtol*abs(y(i)) + atol(i)     
                 3     array      scalar     rtol(i)*abs(y(i)) + atol     
                 4     array      array      rtol(i)*abs(y(i)) + atol(i)  
                                                                          
             when either of these parameters is a scalar, it need not     
             be dimensioned in the user-s calling program.                
                                                                          
             if none of the above choices (with itol, rtol, and atol      
             fixed throughout the problem) is suitable, more general      
             error controls can be obtained by substituting               
             user-supplied routines for the setting of ewt and/or for     
             the norm calculation.  see part iv below.                    
                                                                          
             if global errors are to be estimated by making a repeated    
             run on the same problem with smaller tolerances, then all    
             components of rtol and atol (i.e. of ewt) should be scaled   
             down uniformly.                                              
                                                                          
    itask  = an index specifying the task to be performed.                
             input only.  itask has the following values and meanings.    
             1  means normal computation of output values of y(t) at      
                t = tout (by overshooting and interpolating).             
             2  means take one step only and return.                      
             3      rtol(i)*abs(y(i)) + atol                              
                 4     array      array      rtol(i)*abs(y(i)) + atol(i)  
                                                                          
             when either of these parameters is a scalar, it need not     
             be dimensioned in the user-s calling program.                
                                                                          
             if none of the above choices (with itol, rtol, and atol      
             fixed throughout the problem) is suitable, more general      
             error controls can be obtained by substituting               
             user-supplied routines for the setting of ewt and/or for     
             the norm calculation.  see part iv below.                    
                                                                          
             if global errors are to be estimated by making a repeated    
             run on the same problem with smaller tolerances, then all    
             components of rtol and atol (i.e. of ewt) should be scaled   
             down uniformly.                                              
                                                                          
    itask  = an index specifying the task to be performed.                
             input only.  itask has the following values and meanings.    
             1  means normal computation of output values of y(t) at      
                t = tout (by overshooting and interpolating).             
             2  means take one step only and return.                      
             3  means stop at the first internal mesh point at or         
                beyond t = tout and return.                               
             4  means normal computation of output values of y(t) at      
                t = tout but without overshooting t = tcrit.              
                tcrit must be input as rwork(1).  tcrit may be equal to   
                or beyond tout, but not behind it in the direction of     
                integration.  this option is useful if the problem        
                has a singularity at or beyond t = tcrit.                 
             5  means take one step, without passing tcrit, and return.   
                tcrit must be input as rwork(1).                          
                                                                          
             note..  if itask = 4 or 5 and the solver reaches tcrit       
             (within roundoff), it will return t = tcrit (exactly) to     
             indicate this (unless itask = 4 and tout comes before tcrit, 
             in which case answers at t = tout are returned first).       
                                                                          
    istate = an index used for input and output to specify the            
             the state of the calculation.                                
                                                                          
             on input, the values of istate are as follows.               
             1  means this is the first call for the problem              
                (initializations will be done).  see note below.          
             2  means this is not the first call, and the calculation     
                is to continue normally, with no change in any input      
                parameters except possibly tout and itask.                
                (if itol, rtol, and/or atol are changed between calls     
                with istate = 2, the new values will be used but not      
                tested for legality.)                                     
             3  means this is not the first call, and the                 
                calculation is to continue normally, but with             
                a change in input parameters other than                   
                tout and itask.  changes are allowed in                   
                neq, itol, rtol, atol, iopt, lrw, liw, mf, ml, mu,        
                and any of the optional inputs except h0.                 
                (see iwork description for ml and mu.)                    
             note..  a preliminary call with tout = t is not counted      
             as a first call here, as no initialization or checking of    
             input is done.  (such a call is sometimes useful for the     
             purpose of outputting the initial conditions.)               
             thus the first call for which tout != t requires             
             istate = 1 on input.                                         
                                                                          
             on output, istate has the following values and meanings.     
              1  means nothing was done, as tout was equal to t with      
                 istate = 1 on input.  (however, an internal counter was  
                 set to detect and prevent repeated calls of this type.)  
              2  means the integration was performed successfully.        
             -1  means an excessive amount of work (more than mxstep      
                 steps) was done on this call, before completing the      
                 requested task, but the integration was otherwise        
                 successful as far as t.  (mxstep is an optional input    
                 and is normally 500.)  to continue, the user may         
                 simply reset istate to a value .gt. 1 and call again     
                 (the excess work step counter will be reset to 0).       
                 in addition, the user may increase mxstep to avoid       
                 this error return (see below on optional inputs).        
             -2  means too much accuracy was requested for the precision  
                 of the machine being used.  this was detected before     
                 completing the requested task, but the integration       
                 was successful as far as t.  to continue, the tolerance  
                 parameters must be reset, and istate must be set         
                 to 3.  the optional output tolsf may be used for this    
                 purpose.  (note.. if this condition is detected before   
                 taking any steps, then an illegal input return           
                 (istate = -3) occurs instead.)                           
             -3  means illegal input was detected, before taking any      
                 integration steps.  see written message for details.     
                 note..  if the solver detects an infinite loop of calls  
                 to the solver with illegal input, it will cause          
                 the run to stop.                                         
             -4  means there were repeated error test failures on         
                 one attempted step, before completing the requested      
                 task, but the integration was successful as far as t.    
                 the problem may have a singularity, or the input         
                 may be inappropriate.                                    
             -5  means there were repeated convergence test failures on   
                 one attempted step, before completing the requested      
                 task, but the integration was successful as far as t.    
                 this may be caused by an inaccurate jacobian matrix,     
                 if one is being used.                                    
             -6  means ewt(i) became zero for some i during the           
                 integration.  pure relative error control (atol(i)=0.0)  
                 was requested on a variable which has now vanished.      
                 the integration was successful as far as t.              
                                                                          
             note..  since the normal output value of istate is 2,        
             it does not need to be reset for normal continuation.        
             also, since a negative input value of istate will be         
             regarded as illegal, a negative output value requires the    
             user to change it, and possibly other inputs, before         
             calling the solver again.                                    
                                                                          
    iopt   = an integer flag to specify whether or not any optional       
             inputs are being used on this call.  input only.             
             the optional inputs are listed separately below.             
             iopt = 0 means no optional inputs are being used.            
                      default values will be used in all cases.           
             iopt = 1 means one or more optional inputs are being used.   
                                                                          
    rwork  = a real working array (double precision).                     
             the length of rwork must be at least                         
                20 + nyh*(maxord + 1) + 3*neq + lwm    where              
             nyh    = the initial value of neq,                           
             maxord = 12 (if meth = 1) or 5 (if meth = 2) (unless a       
                      smaller value is given as an optional input),       
             lwm   = 0             if miter = 0,                          
             lwm   = neq**2 + 2    if miter is 1 or 2,                    
             lwm   = neq + 2       if miter = 3, and                      
             lwm   = (2*ml+mu+1)*neq + 2 if miter is 4 or 5.              
             (see the mf description for meth and miter.)                 
             thus if maxord has its default value and neq is constant,    
             this length is..                                             
                20 + 16*neq                  for mf = 10,                 
                22 + 16*neq + neq**2         for mf = 11 or 12,           
                22 + 17*neq                  for mf = 13,                 
                22 + 17*neq + (2*ml+mu)*neq  for mf = 14 or 15,           
                20 +  9*neq                  for mf = 20,                 
                22 +  9*neq + neq**2         for mf = 21 or 22,           
                22 + 10*neq                  for mf = 23,                 
                22 + 10*neq + (2*ml+mu)*neq  for mf = 24 or 25.           
             the first 20 words of rwork are reserved for conditional     
             and optional inputs and optional outputs.                    
                                                                          
             the following word in rwork is a conditional input..         
               rwork(1) = tcrit = critical value of t which the solver    
                          is not to overshoot.  required if itask is      
                          4 or 5, and ignored otherwise.  (see itask.)    
                                                                          
    lrw    = the length of the array rwork, as declared by the user.      
             (this will be checked by the solver.)                        
                                                                          
    iwork  = an integer work array. the length of iwork must be at least  
                20       if miter = 0 or 3 (mf = 10, 13, 20, 23), or      
                20 + neq otherwise (mf = 11, 12, 14, 15, 21, 22, 24, 25). 
             the first few words of iwork are used for conditional and    
             optional inputs and optional outputs.                        
                                                                          
             the following 2 words in iwork are conditional inputs..      
               iwork(1) = ml     these are the lower and upper            
               iwork(2) = mu     half-bandwidths, respectively, of the    
                          banded jacobian, excluding the main diagonal.   
                          the band is defined by the matrix locations     
                          (i,j) with i-ml .le. j .le. i+mu.  ml and mu    
                          must satisfy  0 .le.  ml,mu  .le. neq-1.        
                          these are required if miter is 4 or 5, and      
                          ignored otherwise.  ml and mu may in fact be    
                          the band parameters for a matrix to which       
                          df/dy is only approximately equal.              
                                                                          
    liw    = the length of the array iwork, as declared by the user.      
             (this will be checked by the solver.)                        
                                                                          
    note..  the work arrays must not be altered between calls to lsode    
    for the same problem, except possibly for the conditional and         
    optional inputs, and except for the last 3*neq words of rwork.        
    the latter space is used for internal scratch space, and so is        
    available for use by the user outside lsode between calls, if         
    desired (but not for use by f or jac).                                
                                                                          
    jac    = the name of the user-supplied routine (miter = 1 or 4) to    
             compute the jacobian matrix, df/dy, as a function of         
             the scalar t and the vector y.  it is to have the form       
                  subroutine jac (neq, t, y, ml, mu, pd, nrowpd)          
                  dimension y(1), pd(nrowpd,1)                            
             where neq, t, y, ml, mu, and nrowpd are input and the array  
             pd is to be loaded with partial derivatives (elements of     
             the jacobian matrix) on output.  pd must be given a first    
             dimension of nrowpd.  t and y have the same meaning as in    
             subroutine f.  (in the dimension statement above, 1 is a     
             dummy dimension.. it can be replaced by any value.)          
                  in the full matrix case (miter = 1), ml and mu are      
             ignored, and the jacobian is to be loaded into pd in         
             columnwise manner, with df(i)/dy(j) loaded into pd(i,j).     
                  in the band matrix case (miter = 4), the elements       
             within the band are to be loaded into pd in columnwise       
             manner, with diagonal lines of df/dy loaded into the rows    
             of pd.  thus df(i)/dy(j) is to be loaded into pd(1 or 4) to  
             compute the jacobian matrix, df/dy, as a function of         
             the scalar t and the vector y.  it is to have the form       
                  subroutine jac (neq, t, y, ml, mu, pd, nrowpd)          
                  dimension y(1), pd(nrowpd,1)                            
             where neq, t, y, ml, mu, and nrowpd are input and the array  
             pd is to be loaded with partial derivatives (elements of     
             the jacobian matrix) on output.  pd must be given a first    
             dimension of nrowpd.  t and y have the same meaning as in    
             subroutine f.  (in the dimension statement above, 1 is a     
             dummy dimension.. it can be replaced by any value.)          
                  in the full matrix case (miter = 1), ml and mu are      
             ignored, and the jacobian is to be loaded into pd in         
             columnwise manner, with df(i)/dy(j) loaded into pd(i,j).     
                  in the band matrix case (miter = 4), the elements       
             within the band are to be loaded into pd in columnwise       
             manner, with diagonal lines of df/dy loaded into the rows    
             of pd. thus df(i)/dy(j) is to be loaded into pd(i-j+mu+1,j). 
             ml and mu are the half-bandwidth parameters (see iwork).     
             the locations in pd in the two triangular areas which        
             correspond to nonexistent matrix elements can be ignored     
             or loaded arbitrarily, as they are overwritten by lsode.     
                  jac need not provide df/dy exactly.  a crude            
             approximation (possibly with a smaller bandwidth) will do.   
                  in either case, pd is preset to zero by the solver,     
             so that only the nonzero elements need be loaded by jac.     
   i-j+mu+1,j).                                                           
             ml and mu are the half-bandwidth parameters (see iwork).     
             the locations in pd in the two triangular areas which        
             correspond to nonexistent matrix elements can be ignored     
             or loaded arbitrarily, as they are overwritten by lsode.     
                  jac need not provide df/dy exactly.  a crude            
             approximation (possibly with a smaller bandwidth) will do.   
                  in either case, pd is preset to zero by the solver,     
             so that only the nonzero elements need be loaded by jac.     
             each call to jac is preceded by a call to f with the same    
             arguments neq, t, and y.  thus to gain some efficiency,      
             intermediate quantities shared by both calculations may be   
             saved in a user common block by f and not recomputed by jac, 
             if desired.  also, jac may alter the y array, if desired.    
             jac must be declared external in the calling program.        
                  subroutine jac may access user-defined quantities in    
             neq(2),... and/or in y(neq(1)+1),... if neq is an array      
             (dimensioned in jac) and/or y has length exceeding neq(1).   
             see the descriptions of neq and y above.                     
                                                                          
    mf     = the method flag.  used only for input.  the legal values of  
             mf are 10, 11, 12, 13, 14, 15, 20, 21, 22, 23, 24, and 25.   
             mf has decimal digits meth and miter.. mf = 10*meth + miter. 
             meth indicates the basic linear multistep method..           
               meth = 1 means the implicit adams method.                  
               meth = 2 means the method based on backward                
                        differentiation formulas (bdf-s).                 
             miter indicates the corrector iteration method..             
               miter = 0 means functional iteration (no jacobian matrix   
                         is involved).                                    
               miter = 1 means chord iteration with a user-supplied       
                         full (neq by neq) jacobian.                      
               miter = 2 means chord iteration with an internally         
                         generated (difference quotient) full jacobian    
                         (using neq extra calls to f per df/dy value).    
               miter = 3 means chord iteration with an internally         
                         generated diagonal jacobian approximation.       
                         (using 1 extra call to f per df/dy evaluation).  
               miter = 4 means chord iteration with a user-supplied       
                         banded jacobian.                                 
               miter = 5 means chord iteration with an internally         
                         generated banded jacobian (using ml+mu+1 extra   
                         calls to f per df/dy evaluation).                
             if miter = 1 or 4, the user must supply a subroutine jac     
             (the name is arbitrary) as described above under jac.        
             for other values of miter, a dummy argument can be used.     
   ---------------------------------------------------------------------  
    optional inputs.                                                      
                                                                          
    the following is a list of the optional inputs provided for in the    
    call sequence.  (see also part ii.)  for each such input variable,    
    this table lists its name as used in this documentation, its          
    location in the call sequence, its meaning, and the default value.    
    the use of any of these inputs requires iopt = 1, and in that         
    case all of these inputs are examined.  a value of zero for any       
    of these optional inputs will cause the default value to be used.     
    thus to use a subset of the optional inputs, simply preload           
    locations 5 to 10 in rwork and iwork to 0.0 and 0 respectively, and   
    then set those of interest to nonzero values.                         
                                                                          
    name    location      meaning and default value                       
                                                                          
    h0      rwork(5)  the step size to be attempted on the first step.    
                      the default value is determined by the solver.      
                                                                          
    hmax    rwork(6)  the maximum absolute step size allowed.             
                      the default value is infinite.                      
                                                                          
    hmin    rwork(7)  the minimum absolute step size allowed.             
                      the default value is 0.  (this lower bound is not   
                      enforced on the final step before reaching tcrit    
                      when itask = 4 or 5.)                               
                                                                          
    maxord  iwork(5)  the maximum order to be allowed.  the default       
                      value is 12 if meth = 1, and 5 if meth = 2.         
                      if maxord exceeds the default value, it will        
                      be reduced to the default value.                    
                      if maxord is changed during the problem, it may     
                      cause the current order to be reduced.              
                                                                          
    mxstep  iwork(6)  maximum number of (internally defined) steps        
                      allowed during one call to the solver.              
                      the default value is 500.                           
                                                                          
    mxhnil  iwork(7)  maximum number of messages printed (per problem)    
                      warning that t + h = t on aon the first step.       
                      the default value is determined by the solver.      
                                                                          
    hmax    rwork(6)  the maximum absolute step size allowed.             
                      the default value is infinite.                      
                                                                          
    hmin    rwork(7)  the minimum absolute step size allowed.             
                      the default value is 0.  (this lower bound is not   
                      enforced on the final step before reaching tcrit    
                      when itask = 4 or 5.)                               
                                                                          
    maxord  iwork(5)  the maximum order to be allowed.  the default       
                      value is 12 if meth = 1, and 5 if meth = 2.         
                      if maxord exceeds the default value, it will        
                      be reduced to the default value.                    
                      if maxord is changed during the problem, it may     
                      cause the current order to be reduced.              
                                                                          
    mxstep  iwork(6)  maximum number of (internally defined) steps        
                      allowed during one call to the solver.              
                      the default value is 500.                           
                                                                          
    mxhnil  iwork(7)  maximum number of messages printed (per problem)    
                      warning that t + h = t on a step (h = step size).   
                      this must be positive to result in a non-default    
                      value.  the default value is 10.                    
   ---------------------------------------------------------------------- 
    optional outputs.                                                     
                                                                          
    as optional additional output from lsode, the variables listed        
    below are quantities related to the performance of lsode              
    which are available to the user.  these are communicated by way of    
    the work arrays, but also have internal mnemoni    names as shown.    
    except where stated otherwise, all of these outputs are defined       
    on any successful return from lsode, and on any return with           
    istate = -1, -2, -4, -5, or -6.  on an illegal input return           
    (istate = -3), they will be unchanged from their existing values      
    (if any), except possibly for tolsf, lenrw, and leniw.                
    on any error return, outputs relevant to the error will be defined,   
    as noted below.                                                       
                                                                          
    name   location      meaning                                          
                                                                          
    hu     rwork(11) the step size in t last used (successfully).         
                                                                          
    hcur   rwork(12) the step size to be attempted on the next step.      
                                                                          
    tcur   rwork(13) the current value of the independent variable        
                     which the solver has actually reached, i.e. the      
                     current internal mesh point in t.  on output, tcur   
                     will always be at least as far as the argument       
                     t, but may be farther (if interpolation was done).   
                                                                          
    tolsf  rwork(14) a tolerance scale factor, greater than 1.0,          
                     computed when a request for too much accuracy was    
                     detected (istate = -3 if detected at the start of    
                     the problem, istate = -2 otherwise).  if itol is     
                     left unaltered but rtol and atol are uniformly       
                     scaled up by a factor of tolsf for the next call,    
                     then the solver is deemed likely to succeed.         
                     (the user may also ignore tolsf and alter the        
                     tolerance parameters in any other way appropriate.)  
                                                                          
    nst    iwork(11) the number of steps taken for the problem so far.    
                                                                          
    nfe    iwork(12) the number of f evaluations for the problem so far.  
                                                                          
    nje    iwork(13) the number of jacobian evaluations (and of matrix    
                     lu decompositions) for the problem so far.           
                                                                          
    nqu    iwork(14) the method order last used (successfully).           
                                                                          
    nqcur  iwork(15) the order to be attempted on the next step.          
                                                                          
    imxer  iwork(16) the index of the component of largest magnitude in   
                     the weighted local error vector ( e(i)/ewt(i) ),     
                     on an error return with istate = -4 or -5.           
                                                                          
    lenrw  iwork(17) the length of rwork actually required.               
                     this is defined on normal returns and on an illegal  
                     input return for insufficient storage.               
                                                                          
    leniw  iwork(18) the length of iwork actually required.               
                     this is defined on normal returns and on an illegal  
                     input return for insufficient storage.               
                                                                          
    the following two arrays are segments of the rwork array which        
    may also be of interest to the user as optional outputs.              
    for each array, the table below gives its internal name,              
    its base address in rwork, and its description.                       
                                                                          
    name   base address      description                                  
                                                                          
    yh     21            the nordsieck history array, of size nyh by      
                         (nqcur + 1), where nyh is the initial value      
                         of neq.  for j = 0,1,...,nqcur, column j+1       
                         of yh contains hcur**j/factorial(j) times        
                         the j-th derivative of the interpolating         
                         polynomial currently representing the solution,  
                         evaluated at t = tcur.                           
                                                                          
    acor   lenrw-neq+1   array of size neq used for the accumulated       
                         corrections on each step, scaled on output       
                         to represent the estimated local error in y      
                         on the last step.  this is the vector e in       
                         the description of the error control.  it is     
                         defined only on a successful return from lsode.  
                                                                          
   ---------------------------------------------------------------------- 
    part ii.  other routines callable.                                    
                                                                          
    the following are optional calls which the user may make to           
    gain additional capabilities in conjunction with lsode.               
    (the routines xsetun and xsetf are designed to conform to the         
    slatec error handling package.)                                       
                                                                          
        form of call                 function                             
      call xsetun(lun)         set the logical unit number, lun, for      
                               output of messages from lsode, if          
                               the default is not desired.                
                               the default value of lun is 6.             
                                                                          
      call xsetf(mflag)        set a flag to control the printing of      
                               messages by lsode.                         
                               mflag = 0 means do not print. (danger..    
                               this risks losing valuable information.)   
                               mflag = 1 means print (the default).       
                                                                          
                               either of the above calls may be made at   
                               any time and will take effect immediately. 
                                                                          
      call srcom(rsav,isav,job)saves and restores the contents of         
                               the internal common blocks used by         
                               lsode (see part iii below).                
                               rsav must be a real array of length 218    
                               or more, and isav must be an integer       
                               array of length 41 or more.                
                               job=1 means save common into rsav/isav.    
                               job=2 means restore common from rsav/isav. 
                                  srcom is useful if one is               
                               interrupting a run and restarting          
                               later, or alternating between two or       
                               more problems solved with lsode.           
                                                                          
      call intdy(,,,,,)        provide derivatives of y, of various       
           (see below)         orders, at a specified point t, if         
                               desired.  it may be called only after      
                               a successful return from lsode.            
                                                                          
    the detailed instructions for using intdy are as follows.             
    the form of the call is..                                             
                                                                          
      call intdy (t, k, rwork(21), nyh, dky, iflag)                       
                                                                          
    the input parameters are..                                            
                                                                          
    t         = value of independent variable where answers are desired   
                (normally the same as the t last returned by lsode).      
                for valid results, t must lie between tcur - hu and tcur. 
                (see optional outputs for tcur and hu.)                   
    k         = integer order of the derivative desired.  k must satisfy  
                0 .le. k .le. nqcur, where nqcur is the current order     
                (see optional outputs).  the capability corresponding     
                to k = 0, i.e. computing y(t), is already provided        
                by lsode directly.  since nqcur .ge. 1, the first         
                derivative dy/dt is always available with intdy.          
    rwork(21) = the base address of the history array yh.                 
    nyh       = column length of yh, equal to the initial value of neq.   
                                                                          
    the output parameters are..                                           
                                                                          
    dky       = a real array of length neq containing the computed value  
                of the k-th derivative of y(t).                           
    iflag     = integer flag, returned as 0 if k and t were legal,        
                -1 if k was illegal, and -2 if t was illegal.             
                on an error return, a message is also written.            
   ---------------------------------------------------------------------- 
    part iii.  common blocks.                                             
                                                                          
    if lsode is to be used in an overlay situation, the user              
    must declare, in the primary overlay, the variables in..              
      (1) the call sequence to lsode,                                     
      (2) the two internal common blocks                                  
            /ls0001/  of length  257  (218 double precision words         
                            followed by 39 integer words),                
            /eh0001/  of length  2 (integer words).                       
                                                                          
    if lsode is used on a system in which the contents of internal        
    common blocks are not preserved between calls, the user should        
    declare the above two common blocks in his main program to insure     
    that their contents are preserved.                                    
                                                                          
    if the solution of a given problem by lsode is to be interrupted      
    and then later continued, such as when restarting an interrupted run  
    or alternating between two or more problems, the user should save,    
    following the return from the last lsode call prior to the            
    interruption, the contents of the call sequence variables and the     
    internal common blocks, and later restore these values before the     
    next lsode call for that problem.  to save and restore the common     
    blocks, use subroutine srcom (see part ii above).                     
                                                                          
   ---------------------------------------------------------------------- 
    part iv.  optionally replaceable solver routines.                     
                                                                          
    below are descriptions of two routines in the lsode package which     
    relate to the measurement of errors.  either routine can be           
    replaced by a user-supplied version, if desired.  however, since such 
    a replacement may have a major impact on performance, it should be    
    done only when absolutely necessary, and only with great caution.     
    (note.. the means by which the package version of a routine is        
    superseded by the user-s version may be system-dependent.)            
                                                                          
    (a) ewset.                                                            
    the following subroutine is called just before each internal          
    integration step, and sets the array of error weights, ewt, as        
    described under itol/rtol/atol above..                                
        subroutine ewset (neq, itol, rtol, atol, ycur, ewt)               
    where neq, itol, rtol, and atol are as in the lsode call sequence,    
    ycur contains the current dependent variable vector, and              
    ewt is the array of weights set by ewset.                             
                                                                          
    if the user supplies this subroutine, it must return in ewt(i)        
    (i = 1,...,neq) a positive quantity suitable for comparing errors     
    in y(i) to.  the ewt array returned by ewset is passed to the         
    vnorm routine (see below), and also used by lsode in the computation  
    of the optional output imxer, the diagonal jacobian approximation,    
    and the increments for difference quotient jacobians.                 
                                                                          
    in the user-supplied version of ewset, it may be desirable to use     
    the current values of derivatives of y.  derivatives up to order nq   
    are available from the history array yh, described above under        
    optional outputs.  in ewset, yh is identical to the ycur array,       
    extended to nq + 1 columns with a column length of nyh and scale      
    factors of h**j/factorial(j).  on the first call for the problem,     
    given by nst = 0, nq is 1 and h is temporarily set to 1.0.            
    the quantities nq, nyh, h, and nst can be obtained by including       
    in ewset the statements..                                             
        double precision h, rls                                           
        common /ls0001/ rls(218),ils(39)                                  
        nq = ils(35)                                                      
        nyh = ils(14)                                                     
        nst = ils(36)                                                     
        h = rls(212)                                                      
    thus, for example, the current value of dy/dt can be obtained as      
    ycur(nyh+i)/h  (i=1,...,neq)  (and the division by h is               
    unnecessary when nst = 0).                                            
                                                                          
    (b) vnorm.                                                            
    the following is a real function routine which computes the weighted  
    root-mean-square norm of a vector v..                                 
        d = vnorm (n, v, w)                                               
    where..                                                               
      n = the length of the vector,                                       
      v = real array of length n containing the vector,                   
      w = real array of length n containing weights,                      
      d = sqrt( (1/n) * sum(v(i)*w(i))**2 ).                              
    vnorm is called with n = neq and with w(i) = 1.0/ewt(i), where        
    ewt is as set by subroutine ewset.                                    
                                                                          
    if the user supplies this function, it should return a non-negative   
    value of vnorm suitable for use in the error control in lsode.        
    none of the arguments should be altered by vnorm.                     
    for example, a user-supplied vnorm routine might..                    
      -substitute a max-norm of (v(i)*w(i)) for the rms-norm, or          
      -ignore some components of v in the norm, with the effect ofthus,   
    for example, the current value of dy/dt can be obtained as            
    ycur(nyh+i)/h  (i=1,...,neq)  (and the division by h is               
    unnecessary when nst = 0).                                            
                                                                          
    (b) vnorm.                                                            
    the following is a real function routine which computes the weighted  
    root-mean-square norm of a vector v..                                 
        d = vnorm (n, v, w)                                               
    where..                                                               
      n = the length of the vector,                                       
      v = real array of length n containing the vector,                   
      w = real array of length n containing weights,                      
      d = sqrt( (1/n) * sum(v(i)*w(i))**2 ).                              
    vnorm is called with n = neq and with w(i) = 1.0/ewt(i), where        
    ewt is as set by subroutine ewset.                                    
                                                                          
    if the user supplies this function, it should return a non-negative   
    value of vnorm suitable for use in the error control in lsode.        
    none of the arguments should be altered by vnorm.                     
    for example, a user-supplied vnorm routine might..                    
      -substitute a max-norm of (v(i)*w(i)) for the rms-norm, or          
      -ignore some components of v in the norm, with the effect of        
       suppressing the error control on those components of y.            
   ---------------------------------------------------------------------- 

