#define Uses_TEvent
#define Uses_TRect
#define Uses_TListViewer
#define Uses_TWindow
#define Uses_TKeys
#define Uses_TScrollBar
#include <tv.h>

#define TPoint TT_Point
#include "freetype.h"
#include "tttypes.h"
#include "tttables.h"
#include "ttdebug.h"
#undef TPoint

#include "zonetv.h"
#include "debugger.h"

#include <malloc.h>
#include <string.h>
#include <stdio.h>


/*
 * TZoneViewer
 */

TZoneViewer::TZoneViewer( const TRect &bounds, TT_PVecRecord AZone ) :
  TListViewer( bounds, 1, NULL, NULL )
{
  int  n;

  growMode  = gfGrowHiX | gfGrowHiY;
  dragMode  = dmDragGrow | dmLimitLoX | dmLimitLoY;
  options   |= ofSelectable;
  eventMask |= evWave;

  Zone = AZone;

  Save.n = Zone->n;
  n = Save.n * sizeof(Long); // FIXME!!
  Save.org_x = (TT_PCoordinates) malloc( n );
  Save.org_y = (TT_PCoordinates) malloc( n );
  Save.cur_x = (TT_PCoordinates) malloc( n );
  Save.cur_y = (TT_PCoordinates) malloc( n );
  Save.touch = (TT_PTouchTable) malloc( Save.n );

  Copy_Zone();

  setRange( Save.n );
}


TZoneViewer::~TZoneViewer()
{
  free( Save.touch );
  free( Save.cur_y );
  free( Save.cur_x );
  free( Save.org_y );
  free( Save.org_x );
}

#define move(x,y,z) memcpy(y,x,z)
void TZoneViewer::Copy_Zone()
{
  int  n;
  n = Save.n * sizeof(Long);

  /* Note that we save also the original coordinates, as we're not sure *
   * that the debugger is debugged !                                    */

  move( Zone->org_x, Save.org_x, n );
  move( Zone->org_y, Save.org_y, n );
  move( Zone->cur_x, Save.cur_x, n );
  move( Zone->cur_y, Save.cur_y, n );
  move( Zone->touch, Save.touch, Save.n );
}
#undef move

void TZoneViewer::handleEvent( TEvent &event )
{
  TRect  Limits;
  TPoint Mini, Maxi;

  TListViewer::handleEvent(event);

  switch (event.what)
  {
  case evWave:

    switch (event.message.command) {

      case cmNewExecution: Copy_Zone(); break;

      case cmReFocus: drawView(); break;
    }
    break;

  case evCommand:

    switch (event.message.command) {

    case cmResize:
      {
	Limits = owner->getExtent();
	sizeLimits( Mini, Maxi );
	dragView(event, dragMode, Limits, Mini, Maxi );
	clearEvent(event);
	break;
      }
    }
    break;
  }
}


void TZoneViewer::draw()
{
  static const uchar Colors[4] = {0x30,0x3F,0x0B,0x0E};
  static const uchar Touchs[4] = {' ','x','y','b'};
  static const char OnOff[2] = {' ',':'};

  TDrawBuffer  B;

  int   I, J, Item;
  char  S[256];
  int   Indent;
  int   Ligne;

  int   Changed;

  unsigned Back_Color, Color;

  int         On_BP;
  PBreakPoint BP;

  Indent = hScrollBar ? hScrollBar->value : 0;

  for (I = 0; I < size.y; ++I)
  {
    B.moveChar( 0, ' ', Colors[0], size.x );

    Item = topItem + I;

    Back_Color = range > 0 && focused == Item ? 2 : 0;

    if ( Item < Save.n )
    {
      Color = Back_Color;
      if ( Save.touch[Item] != Zone->touch[Item] ) ++Color;

      sprintf( S, "%04x:  ", Item );
      S[0] = OnOff[Zone->touch[Item] & 1];
      S[6] = Touchs[(Zone->touch[Item] & TT_Flag_Touched_Both) >> 1];

      B.moveStr( 0, S, Colors[Color] );

      Color = Back_Color;
      if ( Save.org_x[Item] != Zone->org_x[Item] ) ++Color;

      sprintf( S, "%08lx", Zone->org_x[Item] );
      B.moveStr ( 8, S, Colors[Color] );
      B.moveChar( 16, ',', Colors[0], 1 );

      Color = Back_Color;
      if ( Save.org_y[Item] != Zone->org_y[Item] ) ++Color;

      sprintf( S, "%08lx", Zone->org_y[Item] );
      B.moveStr ( 17, S, Colors[Color] );
      B.moveStr( 25, " : ", Colors[0] );

      Color = Back_Color;
      if ( Save.cur_x[Item] != Zone->cur_x[Item] ) ++Color;

      sprintf( S, "%08lx", Zone->cur_x[Item] );
      B.moveStr ( 28, S, Colors[Color] );
      B.moveChar( 36, ',', Colors[0], 1 );

      Color = Back_Color;
      if ( Save.cur_y[Item] != Zone->cur_y[Item] ) ++Color;

      sprintf( S, "%08lx", Zone->cur_y[Item] );
      B.moveStr ( 37, S, Colors[Color] );
    }

    writeLine( 0, I, size.x, 1, B );
  }
}


/*
 * TZoneWindow
 */

TZoneWindow::TZoneWindow( const TRect &bounds, TT_PVecRecord AZone ) :
  TWindow( bounds, "Zone", wnNoNumber ),
  TWindowInit( &TZoneWindow::initFrame )
{
  // XXX GetClipRect( Bounds );
  TRect  Bounds = getExtent();
  Bounds.grow(-1,-1);
  ZoneView = new TZoneViewer( Bounds, AZone );
  insert( ZoneView );
}

