{=============================================================================}
{= (c) Copyright 1993, 1994, Silicon Graphics, Inc.                          =}
{= ALL RIGHTS RESERVED                                                       =}
{= Permission to use, copy, modify, and distribute this software for         =}
{= any purpose and without fee is hereby granted, provided that the above    =}
{= copyright notice appear in all copies and that both the copyright notice  =}
{= and this permission notice appear in supporting documentation, and that   =}
{= the name of Silicon Graphics, Inc. not be used in advertising             =}
{= or publicity pertaining to distribution of the software without specific, =}
{= written prior permission.                                                 =}
{=                                                                           =}
{= THE MATERIAL EMBODIED ON THIS SOFTWARE IS PROVIDED TO YOU "AS-IS"         =}
{= AND WITHOUT WARRANTY OF ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,          =}
{= INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY OR          =}
{= FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT SHALL SILICON              =}
{= GRAPHICS, INC.  BE LIABLE TO YOU OR ANYONE ELSE FOR ANY DIRECT,           =}
{= SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY             =}
{= KIND, OR ANY DAMAGES WHATSOEVER, INCLUDING WITHOUT LIMITATION,            =}
{= LOSS OF PROFIT, LOSS OF USE, SAVINGS OR REVENUE, OR THE CLAIMS OF         =}
{= THIRD PARTIES, WHETHER OR NOT SILICON GRAPHICS, INC.  HAS BEEN            =}
{= ADVISED OF THE POSSIBILITY OF SUCH LOSS, HOWEVER CAUSED AND ON            =}
{= ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE         =}
{= POSSESSION, USE OR PERFORMANCE OF THIS SOFTWARE.                          =}
{=                                                                           =}
{= US Government Users Restricted Rights                                     =}
{= Use, duplication, or disclosure by the Government is subject to           =}
{= restrictions set forth in FAR 52.227.19(c)(2) or subparagraph             =}
{= (c)(1)(ii) of the Rights in Technical Data and Computer Software          =}
{= clause at DFARS 252.227-7013 and/or in similar or successor               =}
{= clauses in the FAR or the DOD or NASA FAR Supplement.                     =}
{= Unpublished-- rights reserved under the copyright laws of the             =}
{= United States.  Contractor/manufacturer is Silicon Graphics,              =}
{= Inc., 2011 N.  Shoreline Blvd., Mountain View, CA 94039-7311.             =}
{=                                                                           =}
{= OpenGL(TM) is a trademark of Silicon Graphics, Inc.                       =}
{=============================================================================}
unit Shark;

interface

uses
    Common;

procedure   DrawShark(fish: pfishRec);

implementation

uses
    MGLTypes,
    MGLGl;

{-- INDENT OFF ---------------------------------------------------------------}

var
    N001 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    N002 : array[0..2] of float = (0.000077 ,-0.020611 ,0.999788);
    N003 : array[0..2] of float = (0.961425 ,0.258729 ,-0.093390);
    N004 : array[0..2] of float = (0.510811 ,-0.769633 ,-0.383063);
    N005 : array[0..2] of float = (0.400123 ,0.855734 ,-0.328055);
    N006 : array[0..2] of float = (-0.770715 ,0.610204 ,-0.183440);
    N007 : array[0..2] of float = (-0.915597 ,-0.373345 ,-0.149316);
    N008 : array[0..2] of float = (-0.972788 ,0.208921 ,-0.100179);
    N009 : array[0..2] of float = (-0.939713 ,-0.312268 ,-0.139383);
    N010 : array[0..2] of float = (-0.624138 ,-0.741047 ,-0.247589);
    N011 : array[0..2] of float = (0.591434 ,-0.768401 ,-0.244471);
    N012 : array[0..2] of float = (0.935152 ,-0.328495 ,-0.132598);
    N013 : array[0..2] of float = (0.997102 ,0.074243 ,-0.016593);
    N014 : array[0..2] of float = (0.969995 ,0.241712 ,-0.026186);
    N015 : array[0..2] of float = (0.844539 ,0.502628 ,-0.184714);
    N016 : array[0..2] of float = (-0.906608 ,0.386308 ,-0.169787);
    N017 : array[0..2] of float = (-0.970016 ,0.241698 ,-0.025516);
    N018 : array[0..2] of float = (-0.998652 ,0.050493 ,-0.012045);
    N019 : array[0..2] of float = (-0.942685 ,-0.333051 ,-0.020556);
    N020 : array[0..2] of float = (-0.660944 ,-0.750276 ,0.015480);
    N021 : array[0..2] of float = (0.503549 ,-0.862908 ,-0.042749);
    N022 : array[0..2] of float = (0.953202 ,-0.302092 ,-0.012089);
    N023 : array[0..2] of float = (0.998738 ,0.023574 ,0.044344);
    N024 : array[0..2] of float = (0.979297 ,0.193272 ,0.060202);
    N025 : array[0..2] of float = (0.798300 ,0.464885 ,0.382883);
    N026 : array[0..2] of float = (-0.756590 ,0.452403 ,0.472126);
    N027 : array[0..2] of float = (-0.953855 ,0.293003 ,0.065651);
    N028 : array[0..2] of float = (-0.998033 ,0.040292 ,0.048028);
    N029 : array[0..2] of float = (-0.977079 ,-0.204288 ,0.059858);
    N030 : array[0..2] of float = (-0.729117 ,-0.675304 ,0.111140);
    N031 : array[0..2] of float = (0.598361 ,-0.792753 ,0.116221);
    N032 : array[0..2] of float = (0.965192 ,-0.252991 ,0.066332);
    N033 : array[0..2] of float = (0.998201 ,-0.002790 ,0.059892);
    N034 : array[0..2] of float = (0.978657 ,0.193135 ,0.070207);
    N035 : array[0..2] of float = (0.718815 ,0.680392 ,0.142733);
    N036 : array[0..2] of float = (-0.383096 ,0.906212 ,0.178936);
    N037 : array[0..2] of float = (-0.952831 ,0.292590 ,0.080647);
    N038 : array[0..2] of float = (-0.997680 ,0.032417 ,0.059861);
    N039 : array[0..2] of float = (-0.982629 ,-0.169881 ,0.074700);
    N040 : array[0..2] of float = (-0.695424 ,-0.703466 ,0.146700);
    N041 : array[0..2] of float = (0.359323 ,-0.915531 ,0.180805);
    N042 : array[0..2] of float = (0.943356 ,-0.319387 ,0.089842);
    N043 : array[0..2] of float = (0.998272 ,-0.032435 ,0.048993);
    N044 : array[0..2] of float = (0.978997 ,0.193205 ,0.065084);
    N045 : array[0..2] of float = (0.872144 ,0.470094 ,-0.135565);
    N046 : array[0..2] of float = (-0.664282 ,0.737945 ,-0.119027);
    N047 : array[0..2] of float = (-0.954508 ,0.288570 ,0.075107);
    N048 : array[0..2] of float = (-0.998273 ,0.032406 ,0.048993);
    N049 : array[0..2] of float = (-0.979908 ,-0.193579 ,0.048038);
    N050 : array[0..2] of float = (-0.858736 ,-0.507202 ,-0.072938);
    N051 : array[0..2] of float = (0.643545 ,-0.763887 ,-0.048237);
    N052 : array[0..2] of float = (0.955580 ,-0.288954 ,0.058068);
    N053 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    N054 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    N055 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    N056 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    N057 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    N058 : array[0..2] of float = (0.000050 ,0.793007 ,-0.609213);
    N059 : array[0..2] of float = (0.913510 ,0.235418 ,-0.331779);
    N060 : array[0..2] of float = (-0.807970 ,0.495000 ,-0.319625);
    N061 : array[0..2] of float = (0.000000 ,0.784687 ,-0.619892);
    N062 : array[0..2] of float = (0.000000 ,-1.000000 ,0.000000);
    N063 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    N064 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    N065 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    N066 : array[0..2] of float = (-0.055784 ,0.257059 ,0.964784);
    N067 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    N068 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    N069 : array[0..2] of float = (-0.000505 ,-0.929775 ,-0.368127);
    N070 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    N071 : array[0..2] of float = (-0.987102 ,0.131723 ,-0.090984);
    N072 : array[0..2] of float = (-0.987102 ,0.131723 ,-0.090984);
    N073 : array[0..2] of float = (-0.987102 ,0.131723 ,-0.090984);
    N074 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    N075 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    N076 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    N077 : array[0..2] of float = (0.995210 ,0.071962 ,-0.066168);
    N078 : array[0..2] of float = (0.995210 ,0.071962 ,-0.066168);
    N079 : array[0..2] of float = (0.995210 ,0.071962 ,-0.066168);
    N080 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    N081 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    N082 : array[0..2] of float = (0.000000 ,1.000000 ,0.000000);
    P001 : array[0..2] of float = (0.00, 0.00, 0.00);
    P002 : array[0..2] of float = (0.00, -36.59, 5687.72);
    P003 : array[0..2] of float = (90.00, 114.73, 724.38);
    P004 : array[0..2] of float = (58.24, -146.84, 262.35);
    P005 : array[0..2] of float = (27.81, 231.52, 510.43);
    P006 : array[0..2] of float = (-27.81, 230.43, 509.76);
    P007 : array[0..2] of float = (-46.09, -146.83, 265.84);
    P008 : array[0..2] of float = (-90.00, 103.84, 718.53);
    P009 : array[0..2] of float = (-131.10, -165.92, 834.85);
    P010 : array[0..2] of float = (-27.81, -285.31, 500.00);
    P011 : array[0..2] of float = (27.81, -285.32, 500.00);
    P012 : array[0..2] of float = (147.96, -170.89, 845.50);
    P013 : array[0..2] of float = (180.00, 0.00, 2000.00);
    P014 : array[0..2] of float = (145.62, 352.67, 2000.00);
    P015 : array[0..2] of float = (55.62, 570.63, 2000.00);
    P016 : array[0..2] of float = (-55.62, 570.64, 2000.00);
    P017 : array[0..2] of float = (-145.62, 352.68, 2000.00);
    P018 : array[0..2] of float = (-180.00, 0.01, 2000.00);
    P019 : array[0..2] of float = (-178.20, -352.66, 2001.61);
    P020 : array[0..2] of float = (-55.63, -570.63, 2000.00);
    P021 : array[0..2] of float = (55.62, -570.64, 2000.00);
    P022 : array[0..2] of float = (179.91, -352.69, 1998.39);
    P023 : array[0..2] of float = (150.00, 0.00, 3000.00);
    P024 : array[0..2] of float = (121.35, 293.89, 3000.00);
    P025 : array[0..2] of float = (46.35, 502.93, 2883.09);
    P026 : array[0..2] of float = (-46.35, 497.45, 2877.24);
    P027 : array[0..2] of float = (-121.35, 293.90, 3000.00);
    P028 : array[0..2] of float = (-150.00, 0.00, 3000.00);
    P029 : array[0..2] of float = (-152.21, -304.84, 2858.68);
    P030 : array[0..2] of float = (-46.36, -475.52, 3000.00);
    P031 : array[0..2] of float = (46.35, -475.53, 3000.00);
    P032 : array[0..2] of float = (155.64, -304.87, 2863.50);
    P033 : array[0..2] of float = (90.00, 0.00, 4000.00);
    P034 : array[0..2] of float = (72.81, 176.33, 4000.00);
    P035 : array[0..2] of float = (27.81, 285.32, 4000.00);
    P036 : array[0..2] of float = (-27.81, 285.32, 4000.00);
    P037 : array[0..2] of float = (-72.81, 176.34, 4000.00);
    P038 : array[0..2] of float = (-90.00, 0.00, 4000.00);
    P039 : array[0..2] of float = (-72.81, -176.33, 4000.00);
    P040 : array[0..2] of float = (-27.81, -285.31, 4000.00);
    P041 : array[0..2] of float = (27.81, -285.32, 4000.00);
    P042 : array[0..2] of float = (72.81, -176.34, 4000.00);
    P043 : array[0..2] of float = (30.00, 0.00, 5000.00);
    P044 : array[0..2] of float = (24.27, 58.78, 5000.00);
    P045 : array[0..2] of float = (9.27, 95.11, 5000.00);
    P046 : array[0..2] of float = (-9.27, 95.11, 5000.00);
    P047 : array[0..2] of float = (-24.27, 58.78, 5000.00);
    P048 : array[0..2] of float = (-30.00, 0.00, 5000.00);
    P049 : array[0..2] of float = (-24.27, -58.78, 5000.00);
    P050 : array[0..2] of float = (-9.27, -95.10, 5000.00);
    P051 : array[0..2] of float = (9.27, -95.11, 5000.00);
    P052 : array[0..2] of float = (24.27, -58.78, 5000.00);
    P053 : array[0..2] of float = (0.00, 0.00, 0.00);
    P054 : array[0..2] of float = (0.00, 0.00, 0.00);
    P055 : array[0..2] of float = (0.00, 0.00, 0.00);
    P056 : array[0..2] of float = (0.00, 0.00, 0.00);
    P057 : array[0..2] of float = (0.00, 0.00, 0.00);
    P058 : array[0..2] of float = (0.00, 1212.72, 2703.08);
    P059 : array[0..2] of float = (50.36, 0.00, 108.14);
    P060 : array[0..2] of float = (-22.18, 0.00, 108.14);
    P061 : array[0..2] of float = (0.00, 1181.61, 6344.65);
    P062 : array[0..2] of float = (516.45, -887.08, 2535.45);
    P063 : array[0..2] of float = (-545.69, -879.31, 2555.63);
    P064 : array[0..2] of float = (618.89, -1005.64, 2988.32);
    P065 : array[0..2] of float = (-635.37, -1014.79, 2938.68);
    P066 : array[0..2] of float = (0.00, 1374.43, 3064.18);
    P067 : array[0..2] of float = (158.49, -11.89, 1401.56);
    P068 : array[0..2] of float = (-132.08, -17.90, 1394.31);
    P069 : array[0..2] of float = (0.00, -418.25, 5765.04);
    P070 : array[0..2] of float = (0.00, 1266.91, 6629.60);
    P071 : array[0..2] of float = (-139.12, -124.96, 997.98);
    P072 : array[0..2] of float = (-139.24, -110.18, 1020.68);
    P073 : array[0..2] of float = (-137.33, -94.52, 1022.63);
    P074 : array[0..2] of float = (-137.03, -79.91, 996.89);
    P075 : array[0..2] of float = (-135.21, -91.48, 969.14);
    P076 : array[0..2] of float = (-135.39, -110.87, 968.76);
    P077 : array[0..2] of float = (150.23, -78.44, 995.53);
    P078 : array[0..2] of float = (152.79, -92.76, 1018.46);
    P079 : array[0..2] of float = (154.19, -110.20, 1020.55);
    P080 : array[0..2] of float = (151.33, -124.15, 993.77);
    P081 : array[0..2] of float = (150.49, -111.19, 969.86);
    P082 : array[0..2] of float = (150.79, -92.41, 969.70);
    iP002 : array[0..2] of float = (0.00, -36.59, 5687.72);
    iP004 : array[0..2] of float = (58.24, -146.84, 262.35);
    iP007 : array[0..2] of float = (-46.09, -146.83, 265.84);
    iP010 : array[0..2] of float = (-27.81, -285.31, 500.00);
    iP011 : array[0..2] of float = (27.81, -285.32, 500.00);
    iP023 : array[0..2] of float = (150.00, 0.00, 3000.00);
    iP024 : array[0..2] of float = (121.35, 293.89, 3000.00);
    iP025 : array[0..2] of float = (46.35, 502.93, 2883.09);
    iP026 : array[0..2] of float = (-46.35, 497.45, 2877.24);
    iP027 : array[0..2] of float = (-121.35, 293.90, 3000.00);
    iP028 : array[0..2] of float = (-150.00, 0.00, 3000.00);
    iP029 : array[0..2] of float = (-121.35, -304.84, 2853.86);
    iP030 : array[0..2] of float = (-46.36, -475.52, 3000.00);
    iP031 : array[0..2] of float = (46.35, -475.53, 3000.00);
    iP032 : array[0..2] of float = (121.35, -304.87, 2853.86);
    iP033 : array[0..2] of float = (90.00, 0.00, 4000.00);
    iP034 : array[0..2] of float = (72.81, 176.33, 4000.00);
    iP035 : array[0..2] of float = (27.81, 285.32, 4000.00);
    iP036 : array[0..2] of float = (-27.81, 285.32, 4000.00);
    iP037 : array[0..2] of float = (-72.81, 176.34, 4000.00);
    iP038 : array[0..2] of float = (-90.00, 0.00, 4000.00);
    iP039 : array[0..2] of float = (-72.81, -176.33, 4000.00);
    iP040 : array[0..2] of float = (-27.81, -285.31, 4000.00);
    iP041 : array[0..2] of float = (27.81, -285.32, 4000.00);
    iP042 : array[0..2] of float = (72.81, -176.34, 4000.00);
    iP043 : array[0..2] of float = (30.00, 0.00, 5000.00);
    iP044 : array[0..2] of float = (24.27, 58.78, 5000.00);
    iP045 : array[0..2] of float = (9.27, 95.11, 5000.00);
    iP046 : array[0..2] of float = (-9.27, 95.11, 5000.00);
    iP047 : array[0..2] of float = (-24.27, 58.78, 5000.00);
    iP048 : array[0..2] of float = (-30.00, 0.00, 5000.00);
    iP049 : array[0..2] of float = (-24.27, -58.78, 5000.00);
    iP050 : array[0..2] of float = (-9.27, -95.10, 5000.00);
    iP051 : array[0..2] of float = (9.27, -95.11, 5000.00);
    iP052 : array[0..2] of float = (24.27, -58.78, 5000.00);
    iP053 : array[0..2] of float = (0.00, 0.00, 0.00);
    iP061 : array[0..2] of float = (0.00, 1181.61, 6344.65);
    iP069 : array[0..2] of float = (0.00, -418.25, 5765.04);
    iP070 : array[0..2] of float = (0.00, 1266.91, 6629.60);

procedure   Fish001;
begin
    glBegin(GL_POLYGON);
    glNormal3fv(@N005);
    glVertex3fv(@P005);
    glNormal3fv(@N059);
    glVertex3fv(@P059);
    glNormal3fv(@N060);
    glVertex3fv(@P060);
    glNormal3fv(@N006);
    glVertex3fv(@P006);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N015);
    glVertex3fv(@P015);
    glNormal3fv(@N005);
    glVertex3fv(@P005);
    glNormal3fv(@N006);
    glVertex3fv(@P006);
    glNormal3fv(@N016);
    glVertex3fv(@P016);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N006);
    glVertex3fv(@P006);
    glNormal3fv(@N060);
    glVertex3fv(@P060);
    glNormal3fv(@N008);
    glVertex3fv(@P008);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N016);
    glVertex3fv(@P016);
    glNormal3fv(@N006);
    glVertex3fv(@P006);
    glNormal3fv(@N008);
    glVertex3fv(@P008);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N016);
    glVertex3fv(@P016);
    glNormal3fv(@N008);
    glVertex3fv(@P008);
    glNormal3fv(@N017);
    glVertex3fv(@P017);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N017);
    glVertex3fv(@P017);
    glNormal3fv(@N008);
    glVertex3fv(@P008);
    glNormal3fv(@N018);
    glVertex3fv(@P018);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N008);
    glVertex3fv(@P008);
    glNormal3fv(@N009);
    glVertex3fv(@P009);
    glNormal3fv(@N018);
    glVertex3fv(@P018);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N008);
    glVertex3fv(@P008);
    glNormal3fv(@N060);
    glVertex3fv(@P060);
    glNormal3fv(@N009);
    glVertex3fv(@P009);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N007);
    glVertex3fv(@P007);
    glNormal3fv(@N010);
    glVertex3fv(@P010);
    glNormal3fv(@N009);
    glVertex3fv(@P009);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N009);
    glVertex3fv(@P009);
    glNormal3fv(@N019);
    glVertex3fv(@P019);
    glNormal3fv(@N018);
    glVertex3fv(@P018);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N009);
    glVertex3fv(@P009);
    glNormal3fv(@N010);
    glVertex3fv(@P010);
    glNormal3fv(@N019);
    glVertex3fv(@P019);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N010);
    glVertex3fv(@P010);
    glNormal3fv(@N020);
    glVertex3fv(@P020);
    glNormal3fv(@N019);
    glVertex3fv(@P019);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N010);
    glVertex3fv(@P010);
    glNormal3fv(@N011);
    glVertex3fv(@P011);
    glNormal3fv(@N021);
    glVertex3fv(@P021);
    glNormal3fv(@N020);
    glVertex3fv(@P020);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N004);
    glVertex3fv(@P004);
    glNormal3fv(@N011);
    glVertex3fv(@P011);
    glNormal3fv(@N010);
    glVertex3fv(@P010);
    glNormal3fv(@N007);
    glVertex3fv(@P007);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N004);
    glVertex3fv(@P004);
    glNormal3fv(@N012);
    glVertex3fv(@P012);
    glNormal3fv(@N011);
    glVertex3fv(@P011);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N012);
    glVertex3fv(@P012);
    glNormal3fv(@N022);
    glVertex3fv(@P022);
    glNormal3fv(@N011);
    glVertex3fv(@P011);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N011);
    glVertex3fv(@P011);
    glNormal3fv(@N022);
    glVertex3fv(@P022);
    glNormal3fv(@N021);
    glVertex3fv(@P021);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N059);
    glVertex3fv(@P059);
    glNormal3fv(@N005);
    glVertex3fv(@P005);
    glNormal3fv(@N015);
    glVertex3fv(@P015);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N015);
    glVertex3fv(@P015);
    glNormal3fv(@N014);
    glVertex3fv(@P014);
    glNormal3fv(@N003);
    glVertex3fv(@P003);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N015);
    glVertex3fv(@P015);
    glNormal3fv(@N003);
    glVertex3fv(@P003);
    glNormal3fv(@N059);
    glVertex3fv(@P059);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N014);
    glVertex3fv(@P014);
    glNormal3fv(@N013);
    glVertex3fv(@P013);
    glNormal3fv(@N003);
    glVertex3fv(@P003);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N003);
    glVertex3fv(@P003);
    glNormal3fv(@N012);
    glVertex3fv(@P012);
    glNormal3fv(@N059);
    glVertex3fv(@P059);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N013);
    glVertex3fv(@P013);
    glNormal3fv(@N012);
    glVertex3fv(@P012);
    glNormal3fv(@N003);
    glVertex3fv(@P003);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N013);
    glVertex3fv(@P013);
    glNormal3fv(@N022);
    glVertex3fv(@P022);
    glNormal3fv(@N012);
    glVertex3fv(@P012);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(@P071);
    glVertex3fv(@P072);
    glVertex3fv(@P073);
    glVertex3fv(@P074);
    glVertex3fv(@P075);
    glVertex3fv(@P076);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(@P077);
    glVertex3fv(@P078);
    glVertex3fv(@P079);
    glVertex3fv(@P080);
    glVertex3fv(@P081);
    glVertex3fv(@P082);
    glEnd();
end;

procedure   Fish002;
begin
    glBegin(GL_POLYGON);
    glNormal3fv(@N013);
    glVertex3fv(@P013);
    glNormal3fv(@N014);
    glVertex3fv(@P014);
    glNormal3fv(@N024);
    glVertex3fv(@P024);
    glNormal3fv(@N023);
    glVertex3fv(@P023);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N014);
    glVertex3fv(@P014);
    glNormal3fv(@N015);
    glVertex3fv(@P015);
    glNormal3fv(@N025);
    glVertex3fv(@P025);
    glNormal3fv(@N024);
    glVertex3fv(@P024);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N016);
    glVertex3fv(@P016);
    glNormal3fv(@N017);
    glVertex3fv(@P017);
    glNormal3fv(@N027);
    glVertex3fv(@P027);
    glNormal3fv(@N026);
    glVertex3fv(@P026);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N017);
    glVertex3fv(@P017);
    glNormal3fv(@N018);
    glVertex3fv(@P018);
    glNormal3fv(@N028);
    glVertex3fv(@P028);
    glNormal3fv(@N027);
    glVertex3fv(@P027);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N020);
    glVertex3fv(@P020);
    glNormal3fv(@N021);
    glVertex3fv(@P021);
    glNormal3fv(@N031);
    glVertex3fv(@P031);
    glNormal3fv(@N030);
    glVertex3fv(@P030);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N013);
    glVertex3fv(@P013);
    glNormal3fv(@N023);
    glVertex3fv(@P023);
    glNormal3fv(@N022);
    glVertex3fv(@P022);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N022);
    glVertex3fv(@P022);
    glNormal3fv(@N023);
    glVertex3fv(@P023);
    glNormal3fv(@N032);
    glVertex3fv(@P032);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N022);
    glVertex3fv(@P022);
    glNormal3fv(@N032);
    glVertex3fv(@P032);
    glNormal3fv(@N031);
    glVertex3fv(@P031);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N022);
    glVertex3fv(@P022);
    glNormal3fv(@N031);
    glVertex3fv(@P031);
    glNormal3fv(@N021);
    glVertex3fv(@P021);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N018);
    glVertex3fv(@P018);
    glNormal3fv(@N019);
    glVertex3fv(@P019);
    glNormal3fv(@N029);
    glVertex3fv(@P029);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N018);
    glVertex3fv(@P018);
    glNormal3fv(@N029);
    glVertex3fv(@P029);
    glNormal3fv(@N028);
    glVertex3fv(@P028);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N019);
    glVertex3fv(@P019);
    glNormal3fv(@N020);
    glVertex3fv(@P020);
    glNormal3fv(@N030);
    glVertex3fv(@P030);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N019);
    glVertex3fv(@P019);
    glNormal3fv(@N030);
    glVertex3fv(@P030);
    glNormal3fv(@N029);
    glVertex3fv(@P029);
    glEnd();
end;

procedure   Fish003;
begin
    glBegin(GL_POLYGON);
    glNormal3fv(@N032);
    glVertex3fv(@P032);
    glNormal3fv(@N023);
    glVertex3fv(@P023);
    glNormal3fv(@N033);
    glVertex3fv(@P033);
    glNormal3fv(@N042);
    glVertex3fv(@P042);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N031);
    glVertex3fv(@P031);
    glNormal3fv(@N032);
    glVertex3fv(@P032);
    glNormal3fv(@N042);
    glVertex3fv(@P042);
    glNormal3fv(@N041);
    glVertex3fv(@P041);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N023);
    glVertex3fv(@P023);
    glNormal3fv(@N024);
    glVertex3fv(@P024);
    glNormal3fv(@N034);
    glVertex3fv(@P034);
    glNormal3fv(@N033);
    glVertex3fv(@P033);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N024);
    glVertex3fv(@P024);
    glNormal3fv(@N025);
    glVertex3fv(@P025);
    glNormal3fv(@N035);
    glVertex3fv(@P035);
    glNormal3fv(@N034);
    glVertex3fv(@P034);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N030);
    glVertex3fv(@P030);
    glNormal3fv(@N031);
    glVertex3fv(@P031);
    glNormal3fv(@N041);
    glVertex3fv(@P041);
    glNormal3fv(@N040);
    glVertex3fv(@P040);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N025);
    glVertex3fv(@P025);
    glNormal3fv(@N026);
    glVertex3fv(@P026);
    glNormal3fv(@N036);
    glVertex3fv(@P036);
    glNormal3fv(@N035);
    glVertex3fv(@P035);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N026);
    glVertex3fv(@P026);
    glNormal3fv(@N027);
    glVertex3fv(@P027);
    glNormal3fv(@N037);
    glVertex3fv(@P037);
    glNormal3fv(@N036);
    glVertex3fv(@P036);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N027);
    glVertex3fv(@P027);
    glNormal3fv(@N028);
    glVertex3fv(@P028);
    glNormal3fv(@N038);
    glVertex3fv(@P038);
    glNormal3fv(@N037);
    glVertex3fv(@P037);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N028);
    glVertex3fv(@P028);
    glNormal3fv(@N029);
    glVertex3fv(@P029);
    glNormal3fv(@N039);
    glVertex3fv(@P039);
    glNormal3fv(@N038);
    glVertex3fv(@P038);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N029);
    glVertex3fv(@P029);
    glNormal3fv(@N030);
    glVertex3fv(@P030);
    glNormal3fv(@N040);
    glVertex3fv(@P040);
    glNormal3fv(@N039);
    glVertex3fv(@P039);
    glEnd();
end;

procedure   Fish004;
begin
    glBegin(GL_POLYGON);
    glNormal3fv(@N040);
    glVertex3fv(@P040);
    glNormal3fv(@N041);
    glVertex3fv(@P041);
    glNormal3fv(@N051);
    glVertex3fv(@P051);
    glNormal3fv(@N050);
    glVertex3fv(@P050);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N041);
    glVertex3fv(@P041);
    glNormal3fv(@N042);
    glVertex3fv(@P042);
    glNormal3fv(@N052);
    glVertex3fv(@P052);
    glNormal3fv(@N051);
    glVertex3fv(@P051);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N042);
    glVertex3fv(@P042);
    glNormal3fv(@N033);
    glVertex3fv(@P033);
    glNormal3fv(@N043);
    glVertex3fv(@P043);
    glNormal3fv(@N052);
    glVertex3fv(@P052);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N033);
    glVertex3fv(@P033);
    glNormal3fv(@N034);
    glVertex3fv(@P034);
    glNormal3fv(@N044);
    glVertex3fv(@P044);
    glNormal3fv(@N043);
    glVertex3fv(@P043);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N034);
    glVertex3fv(@P034);
    glNormal3fv(@N035);
    glVertex3fv(@P035);
    glNormal3fv(@N045);
    glVertex3fv(@P045);
    glNormal3fv(@N044);
    glVertex3fv(@P044);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N035);
    glVertex3fv(@P035);
    glNormal3fv(@N036);
    glVertex3fv(@P036);
    glNormal3fv(@N046);
    glVertex3fv(@P046);
    glNormal3fv(@N045);
    glVertex3fv(@P045);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N036);
    glVertex3fv(@P036);
    glNormal3fv(@N037);
    glVertex3fv(@P037);
    glNormal3fv(@N047);
    glVertex3fv(@P047);
    glNormal3fv(@N046);
    glVertex3fv(@P046);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N037);
    glVertex3fv(@P037);
    glNormal3fv(@N038);
    glVertex3fv(@P038);
    glNormal3fv(@N048);
    glVertex3fv(@P048);
    glNormal3fv(@N047);
    glVertex3fv(@P047);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N038);
    glVertex3fv(@P038);
    glNormal3fv(@N039);
    glVertex3fv(@P039);
    glNormal3fv(@N049);
    glVertex3fv(@P049);
    glNormal3fv(@N048);
    glVertex3fv(@P048);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N039);
    glVertex3fv(@P039);
    glNormal3fv(@N040);
    glVertex3fv(@P040);
    glNormal3fv(@N050);
    glVertex3fv(@P050);
    glNormal3fv(@N049);
    glVertex3fv(@P049);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N070);
    glVertex3fv(@P070);
    glNormal3fv(@N061);
    glVertex3fv(@P061);
    glNormal3fv(@N002);
    glVertex3fv(@P002);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N061);
    glVertex3fv(@P061);
    glNormal3fv(@N046);
    glVertex3fv(@P046);
    glNormal3fv(@N002);
    glVertex3fv(@P002);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N045);
    glVertex3fv(@P045);
    glNormal3fv(@N046);
    glVertex3fv(@P046);
    glNormal3fv(@N061);
    glVertex3fv(@P061);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N002);
    glVertex3fv(@P002);
    glNormal3fv(@N061);
    glVertex3fv(@P061);
    glNormal3fv(@N070);
    glVertex3fv(@P070);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N002);
    glVertex3fv(@P002);
    glNormal3fv(@N045);
    glVertex3fv(@P045);
    glNormal3fv(@N061);
    glVertex3fv(@P061);
    glEnd();
end;

procedure   Fish005;
begin
    glBegin(GL_POLYGON);
    glNormal3fv(@N002);
    glVertex3fv(@P002);
    glNormal3fv(@N044);
    glVertex3fv(@P044);
    glNormal3fv(@N045);
    glVertex3fv(@P045);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N002);
    glVertex3fv(@P002);
    glNormal3fv(@N043);
    glVertex3fv(@P043);
    glNormal3fv(@N044);
    glVertex3fv(@P044);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N002);
    glVertex3fv(@P002);
    glNormal3fv(@N052);
    glVertex3fv(@P052);
    glNormal3fv(@N043);
    glVertex3fv(@P043);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N002);
    glVertex3fv(@P002);
    glNormal3fv(@N051);
    glVertex3fv(@P051);
    glNormal3fv(@N052);
    glVertex3fv(@P052);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N002);
    glVertex3fv(@P002);
    glNormal3fv(@N046);
    glVertex3fv(@P046);
    glNormal3fv(@N047);
    glVertex3fv(@P047);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N002);
    glVertex3fv(@P002);
    glNormal3fv(@N047);
    glVertex3fv(@P047);
    glNormal3fv(@N048);
    glVertex3fv(@P048);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N002);
    glVertex3fv(@P002);
    glNormal3fv(@N048);
    glVertex3fv(@P048);
    glNormal3fv(@N049);
    glVertex3fv(@P049);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N002);
    glVertex3fv(@P002);
    glNormal3fv(@N049);
    glVertex3fv(@P049);
    glNormal3fv(@N050);
    glVertex3fv(@P050);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N050);
    glVertex3fv(@P050);
    glNormal3fv(@N051);
    glVertex3fv(@P051);
    glNormal3fv(@N069);
    glVertex3fv(@P069);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N051);
    glVertex3fv(@P051);
    glNormal3fv(@N002);
    glVertex3fv(@P002);
    glNormal3fv(@N069);
    glVertex3fv(@P069);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N050);
    glVertex3fv(@P050);
    glNormal3fv(@N069);
    glVertex3fv(@P069);
    glNormal3fv(@N002);
    glVertex3fv(@P002);
    glEnd();
end;

procedure   Fish006;
begin
    glBegin(GL_POLYGON);
    glNormal3fv(@N066);
    glVertex3fv(@P066);
    glNormal3fv(@N016);
    glVertex3fv(@P016);
    glNormal3fv(@N026);
    glVertex3fv(@P026);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N015);
    glVertex3fv(@P015);
    glNormal3fv(@N066);
    glVertex3fv(@P066);
    glNormal3fv(@N025);
    glVertex3fv(@P025);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N025);
    glVertex3fv(@P025);
    glNormal3fv(@N066);
    glVertex3fv(@P066);
    glNormal3fv(@N026);
    glVertex3fv(@P026);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N066);
    glVertex3fv(@P066);
    glNormal3fv(@N058);
    glVertex3fv(@P058);
    glNormal3fv(@N016);
    glVertex3fv(@P016);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N015);
    glVertex3fv(@P015);
    glNormal3fv(@N058);
    glVertex3fv(@P058);
    glNormal3fv(@N066);
    glVertex3fv(@P066);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N058);
    glVertex3fv(@P058);
    glNormal3fv(@N015);
    glVertex3fv(@P015);
    glNormal3fv(@N016);
    glVertex3fv(@P016);
    glEnd();
end;

procedure   Fish007;
begin
    glBegin(GL_POLYGON);
    glNormal3fv(@N062);
    glVertex3fv(@P062);
    glNormal3fv(@N022);
    glVertex3fv(@P022);
    glNormal3fv(@N032);
    glVertex3fv(@P032);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N062);
    glVertex3fv(@P062);
    glNormal3fv(@N032);
    glVertex3fv(@P032);
    glNormal3fv(@N064);
    glVertex3fv(@P064);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N022);
    glVertex3fv(@P022);
    glNormal3fv(@N062);
    glVertex3fv(@P062);
    glNormal3fv(@N032);
    glVertex3fv(@P032);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N062);
    glVertex3fv(@P062);
    glNormal3fv(@N064);
    glVertex3fv(@P064);
    glNormal3fv(@N032);
    glVertex3fv(@P032);
    glEnd();
end;

procedure   Fish008;
begin
    glBegin(GL_POLYGON);
    glNormal3fv(@N063);
    glVertex3fv(@P063);
    glNormal3fv(@N019);
    glVertex3fv(@P019);
    glNormal3fv(@N029);
    glVertex3fv(@P029);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N019);
    glVertex3fv(@P019);
    glNormal3fv(@N063);
    glVertex3fv(@P063);
    glNormal3fv(@N029);
    glVertex3fv(@P029);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N063);
    glVertex3fv(@P063);
    glNormal3fv(@N029);
    glVertex3fv(@P029);
    glNormal3fv(@N065);
    glVertex3fv(@P065);
    glEnd();
    glBegin(GL_POLYGON);
    glNormal3fv(@N063);
    glVertex3fv(@P063);
    glNormal3fv(@N065);
    glVertex3fv(@P065);
    glNormal3fv(@N029);
    glVertex3fv(@P029);
    glEnd();
end;

procedure   Fish009;
begin
    glBegin(GL_POLYGON);
    glVertex3fv(@P059);
    glVertex3fv(@P012);
    glVertex3fv(@P009);
    glVertex3fv(@P060);
    glEnd();
    glBegin(GL_POLYGON);
    glVertex3fv(@P012);
    glVertex3fv(@P004);
    glVertex3fv(@P007);
    glVertex3fv(@P009);
    glEnd();
end;

procedure   Fish_1;
begin
    Fish004();
    Fish005();
    Fish003();
    Fish007();
    Fish006();
    Fish002();
    Fish008();
    Fish009();
    Fish001();
end;

procedure   Fish_2;
begin
    Fish005();
    Fish004();
    Fish003();
    Fish008();
    Fish006();
    Fish002();
    Fish007();
    Fish009();
    Fish001();
end;

procedure   Fish_3;
begin
    Fish005();
    Fish004();
    Fish007();
    Fish003();
    Fish002();
    Fish008();
    Fish009();
    Fish001();
    Fish006();
end;

procedure   Fish_4;
begin
    Fish005();
    Fish004();
    Fish008();
    Fish003();
    Fish002();
    Fish007();
    Fish009();
    Fish001();
    Fish006();
end;

procedure   Fish_5;
begin
    Fish009();
    Fish006();
    Fish007();
    Fish001();
    Fish002();
    Fish003();
    Fish008();
    Fish004();
    Fish005();
end;

procedure   Fish_6;
begin
    Fish009();
    Fish006();
    Fish008();
    Fish001();
    Fish002();
    Fish007();
    Fish003();
    Fish004();
    Fish005();
end;

procedure   Fish_7;
begin
    Fish009();
    Fish001();
    Fish007();
    Fish005();
    Fish002();
    Fish008();
    Fish003();
    Fish004();
    Fish006();
end;

procedure   Fish_8;
begin
    Fish009();
    Fish008();
    Fish001();
    Fish002();
    Fish007();
    Fish003();
    Fish005();
    Fish004();
    Fish006();
end;

procedure   DrawShark(fish: pfishRec);
var
    mat         : array[0..3,0..3] of float;
    n           : int;
    seg1, seg2,
    seg3, seg4,
    segup       : float;
    thrash,
    chomp       : float;
begin
    fish.htail  := Trunc(fish.htail - Trunc(5.0 * fish.v)) mod 360;

    thrash      := 50.0 * fish.v;

    seg1        := 0.6 * thrash * sin(fish.htail * RRAD);
    seg2        := 1.8 * thrash * sin((fish.htail + 45.0) * RRAD);
    seg3        := 3.0 * thrash * sin((fish.htail + 90.0) * RRAD);
    seg4        := 4.0 * thrash * sin((fish.htail + 110.0) * RRAD);

    chomp       := 0.0;
    if fish.v > 2.0 then
        chomp := -(fish.v - 2.0) * 200.0;

    P004[1] := iP004[1] + chomp;
    P007[1] := iP007[1] + chomp;
    P010[1] := iP010[1] + chomp;
    P011[1] := iP011[1] + chomp;

    P023[0] := iP023[0] + seg1;
    P024[0] := iP024[0] + seg1;
    P025[0] := iP025[0] + seg1;
    P026[0] := iP026[0] + seg1;
    P027[0] := iP027[0] + seg1;
    P028[0] := iP028[0] + seg1;
    P029[0] := iP029[0] + seg1;
    P030[0] := iP030[0] + seg1;
    P031[0] := iP031[0] + seg1;
    P032[0] := iP032[0] + seg1;
    P033[0] := iP033[0] + seg2;
    P034[0] := iP034[0] + seg2;
    P035[0] := iP035[0] + seg2;
    P036[0] := iP036[0] + seg2;
    P037[0] := iP037[0] + seg2;
    P038[0] := iP038[0] + seg2;
    P039[0] := iP039[0] + seg2;
    P040[0] := iP040[0] + seg2;
    P041[0] := iP041[0] + seg2;
    P042[0] := iP042[0] + seg2;
    P043[0] := iP043[0] + seg3;
    P044[0] := iP044[0] + seg3;
    P045[0] := iP045[0] + seg3;
    P046[0] := iP046[0] + seg3;
    P047[0] := iP047[0] + seg3;
    P048[0] := iP048[0] + seg3;
    P049[0] := iP049[0] + seg3;
    P050[0] := iP050[0] + seg3;
    P051[0] := iP051[0] + seg3;
    P052[0] := iP052[0] + seg3;
    P002[0] := iP002[0] + seg4;
    P061[0] := iP061[0] + seg4;
    P069[0] := iP069[0] + seg4;
    P070[0] := iP070[0] + seg4;

    fish.vtail := fish.vtail + ((fish.dtheta - fish.vtail) * 0.1);

    if fish.vtail > 0.5 then
        fish.vtail := 0.5
    else if fish.vtail < -0.5 then
        fish.vtail := -0.5;

    segup   := thrash * fish.vtail;

    P023[1] := iP023[1] + segup;
    P024[1] := iP024[1] + segup;
    P025[1] := iP025[1] + segup;
    P026[1] := iP026[1] + segup;
    P027[1] := iP027[1] + segup;
    P028[1] := iP028[1] + segup;
    P029[1] := iP029[1] + segup;
    P030[1] := iP030[1] + segup;
    P031[1] := iP031[1] + segup;
    P032[1] := iP032[1] + segup;
    P033[1] := iP033[1] + segup * 5.0;
    P034[1] := iP034[1] + segup * 5.0;
    P035[1] := iP035[1] + segup * 5.0;
    P036[1] := iP036[1] + segup * 5.0;
    P037[1] := iP037[1] + segup * 5.0;
    P038[1] := iP038[1] + segup * 5.0;
    P039[1] := iP039[1] + segup * 5.0;
    P040[1] := iP040[1] + segup * 5.0;
    P041[1] := iP041[1] + segup * 5.0;
    P042[1] := iP042[1] + segup * 5.0;
    P043[1] := iP043[1] + segup * 12.0;
    P044[1] := iP044[1] + segup * 12.0;
    P045[1] := iP045[1] + segup * 12.0;
    P046[1] := iP046[1] + segup * 12.0;
    P047[1] := iP047[1] + segup * 12.0;
    P048[1] := iP048[1] + segup * 12.0;
    P049[1] := iP049[1] + segup * 12.0;
    P050[1] := iP050[1] + segup * 12.0;
    P051[1] := iP051[1] + segup * 12.0;
    P052[1] := iP052[1] + segup * 12.0;
    P002[1] := iP002[1] + segup * 17.0;
    P061[1] := iP061[1] + segup * 17.0;
    P069[1] := iP069[1] + segup * 17.0;
    P070[1] := iP070[1] + segup * 17.0;

    glPushMatrix();

    glTranslatef(0.0, 0.0, -3000.0);

    glGetFloatv(GL_MODELVIEW_MATRIX, @mat);
    n := 0;
    if mat[0,2] >= 0.0 then
        Inc(n);
    if mat[1,2] >= 0.0 then
        Inc(n,2);
    if mat[2,2] >= 0.0 then
        Inc(n,4);
    glScalef(2.0, 1.0, 1.0);

    glEnable(GL_CULL_FACE);
    case n of
        0 : Fish_1();
        1 : Fish_2();
        2 : Fish_3();
        3 : Fish_4();
        4 : Fish_5();
        5 : Fish_6();
        6 : Fish_7();
        7 : Fish_8();
    end;
    glDisable(GL_CULL_FACE);

    glPopMatrix();
end;

end.
