/******************************************************************************
File:      err.c
Version:   2.21
Tab stops: every 2 columns
Project:   any STK related code
Copyright: 1994-1995 DiamondWare, Ltd.  All rights reserved.*
Written:   Keith Weiner & Erik Lorenzen
Purpose:   contains a routine to handle any error generated by the STK
History:   94/10/21 KW Started
           95/02/21 EL Finalized for 1.00
           95/03/18 EL Added new error to err_Display(), dws_BUSY
           95/03/22 EL Finalized for 1.01
           95/04/06 EL Added new error to err_Display(), dws_IRQDISABLED
           95/04/11 EL moved DisplayError to err.c (err_Display).
           95/04/12 EL Finalized for 1.02
           95/06/16 EL Finalized for 1.03
           95/07/02 EL Added new errors dws_NOMEM & dws_NOTRESIDENT
           95/07/23 EL Finalized for 2.00, added a getch()
           95/07/23 EL Finalized for 2.00, added a getch()
           95/09/22 EL Changed some comments, added modual support,
                       and #if's for __FLAT__ model
           95/10/05 EL Finalized for 2.10
           95/10/18 EL Finalized for 2.20, no changes
           95/12/10 EL Finalized for 2.21, fixed #if #endif to exclude default
Notes
-----
*Permission is expressely granted to use err_Display or any derivitive made
 from it to registered users of the STK.
******************************************************************************/



#include <conio.h>
#include <stdio.h>
#include <stdlib.h>

#include "err.h"



void err_Display(word errornum, err_MODULE module)
{
  switch (module)
  {
    case err_DWS:
    {
      switch (errornum)
      {
        case dws_EZERO:
        {
          /*
           . This should not have happened, considering how we got here!
          */
          printf("DWS: I'm confused!  There is no error number!\n");
          break;
        }
        case dws_NOTINITTED:
        {
          /*
           . If we get here, it means you haven't called dws_Init().
           . The STK needs to initialize itself and the hardware before
           . it can do anything.
          */
          printf("DWS: The STK was not initialized\n");
          break;
        }
        case dws_ALREADYINITTED:
        {
          /*
           . If we get here, it means you've called dws_Init() already.
           . Calling dws_DetectHardWare at this point would cause zillions
           . of problems if we let the call through.
          */
          printf("DWS: The STK was already initialized\n");
          break;
        }
        case dws_NOTSUPPORTED:
        {
          /*
           . If we get here, it means that either the user's machine does not
           . support the function you just called, or the STK was told not to
           . support it in dws_Init.
          */
          printf("DWS: Function not supported\n");
          break;
        }
        case dws_DetectHardware_UNSTABLESYSTEM:
        {
          /*
           . Please report it to DiamondWare if you get here!
           .
           . Ideally, you would disable control-C here, so that the user can't
           . hit control-alt-delete, causing SmartDrive to flush its (possibly
           . currupt) buffers.
          */
          printf("DWS: The system (or DOS box) is unstable!\n");
          printf("     If not in a multitasking system, please power down!\n");

          InfiniteLoop:
            goto InfiniteLoop;
        }

        /*
         . The following three errors are USER/PROGRAMMER errors.  You forgot
         . to fill the cardtyp struct full of -1's (except in those fields
         . you intended to override, or the user (upon the unlikly event that
         . the STK was unable to find a card) gave you a bad overide value.
        */
        case dws_DetectHardware_BADBASEPORT:
        {
          /*
           . You set dov.baseport to a bad value, or
           . didn't fill it with a -1.
          */
          printf("DWS: Bad port address\n");
          break;
        }
        case dws_DetectHardware_BADDMA:
        {
          /*
           . You set dov.digdma to a bad value, or
           . didn't fill it with a -1.
          */
          printf("DWS: Bad DMA channel\n");
          break;
        }
        case dws_DetectHardware_BADIRQ:
        {
          /*
           . You set dov.digirq to a bad value, or
           . didn't fill it with a -1.
          */
          printf("DWS: Bad IRQ level\n");
          break;
        }
        case dws_Kill_CANTUNHOOKISR:
        {
          /*
           . The STK points the interrupt vector for the sound card's IRQ
           . to its own code in dws_Init.
           .
           . dws_Kill was unable to restore the vector to its original
           . value because other code has hooked it after the STK
           . initialized(!)  This is really bad.  Make the user get rid
           . of it and call dws_Kill again.
          */
          printf("DWS: Get rid of your TSR, pal!\n");
          break;
        }
        case dws_X_BADINPUT:
        {
          /*
           . The mixer funtions can only accept volumes between 0 & 255,
           . the volume will remain unchanged.
          */
          printf("DWS: Bad mixer level\n");
          break;
        }
        case dws_D_NOTADWD:
        {
          /*
           . You passed the STK a pointer to something which is not a .DWD file!
          */
          printf("DWS: Pointer does not point to a .DWD\n");
          break;
        }
        case dws_D_NOTSUPPORTEDVER:
        {
          /*
           . The STK can't play a .DWD converted using a version of VOC2DWD.EXE
           . newer than itself.  And, although we'll try to maintain backwards
           . compatibility, we may not be able to guarantee that newer versions
           . of the code will be able to play older .DWD files.  In any event,
           . it's a good idea to always convert .VOC files with the utility
           . which comes with the library you're linking into your application.
          */
          printf("DWS: Please reconvert this file using the VOC2DWD.EXE\n");
          printf("     which came with this library\n");
          break;
        }
        case dws_D_INTERNALERROR:
        {
          /*
           . This error should never occur and probably will not affect sound
           . play(?).  If it happens please contact DiamondWare.
          */
          printf("DWS: An internal error has occured\n");
          printf("     Please contact DiamondWare\n");
          break;
        }
        case dws_DPlay_NOSPACEFORSOUND:
        {
          /*
           . This error is more like a warning, though it may happen on a
           . regular basis, depending on how many sounds you told the STK
           . to allow in dws_Init, how you chose to prioritize sounds and
           . how many sounds are currently being played.
          */
          printf("DWS: No more room for new digitized sounds right now\n");
          break;
        }
        case dws_DSetRate_FREQTOLOW:
        {
          /*
           . The STK will set rate as close as possible to the indicated rate
           . but cannot set a rate that low.
          */
          printf("DWS: Playback frequency too low\n");
          break;
        }
        case dws_DSetRate_FREQTOHIGH:
        {
          /*
           . The STK will set rate as close as possible to the indicated rate
           . but cannot set a rate that high.
          */
          printf("DWS: Playback frequency too high\n");
          break;
        }
        case dws_MPlay_NOTADWM:
        {
          /*
           . You passed the STK a pointer to something which is not a .DWM file!
          */
          printf("DWS: Pointer does not point to a .DWM\n");
          break;
        }
        case dws_MPlay_NOTSUPPORTEDVER:
        {
          /*
           . The STK can't play a .DWM converted using a version of VOC2DWM.EXE
           . newer than itself.  And, although we'll try to maintain backwards
           . compatibility, we may not be able to guarantee that newer versions
           . of the code will be able to play older .DWM files.  In any event,
           . it's a good idea to always convert .MID files with the utility
           . which comes with the library you're linking into your application.
          */
          printf("DWS: Please reconvert this file using the MID2DWM.EXE\n");
          printf("     which came with this library\n");
          break;
        }
        case dws_MPlay_INTERNALERROR:
        {
          /*
           . This error should never occur and probably will not affect sound
           . play(?).  If it happens please contact DiamondWare.
          */
          printf("DWS: An internal error has occured\n");
          printf("     Please contact DiamondWare\n");
          break;
        }
        case dws_BUSY:
        {
          /*
           . Can only occur when DWS is being called from the background
           . (within an ISR--possibly timer or keyboard handler.)  If you get
           . this error, do your IRET, and call again from your next interrupt.
           . Repeat until successful.
          */
          printf("DWS: Busy now, please call again later.\n");
          break;
        }
        case dws_IRQDISABLED:
        {
         /*
          . The following error may be triggered by dws_Init, dws_Kill,
          . or dws_DetectHardWare.  It occurs if interrupts are disabled.
          . Enable interrupts (execute the STI instruction) and call again.
         */
          printf("DWS: Interrupts are disabled.\n");
          break;
        }
        #ifdef __FLAT__
        case dws_NOTRESIDENT:
        {
          /*
           . The real-mode STK component has not been installed, or
           . you may have mixed shareware & registerd versions.  The
           . solution is simple. Either STKRUN.EXE or run the correct
           . STKRUN.EXE.
          */
          printf("DWS: The STK driver is not resident, or you may be\n");
          printf("     mixing shareware and registered versions.\n");
          printf("     Registered libs are not compatible with the\n");
          printf("     shareware STKRUN.EXE, and vice versa.\n");
          break;
        }
        case dws_NOMEM:
        {
          /*
           . The following error will occur if the STK cannot allocate
           . enough DOS (real-mode) memory.
          */
          printf("DWS: Insufficient DOS memory.\n");
          break;
        }
        #endif
        default:
        {
          /*
           . If this function was clipped intact from err.c, this case
           . should never occur and probably will not affect sound play(?)
           . If it happens please contact DiamondWare.
          */
          printf("DWS: I'm confused!  Where am I?  HOW DID I GET HERE????\n");
          printf("     The ERROR number is: %d\n",errornum);
          break;
        }
      }
      break;
    }
    case err_DWDSP:
    {
      switch (errornum)
      {
        case dwdsp_EZERO:
        {
          /*
           . This should not have happened, considering how we got here!
          */
          printf("DWDSP: I'm confused!  There is no error number!\n");
          break;
        }
        case dwdsp_NOTADWD:
        {
          /*
           . You passed DWDSP a pointer to something which is not a .DWD file!
          */
          printf("DWDSP: Pointer does not point to a .DWD\n");
          break;
        }
        case dwdsp_NULLPTR:
        {
          /*
           . You passed DWDSP a NULL pointer
          */
          printf("DWDSP: A NULL pointer was passed to a function.\n");

          break;
        }
        case dwdsp_BADLEN:
        {
          /*
           . The length is smaller than the size of the DWD header.
           . There is no space for data!
          */
          printf("DWDSP: The length is too short to be useable.\n");
          break;
        }
        case dwdsp_SAMEPTR:
        {
          /*
           . This function does not support operation on
           . the source buffer.
          */
          printf("DWDSP: Can't use the same ptr.\n");
          break;
        }
        default:
        {
          /*
           . If this function was clipped intact from err.c, this case
           . should never occur.
          */
          printf("DWDSP: I'm confused!  Where am I?  HOW DID I GET HERE?\n");
          printf("       The ERROR number is: %d\n", errornum);
          break;
        }
      }
      break;
    }
    default:
    {
      printf("Unknown module specified!\n");
    }
  }

  /*
   . If you are using a keyboard handler, the call to getch may cause a lockup
  */
  printf("\n\nPress any key to continue..\n\n");
  getch();
}
