/* dive.h */

#ifdef __cplusplus
        extern "C" {
#endif

#ifndef _DIVE_H_
#define _DIVE_H_


#define MAX_DIVE_INSTANCES 64


#define FOURCC ULONG
#define HDIVE ULONG

#define DIVE_BUFFER_SCREEN 0x00000000
#define DIVE_BUFFER_GRAPHICS_PLANE 0x00000001
#define DIVE_BUFFER_ALTERNATE_PLANE 0x00000002

#define DIVE_FULLY_VISIBLE 0xffffffff


/* Blitter setup structures */

typedef struct _SETUP_BLITTER {
ULONG   ulStructLen;
/* ulStructLen tells how much of the structure is used. */
/* Comments here show appropriate values, so don't count ;) */
ULONG   fInvert;                /* Image is inverted on blit */
/* fInvert use: */
/* b0001 = d01 = h01 horizontal flip */
/* b0010 = d02 = h02 vertical flip */

/* This is the mark for 8 bytes */

FOURCC  fccSrcColorFormat;      /* Source data format */
ULONG   ulSrcWidth;             /* Width in pels */
ULONG   ulSrcHeight;            /* Height in pels */
/* The following are for displaying a sub-portion of the image. */
ULONG   ulSrcPosX;              /* X Position of source data */
ULONG   ulSrcPosY;              /* Y Position of source data */

/* This is the mark for 28 bytes */

ULONG   ulDitherType;           /* Dither type */

/* 32 byte mark */

FOURCC  fccDstColorFormat;      /* Destination color format */
ULONG   ulDstWidth;             /* Destination width in pels */
ULONG   ulDstHeight;            /* Destination height in pels */
LONG    lDstPosX;
LONG    lDstPosY;

/* 52 byte mark */

LONG    lScreenPosX;
LONG    lScreenPosY;

/* 60 byte mark */

ULONG   ulNumDstRects;
PRECTL  pVisDstRects; /* This is a pointer to an array of visible rectangles. */

/* 68 bytes = fully used */

} SETUP_BLITTER;

typedef SETUP_BLITTER *PSETUP_BLITTER;


/* Stuff for DiveQueryCaps() */

typedef struct _DIVE_CAPS {
ULONG   ulStructLen;            /* sizeof(DIVE_CAPS) */
ULONG   ulPlaneCount;           /* Number of defined planes */

/*Following info applies to ulPlaneID */
BOOL    fScreenDirect;          /* Direct screen access */
BOOL    fBankSwitched;          /* VRAM bank-switched? */
ULONG   ulDepth;                /* Number of bits per pixel */
ULONG   ulHorizontalResolution;
ULONG   ulVerticalResolution;
ULONG   ulScanLineBytes;
FOURCC  fccColorEncoding;
ULONG   ulApertureSize;

ULONG   ulInputFormats;         /* Number of input color formats */
ULONG   ulOutputFormats;
ULONG   ulFormatLength;         /* Length of format buffer */
PVOID   pFormatData;            /* Pointer to format buffer of FOURCC's */
} DIVE_CAPS;

typedef DIVE_CAPS *PDIVE_CAPS;


/* DIVE function declarations as of Warp 4 */

ULONG APIENTRY DiveAcquireFrameBuffer ( HDIVE, PRECTL );
ULONG APIENTRY DiveDeacquireFrameBuffer ( HDIVE );

ULONG APIENTRY DiveAllocImageBuffer ( HDIVE, PULONG, FOURCC, ULONG, ULONG, ULONG, PBYTE);
/* if specified line size is 0, allocated line size is rounded up to nearest DWORD boundary. */
ULONG APIENTRY DiveBeginImageBufferAccess ( HDIVE, ULONG, PBYTE *, PULONG, PULONG );
ULONG APIENTRY DiveEndImageBufferAccess ( HDIVE, ULONG );
ULONG APIENTRY DiveFreeImageBuffer (HDIVE, ULONG );

ULONG APIENTRY DiveSetupBlitter (HDIVE, PSETUP_BLITTER );
ULONG APIENTRY DiveBlitImage ( HDIVE, ULONG, ULONG );

ULONG APIENTRY DiveCalcFrameBufferAddress ( HDIVE, PRECTL, PBYTE *, PULONG, PULONG );
ULONG APIENTRY DiveSwitchBank ( HDIVE, ULONG );

ULONG APIENTRY DiveQueryCaps ( PDIVE_CAPS, ULONG );
ULONG APIENTRY DiveSetDestinationPalette ( HDIVE, ULONG, ULONG, PBYTE );
ULONG APIENTRY DiveSetSourcePalette ( HDIVE, ULONG, ULONG, PBYTE );

ULONG APIENTRY DiveOpen ( HDIVE *, BOOL, PVOID ppFrameBuffer );
ULONG APIENTRY DiveClose ( HDIVE );

#ifdef INCL_MM_OS2
ULONG APIENTRY DiveBlitImageLines ( HDIVE, ULONG, ULONG, PBYTE );
#endif
/* in pbLineMask: one byte per line in source buffer, 0:unchanged, 0xFF=changed. */

#define DIVE_PALETTE_PHYSICAL (PBYTE)0x00000000
#define DIVE_PALETTE_DEFAULT (PBYTE)0xffffffff

#ifdef INCL_MM_OS2
ULONG APIENTRY DiveSetTransparentBlitMode ( HDIVE, ULONG ulTransBlitMode, ULONG ulValue1, ULONG ulValue2);
#define DIVE_IBM_NONE 0x0
#define DIVE_IBM_EXCLUDE_SOURCE_VALUE 0x01
/* Pixels matching ulValue1 are not transferred */
#define DIVE_IBM_EXCLUDE_SOURCE_RGB_RANGE 0x02
/* don't transfer values that fall between ulValue1 and ulValue2 */
#define DIVE_IBM_INCLUDE_SOURCE_RGB_RANGE 0x03
#define DIVE_IBM_EXCLUDE_SOURCE_YUV_RANGE 0x04
#define DIVE_IBM_INCLUDE_SOURCE_YUV_RANGE 0x05
#endif
#endif

#ifdef __cplusplus
}
#endif



/* Return codes as of Warp 4 */

#define DIVE_SUCCESS 0x00000000
#define DIVE_ERR_INVALID_INSTANCE 0x00001000
#define DIVE_ERR_SOURCE_FORMAT 0x00001001
#define DIVE_ERR_DESTINATION_FORMAT 0x00001002
#define DIVE_ERR_BLITTER_NOT_SETUP 0x00001003
#define DIVE_ERR_INSUFFICIENT_LENGTH 0x00001004
#define DIVE_ERR_TOO_MANY_INSTANCES 0x00001005
#define DIVE_ERR_NO_DIRECT_ACCESS 0x00001006
#define DIVE_ERR_NOT_BANK_SWITCHED 0x00001007
#define DIVE_ERR_INVALID_BANK_NUMBER 0x00001008
#define DIVE_ERR_FB_NOT_ACQUIRED 0x00001009
#define DIVE_ERR_FB_ALREADY_ACQUIRED 0x0000100a
#define DIVE_ERR_ACQUIRE_FAILED 0x0000100b
#define DIVE_ERR_BANK_SWITCH_FAILED 0x0000100c
#define DIVE_ERR_DEACQUIRE_FAILED 0x0000100d
#define DIVE_ERR_INVALID_PALETTE 0x0000100e
#define DIVE_ERR_INVALID_DESTINATION_RECTL 0x0000100f
#define DIVE_ERR_INVALID_BUFFER_NUMBER 0x00001010
#define DIVE_ERR_SSMDD_NOT_INSTALLED 0x00001011
#define DIVE_ERR_BUFFER_ALREADY_ACCESSED 0x00001012
#define DIVE_ERR_BUFFER_NOT_ACCESSED 0x00001013
#define DIVE_ERR_TOO_MANY_BUFFERS 0x00001014
#define DIVE_ERR_ALLOCATION_ERROR 0x00001015
#define DIVE_ERR_INVALID_LINESIZE 0x00001016
#define DIVE_ERR_FATAL_EXCEPTION 0x00001017
#define DIVE_ERR_INVALID_CONVERSION 0x00001018
#define DIVE_ERR_VSD_ERROR 0x00001019
#define DIVE_ERR_COLOR_SUPPORT 0x0000101a
#define DIVE_ERR_OUT_OF_RANGE 0x0000101b
#define DIVE_WARN_NO_SIZE 0x00001100



