/* This creates a Main Window (with RESULT Flag) with a Group of TEXT.
   Whenever the user moves the window, and presses ENTER, we use RXSET to
   force the window position to 0 ,0
*/

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE

/* =============== Create "Main Window" ================= */
/* First Group is TEXT */
RXTYPE.1 = 'TEXT'

/* Use of a control in this group causes RXDLG to return */
RXFLAGS.1 = 'CENTER'

/* Phrases. No Groupbox */
RXLABEL.1 = 'This is an example of RXSET with a WindowOperation of MOVE.|Move the window and press ENTER.|Window will be forced to the lower left corner of Desktop.'

/* TotalPhrases, PhrasesPerLine, WidthOfPhrase, BetweenPhrases */
RXINFO.1 = '3 1 0 0'

/* Position */
RXX.1 = 10
RXY.1 = 10

/* Default size and position (also gives us sizing and max button) */
RXWIN1 = ''

/* NOCLOSE since we want to close the window ourselves */
RXDLG 1 '"Main Window"' 'RXWIN1'  'NOCLOSE|RESULT'

more:

/* Do user interaction */
RXDLG

/* Did user click upon the CLOSE ICON? If so, then exit */
IF RXID < 0 THEN EXIT

/* The only other thing that could have caused RXDLG to return is ENTER.
   Note that we haven't setup a timeout, nor set the KEYS flag
   of any window, and have no Groups with END Flag set. So... */

/* Force Main Window position to 0, 0 */
RXSET '""' 'MOVE' 0 0

SIGNAL more

/* ==================================================== */
FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
