/* An example of RXFILE */

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE


/* ====================== 'Main Window' ======================= */
/* Just put a TEXT Group in the window in order to have something */
RXTYPE.1 = 'TEXT'

/* Default */
RXFLAGS.1 = ' '

/* Text lines */
RXLABEL.1 = 'Example of RXFILE.'

/* TotalPhrases, PhrasesPerLine, WidthOfPhrase, BetweenPhrases */
RXINFO.1 = '1 1 0 0'

/* Position */
RXX.1 = 10
RXY.1 = 10

/* Default size and position (also gives us sizing and max button) */
RXWINMAIN = ' '
RXDLG 1 '"Main Window"' 'RXWINMAIN'

/* NOTE: We don't actually need a main window open in order to present
   a File Dialog. If you comment out the RXDLG call above, then the File
   Dialog will open on the Desktop. Note that opening it in the Main Window
   automatically causes a MODAL condition, so even if we were within a
   Loop Design script, the RXFILE call will not return until the File Dialog
   is dismissed
*/

/* Store the filename in the variable FN. Initialize it to '*.cmd' in order to
   initially display all filenames in the current directory that end in
   '.cmd' */
FN = 'C:\testrexx\*.cmd'

/* Do the dialog */
RXFILE 'LOAD' 'FN' 'Load Me|' 'This is the title'

/* Check for OK */
IF RC = '' THEN RXSAY FN

/* RC must be 'Cancel', because all other errors jumped to ERROR */
ELSE RXSAY 'User cancelled!'

/* ========================== Done ========================== */
EXIT

FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
