#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unidef.h>
#include <uconv.h>

/* Define the maximum length of the locale list.  2048 is generally sufficient
 * for the list of system locales.  The list of user locales is typically
 * shorter.
 */
#define LIST_BUF_SIZE 2048

/* GCC 3.3.5 fails to define the following constants (in unidef.h):
 */
#ifndef UNI_SYSTEM_LOCALES
    #define UNI_SYSTEM_LOCALES  1
#endif

#ifndef UNI_USER_LOCALES
    #define UNI_USER_LOCALES    2
#endif

#ifndef ULS_LNAMEMAX
    #define ULS_LNAMEMAX        32
#endif


/*****************************************************************************
 * Displays a list of the currently-defined user locales (i.e. locales which *
 * are defined in the Locale applet).                                        *
 *****************************************************************************/
int main( void )
{
    UconvObject  uconvObj;
    LocaleObject localeObj;
    UniChar      suUsrLocales[ LIST_BUF_SIZE ],
                 *psuLocale,
                 *psuCountry,
                 *psuLanguage;
    CHAR         szLocaleName[ ULS_LNAMEMAX ];
    PSZ          pszCountry,
                 pszLanguage;
    ULONG        ulOffset,
                 ulRC,
                 i;
    size_t       stBufLen;


    /* Create a conversion object for the current codepage */
    ulRC = UniCreateUconvObject((UniChar *)L"@map=display", &uconvObj );
    if ( ulRC != ULS_SUCCESS ) {
        printf("UniCreateUconvObject error: 0x%X\n", ulRC );
        return ulRC;
    }

    /* Get the list of defined user locales */
    ulRC = UniQueryLocaleList( UNI_USER_LOCALES, suUsrLocales, LIST_BUF_SIZE );
    if ( ulRC != ULS_SUCCESS ) {
        printf("UniQueryLocaleList error: 0x%X\n", ulRC );
        return ulRC;
    }
    printf("The following user locales are defined:\n");

    /* Parse each locale name from the null-delimited list of names */
    ulOffset = 0;
    while (( ulOffset < LIST_BUF_SIZE ) && ( suUsrLocales[ulOffset] != 0 )) {
        psuLocale = suUsrLocales + ulOffset;

        /* Convert the locale name into a printable codepage string */
        ulRC = UniStrFromUcs( uconvObj, szLocaleName, psuLocale, sizeof(szLocaleName) );
        if ( ulRC != ULS_SUCCESS ) {
            printf("UniStrFromUcs error: 0x%X\n", ulRC );
            continue;
        }
        printf("-> %-20s", szLocaleName );

        /* Request a LocaleObject for this locale */
        ulRC = UniCreateLocaleObject( UNI_UCS_STRING_POINTER, psuLocale, &localeObj );
        if ( ulRC == ULS_SUCCESS ) {

            /* Now get some information about this locale. */
            /* (Note: UniQueryLocaleItem() allocates the UniChar buffer for us.) */

            /* Localized country name */
            ulRC = UniQueryLocaleItem( localeObj, LOCI_sNativeCtryName, &psuCountry );
            if ( ulRC == ULS_SUCCESS ) {

                stBufLen   = UniStrlen( psuCountry ) + 1;
                pszCountry = (PSZ) malloc( stBufLen );
                ulRC = UniStrFromUcs( uconvObj, pszCountry, psuCountry, stBufLen );
                if ( ulRC != ULS_SUCCESS )
                    printf("Country: %-20ls", psuCountry );
                else
                    printf("Country: %-20s", pszCountry );

                /* Localized language name */
                ulRC = UniQueryLocaleItem( localeObj, LOCI_sLanguage, &psuLanguage );
                if ( ulRC == ULS_SUCCESS ) {
                    stBufLen    = UniStrlen( psuLanguage ) + 1;
                    pszLanguage = (PSZ) malloc( stBufLen );
                    ulRC = UniStrFromUcs( uconvObj, pszLanguage, psuLanguage, stBufLen );
                    if ( ulRC != ULS_SUCCESS )
                        printf("Language: %ls\n", psuLanguage );
                    else
                        printf("Language: %s\n", pszLanguage );

                    free( pszLanguage );
                    UniFreeMem( psuLanguage );

                } else printf("UniQueryLocaleItem error: 0x%X\n", ulRC );

                free( pszCountry );
                UniFreeMem( psuCountry );

            } else printf("UniQueryLocaleItem error: 0x%X\n", ulRC );

            UniFreeLocaleObject( localeObj );

        } else printf("UniCreateLocaleObject error: 0x%X\n", ulRC );

        ulOffset += UniStrlen( psuLocale ) + 1;
    }

    UniFreeUconvObject( uconvObj );
    return ULS_SUCCESS;
}

