#!/usr/bin/awk -f
BEGIN {
  good = bad = bad2 = 0;
  unres = "";
}
{
  if ($1 == "&") {
    printf("Alternative(s): %s\n", $0);
    bad++;
  }
  else if ($1 == "#") {
    unres = sprintf("%s %s", unres, $2);
#    printf("Unresolved: %s\n", $2);
    bad2++;
  }
  else if ($1 == "*")
    good++;
}
END {
  if (bad2 != 0)
    printf("Unresolved: %s\n", unres);
  else if ((good != 0) && ((bad+bad2) == 0))
    print "Spelling is correct";
}
