#include "FResizeImage.h"

#include <QtGui/QPushButton>
#include <QtGui/QLayout>
#include <QtGui/QSpinBox>
#include <QtGui/QLabel>

/*!
 \brief конструктор формы для задания нового размера изображению

 \param width_ текущая ширина изображения
 \param height_ текущая высота изображения
 \param parent указатель на родителя
*/
FResizeImage::FResizeImage(int width_, int height_, QWidget *parent) : QDialog(parent)
{
    setWindowTitle(tr("Set size"));
    buttonOK = new QPushButton("OK");
    buttonCancel = new QPushButton("Cancel");
    QLabel *labelX = new QLabel("Width:");
    QLabel *labelY = new QLabel("Height:");
    spinX = new QSpinBox();
    spinX->setFixedWidth(90);
    spinX->setRange(1, 5000);
    spinX->setValue(width_);
    spinY = new QSpinBox();
    spinY->setFixedWidth(90);
    spinY->setRange(1, 5000);
    spinY->setValue(height_);
    QGridLayout *gLayout = new QGridLayout();
    gLayout->addWidget(labelX, 0, 0);
    gLayout->addWidget(spinX, 0, 1);
    gLayout->addWidget(labelY, 1, 0);
    gLayout->addWidget(spinY, 1, 1);
    QHBoxLayout *hLayout = new QHBoxLayout();
    hLayout->addWidget(buttonOK);
    hLayout->addWidget(buttonCancel);
    gLayout->addLayout(hLayout, 2, 0, 1, 2);
    setLayout(gLayout);
    layout()->setSizeConstraint(QLayout::SetFixedSize);
    show();
    loadSignals();
}

/*!
 \brief инициализация сигналов

*/
void FResizeImage::loadSignals()
{
    connect(buttonOK, SIGNAL(clicked()), this, SLOT(clickOK()));
    connect(buttonCancel, SIGNAL(clicked()), this, SLOT(close()));
}

/*!
 \brief обработчик кнопки buttonOK

*/
void FResizeImage::clickOK()
{
    emit newSize(spinX->value(), spinY->value());
    close();
}
