/* REXX: Scan local Desktop for URL objects dropped from
         Netscape/Mozilla etc. & add to PM Downloader via pipe
         
   Script originally written by Sant Coetzer <sant@OS2World.com>
   Modified by Eugene Romanenko <eros2@os2.ru>

   Configure this script, then put a program ref object for it in
   the startup folder of your machine, or every machine on your
   network from which requests for downloads may be submitted.
   
   !!! Note: If you have PM Downloader installed in this folder,
             configured script must be renamed or moved to another
             folder to prevent losing configuration when new version
             of PM Downloader will be unpacked into this folder.

 ********************************************************
  Customize the information below for your installation */

/* Location of local "Desktop" */
desktop=VALUE("DESKTOP",,"OS2ENVIRONMENT")
IF desktop="" THEN desktop="C:\Desktop"

/* Scan interval in seconds */
interval = 15

/* Wether to make a noise upon URL submission */
quiet = 0

pmdhost = ""               /* Name of PM Downloader HOST
   Set variable above with the name of the machine on your
   NETBIOS network on which PM Downloader is running.
   Leave empty if PM Downloader running on your local machine. */

/* destination: Folder, where downloaded files will be placed.
                If empty, default from PM Downloader settings
                will be used.  */
destination = ""  /* or may be like
                     destination = "D:\Downloads\Users\ShaoKhan" */

/*  End of customization section
*********************************************************/

SIGNAL on halt name _exit0

Sequence=0

/* Name of pipe */
if pmdhost \= "" then pname = "\\"pmdhost"\PIPE\PMDOWNLOADER"
else  pname = "\PIPE\PMDOWNLOADER"

/* Load RexxUtil functions */
call rxFuncAdd "SysLoadFuncs" , "RexxUtil" , "SysLoadFuncs"
call SysLoadFuncs

Say "Desktop URL scanner running:"
Say
if pmdhost \= "" then  Say "Forwarding URLs to PM Downloader running on "pmdhost
else  Say "Forwarding URLs to PM Downloader"
Say "using pipe "pname
Say "Scanning interval is "interval" seconds."
Say "Using '"desktop"' as the Desktop folder"
Say "Note: Settings above can be configured by editing this script."
Say
Say "URLs submitted listed below, preceded by the sequence number."

DO Forever
    CALL SysFileTree desktop"\*",UFILE,"FO"
    DO i=1 TO UFILE.0
        url=linein(UFILE.i)
        turl=translate(url)
        IF substr(turl,1,18)="[INTERNETSHORTCUT]" THEN DO
            url=linein(UFILE.i)
            turl=translate(url)
        END
        CALL stream UFILE.i,"c","close"
        IF substr(turl,1,7)="HTTP://" | substr(turl,1,6)="FTP://" THEN DO
            IF Send(url)=0 THEN CALL SysFileDelete UFILE.i
        END
  END
  CALL SysSleep interval
END

/* function Send */
Send:
    PARSE arg url
    DO Forever
        opret = stream(pname,"C","open write")   /* Open pipe for writing */
        IF opret == "READY:" THEN DO  /* Pipe opened */
            /* write URL to pipe */
            if destination\="" then do
                CALL lineout pname,"/URL="url" /FOLDER="destination
            end
            else  CALL lineout pname,url

            CALL lineout pname        /* Close pipe */

            IF \quiet THEN DO
                call beep 4567,20
                call beep 3456,30
                call beep 2345,20
            END
            Say Sequence url          /* Echo to console */
            Sequence=Sequence+1
            RETURN 0                  /* URL sent, return with 0 */
        END

        /* Pipe not opened, opret contains something like "NOTREADY:errorcode" */
        parse value opret with pstate ":" os2rc

        /* OS/2 errorcode 231 indicates pipe busy, so we call SysWaitNamedPipe */
        IF os2rc=231 THEN DO
            os2rc = SysWaitNamedPipe( pname , -1 )
            IF os2rc\=0 THEN RETURN os2rc  /* Non-zero return value indicates error */
        END
        ELSE RETURN os2rc  /* Another error, pipe not available */

        /* retry loop after calling SysWaitNamedPipe */
    END
/* end of Send */

_exit0:

