/*
$VerboseHistory: vicmode.e$
 *
 * *****************  Version 2  *****************
 * User: Clark       Date: 01/19/1998  Time:08:56a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/19/1998 08:56a
 * Comment:
 *
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:10:25a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 10:25a
 * Comment:
 * Added editor control support.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:35p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:36p
 * Comment:
 * Adding new 3.0 stuff
*/

#include "slick.sh"
#include "ex.sh"

int  def_vi_always_preview_change;
_str def_vi_insertion_pos;
_str def_vi_chars;
_str def_vi_chars2;


_str def_next_word_style;


_str _snap_to_col="";

_str _vi_ckey='';   /* Used by vi-change to do a call-key after the text
                     * to be changed has been cut.
                     */



/* By default this command handles '1'-'9' pressed */
/* The '0' key in vi serves two purposes in command mode:
 *    - if user is not in the process of specifying a
 *      repeat count, then this key will put cursor at
 *      column 1
 *
 *    - otherwise, the repeat count is extended
 */
_command vi_count (...) name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   _macro('m',_macro());
   _macro_delete_line();

   arg1=strip(arg(1));
   parse arg1 with option ':' last_name;
   option=upcase(strip(option));
   last_name=vi_name_eq_translate(last_name);
   in_delete=(option=='D');
   in_modification=(option=='M');
   in_cb=(option=='C');
   in_cb_name=(option=='N');
   cb_info='';
   if( in_delete || in_cb || in_cb_name || in_modification ) {
      cb_info=arg(2);
   }
   multiplier=arg(3);
   //dmessage('multiplier='multiplier);
   snap_to_end_line=1;   /* Should we snap the cursor to the end of the line if an operation leaves the cursor in virtual space? */
   if( arg(4)!='' && arg(4) ) {
      snap_to_end_line=0;
   }
   key=last_event();
   if ( length(key)!=1 || ! isinteger(key) || key<1 ) {
      vi_message('The key "'key'" should not be bound to vi-count');
      return(1);
   }
   /* This is a multiplier for the repeat count */
   if( !isinteger(multiplier) || multiplier<1 ) {
      multiplier=1;
   }
   repeat_count='';
   _vi_ckey='';   // See declaration above
   status=0;
   for (;;) {
      repeat_count=repeat_count:+key;
      key=get_event();
      name=vi_name_eq_translate(vi_name_on_key(key));
      is_intraline_cmd=( vi_name_in_list(name,INTRALINE_CMDS) || vi_name_in_list(name,INTRALINE_CMDS2) );
      is_modification_cmd=( vi_name_in_list(name,MODIFICATION_CMDS) && !vi_name_in_list(name,'vi-replace-line') );
      is_delete_cmd=( vi_name_in_list(name,DELETE_CMDS) );
      is_cb_cmd=( vi_name_in_list(name,CB_CMDS) );
      is_cb_name_cmd=( vi_name_in_list(name,'vi-cb-name') );
      is_search_cmd=( vi_name_in_list(name,SEARCH_CMDS) );
      is_posted_cmd=( vi_name_in_list(name,POSTED_INSERT_CMDS) );
      is_scroll_cmd=( vi_name_in_list(name,SCROLL_CMDS) );

      // 'is_double_cmd' handles cases like 'd3d' or 'c3c' or '>3>' or 'y3y'
      is_double_cmd=(name==last_name && vi_name_in_list(name,DOUBLE_CMDS) && vi_name_in_list(last_name,DOUBLE_CMDS));
      //message(last_name' 'is_double_cmd);delay(200);clear_message();

      /* We must add the test:  !isinteger(key) for the case of vi-begin-line which is normally bound to '0' */
      if ( !isinteger(key) && (is_intraline_cmd || is_modification_cmd || is_delete_cmd || is_cb_cmd || is_cb_name_cmd || is_search_cmd || is_double_cmd) ) {
         if ( !is_double_cmd && (((is_modification_cmd || is_delete_cmd || is_cb_cmd || is_cb_name_cmd) && (in_modification || in_cb))
            || ((is_modification_cmd || is_delete_cmd || is_cb_cmd) && in_delete)) ) {
            vi_message('Invalid key sequence');
            status=1;
            break;
         }

         inclusive_mark_override=0;
         if( in_modification && last_name=='vi-change-line-or-to-cursor' ) {
            if( vi_name_in_list(name,'vi-next-word vi-next-word2 vi-end-word vi-end-word2') ) {
               inclusive_mark_override=1;
               switch( name ) {
                  case 'vi-next-word':
                     name='vi-end-word';
                     break;
                  case 'vi-next-word2':
                     name='vi-end-word2';
                     break;
               }
            }
         } else if( in_delete ) {
            if( vi_name_in_list(name,'vi-end-word vi-end-word2') ) {
               inclusive_mark_override=1;
            }
         }

         index=find_index(name,COMMAND_TYPE);
         if ( index==0 || ! index_callable(index) ) {
            vi_message('Command "'name'" not found');
            status=1;
            break;
         }

         // Begin the mark
         beginline=p_line;   // Will need this later when checking for vi-change-line-or-to-cursor
         if ( (in_delete || in_cb || in_modification) && cb_info!='' ) {
            mark=_alloc_selection();
            if ( mark<0 ) {
               vi_message(get_message(mark));
               status=mark;
               break;
            }
            if( is_double_cmd ) {
               /* A double command is always a line mark marking 'repeat_count'
                * lines including the current line. The only commands that will
                * not be included here are:  vi-shift-text-left and
                * vi-shift-text-right.
                */
               _select_line(mark,'P');
            } else {
               intraline_mark(name,mark,'',1);  /* This starts the appropriate mark-type
                                                 * depending on which command is
                                                 * specified by 'name'
                                                 */
            }
         }

         p=_nrseek();
         //dmessage('key='key);
         last_event(key);     // Set this so that vi-repeat-last-insert-or-delete works correctly
         last_index(index);   // Set this so that vi-repeat-last-insert-or-delete works correctly
         info='';
         if( is_cb_cmd || in_cb_name ) {
            info=cb_info;
         }
         if( is_double_cmd ) {
            // A double command requires that we simply mark 'repeat_count' lines including the current line
            save_pos(q);
            status=down(multiplier*repeat_count-1);
            if( status ) {
               restore_pos(q);
            }
         } else {
            /* Check special case of vi-change-line-or-to-cursor
             * used with vi-end-word or vi-end-word2
             */
            include_cur_col=0;
            if( last_name=='vi-change-line-or-to-cursor' && vi_name_in_list(name,'vi-end-word vi-end-word2') ) {
               line=_expand_tabsc();
               ch1=substr(line,p_col,1);
               ch2=substr(line,p_col+1,1);
               if( name=='vi-end-word' ) {
                  include_cur_col= ( (pos('['def_vi_chars']',ch1,'','r') && !pos('['def_vi_chars']',ch2,'','r')) ||
                                     (pos('['def_vi_chars2']',ch1,'','r') && !pos('['def_vi_chars2']',ch2,'','r')) ||
                                     pos('[ \t]',ch1,'','r')
                                   );
               } else {
                  include_cur_col= ( (pos('[~ \t]',ch1,'','r') && !pos('[~ \t]',ch2,'','r')) ||
                                     pos('[ \t]',ch1,'','r')
                                   );
               }
               if( (multiplier*repeat_count)>1 || !include_cur_col ) {
                  if( include_cur_col ) {
                     // Subtract 1 so we select the correct number of words
                     _macro_call(stranslate(name_name(index),'_','-'),multiplier*repeat_count-1,info);
                     status=call_index(multiplier*repeat_count-1,info,index);   // 'info' is an optional argument used mainly by the clipboard commands
                  } else {
                     _macro_call(stranslate(name_name(index),'_','-'),multiplier*repeat_count,info);
                     status=call_index(multiplier*repeat_count,info,index);   // 'info' is an optional argument used mainly by the clipboard commands
                  }
               }
            } else {
               _macro_call(stranslate(name_name(index),'_','-'),multiplier*repeat_count,info);
               status=call_index(multiplier*repeat_count,info,index);   // 'info' is an optional argument used mainly by the clipboard commands
            }
         }
         if ( status ) {
            if ( p==_nrseek() && name!='vi-cursor-right' ) {
               // A possible error occurred in the command called
               if ( (in_delete || in_cb || in_modification) && cb_info!='' ) {
                  _free_selection(mark);
               }
               break;
            } else {
               clear_message();   /* Clear the message if not a serious error.
                                   * A non-serious error would be CALLing vi-cursor-down
                                   * more times than is valid, where the result is to
                                   * simply put the cursor at the bottom of the file
                                   */

            }
         }

         // End the mark and move to the clipboard
         endline=p_line;   // Will need this when checking for vi-change-line-or-to-cursor
         if ( (in_delete || in_cb || in_modification) && cb_info!='' ) {
            if( is_double_cmd ) {
               /* A double command is always a line mark marking 'repeat_count'
                * lines including the current line. The only commands that will
                * not be included here are:  vi-shift-text-left and
                * vi-shift-text-right.
                */
               _select_line(mark,'P');
            } else {
               status=(status || inclusive_mark_override);
               intraline_mark(name,mark,status,0);   /* This ends the appropriate mark-type
                                                      * depending on which command is
                                                      * specified by 'name'
                                                      */
            }

            status=0;   // There were no serious errors so far
            old_mark=_duplicate_selection('');   // Get the mark showing
            _show_selection(mark);
            at_bottom=down();
            if( !at_bottom ) up();
            copy_option='';
            cb_name='';
            parse cb_info with copy_option cb_name;
            stack_push='';
            if( in_delete ) {
               stack_push=1;   // Push onto clipboard stack too
            }
            stype=_select_type(mark);
            if( !is_double_cmd && last_name=='vi-change-line-or-to-cursor' && ((stype!='LINE' && beginline==endline) || def_vi_always_preview_change) ) {
               // Special case:  leave the highlighted block until a key is pressed to show what the user is changing
               _begin_select(mark);
               _vi_ckey=get_event();
            }

            if( !is_double_cmd && last_name=='vi-change-line-or-to-cursor' ) {

               // Check to see if only an empty line was selected
               save_pos(p);
               _begin_select(mark);
               beginline=p_line;
               _end_select(mark);
               endline=p_line;
               restore_pos(p);
               noflines=endline-beginline+1;
               single_empty_line= (noflines==1 && !_line_length() );
               if( stype=='LINE' || !single_empty_line ) {
                  if( vi_cut('',cb_name) ) {
                     status=1;
                  }
               }
            } else {
               if ( vi_cut(copy_option,cb_name,stack_push) ) {
                  // Something happened when trying to move the mark to the clipboard
                  status=1;
               }
            }

            if( !status ) {
               // Check special cases
               if( (is_double_cmd && name=='vi-change-line-or-to-cursor') ||
                   (last_name=='vi-change-line-or-to-cursor' && stype=='LINE')
               ) {
                  // Now check to see if we are at bottom of file
                  if( !at_bottom ) {   // Are we at the bottom of the file?
                     up();
                  }
                  // Open a new line for inserting
                  lkey=last_event();
                  last_event(ENTER);   // Must do this so nosplit-insert-line works correctly
                  nosplit_insert_line();
                  last_event(lkey);    // Set the last event back
               }
            }
            _show_selection(old_mark);
            _free_selection(mark);
            // Now make sure the cursor is on a real character
            if( snap_to_end_line && p_col>_text_colc() ) {
               p_col=_text_colc();
            }
         }
         break;
      } else if( (name=='vi-delete' || name=='vi-delete-to-end') && ! in_delete && !in_cb && !in_modification ) {
         index=find_index(name,COMMAND_TYPE);
         if( !index || !index_callable(index) ) {
            vi_message('Command "'name'" not found');
            status=1;
            break;
         }
         last_event(key);     // Set this so that vi-repeat-last-insert-or-delete works correctly
         last_index(index);   // Set this so that vi-repeat-last-insert-or-delete works correctly
         _macro_call(stranslate(name_name(index),'_','-'),cb_info,info);
         status=call_index(multiplier*repeat_count,cb_info,index);
         break;
      } else if( name=='vi-repeat-last-insert-or-delete' && !in_delete && !in_cb && !in_modification ) {
         status=vi_repeat_last_insert_or_delete(repeat_count,cb_info);
         break;
      } else if( is_posted_cmd ) {
         index=find_index(name,COMMAND_TYPE);
         if( !index || !index_callable(index) ) {
            vi_message('Command "'name'" not found');
            status=1;
            break;
         }
         last_event(key);     // Set this so that vi-repeat-last-insert-or-delete works correctly
         last_index(index);   // Set this so that vi-repeat-last-insert-or-delete works correctly
         //status=vi_insert_mode(repeat_count);
         _macro_call(stranslate(name_name(index),'_','-'),repeat_count);
         status=call_index(repeat_count,index);
         break;
      } else if( is_scroll_cmd ) {
         index=find_index(name,COMMAND_TYPE);
         if( !index || !index_callable(index) ) {
            vi_message('Command "'name'" not found');
            status=1;
            break;
         }
         last_event(key);     // Set this so that vi-repeat-last-insert-or-delete works correctly
         last_index(index);   // Set this so that vi-repeat-last-insert-or-delete works correctly
         _macro_call(stranslate(name_name(index),'_','-'),repeat_count);
         status=call_index(repeat_count,index);
         break;
      } else {
         if ( length(key)!=1 || ! isinteger(key) || key<0 ) {
            vi_message('Invalid key sequence');
            status=1;
            break;
         }
      }
   }

   return(status);
}


/* By default this command handles 'l',SPACE,RIGHT pressed */
/* This command will NOT allow the cursor to go past the end of the line */
/* NOTE:  You might observe that the delete option used in conjunction
 *        with this command behaves differently when used with the
 *        vi-cursor-left command.  This is how the true vi behaves, and
 *        not our choice.
 */
_command vi_cursor_right() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( key:==' ' ) {
         maybe_complete();
      } else if ( isnormal_char(key) ) {
         keyin(key);
      } else {
         right();
      }
      return(0);
   }
   count=arg(1);
   if ( !isinteger(count) || count<1 ) {
      count=1;
   }

   status=0;
   if ( !_line_length() ) {
      vi_message('Line is empty');
      return(1);
   }
   len=_line_length();   // This is a physical length
   col=_text_colc(p_col,'P');   // This is a physical column
   if( col==len || (_dbcsIsLeadByte(get_text()) && col==len-1) ) {
      vi_message('Can''t go past end of line');
      return(1);
   }
   for( i=0;i<count;++i ) {
      col=_text_colc(p_col,'P');
      if( col==len || (_dbcsIsLeadByte(get_text()) && col==len-1) ) {
         status=1;   // This is not serious
         break;
      }
      right();
   }

   return(status);
}


/* By default this command handles 'h',BACKSPACE,LEFT pressed */
/* This command will NOT allow the cursor to go past beginning of line */
/* NOTE:  You might observe that the delete option used in conjunction
 *        with this command behaves differently when used with the
 *        vi-cursor-right command.  This is how the true vi behaves, and
 *        not our choice.
 */
_command vi_cursor_left() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      } else if ( key:==BACKSPACE ) {
         rubout();
      } else {
         left();
      }
      return(0);
   }
   count=arg(1);
   if ( count=='' || count<1 ) {
      count=1;
   }

   status=0;
   col=_text_colc(p_col,'P');   // This is a physical column
   if ( col==1 ) {
      vi_message('Can''t go past beginning of line');
      return(1);
   }
   for( i=0;i<count;++i ) {
      if( p_col==1 ) {
         status=1;   // This is not serious
         break;
      }
      left();
   }

   return(status);
}



/* By default this command handles '+',ENTER */
/* This command moves cursor down 1 line to the first non-blank character */
_command vi_begin_next_line () name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( key:==ENTER && p_window_id==_cmdline ) {
         command_execute();
      } else if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);
   if ( count=='' || count<1 ) {
      count=1;
   }
   save_pos(p);   // Save in case of fail

   if ( down(count) ) {
      restore_pos(p);
      vi_message('Can''t move past end of file');
      return(1);
   }

   /* Make sure cursor is on first non-blank character */
   vi_begin_text();

   return(0);
}


/* By default this command handles 'j','C-N',DOWN pressed */
/* This command moves cursor down/up 1 line without changing the column */
/* Note:  if arg(2)='-' then go up to PREVious line */
_command vi_next_line(...) name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
  if ( command_state() ) {
     key=last_event();
     if ( key==UP && p_window_id==_cmdline ) {
        retrieve_prev();
     } else if ( key==DOWN && p_window_id==_cmdline ) {
        retrieve_next();
     } else if ( isnormal_char(key) ) {
        keyin(key);
     }
  } else {
     count=arg(1);
     arg2=arg(2);
     if ( ! isinteger(count) || count<1 ) {
        count=1;
     }
     if ( arg2=='-' ) {
        if ( count>(p_line-1) ) {
           vi_message('Can''t move past beginning of file');
           return(1);
        }
     } else {
        if ( count>(p_noflines-p_line) ) {
           vi_message('Can''t move past end of file');
           return(1);
        }
     }
     key=last_event();
     read_behind_flush_repeats(key,def_flush_repeats);
     prev_cmd=name_name(prev_index());
     if ( _snap_to_col && prev_cmd!='vi-next-line' && prev_cmd!='vi-prev-line' ) {
        _snap_to_col=p_col;
     }
     for (i=1;i<=count;++i) {
        if (p_hex_mode) {
           if ( arg(2)=='-' ) {
              _hex_up();
           } else {
              _hex_down();
           }
        } else {
           if ( arg(2)=='-' ) {
              status=up();
           } else {
              status=down();
           }
           if (status) break;
           if (_lineflags()&HIDDEN_LF) {
              --i;
           }
        }
     }
     if( !p_hex_mode ) {
        stay_on_text(_snap_to_col);
     }
     read_behind_flush_repeats(key,def_flush_repeats);
  }

  return(0);
}

static void stay_on_text(_snap_to_col)
{
   if ( _snap_to_col && (! select_active() || _select_type():!='BLOCK') ) {
      if ( _text_colc()<_snap_to_col ) {
         p_col=_text_colc();
      } else if ( _text_colc(_snap_to_col,'T')<0 ) {
         p_col=_text_colc(1-_text_colc(_snap_to_col,'T'),'i');
      } else {
         p_col=_snap_to_col;
      }
   }
}

/* By default this command handles 'k','C-P',UP pressed */
/* This command moves the cursor up 1 line without changing the column */
_command vi_prev_line () name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
#if 0
   // Set the last index so that the correct column is maintained
   last_index(find_index('vi-next-line',COMMAND_TYPE),'C')l
#endif
   return(vi_next_line(arg(1),'-'));
}

/* By default this command handles '-' pressed */
/* This command moves cursor up 1 line to the first non-blank character */
_command vi_begin_prev_line () name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);
   if ( count=='' || count<1 ) {
      count=1;
   }
   save_pos(p);   // Save the current position in case of fail

   status=up(count)   // Go up 'count' lines

   if ( status || p_line==0 ) {
      restore_pos(p);
      vi_message('Can''t move past beginning of file');
      return(1);
   }

   // Make sure cursor is on the first non-blank character
   vi_begin_text();

   return(0);
}


/* By default this command handles '0' pressed */
/* This command puts the cursor in the first column */
_command vi_begin_line() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      } else if( p_window_id==_cmdline ) {
         get_command(line,col);
         set_command(line,1);
      }
      return(0);
   }
   _begin_line();

   return(0);
}


/* By default this command handles '^' pressed */
/* This command puts the cursor on the first non-blank character */
_command vi_begin_text () name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      } else {
         get_command(line,col);
         set_command(line,1);
      }
      return(0);
   }
   orig_col=p_col;
   first_non_blank();
   if( p_col==orig_col ) {
      _begin_line();
   }
   set_scroll_pos(0,p_cursor_y);

   return(0);
}


/* By default this command handles '$' pressed */
/* This command, unlike Slick emulation, will put
 * the cursor on the last character of the line,
 * not after it
 */
_command vi_end_line() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if( command_state() ) {
      key=last_event();
      if( isnormal_char(key) ) {
         keyin(key);
      } else {
         get_command(line);
         set_command(line,length(line)+1);
      }
      return(0);
   }
   count=arg(1);
   if ( count=='' || count<1 ) {
      count=1;
   }
   save_pos(p);   // Save the buffer location in case of fail

   status=down(count-1);   // Move the cursor

   if ( status ) {
      restore_pos(p);   // Restore the starting position
      vi_message('Can''t move past end of file');
      return(status);
   }
   _end_line();left();   // Put cursor on last character of line

   return(0);
}


/* By default this command handles 'G' pressed */
_command vi_goto_line() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   linenum=arg(1);

   Noflines=p_noflines;
   if( linenum=='' || linenum<1 ) {
      linenum=Noflines;
   }
   if( linenum>Noflines ) {
      vi_message('No such line number');
      return(1);
   } else {
      vi_set_prev_context();   // Set the previous context
      goto_line(linenum);
      first_non_blank();
   }

   return(0);
}


/* By default this command handles '|' pressed */
_command vi_goto_col() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   col=arg(1);

   len=_text_colc();   // This is an imaginary length
   if( col=='' || col<1 ) {
      col=1;   // If no 'col' is given then move to column 1 of current line
   }
   if( col>len ) {
      vi_message('Can''t move past end of line');
      return(1);
   } else {
      p_col=col;
      if( p_col>p_char_width ) {
         // Scroll column into the middle of the window
         set_scroll_pos(p_col-(p_char_width intdiv 2),p_cursor_y);
      }
   }

   return(0);
}


/* By default this command handles 'w' pressed */
_command vi_next_word() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if( command_state() ) {
      key=last_event();
      if( isnormal_char(key) ) {
        keyin(key);
      }
      return(0);
   }
   count=arg(1);
   if( count=='' || count<1 ) {
      count=1;
   }
   for( i=1;i<=count;++i ) {
      status=vi_skip_word('','','B');
      if ( status )  break;
   }
   if( status ) {
      bottom();_end_line();left();
      if( count==1 ) {
         vi_message('Can''t go past end of file');
         return(status);
      }
   }

   return(0);
}


/* By default this command handles 'W' pressed */
_command vi_next_word2() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if( command_state() ) {
      key=last_event();
      if( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);
   if ( count=='' || count<1 ) {
      count=1;
   }
   for( i=1; i<=count ; ++i ) {
      status=vi_skip_word('','1','B');
      if( status ) break;
   }
   if( status ) {
      bottom();_end_line();left();
      if( count==1 ) {
         vi_message('Can''t go past end of file');
         return(status);
      }
   }

   return(0);
}


/* By default this command handles 'b' pressed */
_command vi_prev_word() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if( command_state() ) {
      key=last_event();
      if( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);
   if( count=='' || count<1 ) {
      count=1;
   }
   for( i=1;i<=count;++i ) {
      status=vi_skip_word('-','','B');
      if( status ) break;
   }
   if( status ) {
      top();
      if( count==1 ) {
         vi_message('Can''t go past beginning of file');
         return(status);
      }
   }

   return(0);
}


/* By default this command handles 'B' pressed */
_command vi_prev_word2() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if( command_state() ) {
      key=last_event();
      if( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);
   if( count=='' || count<1 ) {
      count=1;
   }
   for( i=1;i<=count;++i ) {
      status=vi_skip_word('-','1','B');
      if( status ) break;
   }
   if( status ) {
      top();
      if( count==1 ) {
         vi_message('Can''t go past beginning of file');
         return(status);
      }
   }

   return(0);
}


/* By default this command handles 'e' pressed */
_command vi_end_word() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if( command_state() ) {
      key=last_event();
      if( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);
   if( count=='' || count<1 ) {
      count=1;
   }
   for( i=1;i<=count;++i ) {
      status=vi_skip_word('','','E');
      if( status ) break;
   }
   if( status ) {
      bottom();left();
      if( count==1 ) {
         vi_message('Can''t go past end of file');
         return(status);
      }
   }

   return(0);
}


/* By default this command handles 'E' pressed */
_command vi_end_word2() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if( command_state() ) {
      key=last_event();
      if( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);
   if( count=='' || count<1 ) {
      count=1;
   }
   for( i=1;i<=count;++i ) {
      status=vi_skip_word('','1','E');
      if( status ) break;
   }
   if( status ) {
      bottom();left()
      if( count==1 ) {
         vi_message('Can''t go past end of file');
         return(status);
      }
   }

   return(0);
}


static int vi_skip_word(direction_option,chars_option,next_word_style)
{

   /* direction_option:  '-' = skip to previous word
    *                    otherwise, skip to next word
    *     chars_option:  ''  = use 'def_vi_chars'||'def_vi_chars2'
    *                    otherwise, use '[~ \t]'
    *  next_word_style:  'B' = moves cursor to beginning of next word
    *                    'E' = moves cursor to end or next word
    */

   next_word_style=upcase(next_word_style);

   if( direction_option=='-' ) {
      if ( p_col==1 ) {
         up();_end_line();
      } else {
         left()
      }
      if ( chars_option=='' ) {
         word_re='([\od'def_vi_chars']#)|(['def_vi_chars2']#)|(^[ \t]@$)';
      } else {
         word_re='([~ \t]#)|(^[ \t]@$)';
      }
      status=search(word_re,'re-<');
      if ( status ) {
         up();_begin_line();
      }
   } else {
      word_re='';
      word_re2='';
      if ( chars_option=='' ) {
         if ( next_word_style=='E' ) {
            word_re='(((^|)[\od'def_vi_chars']#\c)|((^|)['def_vi_chars2']#\c))';
            line=_expand_tabsc();
            at_last_char=(pos('[\od'def_vi_chars']',substr(line,p_col,1),'','r') && ! pos('[\od'def_vi_chars']',substr(line,p_col+1,1),'','r')) ||
                         (pos('['def_vi_chars2']',substr(line,p_col,1),'','r') && ! pos('['def_vi_chars2']',substr(line,p_col+1,1),'','r'));
            if ( (p_col==1 && line=='') || at_last_char ) {
               /* Don't want to get stuck on an empty line or at the end of a word */
               right();
            }
         } else {
            //word_re='((([~\od'def_vi_chars']|^)\c[\od'def_vi_chars']#)|(([~'def_vi_chars2']|^)\c['def_vi_chars2']#))|(^[ \t]@$)'
            word_re='((^\c[~ \t])|(([~\od'def_vi_chars'])\c[\od'def_vi_chars']#)|(([~'def_vi_chars2'])\c['def_vi_chars2']#))|(^[ \t]@$)';
            //word_re2='((([~\od'def_vi_chars'])\c[\od'def_vi_chars']#)|(([~'def_vi_chars2'])\c['def_vi_chars2']#))|(^[ \t]@$)'
            word_re2='((([~\od'def_vi_chars'])\c[\od'def_vi_chars']#)|(([~'def_vi_chars2'])\c['def_vi_chars2']#))';
            #if 0
            if ( p_col==1 && !pos('[ \t]',get_text(),'','r') ) {
               /* Don't want to get stuck on an empty line or at the beginning of a word */
               right();
            }
            #endif
         }
      } else {
         if ( next_word_style=='E' ) {
            word_re='((^|)[~ \t]#\c)';
            line=_expand_tabsc();
            at_last_char=(pos('[~ \t]',substr(line,p_col,1),'','r') && ! pos('[~ \t]',substr(line,p_col+1,1),'','r'));
            if ( (p_col==1 && line=='') || at_last_char ) {
               right();
            }
         } else {
            word_re='((([ \t]|^)\c[~ \t]#)|(^[ \t]@$))';
            #if 0
            if ( p_col==1 && !pos('[ \t]',get_text(),'','r') ) {
               right();
            }
            #endif
         }
      }
      p=point();col=p_col;
      status=search(word_re,'re');
      if( !status && (p==point() && col==p_col) ) {   /* Did we move? */
         if( word_re2!='' ) {
            if( _first_non_blank_col('-1')=='-1' ) {   /* Is the line blank (all whitespace)? */
               status=repeat_search();
            } else {
               status=repeat_search();
               if( status ) {
                  status=search(word_re2,'re');
                  if( !status && (p==point() && col==p_col) ) {   /* Did we move? */
                     status=repeat_search();
                  }
               }
            }
         } else {
            status=repeat_search();
         }
      }
      if ( next_word_style=='E' ) {
         left();
      }
   }

   if ( status ) {
      clear_message();
   }

   return(status);
}


#define END_SENTENCE_CHARS '.!?'
#define END_OF_SENTENCE_RE '((.|!|\?)[.!\?"'')\]]*\c($|  ))'

/* By default this command handles '(' pressed */
_command vi_prev_sentence() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);
   if ( count=='' || count<1 ) {
      count=1;
   }
   paragraph_chars=def_vi_or_ex_paragraphs;
   if ( paragraph_chars=='' ) {
      paragraph_chars=PARAGRAPHS_DEFAULT;   // This is from 'ex.sh'
   }
   paragraph_re='(^['paragraph_chars']*$)';
   skip_paragraphs_re='^~(['paragraph_chars']*$)';
   status=0;
   for (i=1; i<=count ; ++i) {
      if ( status ) break;
      if ( _first_non_blank_col('-1')=='-1' ) {
         // On a paragraph separator
         search('[~'paragraph_chars']','r-');
      }
      p=point();col=p_col;
      status=search(paragraph_re'|(^[ \t]*\c[~ \t'END_SENTENCE_CHARS'])|('END_OF_SENTENCE_RE'\c)','r-');
      if ( (!status && p==point() && p_col>=col) ) {   // In same place?
         status=repeat_search();
      }
      if( p_col>1 && p_col>=_text_colc()) {
         --p_col;
         ch=get_text();
         ++p_col;
         if( pos('['END_SENTENCE_CHARS']',ch,'','r') ) {
            status=repeat_search();
         }
      }
      for (;;) {
         if ( status ) {
            top();
            break;
         }
         if ( pos(get_text(1,match_length('S')),END_SENTENCE_CHARS) ) break;
         up();
         if ( status ) break;
         get_line(line);
         down();
         if ( pos(paragraph_re,line,'','R') ||
              pos(last_char(strip(line)),END_SENTENCE_CHARS) ) {
            break;
         }
         status=repeat_search();
      }
   }
   clear_message();   // Clear possible "String not found" message
   if ( status && count==1 ) {
      if( p==point() && col==p_col ) {
         vi_message('Can''t move past beginning of file');
      }
      return(status);
   }

   return(0);
}


/* By default this command handles ')' pressed */
_command vi_next_sentence() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);
   if ( count=='' || count<1 ) {
      count=1;
   }
   paragraph_chars=def_vi_or_ex_paragraphs;
   if ( paragraph_chars=='' ) {
      paragraph_chars=PARAGRAPHS_DEFAULT;   // This is from 'ex.sh'
   }
   paragraph_re='(^['paragraph_chars']*$)';
   skip_paragraphs_re='^~(['paragraph_chars']*$)';
   status=0;
   for( i=1;i<=count;++i ) {
      if ( _first_non_blank_col('-1')=='-1' ) {
         // On a paragraph separator
         search(skip_paragraphs_re,'r');
         // Put cursor on first VALID character of the sentence
         search('[\od'def_vi_chars:+def_vi_chars2']','r');
         continue;
      }
      p=point();col=p_col;
      status=search(paragraph_re'|'END_OF_SENTENCE_RE,'r');
      if ( status ) {
         bottom();left();
         break;
      }
      line=_expand_tabsc();
      if ( (p!=point() || p_col>col) ) {
         if ( substr(line,p_col)=='' ) {
            if ( !down() ) _begin_line();
         } else {
            // Put cursor on first VALID character of the sentence
            status=search('[\od'def_vi_chars:+def_vi_chars2']','r');
         }
      }
      if ( status ) {
         bottom();left();
         break;
      }
   }
   clear_message();   // Clear possible "String not found" message
   if ( status && count==1 ) {
      if( p==point() && col==p_col ) {
         vi_message('Can''t move past end of file');
      }
      return(status);
   }

   return(0);
}


/* By default this command handles '{' pressed */
_command vi_prev_paragraph() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);
   if ( count=='' || count<1 ) {
      count=1;
   }
   paragraph_chars=def_vi_or_ex_paragraphs;
   if ( paragraph_chars=='' ) {
      paragraph_chars=PARAGRAPHS_DEFAULT;   // This is from 'ex.sh'
   }
   paragraph_re='(^['paragraph_chars']*$)';
   skip_paragraphs_re='^~(['paragraph_chars']*$)';
   spos=_nrseek();   /* Save the current seek position so we can tell if we've
                      * moved at all.
                      */
   status=0;
   for( i=1;i<=count;++i ) {
      col=p_col;
      first_non_blank();
      if ( col<=p_col ) {
         up();
      }
      _begin_line();
      // Skip paragraph separator lines
      search(skip_paragraphs_re,'r-');
      // Search for paragraph separator line
      status=search(paragraph_re,'r-')
      if ( status ) {
         top();
         if( spos!=_nrseek() ) {   // Have we moved at all?
            status=0;
         }
         break;
      } else {
         _begin_line();
      }
   }
   clear_message();
   if ( status && count==1 ) {
      vi_message('Can''t move past beginning of file');
      return(status);
   }

   return(0);
}


/* By default this command handles '}' pressed */
_command vi_next_paragraph() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);
   if ( count=='' || count<1 ) {
      count=1;
   }
   paragraph_chars=def_vi_or_ex_paragraphs;
   if ( paragraph_chars=='' ) {
      paragraph_chars=PARAGRAPHS_DEFAULT;   // This is from 'ex.sh'
   }
   paragraph_re='(^['paragraph_chars']*$)';
   skip_paragraphs_re='^~(['paragraph_chars']*$)';
   spos=_nrseek();   /* Save the current seek position so we can tell if we've
                      * moved at all.
                      */
   status=0;
   for( i=1;i<=count;++i ) {
      _begin_line();
      // Skip paragraph separator lines
      search(skip_paragraphs_re,'r');
      // Search for paragraph separator line
      status=search(paragraph_re,'r');
      if ( status ) {
         bottom();left();
         if( spos!=_nrseek() ) {   // Have we moved at all?
            status=0;
         }
         break;
      }
   }
   clear_message();
   if ( status && count==1 ) {
      vi_message('Can''t move past end of file');
      return(status);
   }

   return(0);
}


/* By default this command handles '[[' pressed */
/* !!!NOTE!!!  If you rebind this command to another key,
 *             then you must hit that key twice for the
 *             desired effect.
 */
_command vi_prev_section() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);

   key1=last_event();
   key2=get_event();
   if ( vi_name_on_key(key1)!=vi_name_on_key(key2) ) {
      return('');
   }
   if ( count=='' || count<1 ) {
      count=1;
   }
   status=0;
   p=point();col=p_col;
   status=search('^['def_vi_or_ex_sections']','r-');
   if ( !status && p==point() && col==p_col ) {
      status=repeat_search();
   }
   for( i=1;i<=(count-1);++i ) {
      if ( status ) break;
      status=repeat_search();
   }
   clear_message();
   if ( status ) {
      top();
      if ( count==1 && (p==point() && col==p_col) ) {
         vi_message('Can''t move past beginning of file');
         return(status);
      }
   }

   return(0);
}



/* By default this command handles ']]' pressed */
/* !!!NOTE!!!  If you rebind this command to another key,
 *             then you must hit that key twice for the
 *             desired effect.
 */
_command vi_next_section() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   key1=last_event();
   key2=get_event();
   count=arg(1);
   if ( vi_name_on_key(key1)!=vi_name_on_key(key2) ) {
      return('');
   }
   if ( count=='' || count<1 ) {
      count=1;
   }
   status=0;
   p=point();col=p_col;
   status=search('^['def_vi_or_ex_sections']','r');
   if ( !status && p==point() && col==p_col ) {
      status=repeat_search();
   }
   for( i=1;i<=(count-1);++i ) {
      if ( status ) break
      status=repeat_search();
   }
   clear_message()
   if ( status ) {
      bottom();left();
      if ( count==1 && (p==point() && col==p_col) ) {
         vi_message('Can''t move past end of file');
         return(status);
      }
   }

   return(0);
}


/* By default this command handles '%' pressed */
_command vi_find_matching_paren() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   status=_find_matching_paren(def_pmatch_max_diff);
   if ( status ) {
      // Must find the first paren/bracket/brace on the current line
      line=_expand_tabsc();
      p=pos('\(|\)|\[|\]|\{|\}',line,p_col,'r');
      if ( p ) {
         /* Put cursor on the paren/bracket/brace */
         p_col=p;
         _find_matching_paren(def_pmatch_max_diff);
      } else {
         vi_message('Not on paren/bracket/brace pair');
         return(1);
      }
   }
   clear_message();

   return(0);
}


/* By default this command handles 'H' pressed */
_command vi_top_of_window() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   offset=arg(1);
   if ( offset=='' || offset<1 ) {
      offset=1;
   }
   pixel_offset=offset*p_font_height;

   status=0;
   start_lineno=p_line;   // Starting line number
   old_cursor_y=p_cursor_y;   // Save the old scroll position

   old_prev_context=vi_get_prev_context();   // Save the old previous context
   vi_set_prev_context();   // Set the previous context

   if ( offset>p_char_height ) {
      line_cursor_y=p_cursor_y intdiv p_font_height;
      status=down(offset-line_cursor_y-1);
   } else {
      p_cursor_y=pixel_offset-p_font_height;
   }
   if ( status ) {
      // 'offset' was too large
      p_line=start_lineno;
      set_scroll_pos(p_left_edge,old_cursor_y);
      vi_set_prev_context(old_prev_context);   // Set it back to original state
      vi_message('Can''t move past end of file');
      return(1);
   }
   first_non_blank();

   return(0);
}



/* By default this command handles 'M' pressed */
_command vi_middle_of_window() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   /* DON'T CARE ABOUT THE OFFSET FOR THIS COMMAND */

   start_lineno=p_line;   // Starting line number
   old_cursor_y=p_cursor_y;   // Save the old scroll position

   vi_set_prev_context();   // Set the previous context

   p_cursor_y=(p_client_height intdiv 2)-1;
   first_non_blank();

   return(0);
}

/* By default this command handles 'L' pressed */
_command vi_bottom_of_window() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   offset=arg(1);
   if ( offset=='' || offset<1 ) {
      offset=1;
   }
   pixel_offset=offset*p_font_height;

   start_lineno=p_line;   // Starting line number
   old_cursor_y=p_cursor_y;   // Save the old scroll position

   old_prev_context=vi_get_prev_context();   // Save the old previous context
   vi_set_prev_context();   // Set up the previous context

   if ( offset>p_char_height ) {
      line_cursor_y=p_cursor_y intdiv p_font_height;
      up(offset-(p_char_height-(line_cursor_y+1)+1));
   } else {
      //p_cursor_y=(p_char_height-offset+1)-1;
      p_cursor_y=(p_client_height-pixel_offset+1)-1;
   }
   if ( p_line==0 ) {
      // 'offset' was too large
      p_line=start_lineno;
      set_scroll_pos(p_left_edge,old_cursor_y);
      vi_set_previous_context(old_previous_context);
      vi_message('Can''t move past beginning of file');
      return(1);
   }
   first_non_blank();

   return(0);
}



/* This procedure handles "'",'`' pressed in command mode */
/* Note:  arg(2)!='' specifies the cursor be put on the first non-blank of the line containing the mark */
typeless vi_goto_mark(name,...)
{
   orig_buf_id=p_buf_id;   // 11/24/1997 - Need this so can restore in the case of an editor control

   if ( name=='' ) {
      status=vi_goto_prev_context();
   } else {
      status=goto_bookmark(name' -m');
   }

   if( !p_mdi_child && p_buf_id!=orig_buf_id ) {
      p_buf_id=orig_buf_id;
      vi_message('Not allowed to switch buffers in an editor control');
      return(0);
   }

   if ( !status && strip(arg(2))!='' ) {
      // Go to the beginning of the line of the previous context
      first_non_blank();
   }

   return(status);
}



/* By default this command handles '\'' pressed */
/* Case "''":
 * A little more explanation:  This command puts the cursor on the line
 * where the last "non-relative" cursor motion occurred.  "Non-relative"
 * means the last cursor motion that was not relative to any previous
 * cursor motion.  Examples of "non-relative" cursor motion is use of
 * the following commands:  'G', 'H', 'M', 'L'.  An example of a "relative"
 * cursor motion is 'C-F', it pages forward relative to the current line.
 *
 * Case "'letter":
 * A little more explanation:  If "'" is followed by "letter", then "letter"
 * represents a mark id to goto.
 */
_command vi_to_mark_line() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   key1=last_event();
   key2=get_event();
   count=arg(1);
   if ( isinteger(count) && count!=1 ) {
      // Count not allowed
      vi_message('No count allowed');
      return(1);
   }
   if ( vi_name_on_key(key1)==vi_name_on_key(key2) ) {
      // Go to the beginning of the line of the previous context
      return(vi_goto_mark('','1'));
   } else if ( length(key2):==1 && isalpha(key2) ) {
      return(vi_goto_mark(key2,'1'));
   } else {
      vi_message('Invalid key sequence');
      return(1);
   }
}



/* By default this command handles '`' pressed */
/* Case "``":
 * A little more explanation:  This command puts the cursor on the line
 * and column where the last "non-relative" cursor motion occurred.
 * "Non-relative" means the last cursor motion that was not relative to
 * any previous cursor motion.  Examples of "non-relative" cursor motion
 * is use of the following commands:  'G', 'H', 'M', 'L'.  An example of
 * a "relative" cursor motion is 'C-D', it pages forward relative to the
 * current line.
 *
 * Case "`letter":
 * A little more explanation:  If "`" is followed by "letter", then "letter"
 * represents a mark id to goto.
 */
_command vi_to_mark_col() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   key1=last_event();
   key2=get_event();
   count=arg(1);
   if ( isinteger(count) && count!=1 ) {
      // Count not allowed
      vi_message('No count allowed');
      return(1);
   }
   if ( vi_name_on_key(key1)==vi_name_on_key(key2) ) {
      // Go to the previous context
      return(vi_goto_mark(''));
   } else if ( length(key2):==1 && isalpha(key2) ) {
      return(vi_goto_mark(key2));
   } else {
      vi_message('Invalid key sequence');
      return(1);
   }
}


/* This procedure handles 'C-U' and 'C-D' in command mode */
static typeless vi_scroll(direction_option,...)
{
   scroll_amount=arg(2);
   if ( isinteger(scroll_amount) && scroll_amount>0 ) {
      // This is an amount to save for future scrolling
      def_vi_or_ex_scroll=scroll_amount;
   }
   if ( isinteger(def_vi_or_ex_scroll) && def_vi_or_ex_scroll>0 ) {
      scroll_amount=def_vi_or_ex_scroll;
   } else {
      scroll_amount=ex_client_height() intdiv 2;
   }
   save_cursor_y=p_cursor_y;
   if ( direction_option=='-' ) {
      status=down(scroll_amount);
   } else {
      status=up(scroll_amount);
   }
   if ( status || p_line==0 ) {
      // Probably near top/bottom of file or jumped up to line 0
      if( direction_option=='-' ) {
         bottom();
      } else {
         p_line=1;
      }
   }
   first_non_blank();   // Put cursor at beginning of line, not column 1
   set_scroll_pos(p_left_edge,save_cursor_y);
   refresh();

   return(0);
}


/* By default this command handles 'C-U' pressed */
_command vi_scroll_up() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   vi_scroll('',arg(1));

   return(0);
}


/* By default this command handles 'C-D' pressed */
_command vi_scroll_down() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   vi_scroll('-',arg(1));

   return(0);
}



/* This procedure handles 'C-F' and 'C-B' in command mode */
static typeless vi_page_up_down(direction_option,...)
{
   count=arg(2);
   if ( count=='' || count<1 ) {
      count=1;
   }

   save_pos(p);
   s=_nrseek();
   for( i=1;i<=count;++i ) {
      if ( direction_option=='-' ) {
         status=_page_down();
      } else {
         status=_page_up();
      }
      if ( status ) break;
   }
   if ( status && i<=count && s:==_nrseek() ) {
      restore_pos(p);
      return(status);
   }

   return(0);
}


/* By default this command handles 'C-F' pressed */
_command vi_page_down() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   status=vi_page_up_down('-',arg(1));
   if ( status ) {
      // We didn't move
      vi_message('Can''t move past end of file');
   }

   return(status);
}


/* By default this command handles 'C-B' pressed */
_command vi_page_up() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   status=vi_page_up_down('',arg(1));
   if ( status ) {
      vi_message('Can''t move past beginning of file');
   }

   return(status);
}

/* This procedure handles 'C-E' and 'C-Y' in command mode */
/* Scrolls the current line up/down in the client window by count lines */
static typeless vi_scroll_window(direction_option,...)
{
   count=arg(2);
   if ( !isinteger(count) || count<1 ) {
      count=1;
   }
   cursor_y=p_cursor_y;
   updown_count=0;   /* If trying to scroll window beyond client area.
                      * Allow ridiculous counts for this, otherwise would
                      * have to check the number of lines in the file AND
                      * because down() and up() gracefully handle counts
                      * that are larger than the number of lines in file.
                      */
   save_cursor_y=cursor_y;
   if ( direction_option=='-' ) {   // 'C-E'
      cursor_y-=count*p_font_height;

      /* Special case of scrolling the line up AND the current line is
       * already butted up against the top of the window.
       */
      if( cursor_y<0 ) {
         updown_count=(-cursor_y) intdiv p_font_height;
         cursor_y=0;
      }
   } else {                         // 'C-Y'
      if( p_line<p_char_height ) {   // Is it *not* possible to scroll the window down any further?
         return(0);
      }
      cursor_y+=count*p_font_height;

      line_height=p_char_height*p_font_height;
      if( _default_option('T') ) line_height-=p_font_height;   // Subtract out the "Top of File" line

      // Special case of scrolling the line down AND the current line is already butted up against the bottom of the window
      if( cursor_y>line_height ) {
         updown_count=(cursor_y-line_height) intdiv p_font_height;
         cursor_y=p_client_height;
      }
   }

   // The line is already butted up against the top/bottom of the client window, so adjust the current line down/up
   if( updown_count ) {
      if( direction_option=='-' ) {
         down(updown_count);
      } else {
         up(updown_count);
      }
   }

   set_scroll_pos(p_left_edge,cursor_y);

   /* Check to be sure we did *not* try to set the y scroll pos greater than possible */
   if( direction_option!='-' && p_line<p_char_height ) {
      down(p_char_height-p_line);
   }

   /* Check to be sure we are *not* somewhere in virtual space */
   if( p_col>_text_colc() ) {
      p_col=_text_colc();
   }

   refresh();

   return(0);
}

/* By default this command handles 'C-E' pressed */
_command vi_scroll_window_up() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   return(vi_scroll_window('-',arg(1)));
}

/* By default this command handles 'C-Y' pressed */
_command vi_scroll_window_down() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   return(vi_scroll_window('',arg(1)));
}

/* By default this command handles 'C-G' pressed */
_command vi_status() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   if ( p_line==0 ) {
      percent=0;
   } else {
      percent=((p_line-1)*100)  intdiv  p_noflines;
   }
   vi_message('"'p_buf_name'" line 'p_line' of 'p_noflines' --'percent'%--');

   return(0);
}


/* By default this command handles 'z' pressed */
_command vi_zero_line() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   lineno=arg(1);
   if ( lineno=='' || lineno<1 ) {
      lineno=p_line;
   }

   p_line=lineno;
   key=get_event();
   key=event2name(key);
   if ( key=='ENTER' ) {
      new_y=0;
   } else if ( key=='.' ) {
      new_y=(p_client_height intdiv 2)-1;
   } else if ( key=='-' ) {
      new_y=p_client_height;
   } else {
      vi_message('Invalid key pressed');
      return(1);
   }
   set_scroll_pos(p_left_edge,new_y);

   return(0);
}


/* By default this command handles 'C-L' pressed */
_command vi_redraw() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   if( p_mdi_child ) clear_message();

   return(0);
}



/* By default this command handles 'i' pressed */
_command vi_insert_mode(...) name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   callback_idx=find_index('vi_escape',COMMAND_TYPE);
   vi_repeat_info(last_index(),'',arg(1),'',callback_idx);   /* arg(2) is '' because we
                                                              * don't want to save the
                                                              * last keystroke into the
                                                              * keyboard macro
                                                              */

   /* Reset the mode keytable pointer */
   status=vi_switch_mode('I');
   if ( status ) {
      vi_repeat_info('A');   // Abort any keyboard macro currently recording
      return(status);
   }

   insert_at_begin_line=(arg(2)!='' && arg(2)!=0);
   if ( ! insert_at_begin_line ) {
      // Insert at cursor
   } else {
      // Insert at beginning of line at first nonblank character
      first_non_blank();
   }
   def_vi_insertion_pos= p_line' 'p_col;   // Save the beginning line and column of the insertion

   return(0);
}


/* By default this command handles 'I' pressed */
_command vi_begin_line_insert_mode() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   return(vi_insert_mode(arg(1),'1'));
}

/* By default this command handles 'a' pressed */
_command vi_append_mode(...) name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   callback_idx=find_index('vi_escape',COMMAND_TYPE);
   vi_repeat_info(last_index(),'',arg(1),'',callback_idx);   /* arg(2) is '' because we
                                                              * don't want to save the
                                                              * last keystroke into the
                                                              * keyboard macro
                                                              */
   // Reset the mode keytable pointer
   status=vi_switch_mode('I');
   if ( status ) {
      vi_repeat_info('A');   // Abort any keyboard macro currently recording
      return(status);
   }

   append_at_end_line=(arg(2)!='' && arg(2)!=0);
   if ( !append_at_end_line ) {
      // Append after cursor
      right();
   } else {
      // Append at end of current line
      vi_end_line();right();
   }
   def_vi_insertion_pos= p_line' 'p_col;   // Save the beginning line and column of the insertion

   return(0);
}

/* By default this command handles 'A' pressed */
_command vi_end_line_append_mode() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   return(vi_append_mode(arg(1),'1'));
}

/* By default this command handles 'o' pressed */
_command vi_newline_mode(...) name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   callback_idx=find_index('vi_escape',COMMAND_TYPE);
   vi_repeat_info(last_index(),'',arg(1),'',callback_idx);   /* arg(2) is '' because we
                                                              * don't want to save the
                                                              * last keystroke into the
                                                              * keyboard macro
                                                              */
   // Reset the mode keytable pointer
   status=vi_switch_mode('I');
   if ( status ) {
      vi_repeat_info('A');   // Abort any keyboard macro currently recording
      return(status);
   }

   newline_above=(arg(2)!=0 && arg(2)!='');
   if( newline_above ) {
      // Start a newline above the current line
      first_non_blank();
      up();
   }
   //p_col=1;   /* Do this so that cursor is put in column 1 if SMART-INDENTING is off */
   _end_line();   // This is useful when in the middle of a for( ;; ) statement
   nosplit_insert_line();
   def_vi_insertion_pos= p_line' 'p_col;   // Save the beginning line and column of the insertion

   return(0);
}


/* By default this command handles 'O' pressed */
_command vi_above_newline_mode() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   return(vi_newline_mode(arg(1),'1'));
}


/* By default this command handles 'x' pressed */
_command vi_forward_delete_char() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      } else if ( key:==DEL ) {
         _cmdline._delete_char();
      }
      return(0);
   }

   vi_repeat_info(last_index(),last_event(),arg(1),arg(2));

   count=vi_repeat_info('C',arg(1));
   if ( count=='' || count<1 ) {
      count=1;
   }
   cb_name=strip(vi_repeat_info('N',arg(2)));   // IMPORTANT - DO NOT UPCASE THIS
   if ( !_line_length() ) {
      vi_repeat_info('A');   // Abort any keyboard macro currently recording
      vi_message('Empty line');
      return(1);
   }
   len=_line_length();
   old_mark=_duplicate_selection('');
   mark=_alloc_selection();
   if( mark<0 ) {
      vi_repeat_info('A');
      vi_message(get_message(mark));
      return(1);
   }
   _undo('S');
   _select_char(mark,'IP');
   for( i=0;i<(count-1);++i ) {
      col=_text_colc(p_col,'P');
      if( col==len || (_dbcsIsLeadByte(get_text()) && col==len-1) ) {
         break;
      }
      right();
   }
   if( get_text():=="\t" ) {   // Handles the case of a TAB
      right();
      _select_char(mark,'P');
   } else {
      _select_char(mark,'IP');
   }
   _begin_select(mark);
   _show_selection(mark);
   vi_cut('',cb_name);
   _show_selection(old_mark);
   _free_selection(mark);

   // Now make sure that the cursor is on a real character
   if( p_col>_text_colc() ) {
      vi_end_line();
   }

   this_idx=find_index('vi-forward-delete-char',COMMAND_TYPE);
   repeat_idx=vi_repeat_info('X');   // Get the index which started the recording
   if( repeat_idx && repeat_idx==this_idx ) {
      if( vi_repeat_info('I') ) {
         vi_repeat_info('E');   // End and save the currently recording keyboard macro
      }
   }

   return(0);
}



/* By default this command handles 'X' pressed */
_command vi_backward_delete_char() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   vi_repeat_info(last_index(),last_event(),arg(1),arg(2));

   count=vi_repeat_info('C',arg(1))
   if ( count=='' || count<1 ) {
      count=1;
   }
   cb_name=strip(vi_repeat_info('N',arg(2)))   // IMPORTANT - DO NOT UPCASE THIS
   if ( !_line_length() ) {
      vi_repeat_info('A');   // Abort any keyboard macro currently recording
      vi_message('Empty line');
      return(1);
   }
   col=_text_colc(p_col,'P');   // This is physical column
   len=col-1;
   if ( len==0 ) {
      vi_repeat_info('A');   // Abort any keyboard macro currently recording
      vi_message('Can''t go past beginning of line');
      return(1);
   }
   old_mark=_duplicate_selection('');
   mark=_alloc_selection();
   if( mark<0 ) {
      vi_repeat_info('A');
      vi_message(get_message(mark));
      return(1);
   }
   save_pos(p);
   for( i=0;i<count;++i ) {
      if( p_col==1 ) break;
      left();
   }
   _select_char(mark,'IP');
   restore_pos(p);
   _select_char(mark,'NP');
   _begin_select(mark);
   _show_selection(mark);
   vi_cut('',cb_name);
   _show_selection(old_mark);
   _free_selection(mark);

   // Now make sure that the cursor is on a real character
   if( p_col>_text_colc() ) {
      vi_end_line();
   }

   this_idx=find_index('vi-backward-delete-char',COMMAND_TYPE);
   repeat_idx=vi_repeat_info('X');   // Get the index which started the recording
   if( repeat_idx && repeat_idx==this_idx ) {
      if( vi_repeat_info('I') ) {
         vi_repeat_info('E');   // End and save the currently recording keyboard macro
      }
   }

   return(0);
}


/* By default this command handles 'd' pressed */
/* arg(1) is not '' when called by vi-count */
_command vi_delete() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   vi_repeat_info(last_index(),last_event(),arg(1),arg(2));

   repeat_count=vi_repeat_info('C',arg(1));

   if ( ! isinteger(repeat_count) || repeat_count<1 ) {
      repeat_count=1;
   }

   cb_name=strip(vi_repeat_info('N',arg(2)));   // IMPORTANT - DO NOT UPCASE THIS

   key1=last_event();
   key2=get_event();
   name=vi_name_eq_translate(vi_name_on_key(key2));

#if 0
   /* Check the special case of deleting to end of current word or next word */
   inclusive_mark_override=0;
   if( vi_name_in_list(name,'vi-next-word vi-next-word2 vi-end-word vi-end-word2') ) {
      inclusive_mark_override=1;
      switch( name ) {
         case 'vi-next-word':
            name='vi-end-word';
            break;
         case 'vi-next-word2':
            name='vi-end-word2';
            break;
      }
   }
#endif

   index=find_index(name,COMMAND_TYPE);
   if ( index==0 || ! index_callable(index) ) {
      vi_repeat_info('A');   // Abort any keyboard macro currently recording
      vi_message('Command "'name'" not found');
      return(1);
   }

   // Special check for vi-goto-line : don't default the repeat-count to 1
   if( name=='vi-goto-line' && (!isinteger(arg(1)) || arg(1)<1) ) {
      repeat_count=arg(1);
   }
   status=0;
   is_intraline_cmd=( vi_name_in_list(name,INTRALINE_CMDS) || vi_name_in_list(name,INTRALINE_CMDS2) );
   is_search_cmd=( vi_name_in_list(name,SEARCH_CMDS) );
   if ( vi_name_eq_translate(vi_name_on_key(key1)):==name ) {
      // This is the equivalent of a 'dd' pressed in vi
      mark=_alloc_selection();
      if ( mark<0 ) {
         vi_repeat_info('A');   // Abort any keyboard macro currently recording
         vi_message(get_message(mark));
         return(mark);
      }
      _select_line(mark,'P');
      save_pos(p);
      status=down(repeat_count-1);
      if ( status ) {
         vi_repeat_info('A');   // Abort any keyboard macro currently recording
         restore_pos(p);
         vi_message('Invalid count');
         return(status)
      }
      _select_line(mark,'P');
      // Now move the marked area to the clipboard
      old_mark=_duplicate_selection('');
      _show_selection(mark);
      if ( vi_cut('',cb_name,'1') ) {
         // Something happened when trying to move the mark to the clipboard
         status=1;
      }
      _show_selection(old_mark);
      _free_selection(mark);

      // Now make sure the cursor is on a real character
      if( p_col>_text_colc() ) {
         p_col=_text_colc();
      }
   } else if ( is_intraline_cmd || is_search_cmd ) {

      // Check the special case of deleting to end of current word or next word
      inclusive_mark_override=0;
      if( vi_name_in_list(name,'vi-end-word vi-end-word2') ) {
         inclusive_mark_override=1;
      }

      mark=_alloc_selection();
      if ( mark<0 ) {
         vi_repeat_info('A');   // Abort any keyboard macro currently recording
         vi_message(get_message(mark));
         return(mark);
      }
      intraline_mark(name,mark,'',1);  /* This starts the appropriate mark-type
                                        * depending on which command is
                                        * specified by 'name'
                                        */

      p=_nrseek();

      buf_id=p_buf_id;   // Save this in case a search command takes us to a mark in another buffer

#if 0
      include_cur_col=0;
      if( vi_name_in_list(name,'vi-end-word vi-end-word2') ) {
         line=_expand_tabsc();
         ch1=substr(line,p_col,1);
         if( _dbcsIsLeadByte(ch1) ) {
            ch1=substr(line,p_col,2);
            ch2=substr(line,p_col+2,1);
            if( _dbcsIsLeadByte(ch2) ) {
               ch2=substr(line,p_col+2,2);
            }
         } else {
            ch2=substr(line,p_col+1,1);
            if( _dbcsIsLeadByte(ch2) ) {
               ch2=substr(line,p_col+1,2);
            }
         }
         if( name=='vi-end-word' ) {
            include_cur_col= ( (pos('[\od'def_vi_chars']',ch1,'','r') && !pos('[\od'def_vi_chars']',ch2,'','r')) ||
                               (pos('['def_vi_chars2']',ch1,'','r') && !pos('['def_vi_chars2']',ch2,'','r')) ||
                               pos('[ \t]',ch1,'','r')
                             );
         } else {
            include_cur_col= ( (pos('[~ \t]',ch1,'','r') && !pos('[~ \t]',ch2,'','r')) ||
                               pos('[ \t]',ch1,'','r')
                             );
         }
         if( include_cur_col ) --repeat_count;
      }
      if( repeat_count>0 || !include_cur_col ) {
         status=call_index(repeat_count,index);
      }
#else
      status=call_index(repeat_count,index);
#endif

      if ( is_search_cmd && buf_id!=p_buf_id ) {   // Did a search command (i.e. vi-to-mark-col) take us to another buffer?
         vi_repeat_info('A');   // Abort any keyboard macro currently recording
         load_files('+bi 'buf_id);
         vi_message('Can''t delete across different buffers');
         _free_selection(mark);
         return(1);
      }

      if ( status ) {
         if ( p==_nrseek() && name!='vi-cursor-right' ) {
            // A possible error occurred in the command called
            vi_repeat_info('A');   // Abort any keyboard macro currently recording
            _free_selection(mark);
            return(1);
         } else {
            clear_message();   /* Clear the message line if not serious error.
                                * A non-serious error would be calling vi-cursor-down
                                * more times than is valid, where the result is to
                                * simply put the cursor at the bottom of the file
                                */
         }
      }

      status=(status || inclusive_mark_override);
      intraline_mark(name,mark,status,0);  /* This ends the appropriate mark-type
                                            * depending on which command is
                                            * specified by 'name'
                                            */

      status=0;   // There were no serious errors so far
      old_mark=_duplicate_selection('');
      _show_selection(mark);
      if ( vi_cut('',cb_name,'1') ) {
         // Something happened when trying to move the mark to the clipboard
         status=1;
      }
      _show_selection(old_mark);
      _free_selection(mark);

      // Now make sure the cursor is on a real character
      if( p_col>_text_colc() ) {
         vi_end_line();
      }
   } else if ( name=='vi-count' ) {
      flag='D:vi-delete';
      cb_info='0 'cb_name;   // '0 ' is a place holder and, because it is not equal to 'C ', will cause the subsequent mark to be deleted to the clipboard
      status=vi_count(flag,cb_info,repeat_count);
   } else {
      vi_message('Invalid delete sequence');
      status=1;
   }

   if( status ) {
      vi_repeat_info('A');   // Abort any keyboard macro currently recording
   } else {
      this_idx=find_index('vi-delete',COMMAND_TYPE);
      repeat_idx=vi_repeat_info('X');   // Get the index which started the recording
      if( repeat_idx && repeat_idx==this_idx ) {
         if( vi_repeat_info('I') ) {
            vi_repeat_info('E');   // End and save the currently recording keyboard macro
         }
      }
   }

   return(status);
}


_str vi_old_search_string,vi_old_word_re;
int  vi_old_search_flags;

static int intraline_mark(cmd_name,mark,...)
{
   /* 'inclusive_mark_override' is non-zero when a command (like vi-cursor-right)
    * is called more times than is valid and there is a deletion sequence in
    * progress.  In the case of vi-cursor-right the cursor would be put at the
    * end of the current line and the mark would be inclusive so that the last
    * character on the line gets deleted along with the rest of the mark
    */
   inclusive_mark_override=(isinteger(arg(3)) && arg(3)!=0);
   noninclusive_mark_override=(upcase(arg(3))=='N');
   start_mark=(isinteger(arg(4)) && arg(4)!=0);
   if ( inclusive_mark_override ) {
      _select_char(mark,'IP');
   } else if( noninclusive_mark_override ) {
      _select_char(mark,'NP');
   } else if( cmd_name=='vi-cursor-left' ) {
      _select_char(mark,'NP');
   } else if ( cmd_name=='vi-cursor-right' || cmd_name=='vi-to-mark-col' ) {
      _select_char(mark,'NP');
   } else if( cmd_name=='vi-begin-line' || cmd_name=='vi-begin-text' ) {
      _select_char(mark,'NP');
   } else if( cmd_name=='vi-goto-col' ) {
      _select_char(mark,'NP');
   } else if( cmd_name=='vi-next-word' || cmd_name=='vi-next-word2' || cmd_name=='vi-prev-word' || cmd_name=='vi-prev-word2' ) {
      if( start_mark && (cmd_name=='vi-prev-word' || cmd_name=='vi-prev-word2') ) {
         if( p_col==1 ) {
            up();_end_line();   // Start the deletion on the line above
         }
      } else if( !start_mark && (cmd_name=='vi-next-word' || cmd_name=='vi-next-word2') ) {
         save_pos(p);
         old_line=p_line;
         _begin_select(mark);
         diff=old_line-p_line;
         restore_pos(p);
         if( diff>0 ) {
            line=_expand_tabsc();
            if( substr(line,1,p_col-1)=='' ) {
               up();_end_line();   // End deletion on the line above
            }
         }
      }
      _select_char(mark,'NP');
   } else if( cmd_name=='vi-end-word' || cmd_name=='vi-end-word2' ) {
      _select_char(mark,'NP');
   } else if( cmd_name=='vi-prev-sentence' || cmd_name=='vi-next-sentence'
              || cmd_name=='vi-prev-paragraph' || cmd_name=='vi-next-paragraph'
              || cmd_name=='vi-prev-section' || cmd_name=='vi-next-section' ) {
      _select_char(mark,'NP');
   } else if( cmd_name=='vi-char-search-forward' || cmd_name=='vi-char-search-backward'
          || cmd_name=='vi-char-search-forward2' || cmd_name=='vi-char-search-backward2'
          || cmd_name=='vi-repeat-char-search' || cmd_name=='vi-reverse-repeat-char-search' )
          {
      if( start_mark ) {
         if( cmd_name=='vi-char-search-backward' || cmd_name=='vi-char-search-backward2' ) {
            col=p_col;
            left();
            _select_char(mark,'IP');
            if( p_col!=col ) {
               right();   // Put us back where we started so the user doesn't see
            }
         } else if( cmd_name=='vi-repeat-char-search' || cmd_name=='vi-reverse-repeat-char-search' ) {
            if( (cmd_name=='vi-repeat-char-search' && vi_old_search_flags&REVERSE_SEARCH)
                || (cmd_name=='vi-reverse-repeat-char-search' && !(vi_old_search_flags&REVERSE_SEARCH))
                ) {
               col=p_col;
               left();
               _select_char(mark,'IP');
               if( p_col!=col ) {
                  right();   // Put us back where we started so the user doesn't see
               }
            } else {
               _select_char(mark,'IP');
            }
         } else {
            _select_char(mark,'IP');
         }
      } else {
         _select_char(mark,'IP');
      }
   } else if( cmd_name=='ex-search-mode' || cmd_name=='ex-reverse-search-mode' ) {
      if( start_mark ) {
         if( cmd_name=='ex-reverse-search-mode' && p_col==1 ) {
            // Don't include the character at the cursor
            up();_end_line();
         }
      }
      _select_char(mark,'NP');
   } else if( cmd_name=='vi-find-matching-paren' ) {
      _select_char(mark,'IP');
   } else if ( cmd_name=='vi-to-mark-line' ) {
      _select_line(mark,'P');
   } else if( vi_name_in_list(cmd_name,LINE_CMDS) || vi_name_in_list(cmd_name,LINE_CMDS2) ) {
      _select_line(mark,'P');
   } else {
      _select_char(mark,'IP');
   }

   return(0);
}


/* By default this command handles 'D' pressed */
_command vi_delete_to_end() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   vi_repeat_info(last_index(),last_event(),arg(1),arg(2));

   count=arg(1);   // This is not used
   cb_name=strip(vi_repeat_info('N',arg(2)));   // IMPORTANT - DO NOT UPCASE THIS
   status=0;
   if ( !_line_length() ) {   // Is the line empty?
      vi_repeat_info('A');   // Abort any keyboard macro currently recording
      vi_message('Nothing to delete');
      return(1);
   }
   mark=_alloc_selection();
   if ( mark<0 ) {
      vi_repeat_info('A');
      vi_message(get_message(mark));
      return(mark);
   }
   _select_char(mark,'IP');
   save_col=p_col;
   vi_end_line();
   _select_char(mark,'IP');
   // Now move the marked area onto the clipboard
   old_mark=_duplicate_selection('');
   _show_selection(mark);
   if ( vi_cut('',cb_name) ) {
      // Something happened when trying to move the mark to the clipboard
      status=1;
   }
   _show_selection(old_mark);
   _free_selection(mark);

   // Now make sure the cursor is on a real character
   if( p_col>_text_colc() ) {
      vi_end_line();
   }

   if( status ) {
      vi_repeat_info('A');   // Abort any keyboard macro currently recording
   } else {
      this_idx=find_index('vi-delete-to-end',COMMAND_TYPE);
      repeat_idx=vi_repeat_info('X');   // Get the index which started the recording
      if( repeat_idx && repeat_idx==this_idx ) {
         if( vi_repeat_info('I') ) {
            vi_repeat_info('E');   // End and save the currently recording keyboard macro
         }
      }
   }

   return(0);
}


/* By default this command handles 'u' pressed */
_command vi_undo() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_MARK|VSARG2_NOEXIT_SCROLL|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   idx=find_index('undo',COMMAND_TYPE);
   if ( !idx ) {
      vi_message('Can''t find command: undo');
      return(1);
   }
   last_index(idx);   // Set the last index for past save

   return(call_index(idx));
}


/* By default this command handles 'U' pressed */
_command vi_undo_cursor() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_NOEXIT_SCROLL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   idx=find_index('undo-cursor',COMMAND_TYPE);
   if ( !idx ) {
      vi_message('Can''t find command: undo-cursor');
      return(1);
   }
   last_index(idx);   // Set the last index for past save

   return(call_index(idx));
}

/* By default this command handles '.' pressed */
_command vi_repeat_last_insert_or_delete() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);   // MUST pass this unmodified because vi-repeat-info makes decisions based on the original value
   cb_name=arg(2);   // Clipboard name which (if not '') will override any existing clipboard name associated with playback
   idx=vi_repeat_info('X');
   cmdname=vi_name_eq_translate(name_name(idx));
   is_posted_cmd=vi_name_in_list(cmdname,POSTED_INSERT_CMDS);
   if( is_posted_cmd ) {
      call_index(idx);
   }
   status=vi_repeat_info('',count,cb_name);   /* '' as arg(1) means execute the last command */
   return(status);
}

/* This procedure handles 'c','C' pressed in command mode */
static typeless vi_change(option,...)
{
   option=upcase(strip(option));   /* 'C' = delimit changed text between the cursor and an intraline cursor command
                                    * 'E' = delimit from cursor to end of line
                                    * 'L' = delimit entire line
                                    */
   count=arg(2);
   if ( ! isinteger(count) || count<1 ) {
      count=1;
   }
   cb_name=strip(arg(3));   // IMPORTANT - DO NOT UPCASE THIS

   old_mark=_duplicate_selection('');
   mark=_alloc_selection();
   if ( mark<0 ) {
      vi_message(get_message(mark));
      return(mark);
   }
   _vi_ckey='';   /* We call this key for the example:  '4cl' so that we can mark the affected text
                   * and cut it when the user starts typing, so that the user may see what they are
                   * affecting
                   */

   status=0;
   if ( option:=='C' ) {
      key=last_event();
      name=vi_name_eq_translate(vi_name_on_key(key));
      is_intraline_cmd=( vi_name_in_list(name,INTRALINE_CMDS) || vi_name_in_list(name,INTRALINE_CMDS2) );
      is_search_cmd=( vi_name_in_list(name,SEARCH_CMDS) );
      is_line_cmd=( vi_name_in_list(name,LINE_CMDS) || vi_name_in_list(name,LINE_CMDS2) );

      // Special check for vi-goto-line() : don't default the repeat-count to 1
      if( name=='vi-goto-line' && (!isinteger(arg(2)) || arg(2)<1) ) {
         count=arg(2);
      }
      if ( is_intraline_cmd || is_search_cmd || name:=='vi-count' ) {

         // Check the special case of changing to end of current word or next word
         inclusive_mark_override=0;
         if( vi_name_in_list(name,'vi-next-word vi-next-word2 vi-end-word vi-end-word2') ) {
            inclusive_mark_override=1;
            switch( name ) {
               case 'vi-next-word':
                  name='vi-end-word';
                  break;
               case 'vi-next-word2':
                  name='vi-end-word2';
                  break;
            }
         }

         index=find_index(name,COMMAND_TYPE);
         if ( !index || !index_callable(index) ) {
            vi_message('Command "'name'" not found');
            return(1);
         }
         save_pos(p);   // Save the starting position
         s=_nrseek();
         if( name=='vi-count' ) {
            flag='M:vi-change-line-or-to-cursor';
            cb_info='0 'cb_name;   // '0 ' is just a place holder
            status=call_index(flag,cb_info,count,'1',index);   // In a modification sequence
         } else {
            intraline_mark(name,mark,'',1);   // Start the mark
            include_cur_col=0;
            if( vi_name_in_list(name,'vi-end-word vi-end-word2') ) {
               chars=get_text(4);   // 2/6/1997 - get 4 chars in case of DBCS lead bytes
               ch1=substr(chars,1,1);
               if( _dbcsIsLeadByte(ch1) ) {
                  ch1=substr(chars,1,2);
                  ch2=substr(chars,3,1);
                  if( _dbcsIsLeadByte(ch2) ) {
                     ch2=substr(chars,3,2);
                  }
               } else {
                  ch2=substr(chars,2,1);
                  if( _dbcsIsLeadByte(ch2) ) {
                     ch2=substr(chars,2,2);
                  }
               }
               if( name=='vi-end-word' ) {
                  include_cur_col= ( (pos('[\od'def_vi_chars']',ch1,'','r') && !pos('[\od'def_vi_chars']',ch2,'','r')) ||
                                     (pos('['def_vi_chars2']',ch1,'','r') && !pos('['def_vi_chars2']',ch2,'','r')) ||
                                     pos('[ \t]',ch1,'','r')
                                   );
               } else {
                  include_cur_col= ( (pos('[~ \t]',ch1,'','r') && !pos('[~ \t]',ch2,'','r')) ||
                                     pos('[ \t]',ch1,'','r')
                                   );
               }
               if( include_cur_col ) --count;
            }
            if( count>0 || !include_cur_col ) {
               status=call_index(count,index);
            } else {
               if( ch1:=="\t" || _text_colc(p_col,'T')<0 ) {   // Handles the case of a TAB
                  // End the selection at the EXACT end of the tab
                  right();
                  --p_col;
               }
            }
         }
         if ( status && s:==_nrseek() && name!='vi-cursor-right' ) {
            // An error occurred executing the intraline command
            _free_selection(mark);
            return(status);
         } else {
            clear_message();   /* Clear the message line if not serious error.
                                * A non-serious error would be CALLing vi-cursor-down
                                * more times than is valid, where the result is to
                                * simply put the cursor at the bottom of the file
                                */
         }
         if( name!='vi-count' ) {
            status=(status || inclusive_mark_override);
            intraline_mark(name,mark,status,0);   // End the mark
            _begin_select(mark);
            _show_selection(mark);

            // Check to see if we should go ahead and delete the text before the user presses a key
            save_pos(p);
            endline=p_line;
            _end_select(mark);
            at_bottom=down()
            if( !at_bottom ) up();
            beginline=p_line;
            restore_pos(p);
            stype=_select_type(mark);
            if( (stype!='LINE' && beginline==endline) || def_vi_always_preview_change ) {
               _vi_ckey=get_event();
            }

            // Check to see if only an empty line was selected
            save_pos(p);
            _begin_select(mark);
            beginline=p_line;
            _end_select(mark);
            endline=p_line;
            restore_pos(p);
            noflines=endline-beginline+1;
            single_empty_line= (noflines==1 && !_line_length());

            if( stype=='LINE' || !single_empty_line ) {
               vi_cut('',cb_name);
            }

            if( stype=='LINE' ) {

               // Check to see if we are at the bottom of the file
               if( !at_bottom ) {   // At the bottom of the file?
                  // Open a new line for inserting
                  up();
               }
               lkey=last_event();
               last_event(ENTER);   // Must do this so nosplit-insert-line works correctly
               nosplit_insert_line();
               last_event(lkey);
            }
         }
      } else {
         _free_selection(mark);
         vi_message('Invalid key sequence');
         return(1);
      }
   } else if ( option:=='E' || option:=='L' ) {
      if( _line_length() || count!=1 ) {
         if ( option:=='L' ) {
            p_col=1;
         }
         //line=substr(line,text_col(line,p_col,'P'))   // Get that part of the line after(and including) the cursor
         _select_char(mark,'IP');

         // Check to be sure we can substitute 'count' lines
         save_pos(p);   // Save the starting position
         if ( count>1 ) {
            if ( down(count-1) ) {
               restore_pos(p);
               _free_selection(mark);
               vi_message('Invalid count');
               return(1);
            }
         }
         vi_end_line();
         _select_char(mark,'IP');
         restore_pos(p);   // Start changing at beginning
         _show_selection(mark);
         vi_cut('',cb_name);
      }
   }

   _show_selection(old_mark);
   _free_selection(mark);
   status=vi_switch_mode('I');
   if( !status && _vi_ckey:!='' ) {
      call_key(_vi_ckey);
   }

   return(status);
}

/* By default this command handles 'c' pressed */
_command vi_change_line_or_to_cursor() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   vi_repeat_info(last_index(),last_event(),arg(1),arg(2));

   count=vi_repeat_info('C',arg(1));
   cb_name=vi_repeat_info('N',arg(2));   // IMPORTANT - DO NOT UPCASE THIS
   key1=last_event();
   key2=get_event();
   if ( vi_name_on_key(key1):==vi_name_on_key(key2) ) {
      // This is the equivalent of a 'cc' in vi
      status=vi_change('L',count,cb_name);
   } else {
      status=vi_change('C',count,cb_name);
   }

   if( status ) {
      vi_repeat_info('A');   // Abort any keyboard macro currently recording
   }

   return(status);
}

/* By default this command handles 'C' pressed */
_command vi_change_to_end() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   vi_repeat_info(last_index(),last_event(),arg(1),arg(2));

   count=vi_repeat_info('C',arg(1));
   cb_name=vi_repeat_info('N',arg(2));   // IMPORTANT - DO NOT UPCASE THIS
   status=vi_change('E',count,cb_name);

   if( status ) {
      vi_repeat_info('A');   // Abort any keyboard macro currently recording
   }

   return(status);
}

/* This procedure handles 'r','R' pressed in command mode */
static typeless vi_replace(option,...)
{
   option=upcase(strip(option));   /* 'C' = only change the character at the cursor
                                    * 'R' = go into vi replace mode (overstrike mode)
                                    */
   count=arg(2);   // This is a repeat count
   if ( ! isinteger(count) || count<1 ) {
      count=1;
   }

   if ( option:=='C' ) {
      len=_line_length();
      col=_text_colc(p_col,'P');   // Physical column
      if ( count>len ) {
         vi_message('Replacement text is longer than existing line');
         return(1);
      }
      key=get_event();
      if ( (isnormal_char(key)) || key==TAB || key==ENTER ) {
         if( key==TAB ) {
            key=_chr(9);
         } else if( key==ENTER ) {   // HERE - 12/22/1995 - Added to support 'r' followed by ENTER to split a line
            if( _dbcs() ) {
               mark=_alloc_selection();
               if( mark<0 ) {
                  vi_message(get_message(mark));
                  return(1);
               }
               _select_char(mark,'IP');
               for( i=0;i<(count-1);++i ) {
                  col=_text_colc(p_col,'P');
                  if( col==len || (_dbcsIsLeadByte(get_text()) && col==len-1) ) {
                     break;
                  }
                  right();
               }
               _select_char(mark,'IP');
               _begin_select(mark);
               _delete_selection(mark);
               _free_selection(mark);
            } else {
               _delete_text(count);
            }
            split_insert_line();

            return(0);
         }
         if( _dbcs() ) {
            rstr='';   /* Replacement string */
            for( i=1;i<=count;++i ) {
               rstr=rstr:+key;
            }
         } else {
            rstr=substr('',1,count,key);
         }
         /* DBCS ok */
         if( _dbcs() ) {
            mark=_alloc_selection();
            if( mark<0 ) {
               vi_message(get_message(mark));
               return(1);
            }
            _select_char(mark,'IP');
            for( i=0;i<(count-1);++i ) {
               col2=_text_colc(p_col,'P');
               if( col2==len || (_dbcsIsLeadByte(get_text()) && col2==len-1) ) {
                  break;
               }
               right();
            }
            _select_char(mark,'IP');
            _begin_select(mark);
            _delete_selection(mark);
            _free_selection(mark);
         } else {
            _delete_text(count);
         }
         _insert_text(rstr);
      } else if ( lowcase(strip(translate(vi_name_on_key(key),'-','_'))):=='quote-key' ) {
         message nls('Type a key');
         key=get_event();
         clear_message();
         key=key2ascii(key);
         if ( length(key)>1 ) {
            //str=raw_last_event();
            str=key;
         } else {
            str=key;
         }
         rstr='';   // Replacement string
         for (i=1; i<=count ; ++i) {
            rstr=rstr:+str;
         }
         if( _dbcs() ) {
            mark=_alloc_selection();
            if( mark<0 ) {
               vi_message(get_message(mark));
               return(1);
            }
            _select_char(mark,'IP');
            for( i=0;i<(count-1);++i ) {
               col2=_text_colc(p_col,'P');
               if( col2==len || (_dbcsIsLeadByte(get_text()) && col2==len-1) ) {
                  break;
               }
               right();
            }
            _select_char(mark,'IP');
            _begin_select(mark);
            _delete_selection(mark);
            _free_selection(mark);
         } else {
            _delete_text(count);
         }
         _insert_text(rstr);
      } else {
         vi_message('Invalid key');
         return(1);
      }
      p_col=_text_colc(col+(count*length(key))-length(key),'I');   // Move cursor to end of replacement
   } else {   // option=='R'
      // This is essentially a way to put the editor into overstrike mode
      if ( _insert_state() ) {
         _insert_toggle();
      }
      return(vi_switch_mode('I'));
   }

   return(0);
}

/* By default this command handles 'r' pressed */
_command vi_replace_char() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   vi_repeat_info(last_index(),last_event(),arg(1),arg(2));

   count=vi_repeat_info('C',arg(1));
   status=vi_replace('C',count);

   if( status ) {
      vi_repeat_info('A');   // Abort any keyboard macro currently recording
   } else {
      this_idx=find_index('vi-replace-char',COMMAND_TYPE);
      repeat_idx=vi_repeat_info('X');   // Get the index which started the recording
      if( repeat_idx && repeat_idx==this_idx ) {
         if( vi_repeat_info('I') ) {
            vi_repeat_info('E');   // End and save the currently recording keyboard macro
         }
      }
   }

   return(status);
}

/* By default this command handles 'R' pressed */
/* NOTE:  Unlike standard vi, this command only puts the editor into
 *        overstrike mode and does not take a repeat count
 */
_command vi_replace_line() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   callback_idx=find_index('vi_escape',COMMAND_TYPE);
   vi_repeat_info(last_index(),'',arg(1),arg(2),callback_idx);   /* arg(2) is '' because we
                                                                  * don't want to save the
                                                                  * last keystroke into the
                                                                  * keyboard macro
                                                                  */
   status=vi_replace('R');

   if( status ) {
      vi_repeat_info('A');   // Abort any keyboard macro currently recording
   }

   return(status);
}

/* This procedure handles 's','S' pressed in command mode */
static typeless vi_substitute(option,...)
{
   option=upcase(strip(option));   /* 'C' = replace single character with some text
                                    * 'L' = replace entire line with some text
                                    */
   count=arg(2);
   if ( ! isinteger(count) || count<1 ) {
      count=1;
   }

   cb_name=strip(arg(3));   // IMPORTANT - DO NOT UPCASE THIS

   old_mark=_duplicate_selection('');
   mark=_alloc_selection();
   if( mark<0 ) {
      vi_message(get_message(mark));
      return(1);
   }
   if ( option:=='C' ) {
      col=_text_colc(p_col,'P');
      len=_line_length();
      if ( count>(len-col+1) ) {
         count=len-col;
      } else {
         count=count-1;   /* Do this instead of a non-inclusive mark */
      }
      _select_char(mark,'IP');
      for( i=0;i<count;++i ) {
         col=_text_colc(p_col,'P');
         if( col==len || (_dbcsIsLeadByte(get_text()) && col==len-1) ) {
            break;
         }
         right();
      }
      _select_char(mark,'IP');
      _begin_select(mark);
      _show_selection(mark);
      vi_cut('',cb_name);
   } else {
      p_col=1;   // Start substituting at the start of the new line
      if ( _line_length() ) {
         _select_char(mark,'IP');

         // Check to be sure we can substitute 'count' lines
         save_pos(p);   // Save the starting position
         if ( count>1 ) {
            if ( down(count-1) ) {
               restore_pos(p);
               _free_selection(mark);
               vi_message('Invalid count');
               return(1);
            }
         }
         vi_end_line();
         _select_char(mark,'IP');
         restore_pos(p);   // Start substituting at beginning
         _show_selection(mark);
         vi_cut('',cb_name);
      }
   }
   _show_selection(old_mark);
   _free_selection(mark);
   status=vi_switch_mode('I');

   return(status);
}

/* By default this command handles 's' pressed */
_command vi_substitute_char() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   vi_repeat_info(last_index(),last_event(),arg(1),arg(2));

   count=vi_repeat_info('C',arg(1));
   cb_name=vi_repeat_info('N',arg(2));   // IMPORTANT - DO NOT UPCASE THIS
   status=vi_substitute('C',count,cb_name);

   if( status ) {
      vi_repeat_info('A');   // Abort any keyboard macro currently recording
   }

   return(status);
}

/* By default this command handles 'S' pressed */
_command vi_substitute_line() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   vi_repeat_info(last_index(),last_event(),arg(1),arg(2));

   count=vi_repeat_info('C',arg(1));
   cb_name=vi_repeat_info('N',arg(2));   // IMPORTANT - DO NOT UPCASE THIS
   status=vi_substitute('L',count,cb_name);

   if( status ) {
      vi_repeat_info('A');
   }

   return(status);
}

/* By default this command handles '!' pressed */
_command vi_filter() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   vi_repeat_info(last_index(),last_event(),arg(1),arg(2))

   count=vi_repeat_info('C',arg(1));
   cb_name=vi_repeat_info('N',arg(2));   // IMPORTANT - DO NOT UPCASE THIS
   status=0;

   // Use a loop here to give us an easy mechanism for breaking out
   for(;;) {
      lkey=last_event();
      key=get_event();
      if( lkey==key ) {   // This is the equivalent of a '!!'
         old_mark=_duplicate_selection('');
         mark=_alloc_selection();
         if( mark<0 ) {
            vi_message(get_message(mark));
            status=1;
            break;
         }
         _select_line(mark,'P');_select_line(mark,'P');   // Lock the mark
         mark2=_duplicate_selection(mark);   // Make a duplicate so we can cut it to the clipboard later
      } else {
         name=vi_name_eq_translate(vi_name_on_key(key));
         //messageNwait('name='name);vi_repeat_info('A');return(0);
         index=find_index(name,COMMAND_TYPE);
         if ( index==0 || ! index_callable(index) ) {
            vi_message('Command "'name'" not found');
            status=1;
            break;
         }

         // Now mark the lines which will be used as input to the filter AND replaced with the output from the filter
         is_line_cmd=( vi_name_in_list(name,LINE_CMDS) || vi_name_in_list(name,LINE_CMDS2) );
         is_search_cmd=( vi_name_in_list(name,'ex-search-mode ex-reverse-search-mode') );
         if( is_line_cmd || is_search_cmd || name=='vi-count' ) {
            old_mark=_duplicate_selection('');
            mark=_alloc_selection();
            if( mark<0 ) {
               vi_message(get_message(mark));
               status=1;
               break;;
            }
            _select_line(mark,'P');
            if( name=='vi-count' ) {
               // Have to force a line mark, so don't pass any cb info to vi-count
               status=call_index('M:vi-filter','',count,index);
            } else {
               status=call_index(count,index);
            }
            if( status ) {
               _free_selection(mark);
               break;
            }
            _select_line(mark,'P');
            _begin_select(mark);
            mark2=_duplicate_selection(mark);   // Make a duplicate so we can cut it to the clipboard later
         } else {
            vi_message('Invalid key sequence');
            status=1;
            break;
         }
      }

      // Now make a temporary file to hold the input to the shell and copy the marked lines into it
      temp_in=mktemp();
      if( temp_in=='' ) {
         _free_selection(mark);
         _free_selection(mark2);
         vi_message('Unable to make temp file');
         status=1;
         break;
      }
      temp_in=absolute(temp_in);   // Do this in case the working directory changes

      orig_buf_id=p_buf_id;   // 11/24/1997 - Need this so can restore in the case of an editor control

      status=load_files('+t 'temp_in);
      if( status ) {
         _free_selection(mark);
         _free_selection(mark2);
         break;
      }
      _delete_line();
      _copy_to_cursor(mark2);
      _free_selection(mark2);
      status=save('+o');
      _delete_buffer();
      if( status ) break;

      p_buf_id=orig_buf_id;   // 11/24/1997 - Need this so can restore in the case of an editor control

      // Now make a temporary file to hold the output from the shell
      start=(int)substr(strip_filename(temp_in,'EP'),7)+1;
      temp_out=mktemp(start);
      if ( temp_out=='' ) {
         _free_selection(mark);
         vi_message('Unable to make temp file');
         status=1;
         break;
      }
      temp_out=absolute(temp_out);   // Do this in case the working directory changes

      // Now prompt for the shell command to execute
      status=get_string(cmd,'! ');
      if( status || cmd=='' ) {
         _free_selection(mark);
         break;
      }

      shell(cmd' <'temp_in' >'temp_out,'Q');
      if ( file_match(temp_out,'1')!=temp_out ) {
         _free_selection(mark);
         vi_message('Error opening results of shell command');
         status=1;
         break;
      } else {
         // Success
         _show_selection(mark);
         old_line=p_line;
         vi_cut('',cb_name);
         _show_selection(old_mark);
         _free_selection(mark);
         old_line_insert=def_line_insert;
         if( p_line!=old_line ) {
            // The end of the mark was at the bottom of the buffer, so insert AFTER
            def_line_insert='A';
         } else {
            def_line_insert='B';
         }
         get(temp_out);
         if( def_line_insert=='A' ) {
            down();   // Must move down so we are back where we started
         }
         def_line_insert=old_line_insert;   // Quick, change it back

         // Now delete the temp files
         status=delete_file(temp_in);
         if ( status ) {
            vi_message('Error deleting temp file: 'temp_in);
            break;
         }
         status=delete_file(temp_out);
         if ( status ) {
            vi_message('Error deleting temp file: 'temp_out);
            break;
         }
      }
      break;
   }

   if( status ) {
      vi_repeat_info('A');
   } else {
      this_idx=find_index('vi-filter',COMMAND_TYPE);
      repeat_idx=vi_repeat_info('X');   // Get the index which started the recording
      if( repeat_idx && repeat_idx==this_idx ) {
         if( vi_repeat_info('I') ) {
            vi_repeat_info('E');   // End and save the currently recording keyboard macro
         }
      }
   }

   return(status);
}

/* By default this command handles 'J' pressed */
/* This code has been wholesaled from join-line.
 * A check has been added to check if the newly joined line
 * exceeds the line length limit and a FOR loop has been
 * added to support a repeat count.
 */
_command vi_join_line() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   vi_repeat_info(last_index(),last_event(),arg(1),arg(2));

   status=0;
   count=vi_repeat_info('C',arg(1));
   if ( ! isinteger(count) || count<1 ) {
      count=1;
   } else {
      if ( count>(p_noflines-p_line) ) {
         count=p_noflines-p_line;
      }
   }
   /* Join next line to current line at cursor position.
    * If cursor position is less than length of line then
    * join next line to end of current line. Leading spaces
    * and tabs of next line are stripped before join.
    */
   for( i=1;i<=count;++i ) {
      _end_line();
      status=down();
      if ( status ) {
        message get_message(status);
        break;
      }
      up();
      --p_col;
      if( _line_length() && !pos('[ \t]',get_text(),'','r') ) {   // No SPACE or TAB at end of line?
         p_col+=2;   // Force us to pad the end of the line with a space
      }
      if ( p_col>_text_colc() ) {
        // Pad current line with spaces
         _insert_text('a');--p_col;_delete_text();
      }
      if ( arg(1)!='' && arg(1) ) { // Do not strip spaces?
         _join_line();
      } else {
         down();strip_leading_spaces();up();
         _join_line();
      }
   }

   if( status ) {
      vi_repeat_info('A');
   } else {
      this_idx=find_index('vi-join-line',COMMAND_TYPE);
      repeat_idx=vi_repeat_info('X');   // Get the index which started the recording
      if( repeat_idx && repeat_idx==this_idx ) {
         if( vi_repeat_info('I') ) {
            vi_repeat_info('E');   // End and save the currently recording keyboard macro
         }
      }
   }

   return(status);
}

/* This procedure handles '<','>' pressed in command mode */
static typeless vi_shift_text(option,...)
{
   option=upcase(strip(option));
   count=arg(2)
   if ( ! isinteger(count) || count<1 ) {
      count=1;
   }

   cb_name=strip(arg(3));   // IMPORTANT - DO NOT UPCASE THIS

   shiftwidth=def_vi_or_ex_shiftwidth;
   if ( !isinteger(shiftwidth) || shiftwidth<1 ) {
      shiftwidth=SHIFTWIDTH_DEFAULT;   // This is the real vi default value
   }

   key1=last_event();
   key2=get_event();
   old_mark=_duplicate_selection('');
   mark=_alloc_selection();
   if( mark<0 ) {
      vi_message(get_message(mark));
      return(1);
   }
   if ( vi_name_on_key(key1)==vi_name_on_key(key2) ) {
      save_pos(p);
      _select_line(mark,'P');
      if ( down(count-1) ) {
         restore_pos(p);
         _free_selection(mark);   // Can free this because it was never shown
         vi_message('Invalid count');
         return(1);
      }
      _select_line(mark,'P');
      _show_selection(mark);
      vi_cut('C',cb_name);
      _show_selection(old_mark);
      _free_selection(mark);
      up(count-1);
   } else {
      name=vi_name_eq_translate(vi_name_on_key(key2));
      is_line_cmd=( vi_name_in_list(name,LINE_CMDS) || vi_name_in_list(name,LINE_CMDS2) );
      is_search_cmd=( vi_name_in_list(name,'vi-to-mark-line vi-to-mark-col ex-search-mode ex-reverse-search-mode') );

      // Special check for vi-goto-line : don't default the repeat-count to 1
      if( name=='vi-goto-line' && (!isinteger(arg(2)) || arg(2)<1) ) {
         count=arg(2);
      }
      if ( is_line_cmd || is_search_cmd || name:=='vi-count' ) {
         index=find_index(name,COMMAND_TYPE);
         if ( index==0 || ! index_callable(index) ) {
            vi_message('Command "'name'" not found');
            return(1);
         }
         begin_linenum=p_line;
         save_pos(p);
         if ( name:=='vi-count' ) {
            // We have to force a line mark, so call vi-count without any clipboard info
            if( option=='-' ) {
               flag='M:vi-shift-text-left';
            } else {
               flag='M:vi-shift-text-right';
            }
            status=call_index(flag,'',count,index);   // 'M' = in a modification sequence
         } else {
            status=call_index(count,index);
         }
         if ( status ) {
            restore_pos(p);
            _free_selection(mark);   // Can free this because it was never shown
            return(status);
         }
         end_linenum=p_line;
         if ( begin_linenum>end_linenum ) {
            temp=begin_linenum;
            begin_linenum=end_linenum;
            end_linenum=temp;
         } else {
            p_line=begin_linenum;
         }
         count=(end_linenum-begin_linenum+1);
         save_pos(p);
         _select_line(mark,'P');
         if ( down(count-1) ) {
            restore_pos(p);
            _free_selection(mark);   // Can free this because it was never shown
            vi_message('Invalid count');
            return(BOTTOM_OF_FILE_RC)
         }
         _select_line(mark,'P');
         _show_selection(mark);
         vi_cut('C',cb_name);
         _show_selection(old_mark);
         _free_selection(mark);
         up(count-1);
      } else {
         _free_selection(mark);   // Can free this because it was never shown
         vi_message('Invalid modification sequence');
         return(1);
      }
   }

   // Now shift the text
   up();   // Start on the line above so the FOR loop works correctly
   for( i=1;i<=count;++i ) {
      down();
      if( !_line_length() ) continue;
      first_non_blank();
      if ( option:=='-' ) {
         // Shifting left
         shift_amount=shiftwidth;
         if ( shiftwidth>(p_col-1) ) {
            shift_amount=p_col-1;
         }
         if ( p_col>1 ) {
            lead_indent=_expand_tabsc(1,p_col-shift_amount-1,'S');
            dcount=p_col-1;
            _begin_line();
            _delete_text(dcount,'C');   // Strip leading spaces
            _insert_text(lead_indent);
         }
      } else {
         // Shifting right
         if ( (_text_colc()+shiftwidth) > MAX_LINE ) {
            vi_message('This line cannot be shifted because it would exceed the line length limit!');
            return(1);
         }
         first_non_blank();
         lead_indent=indent_string(shiftwidth+p_col-1);   // The new indent
         dcount=p_col-1;
         _begin_line();
         _delete_text(dcount,'C');   // Strip leading spaces
         _insert_text(lead_indent);
      }
   }
   up(count-1);
   first_non_blank();

   return(0);
}


/* By default this command handles '<' pressed */
_command vi_shift_text_left() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   vi_repeat_info(last_index(),last_event(),arg(1),arg(2));

   count=vi_repeat_info('C',arg(1));     // Get the proper repeat count for playback
   cb_name=vi_repeat_info('N',arg(2));   // IMPORTANT - DO NOT UPCASE THIS
   status=vi_shift_text('-',count,cb_name);

   if( status ) {
      vi_repeat_info('A');
   } else {
      this_idx=find_index('vi-shift-text-left',COMMAND_TYPE);
      repeat_idx=vi_repeat_info('X');   // Get the index which started the recording
      if( repeat_idx && repeat_idx==this_idx ) {
         if( vi_repeat_info('I') ) {
            vi_repeat_info('E');   // End and save the currently recording keyboard macro
         }
      }
   }

   return(status);
}

/* By default this command handles '>' pressed */
_command vi_shift_text_right() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   vi_repeat_info(last_index(),last_event(),arg(1),arg(2));

   count=vi_repeat_info('C',arg(1));     // Get the proper repeat count for playback
   cb_name=vi_repeat_info('N',arg(2));   // IMPORTANT - DO NOT UPCASE THIS
   status=vi_shift_text('',count,cb_name);

   if( status ) {
      vi_repeat_info('A');
   } else {
      this_idx=find_index('vi-shift-text-right',COMMAND_TYPE);
      repeat_idx=vi_repeat_info('X');   // Get the index which started the recording
      if( repeat_idx && repeat_idx==this_idx ) {
         if( vi_repeat_info('I') ) {
            vi_repeat_info('E');   // End and save the currently recording keyboard macro
         }
      }
   }

   return(status);
}


/* By default this command handles '"' pressed */
_command vi_cb_name() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   status=0;
   count=arg(1);
   cb_name=get_event();
   if ( length(cb_name)!=1 || ! isalnum(cb_name) ) {
      vi_message('Invalid clipboard name: "'cb_name'"');
      return(1);
   }
   key=get_event();
   name=vi_name_eq_translate(vi_name_on_key(key));
   is_cb_cmd=( vi_name_in_list(name,CB_CMDS) );
   is_modification_cmd=( vi_name_in_list(name,MODIFICATION_CMDS) && !vi_name_in_list(name,'vi-replace-char vi-replace-line vi-join-line') );
   is_delete_cmd=( vi_name_in_list(name,DELETE_CMDS) );
   if ( is_cb_cmd || is_modification_cmd || is_delete_cmd || name=='vi-count' || name=='vi-delete' || name=='vi-delete-to-end' ) {
      index=find_index(name,COMMAND_TYPE);
      if ( index==0 || ! index_callable(index) ) {
         vi_message('Command "'name'" not found');
         return(1);
      }
      if( name!='vi-count' && name!='vi-delete' ) {
         last_event(key);     // Set this so that vi-repeat-last-insert-or-delete works correctly
         last_index(index);   // Set this so that vi-repeat-last-insert-or-delete works correctly
         status=call_index(count,cb_name,index);
      } else {
         cb_info=cb_name;
         if( name=='vi-count' ) {
            flag='N:vi-cb-name';
            status=call_index(flag,cb_info,count,index);
         } else {
            // Call vi-delete
            last_event(key);     // Set this so that vi-repeat-last-insert-or-delete works correctly
            last_index(index);   // Set this so that vi-repeat-last-insert-or-delete works correctly
            status=call_index(count,cb_info,index);
         }
      }
      return(status);
   } else if( name=='vi-repeat-last-insert-or-delete' ) {
      return(vi_repeat_last_insert_or_delete(count,cb_name));
   }

   // If we got here then we have an error
   vi_message('Invalid key sequence');
   return(1);
}

/* This procedure handles 'p','P' pressed in command mode */
/* This pastes text from the clipboard into the editing buffer */
static typeless vi_put(option,...)
{
   option=upcase(strip(option));   /* 'B' = insert lines before current line
                                    * 'A' = insert lines after current line
                                    */
   cb_name=strip(arg(2));   // IMPORTANT - DO NOT UPCASE THIS
   if ( cb_name=='' || cb_name:=='0' ) {
      cb_name=VI_CB0;
   } else if ( length(cb_name)!=1 || ! isalnum(cb_name) ) {
      vi_message('Invalid clipboard name: "'cb_name'"');
      return(1);
   }
   old_line_insert=def_line_insert;
   if ( option:=='B' || option:=='A' ) {
      def_line_insert=option;
   }

   do_left=0;
   if( def_line_insert=='A' ) {
      if( _line_length() ) {
         if( p_col>=_text_colc() ) {
            vi_end_line();   // Start the paste after the last char
         }
         right();
         do_left=1;   // Correct for the right() we just did
      }
   }
   status=paste(lowcase(cb_name));
   def_line_insert=old_line_insert;
   if( do_left ) left();

   return(status);
}

/* By default this command handles 'p' pressed */
_command vi_put_after_cursor() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   vi_repeat_info(last_index(),last_event(),arg(1),arg(2));

   count=vi_repeat_info('C',arg(1));
   cb_name=strip(vi_repeat_info('N',arg(2)));   /* IMPORTANT - DO NOT UPCASE THIS */
   status=vi_put('A',cb_name,count);

   if( status ) {
      vi_repeat_info('A');
   } else {
      this_idx=find_index('vi-put-after-cursor',COMMAND_TYPE);
      repeat_idx=vi_repeat_info('X');   // Get the index which started the recording
      if( repeat_idx && repeat_idx==this_idx ) {
         if( vi_repeat_info('I') ) {
            vi_repeat_info('E');   // End and save the currently recording keyboard macro
         }
      }
   }

   return(status);
}


/* By default this command handles 'P' pressed */
_command vi_put_before_cursor() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   vi_repeat_info(last_index(),last_event(),arg(1),arg(2));

   count=vi_repeat_info('C',arg(1));
   cb_name=strip(vi_repeat_info('N',arg(2)));   // IMPORTANT - DO NOT UPCASE THIS
   status=vi_put('B',cb_name,count);

   if( status ) {
      vi_repeat_info('A');
   } else {
      this_idx=find_index('vi-put-before-cursor',COMMAND_TYPE);
      repeat_idx=vi_repeat_info('X');   // Get the index which started the recording
      if( repeat_idx && repeat_idx==this_idx ) {
         if( vi_repeat_info('I') ) {
            vi_repeat_info('E');   // End and save the currently recording keyboard macro
         }
      }
   }

   return(status);
}

/* This procedure handles 'y','Y' pressed in command mode */
/* This copies text from the editing buffer into the clipboard */
static typeless vi_yank(option,...)
{
   option=upcase(strip(option));   /* 'C' = copy text between current position to the cursor
                                    * 'L' = copy current line
                                    */

   cb_name=strip(arg(2));   // IMPORTANT - DO NOT UPCASE THIS

   count=arg(3);
   if ( ! isinteger(count) || count<1 ) {
      count=1;
   }
   mark=_alloc_selection();
   if ( mark<0 ) {
      vi_message(get_message(mark))
      return(mark)
   }
   if ( option:=='C' ) {
      key1=last_event();
      key2=get_event();
      name=vi_name_eq_translate(vi_name_on_key(key2));
      is_intraline_cmd=( vi_name_in_list(name,INTRALINE_CMDS) || vi_name_in_list(name,INTRALINE_CMDS2) );
      is_search_cmd=( vi_name_in_list(name,SEARCH_CMDS) );

      // Special check for vi-goto-line : don't default the repeat-count to 1
      if( name=='vi-goto-line' && (!isinteger(arg(3)) || arg(3)<1) ) {
         count=arg(3);
      }
      if ( vi_name_on_key(key1)==vi_name_on_key(key2) ) {
         // This is the equivalent of a 'yy' pressed in the real vi

         // First see if the count is valid
         l=p_line;
         if ( down(count-1) ) {
            p_line=l;
            _free_selection(mark);
            vi_message('Invalid count');
            return(BOTTOM_OF_FILE_RC);
         }
         // Now mark it
         _select_line(mark,'P');
         up(count-1);
         _select_line(mark,'P');
      } else if( is_intraline_cmd || is_search_cmd || name:=='vi-count' ) {
         // We may have a repeat count
         index=find_index(name,COMMAND_TYPE);
         if ( ! index || ! index_callable(index) ) {
            vi_message('Command "'name'" not found');
            return(1);
         }
         save_pos(p);
         if( !(is_intraline_cmd || is_search_cmd) ) {
            // Call vi-count
            flag='C:vi-yank-to-cursor';
            cb_info='C 'cb_name;
            status=call_index(flag,cb_info,count,index);   // 'C' = in a clipboard operation
            restore_pos(p);
            _free_selection(mark);   // Don't need this
            return(status);
         }

         inclusive_mark_override=0;
         if( name=='vi-end-word' || name=='vi-end-word2' ) {
            inclusive_mark_override=1;
         }
         //_select_char(mark,'NP');
         s=_nrseek();
         intraline_mark(name,mark,inclusive_mark_override,1);   // Start of mark
         status=call_index(count,index);
         if ( status && s:==_nrseek() && name!='vi-cursor-right' ) {
            // An error occurred executing the intraline command
            restore_pos(p);
            _free_selection(mark);
            return(status);
         } else {
            clear_message();   /* Clear the message if not a serious error.
                                * A non-serious error would be CALLing vi-cursor-down
                                * more times than is valid, where the result is to
                                * simply put the cursor at the bottom of the file
                                */
         }
         //_select_char(mark,'NP');
         intraline_mark(name,mark,status||inclusive_mark_override,0);   // End of mark
         restore_pos(p);
      } else {
         _free_selection(mark);
         vi_message('Invalid key sequence');
         return(1);
      }
   } else if ( option:=='L' ) {
      // First see if the count is valid
      l=p_line;
      if ( down(count-1) ) {
         p_line=l;
         _free_selection(mark);
         vi_message('Invalid count');
         return(BOTTOM_OF_FILE_RC);
      }
      // Now mark it
      _select_line(mark,'P');
      up(count-1);
      _select_line(mark,'P');
   }
   old_mark=_duplicate_selection('');
   _show_selection(mark);

   status=vi_cut('C',cb_name);
   _show_selection(old_mark);
   _free_selection(mark);

   return(status);
}

/* By default this command handles 'y' pressed */
_command vi_yank_to_cursor() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   vi_repeat_info(last_index(),last_event(),arg(1),arg(2));

   count=vi_repeat_info('C',arg(1));
   cb_name=strip(vi_repeat_info('N',arg(2)));   // IMPORTANT - DO NOT UPCASE THIS
   status=vi_yank('C',cb_name,count);

   if( status ) {
      vi_repeat_info('A');
   } else {
      this_idx=find_index('vi-yank-to-cursor',COMMAND_TYPE);
      repeat_idx=vi_repeat_info('X');   // Get the index which started the recording
      if( repeat_idx && repeat_idx==this_idx ) {
         if( vi_repeat_info('I') ) {
            vi_repeat_info('E');   // End and save the currently recording keyboard macro
         }
      }
   }

   return(status);
}

/* By default this command handles 'Y' pressed */
_command vi_yank_line() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }

   vi_repeat_info(last_index(),last_event(),arg(1),arg(2));

   count=vi_repeat_info('C',arg(1));
   cb_name=strip(vi_repeat_info('N',arg(2)));   // IMPORTANT - DO NOT UPCASE THIS
   status=vi_yank('L',cb_name,count);

   if( status ) {
      vi_repeat_info('A');
   } else {
      this_idx=find_index('vi-yank-line',COMMAND_TYPE);
      repeat_idx=vi_repeat_info('X');   // Get the index which started the recording
      if( repeat_idx && repeat_idx==this_idx ) {
         if( vi_repeat_info('I') ) {
            vi_repeat_info('E');   // End and save the currently recording keyboard macro
         }
      }
   }

   return(status);
}


/* This procedure handles 'f','F','t','T' pressed in command mode */
static typeless vi_char_search(option1,option2,...)
{
   /* option1 - ''  = put cursor ON next character typed
                '<' = put cursor BEFORE next character typed
                '>' = put cursor AFTER next character typed
                'R' = repeat last search

      option2 - ''  = forward search
                '-' = reverse search
    */
   if ( p_line==0 ) {
      return(1);
   }
   mark=_alloc_selection();
   if ( mark<0 ) {
      vi_message(get_message(mark))
      return(1);
   }
   old_mark=_duplicate_selection('');
   option1=upcase(option1);
   count=arg(3);
   if ( ! isinteger(count) || count<1 ) {
      count=1;
   }
   save_pos(p);
   status=0;
   search_flags='';
   soptions='m';   // We will be searching within a line mark
   if ( option2=='-' ) {   // Reversing the search?
      if( option1=='R' ) {
         if( vi_old_search_flags&REVERSE_SEARCH ) {
            soptions=soptions:+'+';
         } else {
            soptions=soptions:+'-';
         }
      } else {
         soptions=soptions:+'-';
      }
   }
   if ( option1=='R' ) {
      _show_selection(mark);_select_line(mark,'P');_select_line(mark,'P');   // Mark the line and show it
      restore_search(vi_old_search_string,vi_old_search_flags,vi_old_word_re);
      if( search_flags!='' ) {
         execute(vi_old_search_flags);
      }
      for (i=1; i<=count ; ++i) {
         q=point();
         col=p_col;
         status=repeat_search(soptions);
         if ( ! status && q==point() && col==p_col ) {   // In same place?
            status=repeat_search(soptions);
         }
         if ( status ) break;
      }
   } else {
      key=get_event();
      if ( lowcase(strip(translate(vi_name_on_key(key),'-','_'))):=='quote-key' ) {
         message nls('Type a key');
         key=get_event();
         clear_message();
         key=key2ascii(key);
      } else if ( length(key)!=1 ) {
         if( !_dbcsIsLeadByte(substr(key,1,1)) ) {
            vi_message('Invalid character');
            status=1;
         }
      }
      if ( option1=='<' ) {
         key=_escape_re_chars(key);
         key='?':+key;   // The '?' forces us to put cursor before the character pressed
         soptions=soptions:+'r';
      } else if ( option1=='>' ) {
         soptions=soptions:+'>';
      }
      // We show the mark after we get the character so the user does not see the mark
      _show_selection(mark);_select_line(mark,'P');_select_line(mark,'P');   // Mark the line and show it
      s=_nrseek();
      status=search(key,soptions);
      if( s==_nrseek() ) {   // Did we move?
         status=repeat_search();
      }
      for (i=1; i<=(count-1) ; ++i) {
         if ( status ) break;
         status=repeat_search()
      }
      if ( ! status ) {
         save_search(vi_old_search_string,vi_old_search_flags,vi_old_word_re);
      }
   }
   _show_selection(old_mark);
   _free_selection(mark);
   if ( status ) {
      restore_pos(p);
      vi_message(get_message(status));
      return(status);
   }

   return(0);
}


/* By default this command handles 'f' pressed */
_command vi_char_search_forward() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);

   return(vi_char_search('','',count));
}

/* By default this command handles 'F' pressed */
_command vi_char_search_backward() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);

   return(vi_char_search('','-',count));
}

/* By default this command handles 't' pressed */
/* This command puts the cursor before the character searched for */
_command vi_char_search_forward2() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);

   return(vi_char_search('<','',count));
}

/* By default this command handles 'T' pressed */
/* This command puts the cursor before the character searched for */
_command vi_char_search_backward2() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);

   return(vi_char_search('>','-',count));
}

/* By default this command handles ';' pressed */
_command vi_repeat_char_search() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);

   return(vi_char_search('R','',count));
}


/* By default this command handles ',' pressed */
_command vi_reverse_repeat_char_search() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   count=arg(1);

   return(vi_char_search('R','-',count));
}

/* By default this command handles 'm' pressed */
_command vi_set_mark() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   key=get_event();
   if ( isalpha(key) ) {
      status=set_bookmark('-r 'key);
      if ( status ) {
         message('Error setting bookmark');
      }
      return(status);
   } else {
      vi_message('Invalid key sequence');
      return(1);
   }
}

/* By default this command handles ')','}' pressed */
_command vi_maybe_keyin_match_paren() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   if ( def_vi_or_ex_showmatch!='' && def_vi_or_ex_showmatch ) {
      return(keyin_match_paren());
   } else {
      keyin(last_event());
   }

   return(0);
}

/* By default this command handles '~' pressed */
_command vi_toggle_case_char() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
      return(0);
   }
   vi_repeat_info(last_index(),last_event(),arg(1),arg(2));

   status=0;
   count=vi_repeat_info('C',arg(1));
   if( !isinteger(count) || count<1 ) {
      count=1;
   }
   len=_line_length();
   old_mark=_duplicate_selection('');
   mark=_alloc_selection();
   if( mark<0 ) {
      vi_repeat_info('A');   // Abort the keyboard macro recording
      vi_message(get_message(mark));
      return(1);
   }
   _select_char(mark,'IP');
   for( i=0;i<(count-1);++i ) {
      col=_text_colc(p_col,'P');
      if( col==len || (_dbcsIsLeadByte(get_text()) && col==len-1) ) {
         break;
      }
      right();
   }
   _select_char(mark,'IP');
   _show_selection(mark);
   filter_init();
   filter_get_string(str);
   len=length(str);
   new_str='';
   for( i=1;i<=len;++i ) {
      ch=substr(str,i,1);
      if( _dbcsIsLeadByte(ch) ) {
         ch=substr(str,i,2);
         ++i;   // Only increment by 1 so the loop gets it right the next time around
      }
      if( ch>='A' && ch<='Z' ) {
         ch=lowcase(ch);
      } else if( ch>='a' && ch<='z' ) {
         ch=upcase(ch);
      }
      new_str=new_str:+ch;
   }
   filter_put_string(new_str);
   filter_restore_pos();
   _end_select();
   _show_selection(old_mark);
   _free_selection(mark);
   vi_cursor_right();
   clear_message();   /* Clear the "Can't go past end of line" message
                       * possibly generated by vi-cursor-right
                       */

   if( status ) {
      vi_repeat_info('A');
   } else {
      this_idx=find_index('vi-toggle-case-char',COMMAND_TYPE)
      repeat_idx=vi_repeat_info('X');   // Get the index which started the recording
      if( repeat_idx && repeat_idx==this_idx ) {
         if( vi_repeat_info('I') ) {
            vi_repeat_info('E');   // End and save the currently recording keyboard macro
         }
      }
   }

   return(status);
}


/* By default this command handles TAB pressed */
_command vi_tab() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      } else {
         return(ctab());
      }
      return(0);
   }

   vi_message('Invalid key sequence');

   return(1);
}


