/*
$VerboseHistory: treeview.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:10:19a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 10:19a
 * Comment:
 * 
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:35p
 * Updated in \vault\vsship30\
 * Last Modified: 10/09/1997 02:28p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'

defeventtab _ul2_tree

int _ul2_tree.down,'C-K'()
{
   if (p_multi_select) {
      _TreeDeselectAll();
   }
#if 0
   status=_TreeDown();
   if (p_multi_select) {
      index=_TreeCurIndex();
      _TreeGetInfo(index,state,bm1,bm2,flags);
      _TreeSetInfo(index,state,bm1,bm2,flags|TREENODE_SELECTED);
   }
#else
   curindex=_TreeCurIndex();
   downindex=_TreeGetNextIndex(curindex);
   if (downindex>=0) {
      if (p_multi_select) {
         _TreeGetInfo(downindex,state,bm1,bm2,flags);
         _TreeSetInfo(downindex,state,bm1,bm2,flags|TREENODE_SELECTED);
      }
      _TreeDown();
   }else{
      return(BOTTOM_OF_FILE_RC);
   }
#endif
   return(0);
}

int _ul2_tree.up,'C-I'()
{
   if (p_multi_select) {
      _TreeDeselectAll();
   }
#if 0
   status=_TreeUp();
   if (p_multi_select) {
      index=_TreeCurIndex();
      _TreeGetInfo(index,state,bm1,bm2,flags);
      _TreeSetInfo(index,state,bm1,bm2,flags|TREENODE_SELECTED);
   }
#else
   curindex=_TreeCurIndex();
   upindex=_TreeGetPrevIndex(curindex);
   if (upindex>=0) {
      if (p_multi_select) {
         _TreeGetInfo(upindex,state,bm1,bm2,flags);
         _TreeSetInfo(upindex,state,bm1,bm2,flags|TREENODE_SELECTED);
      }
      _TreeUp();
   }else{
      return(TOP_OF_FILE_RC);
   }
#endif
   return(0);
}

void _ul2_tree.HOME()
{
   _TreeTop();
}

void _ul2_tree.END()
{
   _TreeBottom();
}

void _ul2_tree.PGUP,'C-P'()
{
   _TreePageUp();
}

void _ul2_tree.PGDN,'C-N'()
{
   _TreePageDown();
}

void _ul2_tree.ENTER,LBUTTON_DOUBLE_CLICK()
{
   index=_TreeCurIndex();
   _TreeGetInfo(index,OrigState);
   if (OrigState<0) {
      wid=p_window_id;
      call_event(CHANGE_LEAF_ENTER,index,p_window_id,ON_CHANGE,'w')
      p_window_id=wid;
      return;
   }
   //Have to call the event first so the user has a chance to fill things in
   //before _TreeSetState scrolls them.
   wid=p_window_id;
   new_index=call_event(OrigState?CHANGE_COLLAPSED:CHANGE_EXPANDED,index,p_window_id,ON_CHANGE,'w')
   p_window_id=wid;
   if (new_index!='') {
      _TreeSetInfo(new_index,(int)!OrigState);
   } else {
      _TreeSetInfo(index,(int)!OrigState);
   }
}

void _ul2_tree.right()
{
   index=_TreeCurIndex();
   if (index<0) return;
   _TreeGetInfo(index,state);
   if (!state) {
      wid=p_window_id;
      call_event(CHANGE_EXPANDED,index,p_window_id,ON_CHANGE,'w')
      p_window_id=wid;
      _TreeSetInfo(index,1);
   }else if (state>0) {
      ChildIndex=_TreeGetFirstChildIndex(index);
      if (ChildIndex<0) return;
      _TreeGetInfo(ChildIndex,state,bm1,bm2,flags);
      //Gotta keep hunting until we find a child that is not hidden
      while (flags&TREENODE_HIDDEN) {
         ChildIndex=_TreeGetNextSiblingIndex(ChildIndex);
         if (ChildIndex<0) break;
         _TreeGetInfo(ChildIndex,state,bm1,bm2,flags);
      }
      if (ChildIndex<0) return;
      _TreeSetCurIndex(ChildIndex);
   }
}


static int TreeFindSelected2(int index)
{
   for (;;) {
      _TreeGetInfo(index,state,bm1,bm2,flags);
      if (flags&TREENODE_SELECTED) {
         return(index);
      }
      index=_TreeGetNextIndex(index);
      if (index<0) break;
   }
   return(-1);
}

/*

   Finds next selected tree item.

   returns 0 if successful   
                                
   returns -1 if none available.

*/
int _TreeFindSelected(ff)
{
   static int index;
   if (ff) {
      if (p_ShowRoot) {
         index=TREE_ROOT_INDEX;
      }else{
         index=_TreeGetFirstChildIndex(TREE_ROOT_INDEX);
      }
   }else{
      index=_TreeGetNextIndex(index);
   }
   if (index<0) return(-1);
   index=TreeFindSelected2(index);
   return(index);
}


_ul2_tree.on_change(reason)
{
   p_user2=_TreeCurIndex();
}

static int TreeDeselectAll2(int index)
{
   for (;;) {
      _TreeGetInfo(index,state,bm1,bm2,flags);
      _TreeSetInfo(index,state,bm1,bm2,flags&~TREENODE_SELECTED);
      cindex=_TreeGetFirstChildIndex(index);
      if (cindex>=0) {
         return(cindex);
      }
      index=_TreeGetNextSiblingIndex(index);
      if (index<0) break;
   }
   return(-1);
}

void _TreeDeselectAll()
{
#if 0
   int index;
   if (p_ShowRoot) {
      index=TREE_ROOT_INDEX;
   }else{
      index=_TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   }
   TreeDeselectAll2(index);
#else
   _TreeSetAllFlags(0,TREENODE_SELECTED);
#endif
}

int _ul2_tree.s_down()
{
   OrigIndex=_TreeCurIndex();
   _TreeGetInfo(OrigIndex,OrigState,OrigBm1,OrigBm2,OrigFlags,OrigLine);

   _TreeGetSelInfo(Nofselected,FirstSelIndex,LastSelIndex);


   //int status=_TreeDown();
   //if (status) return(status);
   //10:58am 9/9/1998
   //_TreeDown sends an on_change, and we don't want the on_change to hit
   //until after the item is selected.  don't want to change _TreeDown because
   //a few other things call it.  So we will jump through hoops here
   int NextIndex=_TreeGetNextIndex(OrigIndex);
   if (NextIndex<0) return(BOTTOM_OF_FILE_RC);

   CurIndex=NextIndex;//_TreeCurIndex();
   _TreeGetInfo(CurIndex,CurState,CurBm1,CurBm2,CurFlags,CurLine);

   if (p_multi_select) {
      if (Nofselected) {

         _TreeGetInfo(LastSelIndex,
                      LastSelState,
                      LastSelBm1,
                      LastSelBm2,
                      LastSelFlags,
                      LastSelLine);

         if (CurLine>LastSelLine) {
            _TreeSetInfo(CurIndex,CurState,CurBm1,CurBm2,CurFlags|TREENODE_SELECTED);
         }else{
            _TreeSetInfo(OrigIndex,OrigState,OrigBm1,OrigBm2,OrigFlags&~TREENODE_SELECTED);
         }
      }else{
         _TreeSetInfo(CurIndex,CurState,CurBm1,CurBm2,CurFlags|TREENODE_SELECTED);
         _TreeSetInfo(OrigIndex,OrigState,OrigBm1,OrigBm2,OrigFlags|TREENODE_SELECTED);
      }
   }
   _TreeDown();
   return(0);
}

int _ul2_tree.s_up()
{
   OrigIndex=_TreeCurIndex();
   _TreeGetInfo(OrigIndex,OrigState,OrigBm1,OrigBm2,OrigFlags,OrigLine);

   _TreeGetSelInfo(Nofselected,FirstSelIndex,LastSelIndex);


   //int status=_TreeUp();
   //if (status) return(status);
   //10:58am 9/9/1998
   //_TreeDown sends an on_change, and we don't want the on_change to hit
   //until after the item is selected.  don't want to change _TreeDown because
   //a few other things call it.  So we will jump through hoops here
   PrevIndex=_TreeGetPrevIndex(OrigIndex);
   if (PrevIndex<0) return(TOP_OF_FILE_RC);

   CurIndex=PrevIndex;//_TreeCurIndex();
   _TreeGetInfo(CurIndex,CurState,CurBm1,CurBm2,CurFlags,CurLine);

   if (p_multi_select) {
      if (Nofselected) {

         _TreeGetInfo(FirstSelIndex,
                      FirstSelState,
                      FirstSelBm1,
                      FirstSelBm2,
                      FirstSelFlags,
                      FirstSelLine);

         if (CurLine<FirstSelLine) {
            _TreeSetInfo(CurIndex,CurState,CurBm1,CurBm2,CurFlags|TREENODE_SELECTED);
         }else{
            _TreeSetInfo(OrigIndex,OrigState,OrigBm1,OrigBm2,OrigFlags&~TREENODE_SELECTED);
         }
      }else{
         _TreeSetInfo(CurIndex,CurState,CurBm1,CurBm2,CurFlags|TREENODE_SELECTED);
         _TreeSetInfo(OrigIndex,OrigState,OrigBm1,OrigBm2,OrigFlags|TREENODE_SELECTED);
      }
   }
   _TreeUp();
   return(0);
}

void _ul2_tree.' '()
{
   index=_TreeCurIndex();
   _TreeGetInfo(index,state,bm1,bm2,flags);
   _TreeSetInfo(index,state,bm1,bm2,flags|TREENODE_SELECTED);
}

void _ul2_tree.lbutton_down()
{
   x=mou_last_x();
   y=mou_last_y();
   index=_TreeGetIndexFromPoint(x,y,'P');
   if (index>=0) {
      _TreeSetCurIndex(index);
      if (p_multi_select!=MS_NONE) {
         _TreeDeselectAll();
         _TreeGetInfo(index,state,bm1,bm2,flags);
         _TreeSetInfo(index,state,bm1,bm2,flags|TREENODE_SELECTED);
      }
   }
}

void _ul2_tree.rbutton_down()
{
   x=mou_last_x();
   y=mou_last_y();
   index=_TreeGetIndexFromPoint(x,y,'P');
   if (index>=0) {
      _TreeSetCurIndex(index);
   }
}

void _ul2_tree."c-lbutton-down"()
{
   x=mou_last_x();
   y=mou_last_y();
   index=_TreeGetIndexFromPoint(x,y,'P');
   if (index>=0) {
      if (p_multi_select!=MS_NONE) {
         _TreeGetInfo(index,state,bm1,bm2,flags);
         if (flags&TREENODE_SELECTED) {
            _TreeSetInfo(index,state,bm1,bm2,flags&~TREENODE_SELECTED);
         }else{
            _TreeSetInfo(index,state,bm1,bm2,flags|TREENODE_SELECTED);
         }
      }
      _TreeSetCurIndex(index);
      //call_event(index,p_window_id,ON_CHANGE,'W');
      //Don't need this because _TreeSetCurIndex calls event
   }
}

static int MyTreeGetPrevIndex(index) {return(_TreeGetPrevIndex(index));}
static int MyTreeGetNextIndex(index) {return(_TreeGetNextIndex(index));}


static void TreeShiftSelect2(int NumSelected,int OrigLN,int NewLN,
                             int OrigIndex,typeless pfn)
{
   /*
      If one or less nodes are selected, we can pretty much just go ahead
      and select from the original position to the new position.  The
      only glitch is the state of the original line.  If it is not selected,
      we select it.  If it is selected, we leave it alone
   */
   int extra=0;
   //Going up...
   if (NumSelected==1) {
      //Start one line up
      index=(*pfn)(OrigIndex);
   }else{
      index=OrigIndex;
      extra=1;
   }
   diff=OrigLN-NewLN;
   if (diff<0) diff=-diff;
   for (i=0;i<diff+extra;++i) {
      _TreeGetInfo(index,state,bm1,bm2,flags);
      _TreeSetInfo(index,state,bm1,bm2,flags|TREENODE_SELECTED);
      index=(*pfn)(index);
      if (index<0) break;//Can't happen
   }
}

static void TreeShiftSelect3(int NumSelected,int OrigLN,int NewLN,
                             int OrigIndex,int NewIndex,typeless pfn)
{
   /*
      If one or less nodes are selected, we can pretty much just go ahead
      and select from the original position to the new position.  The
      only glitch is the state of the original line.  If it is not selected,
      we select it.  If it is selected, we leave it alone
   */
   diff=OrigLN-NewLN;
   _TreeGetSelInfo(NumSelected,FirstSelectedIndex,LastSelectedIndex);
   if (FirstSelectedIndex>=0) {
      _TreeGetInfo(FirstSelectedIndex,state,bm1,bm2,flags,FirstLN);
   }
   if (LastSelectedIndex>=0) {
      _TreeGetInfo(LastSelectedIndex,state,bm1,bm2,flags,LastLN);
   }
   _TreeGetInfo(OrigIndex,state,bm1,bm2,flags,OrigLN);
   _TreeGetInfo(NewIndex,state,bm1,bm2,flags,NewLN);
   int index=-1;
   boolean SelectingDown=false,CrossingOver=false;
   if (OrigLN<NewLN && LastSelectedIndex==OrigIndex) {
      index=(*pfn)(LastSelectedIndex);
   }else if (OrigLN>NewLN && FirstSelectedIndex==OrigIndex) {
      index=(*pfn)(FirstSelectedIndex);
   }else if (OrigLN>NewLN && LastSelectedIndex==OrigIndex) {
      index=LastSelectedIndex;
   }else if (OrigLN<NewLN && FirstSelectedIndex==OrigIndex) {
      index=FirstSelectedIndex;
   }else{
      index=(*pfn)(OrigIndex);
   }
   if (OrigLN<NewLN) {
      SelectingDown=true;
   }
   boolean ContiguousSelection=true;
   tindex=FirstSelectedIndex;
   for (i=0;i<LastLN-FirstLN;++i) {
      if (tindex<0) break;
      _TreeGetInfo(tindex,state,bm1,bm2,flags);
      if (!(flags&TREENODE_SELECTED)) {
         ContiguousSelection=false;
         break;
      }
      tindex=_TreeGetNextIndex(tindex);
   }
   if (!ContiguousSelection) {
      index=OrigIndex;
   }

   //say('OrigLN='OrigLN' NewLN='NewLN);
   int CrossOverIndex=-1;
   if (ContiguousSelection) {
      if (SelectingDown) {
         CrossingOver=(OrigIndex==FirstSelectedIndex) && (NewLN>LastLN);
         if (CrossingOver) {
            CrossOverIndex=LastSelectedIndex;
         }
      }else{
         CrossingOver=(OrigIndex==LastSelectedIndex)  && (NewLN<FirstLN);
         if (CrossingOver) {
            CrossOverIndex=FirstSelectedIndex;
         }
      }
   }
   int extra=0;
   if (CrossingOver || !ContiguousSelection) {
      extra=1;
   }

   if (diff<0) diff=-diff;
   for (i=0;i<diff+extra;++i) {
      _TreeGetInfo(index,state,bm1,bm2,flags);
      if (flags&TREENODE_SELECTED &&
          index!=CrossOverIndex &&
          /*index!=FirstSelectedIndex &&*/
          ContiguousSelection) {
         _TreeSetInfo(index,state,bm1,bm2,flags&~TREENODE_SELECTED);
      }else{
         _TreeSetInfo(index,state,bm1,bm2,flags|TREENODE_SELECTED);
      }
      index=(*pfn)(index);
      if (index<0) break;//Can't happen
   }
}

void _ul2_tree."s-lbutton-down"()
{
   x=mou_last_x();
   y=mou_last_y();
   
   int OrigIndex=_TreeCurIndex();
   NewIndex=_TreeGetIndexFromPoint(x,y,'P');
   if (NewIndex<0) return;
   _TreeGetSelInfo(NumSelected,FirstSelected,LastSelected);
   _TreeGetInfo(OrigIndex,state,bm1,bm2,flags,OrigLN);
   _TreeGetInfo(NewIndex,state,bm1,bm2,flags,NewLN);
   int FirstSelectedLN=-1,LastSelectedLN=-1;
   if (FirstSelected>=0) {
      _TreeGetInfo(FirstSelected,state,bm1,bm2,flags,FirstSelectedLN);
   }
   if (LastSelected>=0) {
      _TreeGetInfo(LastSelected,state,bm1,bm2,flags,LastSelectedLN);
   }
   if (NumSelected<=1) {
      int extra=0;
      if (NewLN<OrigLN) {
         pfn=MyTreeGetPrevIndex;
      }else{
         pfn=MyTreeGetNextIndex;
      }
      TreeShiftSelect2(NumSelected,OrigLN,NewLN,OrigIndex,pfn);
   }else{
      int extra=0;
      if (NewLN<OrigLN) {
         pfn=MyTreeGetPrevIndex;
      }else{
         pfn=MyTreeGetNextIndex;
      }
      TreeShiftSelect3(NumSelected,OrigLN,NewLN,OrigIndex,NewIndex,pfn);
   }
   _TreeSetCurIndex(NewIndex);
}

void _ul2_tree.left()
{
   index=_TreeCurIndex();
   if (index<0) return;
   _TreeGetInfo(index,state);
   if (state>0) {
      wid=p_window_id;
      call_event(CHANGE_COLLAPSED,index,p_window_id,ON_CHANGE,'w')
      p_window_id=wid;
      _TreeSetInfo(index,0);
   }else{
      ParentIndex=_TreeGetParentIndex(index);
      if (ParentIndex>=0 && 
          (p_ShowRoot || ParentIndex!=TREE_ROOT_INDEX)) {
         _TreeSetCurIndex(ParentIndex);
      }
   }
}

void _ul2_tree.'Pad-Minus'()
{
   index=_TreeCurIndex();
   _TreeGetInfo(index,state);
   if (state<0) {
      return;
   }
   wid=p_window_id;
   call_event(CHANGE_COLLAPSED,index,p_window_id,ON_CHANGE,'w')
   p_window_id=wid;
   _TreeSetInfo(index,0);
}

void _ul2_tree.'Pad-Plus'()
{
   index=_TreeCurIndex();
   _TreeGetInfo(index,state);
   if (state<0) {
      return;
   }
   wid=p_window_id;
   call_event(CHANGE_EXPANDED,index,p_window_id,ON_CHANGE,'w')
   p_window_id=wid;
   _TreeSetInfo(index,1);
}

int TreeAddItemMacro(/*int TreeWindowID,*/
                     int RelativeIndex,
                     _str Caption,
                     int Flags,
                     int NonCurrentBMIndex,
                     int CurrentBMIndex,
                     int State)
{
   index=/*TreeWindowID.*/_TreeAddItem(RelativeIndex,
                                       Caption,
                                       Flags,
                                       NonCurrentBMIndex,
                                       CurrentBMIndex,
                                       State);
   return(index);
}

void TreeSetUserInfoMacro(int Index,
                          typeless info)
{
   _TreeSetUserInfo(Index,info);
   //say('p_window_id='p_window_id' p_object='p_object);
}

void TreeDisablePopup(int &Delay)
{
   Delay=p_delay;
   p_delay=-1;
   _bbhelp('C');
}

void TreeEnablePopup(int Delay)
{
   p_delay=Delay;
}

// incremental searching
void _ul2_tree.\33-\255()
{
   // get current index and parent, done if root
   currIndex = _TreeCurIndex();
   if (currIndex <= 0) {
      return;
   }
   parentIndex = _TreeGetParentIndex(currIndex);

   // get last key event, skip space
   key=last_event();
#if 0
   if (key:==' ') {
      call_event(defeventtab _ul2_tree,' ','E');
      return;
   }
#endif

   // search for item with this prefix
   newIndex=_TreeSearch(currIndex, key, 'PIS');

   // didn't find it, start from top
   if (newIndex <= 0) {
      newIndex=_TreeSearch(parentIndex, key, 'PI');
      if (newIndex < 0) {
         return;
      }
   }

   if (newIndex>=0) {
      // select the item
      _TreeSetCurIndex(newIndex);
   }
}  
