/*
$VerboseHistory: tags.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:10:17a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 10:17a
 * Comment:
 * Added support for faster tagging.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:35p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
/*
   This module is a general purpose engine for providing searching and
   completion for tagged function names.  To avoid update problems, do not
   modify this file or "maketags.e" if possible.  Place your tag support
   procedures for other languages in another file. See below.

   To add support for another language define two global (not static)
   procedures with the following name format and function:

   _str "ext"_tag_case()

          Returns "e" for case sensitive languages and
          "i" for case insensitive languages.

   int "ext"_proc_search(_str &proc_name,int find_first,
                         _str ext[,int StartOfs])
          If proc_name is null, this function searches for a valid
          procedure in the current buffer.  If successful,
          proc_name is set to the procedure name and 0 is
          returned.  The find_first parameter when non-zero
          indicates that the first search is being performed.

          If proc_name is NOT null, this function searches for the
          definition of the procedure proc_name in the current
          buffer.  If successful, cursor is placed on procedure
          definition and 0 is returned.  See one of the procedures
          pas_proc_search, or asm_proc_search for an example.  Use
          the find_proc command to find one of the macro procedures
          above.  Note that "c_proc_search" has been defined by the
          cparse.dll (c++ source is not provided for this DLL).

          StartOfs, offset in bytes from the beginning of the buffer
          of the cursor position.  StartOfs, is only given when
          findfirst!=0 and you are not starting from the top of a
          buffer.  The next_proc command uses this argument.  This
          argument is redundent information because you can
          determine this value from the cursor position.  Recursive
          descent parsers written in a DLL may find this handy.

   vs"ext"_list_tags(int output_view_id,_str filename,_str ext)
          (optional) While the "ext"_proc_search function can do
          everything thats required, you might find it difficult to
          restart a recursive descent parser in the middle of some
          calls.

          From a DLL:

             This function uses vsActivateView(output_view_id)
             and vsInsertLine to lists all the tags for
             filename at once.

          From a Slick-C macro:

             This function uses activate_view and
             insert_line to lists all the tags for a
             file at once.

          For DLL or Slick-C macro, the format of the lines that is
          inserted is as follows:

            tagname(tagtype)

                 OR JUST

            tagname

          Note that tagtype can be anything you want
          but use the following conventions:

            var          A variable definition
            proc         A function/procedure definition
            proto        A prototype/forward declaration for a
                         function/procedure
            ClassName:proc    A function/procedure definition for class
                              ClassName
            ClassName:proto   A prototype/forward declaration for a
                              function/procedure for class ClassName.

   "ext" is the extension of the file.
   If you do not provide the "ext"_tag_case function, 'i' is assumed.


   NOTE: Any of the above functions may be defined in a DLL by using
   the vsDllExport DLL Interface function.  See sample.c for an a
   sample dll which interfaces with Visual SlickEdit.  Use VSPSZ
   in place of "_str" argument types except for call by reference
   strings.  For call by reference string arguments use "VSHREFVAR".

   DllExport examples:
      vsDllExport("int c_proc_search(VSHREFVAR proc_name,int find_first,VSHVAR ext)",0,0);
      vsDllExport("int vsc_list_tags(int output_view_id,VSPSZ filename,VSPSZ ext)",0,0);

*/
#include 'slick.sh'

/*#define TAG_TYPES_LIST   ('*.c *.h *.cpp *.cxx,':+\
                          '*.asm,':+\
                          '*.pas,':+\
                          '*.for *.f,':+\
                          '*.cob *.cbl,':+\
                          '*.mod,':+\
                          '*.bas,':+\
                          '*.ada,':+\
                          '*.prg,':+\
                          '*.pl,':+\
                          '*.awk,':+\
                          '*.tcl,':+\
                          '*.cmd')
*/

#define SUPPORTED_TYPES   ('for=fortran':+\
                          ' f=fortran':+\
                          ' cob=cobol':+\
                          ' cbl=cobol':+\
                          ' mod=modula':+\
                          ' bas=msqbas':+\
                          ' prg=prg':+\
                          ' ada=ada':+\
                          ' adb=ada':+\
                          ' ads=ada':+\
                          ' pl=perl':+\
                          ' pm=perl':+\
                          ' awk=awk':+\
                          ' tcl=tcl':+\
                          ' tlib=tcl':+\
                          ' cmd=rexx':+\
                          ' rul=rul':+\
                          ' pro=pro')

//int def_include_protos = 0;

static _str old_tag_case,old_tag_ext;


static boolean gTagCallList:[];
void _TagDelayCallList()
{
   gNoTagCallList=1;
   gTagCallList._makeempty();
}
static _str TagMakeIndex(...)
{
   return(arg(1):+_chr(0):+arg(2):+_chr(0):+arg(3));
}
void _TagCallList(...)
{
   if (_in_firstinit) {
      // We are not off the ground yet
      // We get when load macro in first init
      return;
   }
   if (arg(1)==TAGFILE_ADD_REMOVE_CALLBACK_PREFIX) {
      gtag_filelist_cache_updated=false;
   }
   if (gNoTagCallList) {
      i=TagMakeIndex(arg(1),arg(2),arg(3));
      gTagCallList:[i]=true;
      return;
   }
   call_list(arg(1),arg(2),arg(3));
}
void _TagProcessCallList()
{
   gNoTagCallList=0;
   tag_refresh_i=TagMakeIndex(TAGFILE_REFRESH_CALLBACK_PREFIX);
   DoRefresh=gTagCallList._indexin(tag_refresh_i);
   for (i._makeempty();;) {
      gTagCallList._nextel(i);
      if (i._isempty()) break;
      if (i==tag_refresh_i) {
         continue;
      }
      parse i with a1 (_chr(0)) a2 (_chr(0)) a3;
      call_list(a1,a2,a3);
   }
   if (DoRefresh) {
      call_list(TAGFILE_REFRESH_CALLBACK_PREFIX);
   }
}

static boolean _gin_update_tagfile_cache;
void _update_tag_filelists()
{
   if (!gtag_filelist_cache_updated && !_gin_update_tagfile_cache) {
      _gin_update_tagfile_cache=1;
      _update_tag_filelist2();
      _gin_update_tagfile_cache=0;
   }
}
static _str gtag_filelist_last_ext;
void _update_tag_filelist_ext(_str ext)
{
   _update_tag_filelists();
   if (gtag_filelist_last_ext==ext) {
      return;
   }
   //say('update gtag_filelist_last_ext');
   //gtag_filelist_ext._makeempty();
   tag_filelist=tags_filename(false,ext,true);
   gtag_filelist_ext._makeempty();
   //say("tag_filelist="tag_filelist);
   for (;;) {
      parse tag_filelist with tag_filename (PATHSEP) tag_filelist;
      if (tag_filename=='') {
         break;
      }
      //say("   tag_filename="tag_filename);
      gtag_filelist_ext[gtag_filelist_ext._length()]=tag_filename;
   }
   gtag_filelist_last_ext=ext;
}
static void _update_tag_filelist2()
{
   gtag_filelist_cache_updated=false;
   //say('_update_tag_filelist2');
   gtag_filelist_last_ext="";
   gtag_filelist_ext._makeempty();
   gtag_filelist._makeempty();
   _str tag_filelist=tags_filename();
   for (;;) {
      parse tag_filelist with tag_filename (PATHSEP) tag_filelist;
      if (tag_filename=='') {
         break;
      }
      gtag_filelist[gtag_filelist._length()]=tag_filename;
   }
   gtag_filelist_project._makeempty();
   tag_filelist=project_tags_filename();
   for (;;) {
      parse tag_filelist with tag_filename (PATHSEP) tag_filelist;
      if (tag_filename=='') {
         break;
      }
      gtag_filelist_project[gtag_filelist_project._length()]=tag_filename;
   }
   gtag_filelist_cache_updated=true;
}

typedef _str STRARRAY[];

STRARRAY tags_filenamea(_str ext="")
{
   if (ext=="") {
      _update_tag_filelists();
      return(gtag_filelist);
   }
   _update_tag_filelist_ext(ext);
   return(gtag_filelist_ext);
}
_str tags_filename(boolean doRelative=false,_str ext="",boolean includeSlickC=true)
{
   static int in_tags_filename;
   if (!doRelative && !in_tags_filename) {
      in_tags_filename=1;
      if (ext!="") {
         _update_tag_filelist_ext(ext);
      } else {
         _update_tag_filelists();
      }
      in_tags_filename=0;
      if (gtag_filelist_cache_updated) {
         if (ext!="") {
            result="";
            for (i=0;i<gtag_filelist_ext._length();++i) {
               if (result=="") {
                  result=gtag_filelist_ext[i];
               } else {
                  result=result:+PATHSEP:+gtag_filelist_ext[i];
               }
            }
            //say(result);
            //say('optimize ext tag files');
            return(result);
         } else if (includeSlickC) {
            result="";
            for (i=0;i<gtag_filelist._length();++i) {
               if (result=="") {
                  result=gtag_filelist[i];
               } else {
                  result=result:+PATHSEP:+gtag_filelist[i];
               }
            }
            //say(result);
            //say('optimize all tag files');
            return(result);
         }
      }
   }
   project_tagfiles='';
   if (_project_name!='' && ext!='e') {
      if (!doRelative && gtag_filelist_cache_updated) {
         project_tagfiles="";
         for (i=0;i<gtag_filelist_project._length();++i) {
            if (project_tagfiles=="") {
               project_tagfiles=gtag_filelist_project[i];
            } else {
               project_tagfiles=project_tagfiles:+PATHSEP:+gtag_filelist_project[i];
            }
         }
         //say(project_tagfiles);
         //say('optimize project tag files');
      } else {
         _ini_get_value(_project_name,"COMPILER","TAGFILES",project_tagfiles);
         project_tagfiles=_parse_project_command(project_tagfiles, '', _project_get_filename(),'');
         if (project_tagfiles=='') {
            project_tagfiles=strip_filename(_project_name,'E'):+TAG_FILE_EXT:+PATHSEP;
         }
      }
   }
   _str filename=get_env(_SLICKTAGS);
   // Only use tag files which have files for the
   // correct extension
   if (!doRelative && ext!='') {
      // IF any global tag files to convert to extension specific
      if (filename!="") {
         if (project_tagfiles!="" && last_char(project_tagfiles)!=PATHSEP) {
            project_tagfiles=project_tagfiles:+PATHSEP;
         }
         project_tagfiles=project_tagfiles:+filename;
         filename="";  // Global tag files processed.
      }
      list=project_tagfiles;project_tagfiles="";
      // save the name of the 'original' open tag file
      _str orig_tag_db = tag_current_db();
      for (;;) {
         parse list with tag_filename (PATHSEP) list;
         if (tag_filename=="") {
            break;
         }
         tag_filename=absolute(tag_filename);
         int status= tag_read_db(tag_filename);
         if (!status) {
            // get the files from the database
            status=tag_find_file(srcfilename);
            if (!status) {
               tempext=_bufname2ext(srcfilename);
               if (tempext==ext) {
                  status=1;
               }
            }
         }
         if (status) {
            if (project_tagfiles=="") {
               project_tagfiles=tag_filename;
            } else {
               project_tagfiles=project_tagfiles:+PATHSEP:+tag_filename;
            }
         }
      }
      // restore the 'current' tag file open for read
      if (orig_tag_db != '') {
         tag_read_db(orig_tag_db);
      }
   }
   if (project_tagfiles!="" && last_char(project_tagfiles)!=PATHSEP) {
      project_tagfiles=project_tagfiles:+PATHSEP;
   }

   if (ext!="" && index_callable(find_index(ext'_proc_search',PROC_TYPE))) {
      index=find_index('def-tagfiles-'ext,MISC_TYPE);
      info=_replace_envvars(name_info(index));
      if (info!='') {
         if (filename=='') {
            filename=info;
         } else {
            if (last_char(filename)==PATHSEP) {
               filename=filename:+info;
            } else {
               filename=filename:+PATHSEP:+info;
            }
         }
      }
   } else {
      for (ff=1;;) {
         index=name_match('def-tagfiles-',ff,MISC_TYPE);ff=0;
         if (!index) {
            break;
         }
         info=_replace_envvars(name_info(index));
         if (info!='' && ((includeSlickC && ext=="") || name_name(index)!='def-tagfiles-e')) {
            if (filename=='') {
               filename=info;
            } else {
               if (last_char(filename)==PATHSEP) {
                  filename=filename:+info;
               } else {
                  filename=filename:+PATHSEP:+info;
               }
            }
         }
      }
   }
   /*if ( filename=='' ) {
      filename=SLICK_TAGS_DB;
   } */
   duplist=project_tagfiles:+filename;
   // Remove duplicate tag files
   list='';
   for (;;) {
      parse duplist with TagFilename (PATHSEP) duplist;
      if (TagFilename=='') {
         break;
      }
      if (!doRelative) {
         TagFilename=absolute(TagFilename);
      }
      if (pos(PATHSEP:+TagFilename:+PATHSEP,PATHSEP:+list:+PATHSEP,1,_fpos_case)) {
         continue;
      }
      if (list=='') {
         list=TagFilename
      } else {
         list=list:+PATHSEP:+TagFilename;
      }
   }
   return(list);
}
_str global_tags_filename(boolean doRelative=false)
{
   filename=get_env(_SLICKTAGS);
   /*if ( filename=='' ) {
      filename=SLICK_TAGS_DB;
   }*/
   if (!doRelative) {
      return(AbsoluteList(filename));
   }
   return filename;
}
// Returns 1 if the def-var was actually changed, 0 otherwise
int _set_listvar(_str name, _str list, boolean append=false)
{
   int index=find_index(name,MISC_TYPE);
   if (!index) {
      if (list!='') {
         insert_name(name,MISC_TYPE,list);
         return(1);
      }
   } else {
      if (list=='') {
         delete_name(index);
         return(1);
      } else {
         _str old_list=name_info(index);
         if (append) {
            // Append only works if items in same order or only adding one.
            if (!pos(PATHSEP:+list:+PATHSEP,PATHSEP:+old_list:+PATHSEP,1,_fpos_case)) {
               if (last_char(old_list)!=PATHSEP) {
                  old_list=old_list:+PATHSEP;
               }
               old_list=old_list:+list;
               set_name_info(index,old_list);
               return(1);
            }
         } else {
            if (list != old_list) {
               set_name_info(index,list);
               return(1);
            }
         }
      }
   }
   return(0);
}
_command void set_exttagfiles(_str cmdline='',boolean append=false)
{
   parse cmdline with ext list;
   if (ext=='') {
      return;
   }
   if (substr(ext,1,1)=='.') {
      ext=substr(ext,2);
   }
   ext=refer_ext(_file_case(ext));
   list=_encode_vsroot(list,true,false);
   if (_set_listvar('def-tagfiles-'ext, list, append)) {
      _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,'','');
      _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
   }
}
_command void set_extkillfcts(_str cmdline='',boolean append=false)
{
   parse cmdline with ext list;
   if (ext=='') {
      return;
   }
   if (substr(ext,1,1)=='.') {
      ext=substr(ext,2);
   }
   ext=refer_ext(_file_case(ext));
   if (_set_listvar('def-killfcts-'ext, list, append)) {
      _config_modify|=CFGMODIFY_DEFDATA;
   }
}
_str project_tags_filename(boolean doRelative=false)
{
   _str project_tagfiles='';
   if (_project_name!='') {
      _ini_get_value(_project_name,"COMPILER","TAGFILES",project_tagfiles);
      project_tagfiles=_parse_project_command(project_tagfiles, '', _project_get_filename(),'');
      if (project_tagfiles=='') {
         project_tagfiles=strip_filename(_project_name,'E'):+TAG_FILE_EXT;
      }
   }
   if (!doRelative) {
      return(AbsoluteList(project_tagfiles));
   }
   return(project_tagfiles)
}
_str refs_filename()
{
   _str filename;
   if (_project_name!='') {
      _ini_get_value(_project_name,"COMPILER","REFFILE",filename);
   } else {
      // filename=get_env(_SLICKREFS);
      filename='';
   }
   if (filename=='') {
      return '';
   }
   return absolute(filename)
}
_str AbsoluteList(_str taglist)
{
   list='';
   for (;;) {
      parse taglist with TagFilename (PATHSEP) taglist;
      if (TagFilename=='') break;
      TagFilename=absolute(TagFilename);
      if (list=='') {
         list=TagFilename;
      } else {
         list=list:+PATHSEP:+TagFilename;
      }
   }
   return(list);
}
/*
    Use the p_LangCaseSensitive property instead of this
    function to determine the language case sensitivity.
*/
_str tag_case(filename)
{
   ext=arg(2);
   if (arg(2)!='') {
      ext=_file_case(get_extension(filename));
   }
   if ( ext==old_tag_ext ) {
      return(old_tag_case)
   }
   ext=refer_ext(ext,filename);
   old_tag_ext=ext;
   if ( def_ignore_tcase ) {
      old_tag_case='i'
   // ELSEIF  c or C (c++ on UNIX) OR a macro source extension
   } else if ( lowcase(ext)=='c' || file_eq('.'ext,_macro_ext) || file_eq(ext,'sh')) {
      old_tag_case='e'
   } else if ( file_eq(ext,'pas') || file_eq(ext,'asm') ) {  /* Case insensitive language? */
      old_tag_case='i'
   } else {
      index=find_index(ext'-tag-case',PROC_TYPE)
      if ( index_callable(index) ) {
         old_tag_case=call_index(ext,index)
      } else {
         old_tag_case='i'
      }
   }
   return(old_tag_case)

}
_str tag_match(_str name,int find_first,_str ext="")
{
   //_message_box("got here (tag_match)");
   if ( find_first ) {
      if ( find_first:==2 ) {
         tag_match2('','',2)
         return('')
      }
      // If someone has moved their tag files so the file existance
      // check fails, or tag files have gone corrupt, then they need
      // a different warning than someone who simply has no tag files.
      _str tag_files = tags_filename(false,ext,false);
      if (warn_if_no_tag_files(tag_files)) {
         return('');
      }
      filename = next_tag_file(tag_files, true, false, true);
   }
   for (;;) {
      /* filename does not have to be initialized unless find_first=1 */
      found_name=tag_match2(filename,name,find_first);
      if ( found_name!='' ) {
         //_message_box('filename='filename' found_name='found_name' findfirst='find_first)
         return(found_name);
      }
      // We can get away with passing in '' to next_tag_file
      // because next_tag_file doesn't even use the tag file
      // list when find_first is false.
      //filename=next_tag_file(tag_files,false)
      filename=next_tag_file('',false,false,true);
      if ( filename=='' ) {
         return('')
      }
      /* Remove the previous file. */
      tag_match2('','',2);
      find_first=1;
   }
}
static _str tag_match2(filename,name,find_first)
{
   static _str rejected_ext;
   name=translate(name,'_','-')
   if ( find_first ) {
      rejected_ext = '#';
      if ( find_first==2 ) {
         tag_close_db('',1);
         return('')
      }
      status = tag_read_db(absolute(filename));
      if ( status ) {
         if ( status==NEW_FILE_RC || status==FILE_NOT_FOUND_RC) {
            messageNwait(nls("Tag file '%s' not found",filename)". ":+
              nls("Type a key"));
         } else {
            messageNwait(nls("Error reading tag file '%s'",filename)". "get_message(status));
         }
         return('')
      }
      old_tag_ext='';
      status=tag_find_prefix(name);
   } else {
      status=tag_next_prefix(name);
   }
   while (!status) {
      tag_get_detail(VS_TAGDETAIL_type, tag_type);
      tag_get_detail(VS_TAGDETAIL_flags, tag_flags);
      tag_get_detail(VS_TAGDETAIL_file_name, source_file);
      if (!(tag_flags & VS_TAGFLAG_anonymous) && 
          tag_type:!='import' && tag_type:!='friend') {
         // filter out tags coming from load-tags
         _str ext = lowcase(get_extension(source_file));
         if (ext:==rejected_ext || find_index('vs'ext'_load_tags',PROC_TYPE)) {
            rejected_ext = ext;
         } else {
            break;
         }
      }
      status = tag_next_prefix(name);
   }
   if (status) {
      return('');
   }

   tag_get_detail(VS_TAGDETAIL_name, tag_name);
   tag_get_detail(VS_TAGDETAIL_class_name, class_name);
   //tag_get_info(tag_name, tag_type, filename, dummy_line_no, class_name, tag_flags);
   return tag_tree_compose_tag(tag_name, class_name, tag_type);
}
#if 0
typeless tag_binsrch(key)
{
   top
   start_point=0
   /* Skip over path data if it is there. */
   get_line line
   if ( last_char(line)==FILESEP ) {
      search '%'
      _begin_line
      start_point=point()
   }
   key_len=length(key)
   bottom
   get_line line
   buf_size=(int)point()+length(line)+length(p_newline)-start_point
   for (;;) {
      mid=start_point+buf_size intdiv 2
      goto_point mid
      get_line line;
      mid_key=upcase(substr(line,1,key_len));
      if ( mid_key<key ) {
         old_buf_size=buf_size
         buf_size=start_point+buf_size-(int)point()
         start_point=point()
         if ( old_buf_size==buf_size ) {
            down
            if ( rc ) {
               return(1);
            }
            buf_size=buf_size- ((int)point()-start_point)
            start_point=point()
         }
         /* messageNwait('buf_size='buf_size) */
      } else if ( mid_key>key ) {
         old_buf_size=buf_size
         buf_size=(int)point()-start_point
         if ( old_buf_size==buf_size ) {
            return(1)
         }
         /* messageNwait('buf_size='buf_size) */
      } else {
         for (;;) {
            up
            get_line line
            if ( _on_line0() || last_char(line)==FILESEP ) {
               down
               return(0)
            }
            if ( upcase(substr(line,1,key_len))!=key ) {
               down
               return(0)
            }
         }
         return(0)
      }
/*
      if buf_size<8000 then
         return(1)
      endif
*/
   }

}
#endif

void _xlat_old_vslicktags()
{
   _str next_tag_file_list=get_env(_SLICKTAGS);
   if (next_tag_file_list=="") {
      return;
   }
   /*
       Convert VSE <=2.0 tag file extensions to
       >=3.0 tag file extensions
   */
   new_tag_list="";
   for (;;) {
      parse next_tag_file_list with tag_file (PATHSEP) next_tag_file_list;
      if (tag_file=="" && next_tag_file_list=="") {
         break;
      }
      if(file_eq(get_extension(tag_file),'slk')) {
         tag_file=strip_filename(tag_file,'e')'.vtg';
      }
      if (new_tag_list=="") {
         new_tag_list=tag_file
      } else {
         new_tag_list=new_tag_list:+PATHSEP:+tag_file;
      }
   }
   /*
       Convert global tag files to extension specific tag 
       files.
   */
   list=new_tag_list;
   for (;;) {
      parse list with tag_filename (PATHSEP) list;
      if (tag_filename=="") {
         break;
      }
      tag_filename=absolute(tag_filename);
      int status= tag_read_db(tag_filename);
      if (!status) {
         // get the files from the database
         status=tag_find_file(srcfilename);
         if (!status) {
            ext=_bufname2ext(srcfilename);
            if (ext!="" && ext!="fundamental") {
               _str new_ext_tag_files = _encode_vsroot(tag_filename, true, false);
               _set_listvar('def-tagfiles-'ext, new_ext_tag_files, true);
            }
         }
      }
   }
   // Delete this environment variable from the vslick.ini file
   new_tag_file_list._makeempty();
   _ConfigEnvVar(_SLICKTAGS,new_tag_file_list);

   // Delete this environment variable
   set_env(_SLICKTAGS);

   _config_modify|=CFGMODIFY_DEFDATA;
}
static _str next_tag_file_list;

_str next_alias_file(_str alias_file_list,int find_first)
{
   if ( find_first ) {
      next_tag_file_list=alias_file_list
   }
   for (;;) {
      parse next_tag_file_list with alias_file (PATHSEP) next_tag_file_list;
      first_ch=substr(alias_file,1,1)
      if ( alias_file==''  ) {
         return('')
      }
      if ( first_ch=='+' || first_ch=='-' ) {
         second_ch=upcase(substr(alias_file,2,1));
         /* Search recursively up the directory tree for all alias.slk files. */
         if ( second_ch=='R' ) {
            parse alias_file with . alias_file
            alias_file=absolute(alias_file)
            path=substr(alias_file,1,pathlen(alias_file))
            next_file=absolute(path'..'FILESEP:+substr(alias_file,pathlen(alias_file)+1))
            if ( next_file!=alias_file ) {
               next_tag_file_list='+R 'next_file:+PATHSEP:+next_tag_file_list
            } else {
               continue
            }
         } else {
            messageNwait(nls('Invalid option in alias file list: %s',alias_file))
            return('')
         }
      }
      if ( file_match('-p 'maybe_quote_filename(alias_file),1)!='' ) {
         return(alias_file);
      }
   }
}
_str next_tag_filea(_str (&list)[],int &i,boolean checkFiles=true,boolean openFileRead=false)
{
   for (;;) {
      if (i>=list._length()) {
         return("");
      }
      tag_file=list[i];++i;
      // need to check files?
      if (checkFiles && file_match('-p 'maybe_quote_filename(tag_file),1)=='') {
         // tag file doesn't exist, try .vtg extension instead of .slk
         if(!file_eq(get_extension(tag_file),'slk')) {
            continue;
         }
         tag_file=strip_filename(tag_file,'e')'.vtg';
         if ( file_match('-p 'maybe_quote_filename(tag_file),1)=='' ) {
            continue;
         }
      }
      // if requested, open tag file for read access, otherwise just return it
      if (!openFileRead || !tag_read_db(tag_file)) {
         return(tag_file);
      }
   }
}
_str next_tag_file2(_str &next_tag_file_list,boolean checkFiles=true,boolean openFileRead=false)
{
   for (;;) {
      //say('next_tag_file_list='next_tag_file_list);
      parse next_tag_file_list with tag_file (PATHSEP) next_tag_file_list;
      //say('tag_file='tag_file);
      // end of list?
      if (tag_file=='') {
         return '';
      }
      // need to check files?
      if (checkFiles && file_match('-p 'maybe_quote_filename(tag_file),1)=='') {
         // tag file doesn't exist, try .vtg extension instead of .slk
         if(!file_eq(get_extension(tag_file),'slk')) {
            continue;
         }
         tag_file=strip_filename(tag_file,'e')'.vtg';
         if ( file_match('-p 'maybe_quote_filename(tag_file),1)=='' ) {
            continue;
         }
      }
      // if requested, open tag file for read access, otherwise just return it
      if (!openFileRead || !tag_read_db(tag_file)) {
         return(tag_file);
      }
   }
}
_str next_tag_file(_str tag_file_list,boolean find_first,boolean checkFiles=true,boolean openFileRead=false)
{
   if ( find_first ) {
      next_tag_file_list=tag_file_list
   }
   return(next_tag_file2(next_tag_file_list,checkFiles,openFileRead));
}
int warn_if_no_tag_files(_str tag_files)
{
   if ( tag_files=='' ) {
      messageNwait(nls('No tag files found.  Press any key to continue'));
      return(1);
   }
   _str filename = next_tag_file2(tag_files,true,true)
   if ( filename=='' ) {
      messageNwait(nls('Tag files missing or corrupt: %s.  Press any key to continue',tag_files));
      return(1);
   }
   return(0);
}
void _aremove_duplicates(_str (&list)[],boolean IgnoreCase)
{
   if (!list._length()) return;
   previous_line=list[0];
   for (i=1;i<list._length();++i) {
      if (IgnoreCase) {
         if (!stricmp(list[i],previous_line)) {
            list._deleteel(i);
            --i;
         } else {
            previous_line=list[i];
         }
      } else {
         if ( list[i]:==previous_line ) {
            list._deleteel(i);
            --i;
         } else {
            previous_line=list[i];
         }
      }
   }
}
/*
     tagname is also input.
*/
static int prompt_user(_str (&taglist)[],_str (&filelist)[],_str &tagname,_str &filename)
{
   // If user wants strict language case sensitivity
   if (!def_ignore_tcase) {
      // Determine if all tag entries are for case sensitive languages
      old_tag_ext="";
      IgnoreCase=false;
      for (i=0;i<taglist._length();++i) {
         if (tag_case(filelist[i])=="i") {
            IgnoreCase=true;
            break;
         }
      }
      if (!IgnoreCase) {
         for (i=0;i<taglist._length();++i) {
            if (tagname:!=substr(taglist[i],1,length(tagname))) {
               taglist._deleteel(i);
               filelist._deleteel(i);
               --i;
            }
         }
      }
   }

   // If there is nothing left in the taglist or filelist, return failure:
   if (taglist._length() == 0 || filelist._length() == 0) {
      return(-1);
   }

   list=taglist;    // Copy the list
   list._sort();
   _aremove_duplicates(list,0);
   //messageNwait("prompt_user: len="taglist._length());
   if (list._length()>=2) {
      option='-reinit';
      if (_find_object('_sellist_form')) {
         option='-new';
      }
      tagname=show('_sellist_form -mdi -modal 'option,
                  nls('Select a Tag Name'),
                  SL_SELECTCLINE,
                  list,
                  '',
                  '',  // help item name
                  '',  // font
                  ''   // Call back function
                 );
   } else {
      tagname=list[0];
   }
   if (tagname=="") {
      return(COMMAND_CANCELLED_RC);
   }
   status=0;
   // Now that the exact tag and type type has been selected,
   // we can remove other types
   for (i=0;i<taglist._length();++i) {
      if ( taglist[i]!=tagname) {
         taglist._deleteel(i);
         filelist._deleteel(i);
         --i;
      }
   }
   filelist._sort('f');
   _aremove_duplicates(filelist,_fpos_case:=="I");


   found=0;
   for (i=0;i<filelist._length();++i) {
      if (file_eq(filelist[i],p_buf_name)) {
         found=1;
         filelist._deleteel(i);
         break;
      }
   }
   if (found) {
      for (i=filelist._length();i>0;--i) {
         filelist[i]=filelist[i-1];
      }
      filelist[0]=p_buf_name;
   }

   if ( filelist._length()>1 ) {
      option='-reinit';
      if (_find_object('_sellist_form')) {
         option='-new';
      }
      filename=show('_sellist_form -mdi -modal 'option,
                  title=nls('Select a File'),
                  SL_SELECTCLINE,
                  filelist,
                  '',
                  '',        // help item name
                  '',                    // font
                  ''   // Call back function
                 );
   } else {
      filename=filelist[0];
   }
   if (filename=="") {
      return(COMMAND_CANCELLED_RC);
   }
   return(0);
}

static _str _taglist_callback(reason,var result,key)
{
   if (reason==SL_ONDEFAULT) {  // Enter key
      result=_sellist.p_line-1;
      return(1);
   }
   return("");
}
void MaybeBuildTagFile(_str ext)
{
   //messageNwait('p_extension='p_extension);
   index=find_index('_'p_extension'_MaybeBuildTagFile',PROC_TYPE);
   if (index_callable(index)) {
      call_index(tfindex,index);
   }
   typeless tag_files=tags_filenamea(ext);
   int i=0;
   _str tag_filename = next_tag_filea(tag_files, i, false, true);
   while (tag_filename != '') {
      if (tag_filename!="") {
         if (tag_current_version()<VS_TAG_LATEST_VERSION) {
            tag_get_detail(VS_TAGDETAIL_num_files,Noffiles);
            if (Noffiles<4000) {
                RetagFilesInTagFile(tag_filename,true,false,true,true,false,true);
            }
         }
      }
      tag_filename = next_tag_filea(tag_files, i, false, true);
   }
}
_command find_tag() name_info(TAG_ARG','VSARG2_EDITORCTL|VSARG2_REQUIRES_MDI)
{
   boolean context_found=false;
   int     context_id=0;
   taglist._makeempty();
   filelist._makeempty();

   _str params=arg(1);
   _str tagfiles_ext='';
   combine_slickc_and_c_tagfiles=false;
   for (;;) {
      parse params with option rest;
      if (lowcase(option)=='-e') {
         parse rest with tagfiles_ext params;
      } else if (lowcase(option)=='-sc') {
         combine_slickc_and_c_tagfiles=true;
         params=rest;
      } else {
         break;
      }
   }

   _str proc_name=params;
   if ( params=='' ) {
      if( !_isEditorCtl()) {
         return(1);
      }
      /* Try to find the procedure at the cursor. */
      //say("trying context tagging, proc_name="proc_name);
      _UpdateContext(true);
      context_id = tag_current_context();
      context_found=context_find_tag(proc_name, taglist, filelist);
      if (!context_found || proc_name=='') {
         //say("context tagging failed, reverting to current word only");
         proc_name=cur_word(start_col);
         if ( proc_name=='' ) {
            message nls('No word at cursor');
            return(2);
         }
      }
      ext=get_extension(p_buf_name);
      if (!context_found && _modename_eq(p_mode_name,"slick-c") &&
          (file_eq('.'ext,_macro_ext) || file_eq(ext,'sh')) ) {
         return(find_proc(proc_name));
      }
   }
   long_msg='.  'nls('You may want to rebuild the tag file.');

   if (_isEditorCtl()) {
      _EmbeddedStart(orig_values,'');
      MaybeBuildTagFile(p_extension);
   }
   if (combine_slickc_and_c_tagfiles) {
      list=tag_files=tags_filename(false,'e'):+PATHSEP:+tags_filename(false,'c');
   } else if ((params=='' && tagfiles_ext=="") && _isEditorCtl() && 
       find_index(p_extension'-proc-search',PROC_TYPE)) {
      list=tag_files=tags_filename(false,p_extension /* context tag files*/);
   } else if (tagfiles_ext!="") {
      list=tag_files=tags_filename(false,tagfiles_ext /* context tag files*/);
   } else {
      list=tag_files=tags_filename(false,"",false);
   }
   if (_isEditorCtl()) {
      _EmbeddedEnd(orig_values);
   }
   if (!context_found && warn_if_no_tag_files(tag_files)) {
      return('');
   }
   mark='';
   if ( _select_type()!='' ) {
      mark=_duplicate_selection();
      if ( mark<0 ) {
         return(NOT_ENOUGH_MEMORY_RC);
      }
   }
   if (!context_found) {
      status=find_tag2(taglist,filelist,tag_files,proc_name);
      if (status) {
         _message_box(nls("Tag '%s' not found",proc_name)long_msg);
      }
   }
   // If we found any tags.
   if (taglist._length()) {
      status=prompt_user(taglist,filelist,proc_name,filename);
      if (!status) {
         filename=strip(filename,"B","\"");
         get_view_id(view_id);
         int buf_id= -1;
         boolean isCurrentBuffer=false;
         typeless CurrentBufferPos;
         if (_isEditorCtl()) {
            buf_id=p_buf_id;
         }
         status=edit('+b 'filename);
         if ( status ) {
            status=edit(maybe_quote_filename(filename));
            if ( status ) {
               if ( status==NEW_FILE_RC ) {
                  quit();
                  activate_view(view_id);
                  _message_box(nls("File '%s' not found",filename)long_msg);
               }
               return(2);
            }
            clear_message();
            keep_loaded=0;
         } else {
            keep_loaded=1;
            isCurrentBuffer=p_buf_id==buf_id;
            if (isCurrentBuffer) {
               save_pos(CurrentBufferPos);
            }
         }
         save_pos(p);
         list[0]._makeempty();
         LinenumList[0]._makeempty();
         ColList[0]._makeempty();
         ext=p_extension;
         orig_proc_name=proc_name;
         tag_tree_decompose_tag(orig_proc_name, proc_name, dc, type, df);
         searching_for_proc = (tag_tree_type_is_func(type))? true:false;
         _UpdateContext(true);
         _UpdateLocals(true);

#if 0
         boolean local_found = false;
         index=find_index(ext'-lvar-search',PROC_TYPE);
         if (context_id > 0 && context_found && index_callable(index) ) {
            tag_get_detail2(VS_TAGDETAIL_context_type, context_id, cur_type_name);
            tag_get_detail2(VS_TAGDETAIL_context_file, context_id, cur_file_name);
            // is it a function?
            if (tag_tree_type_is_func(cur_type_name) &&
                file_eq(cur_file_name, p_buf_name)) {
               // gulp up the current context information
               tag_get_detail2(VS_TAGDETAIL_context_start_seekpos, context_id, cur_start_seekpos);
               tag_get_detail2(VS_TAGDETAIL_context_end_seekpos, context_id, cur_end_seekpos);
               _nrseek(cur_start_seekpos);
               _tag_pass=1;
               /*
                  There might be multiple hits because of overloading
                  or because pascal has a forward decl in the same file
                  has the definition.
               */
               findfirst=1;
               get_line(line);
               for (;;) {
                  proc_name = orig_proc_name;
                  status=call_index(proc_name,findfirst,ext,cur_start_seekpos,cur_end_seekpos,index);
                  //say('status='status' proc_name='proc_name' findfirst='findfirst' ext='ext);
                  if (status) {
                     break;
                  }
                  signature="";
                  tag_tree_decompose_tag(proc_name,tag_name,class_name,type_name,tag_flags,signature);
                  proc_name=tag_tree_make_caption(tag_name,type_name,class_name,tag_flags,signature,false);

                  list[list._length()]=proc_name;
                  LinenumList[LinenumList._length()]=p_line;
                  ColList[ColList._length()]=p_col;
                  if (!searching_for_proc) {
                     local_found = true;
                     break;
                  }
                  findfirst=0;
               }
            }
         }
#endif

         // decompose the original proc name into tag, class, type
         tag_tree_decompose_tag(orig_proc_name, orig_tag_name, orig_class_name, orig_type_name, orig_tag_flags);
         //say("tag="orig_tag_name" type="orig_type_name" class="orig_class_name);

         // see if it is found in locals
         boolean local_found = false;
         int i, index=find_index(ext'-lvar-search',PROC_TYPE);
         if (context_id>0 && context_found && index_callable(index) ) {
            i = tag_find_local(orig_tag_name, true, p_LangCaseSensitive);
            while (i > 0) {
               tag_get_local(i, tag_name, type_name, file_name, line_no, class_name, tag_flags, signature, return_type);
               //say("FOUND: tag_name="tag_name" type_name="type_name" orig="orig_type_name);
               if ((orig_type_name=='' || type_name == orig_type_name) &&
                   (orig_class_name=='' || class_name == orig_class_name)) {
                  proc_name=tag_tree_compose_tag(tag_name, class_name, type_name, tag_flags, signature, return_type);
                  proc_name=tag_tree_make_caption(tag_name,type_name,class_name,tag_flags,signature,false);
                  list[list._length()]=proc_name;
                  p_line=line_no;
                  tag_get_detail2(VS_TAGDETAIL_local_start_seekpos, i, start_seekpos);
                  _nrseek(start_seekpos);

                  LinenumList[LinenumList._length()]=p_line;
                  ColList[ColList._length()]=p_col;
                  if (!searching_for_proc) {
                     local_found = true;
                     //break;
                  }
               }
               i = tag_next_local(orig_tag_name, true, p_LangCaseSensitive);
            }
         }

#if 0
         index=find_index(ext'-proc-search',PROC_TYPE);
         if (!local_found && index_callable(index) ) {
            top();
            _tag_pass=1;
            /*
               There might be multiple hits because of overloading
               or because pascal has a forward decl in the same file
               has the definition.
            */
            findfirst=1;
            for (;;) {
               //_message_box("proc_name="proc_name", find_first="findfirst", ext="ext", 0, index="index);
               proc_name = orig_proc_name;
               status=call_index(proc_name,findfirst,ext,0,index);
               //messageNwait('status='status' proc_name='proc_name' findfirst='findfirst' ext='ext);
               if (status) {
                  restore_pos(p);
                  break;
               }
               signature="";
               tag_tree_decompose_tag(proc_name,tag_name,class_name,type_name,tag_flags,signature);
               proc_name=tag_tree_make_caption(tag_name,type_name,class_name,tag_flags,signature,false);
               list[list._length()]=proc_name;
               
               LinenumList[LinenumList._length()]=p_line;
               ColList[ColList._length()]=p_col;
               if (!searching_for_proc) {
                  restore_pos(p);
                  break;
               }
               findfirst=0;
            }
         }
#endif

         // see if it is found in current context
         index=find_index(ext'-proc-search',PROC_TYPE);
         if (!local_found && index_callable(index) ) {
            i = tag_find_context(orig_tag_name, true, p_LangCaseSensitive);
            while (i > 0) {
               tag_get_context(i, tag_name, type_name, file_name, start_line_no, start_seekpos, scope_line_no, scope_seekpos, end_line_no, end_seekpos, class_name, tag_flags, signature, return_type);
               //say("FOUND: tag_name="tag_name" type_name="type_name" orig="orig_type_name);
               if ((orig_type_name=='' || type_name == orig_type_name) &&
                   (orig_class_name=='' || class_name == orig_class_name)) {
                  proc_name=tag_tree_make_caption(tag_name,type_name,class_name,tag_flags,signature,false);
                  list[list._length()]=proc_name;
                  p_line=start_line_no;
                  _nrseek(start_seekpos);
                  LinenumList[LinenumList._length()]=p_line;
                  ColList[ColList._length()]=p_col;
                  if (!searching_for_proc) {
                     restore_pos(p);
                     break;
                  }
               }
               i = tag_next_context(orig_tag_name, true, p_LangCaseSensitive);
            }
         }

         if (list._length()<1) {
            if ( ! keep_loaded ) {
               quit();
               activate_view(view_id);
            }
            _message_box(nls("%s not found in '%s'",proc_name,filename)long_msg);
            return(2)
         }
         status=0;
         old_scroll_style=_scroll_style();
         _scroll_style('c');
         if (list._length()==1) {
            linenum=LinenumList[0];
            col=ColList[0];
         } else {
            i=show("_sellist_form -mdi -modal -reinit",
                        nls("Multiple Occurrences Found"),
                        SL_DEFAULTCALLBACK|SL_SELECTCLINE,
                        list,
                        "",
                        "",  // help item name
                        "",  // font
                        _taglist_callback  // Call back function
                       );
            linenum="";
            if (i!="") {
               linenum=LinenumList[i];
               col=ColList[i];
            }
         }
         if (linenum=="") {
            if ( ! keep_loaded ) {
               quit();
               activate_view(view_id);
            }
            _scroll_style(old_scroll_style);
            return(COMMAND_CANCELLED_RC);
         }
         if (isCurrentBuffer) {
            restore_pos(CurrentBufferPos);
         } else {
            top();
         }
         p_col=col;
         p_line=linenum;
         _scroll_style(old_scroll_style);
      } else if (status == -1) {
         _message_box(nls("Tag '%s' not found",proc_name)".\n\n"nls("You may want to turn off tagging's case-sensitivity")".\n"nls('You may also want to rebuild the tag file')".");
      }
   }
   if ( mark!='' ) {
      old_mark=_duplicate_selection('');
      _show_selection(mark);
      _free_selection(old_mark);
   } else {
      _deselect();
   }
   return(status)
}
int _do_default_find_context_tags(
              _str (&errorArgs)[], 
              _str prefixexp,_str lastid,
              int lastidstart_offset,int info_flags,
              typeless otherinfo,
              boolean find_parents, int max_matches, 
              boolean exact_match, boolean case_sensitive)
{
   errorArgs._makeempty();
   //say "_do_default_find_context_tags"
   int num_matches=0;
   // try to match the symbol in the current context
   tag_clear_matches();
   _MatchSymbolInContext(lastid, "",
                         num_matches, max_matches,
                         VS_TAGFILTER_ANYTHING, true, true, 
                         false, false, exact_match, case_sensitive);

   // Return 0 indicating success if anything was found
   errorArgs[1]=lastid;
   status=(num_matches == 0)? VSCODEHELPRC_NO_SYMBOLS_FOUND:0;
   return(status);
}
// match tags using context information,
// returns 0 on error or no matches.
int context_match_tags(_str &tagname, boolean find_parents=false,
                       int max_matches=VSCODEHELP_MAXFINDCONTEXTTAGS,
                       boolean exact_match=true,boolean case_sensitive=false)
{
   // in a comment or string, then no context
   //say("context_match_tags("tagname")");
   int cfg=_clex_find(0,'g');
   if (_in_comment() || cfg==CFG_STRING){
      //say("context_match_tags: in string or comment");
      return 0;
   }
   // find and call routine to get prefix expression
   _str ext=p_extension;
   int status;
   int get_idexp_index=find_index('_'ext'_get_idexp',PROC_TYPE);
   if (index_callable(get_idexp_index)) {
      status=call_index(errorArgs,
                        false, 
                        prefixexp,
                        lastid,
                        lastidstart_col,
                        lastidstart_offset,
                        info_flags,
                        otherinfo,
                        get_idexp_index);
      //say("context_match_tags: _"ext"_get_idexp");
   } else {
      status = _do_default_get_idexp(errorArgs, 
                                     false, 
                                     prefixexp, 
                                     lastid, 
                                     lastidstart_col, 
                                     lastidstart_offset, 
                                     info_flags, 
                                     otherinfo);
      //say("context_match_tags: _do_default_get_idexp");
   }
   if (status) {
      //say("context_match_tags: _"ext"_get_idexp failed");
      return 0;
   }
   // debugging
   if (_chdebug) {
      refresh();
      _message_box('prefixexp='prefixexp' lastid='lastid' lastidstart_col='lastidstart_col' info_flags='dec2hex(info_flags)' otherinfo='otherinfo);
   }

   // if the suggested tag name to find doesn't match 'lastid'
   // then don't use context tagging
   if (tagname == '') {
      if (exact_match) {
         tagname = lastid;
      } else {
         tagname = substr(lastid,1,p_col-lastidstart_col);
      }
   } else if (tagname != lastid) {
      return 0;
   }

   // evaluate prefix expression and match the tag in context
   int find_in_context_index=find_index('_'ext'_find_context_tags',PROC_TYPE);
   if (!index_callable(find_in_context_index)) {
      status=_do_default_find_context_tags(errorArgs,
                          prefixexp, tagname, lastidstart_col,
                          info_flags, otherinfo, find_parents,
                          max_matches, exact_match, case_sensitive);
   } else {
      status = call_index(errorArgs,
                          prefixexp, tagname, lastidstart_col,
                          info_flags, otherinfo, find_parents,
                          max_matches, exact_match, case_sensitive,
                          find_in_context_index);
   }
   if (status) {
      //say("context_match_tags: _"ext"_find_context_tags failed");
      return 0;
   }
   return tag_get_num_of_matches();
}
static boolean context_find_tag(_str &proc_name, _str (&taglist)[], _str (&filelist)[])
{
   _str match_tag = '';
   int i, num_matches=context_match_tags(match_tag,true);
   if (num_matches <= 0) {
      //say("context_find_tag: no matches");
      return false;
   }

   // copy the results to the taglist and filelist
   for (i=1; i<=num_matches; i++) {
      tag_get_match(i, tag_file, proc_name, type_name, file_name, line_no, class_name, tag_flags, signature, return_type);
      _str tag_name=tag_tree_compose_tag(proc_name, class_name, type_name);
      taglist[taglist._length()]=tag_name;
      filelist[filelist._length()]=file_name;
   }
   //say("context_find_tag: "num_matches" matches");
   return true;
}

/*
    Return
       0   Found one or more tags
       1   No tags found
       2   Bad error. Tag file messed up, Out of memory?, file not found
       COMMAND_CANCELLED_RC   User aborted.
*/
static int find_tag2(_str (&taglist)[],_str (&filelist)[],_str &tag_filelist,_str proc_name,...)
{
   recursive_call=arg(5)!="";
   proc_name=translate(proc_name,'_','-');
   if ( !recursive_call) {
      clear_message();
      find_tag2(taglist,filelist,tag_filelist,'_'proc_name,'1');
   }
   taglist._makeempty();
   filelist._makeempty();
   status=list_duplicate_tags(taglist,filelist/*,partial_proc_name*/,proc_name,tag_filelist);
   return(status);
}
/* When arg(3)='' listing filenames otherwise listing tag names */
static typeless list_duplicate_tags(_str (&taglist)[],_str (&filelist)[],
                                    _str proc_name,   _str TagFileList)
{
   // (DJB 061697) try it using tag_find functions
   boolean check_type;
   check_type=false;
   orig_proc_name=proc_name;
   parse proc_name with proc_name '(' proc_type;
   if (proc_type!='') {
      check_type=true;
   }
   for (;;) {
      _str CurFilename=next_tag_file2(TagFileList,false/*no check*/,false/*no open*/);
      if (CurFilename=='') break;
      status = tag_read_db(absolute(CurFilename));
      if ( status ) {
         if ( status==NEW_FILE_RC || status==FILE_NOT_FOUND_RC) {
            //_delete_buffer();
            //_quit_view();
            _message_box(nls("Tag file '%s' not found.\n\nIf you have tag files which were created before version 3.0 you need to rebuild them.",CurFilename))
         } else {
            _message_box(nls("Error reading tag file '%s'",CurFilename)". "get_message(status));
         }
         return(2);
      }
      old_tag_ext='';
      status = tag_find_equal(strip(proc_name));
      if (status) {
         continue;
      }

      //name="";
      //dummy_type_name="";
      //filename="";
      //dummy_line_no=0;
      //dummy_class_name="";
      //dummy_flags=0;
      //tag_get_info(name, dummy_type_name, filename, dummy_line_no, dummy_class_name, dummy_flags);
      //tag_get_detail(VS_TAGDETAIL_name, name);
      //tag_get_detail(VS_TAGDETAIL_file_name, filename);
      
      //long_msg='.  'nls('You may want to rebuild the tag file.')
      //if ( status ) {
      //   /* Complete match was not found. */
      //   tag_close_db('',1);
      //}
      /* add tags with same name */

      //partial_proc_name=proc_name;
      //exact_match=0;
      //if (!stricmp(name,proc_name)) {
      //   exact_match=1;
      //}

      tag_name="";
      tag_type="";
      tag_flags=0;
      file_name=""
      line_no=0;
      class_name="";

      status=0;
      while (status >= 0) {
         _str line_item;

         tag_get_info(tag_name, tag_type, file_name, line_no, class_name, tag_flags);
         if (!(tag_flags & VS_TAGFLAG_anonymous) && tag_type != 'import' && tag_type != 'friend') {
            line_item = tag_tree_compose_tag(tag_name, class_name, tag_type);
            if (check_type) {
               if (line_item==orig_proc_name) {
                  taglist[taglist._length()]=line_item;
                  filelist[filelist._length()]=file_name;
               }
            } else {
               taglist[taglist._length()]=line_item;
               filelist[filelist._length()]=file_name;
            }
         }
         //if (exact_match == 1) {
            status = tag_next_equal();
         //} else {
         //   status = tag_next_prefix(name);
         //}
      }
      clear_message();
   }
   if (!taglist._length()) return(BT_RECORD_NOT_FOUND_RC);
   return(0)
}
static typeless _keywords;

#if 0
int pas_proc_search(var proc_name,find_first,extension)
{
   if ( find_first ) {
      _keywords='(overlay:b|)(pro(cedure|gram)|function)';
      if ( proc_name:=='' ) {
          status=search('^[ \t]*'_keywords':b:v':+
                 '\c[( \t;:]','ri');
      } else {
         status=search(proc_name,'i>w=[A-Za-z0-9_$]');
      }
   } else {
      status=repeat_search();
   }
   for (;;) {
      if ( rc ) {
         return(rc);
      }
      if (_in_comment()) {
         repeat_search();
         continue;
      }
      get_line(line);
      line=expand_tabs(line);
      col=p_col;
      if ( pos(' '_keywords'[ \t]',' 'line,1,'ri'):==0 ) {
         repeat_search();continue;
      }
      p=pos('[(;:]',line,1,'r');
      if ( p ) {
         if ( substr(line,p,1):=='(' ) {
            p_col=p;
            if ( _find_matching_paren(def_pmatch_max_diff) ) {
               repeat_search();
               continue;
            }
            _find_matching_paren(def_pmatch_max_diff);
         }
         get_line(temp);temp=expand_tabs(temp);
         if ( pos('forward;',temp) ) {
            repeat_search();
            continue;
         }
         line=strip(substr(line,1,p-1));
         i=lastpos(' ',translate(line,' ',\t));
         proc_name=substr(line,i+1);
         return(0);
      }
      repeat_search();
   }
}
#endif
#define ASM_COMMON_LIST ' proc macro equ db dw dd struc label '

typeless s_proc_search(var proc_name, find_first)
{
   return(asm_proc_search(proc_name,find_first))

}
typeless asm_proc_search(var proc_name, find_first)
{
   typeless search_key

   proc_was_null=0
   if ( proc_name:=='' ) {
      proc_was_null=1
      proc_name='[A-Za-z0-9_$@]#' /* rev2a */
   } else {
      parse proc_name with proc_name '('dmm_search_type')'
      /* help out label containing $ */
      proc_name=stranslate(proc_name,'\$','$')
   }
   key_label='('proc_name'\:)'
   if ( find_first ) {
      if ( proc_was_null ) {
         search_key='^('key_label'|':+
                         '[ \t]@'proc_name'[ \t]+':+
                           '(':+
                              stranslate(strip(ASM_COMMON_LIST),'|',' ') :+
                           ')':+
                           '([ \t]|$)':+
                     ')'
      } else {
         list_key='([ \t]@'proc_name'[ \t]+'dmm_search_type')'
         if ( dmm_search_type:=='label' ) {
            search_key= '^('key_label'|'list_key')'
         } else if ( pos(' 'dmm_search_type' ',ASM_COMMON_LIST) ) {
            search_key='^'list_key
         }
      }
      search search_key,'ri'
   } else {
      repeat_search
   }
   get_line line
   parse line with first_word second_word .
   second_word=lowcase(second_word)
   if ( pos(' 'second_word' ',ASM_COMMON_LIST) ) {
      proc_name=first_word'('second_word')'
   } else if ( pos('^'key_label,line,'1','RI'):=='1' ) {
      parse line with proc_name':'
      proc_name=proc_name'(label)'
   }
   return(rc)
}

_command int make_tags(...) name_info(FILE_ARG'*')
{
   status=shell('maketags 'arg(1));
   return(status);

}
#if 0
static void xlat_tag(var filename)
{
   p=point()
   parse filename with number '%' rest
   if ( rest=='' ) {
      return;
   }
   filename=rest
   p_line=number
   get_line line
   filename=line:+filename
   goto_point p

}
#endif

_command void gui_make_tags() name_info(FILE_ARG'*')
{
   if (/*(p_isbutton_bar || !_isEditorCtl() ) && */
       _mdi.p_child._isEditorCtl()
       ) {
      _mdi.p_child.show('_tag_form');
   } else {
      show('-desktop _tag_form');
   }
}



static typeless reset_subdir_box = 0;

/*
   Function returns 1 if error, returns 0 Module loaded ok if ok
   if no there is no support for the  module, returns '' and index = 0
   def-setup-ext's symbol table index is returned in pass by reference
   variable index
*/
typeless check_and_load_support(_str ext, var index)
{
   buf_name=arg(3);
   ext = refer_ext(_file_case(ext),buf_name);
   index = find_index('def-setup-'ext, MISC_TYPE);

   if (index) {
#if 0
      parse SUPPORTED_TYPES with extension'='fn .
      mindex=find_index(fn:+_macro_ext,MODULE_TYPE)
      if (mindex) {
         return(0);//Module already exists
      }
#endif
      return(0);  // Assume module already exists. */
   }

   list = SUPPORTED_TYPES;
   for (;;) {
      parse list with extension '=' fn list;
      if (extension == '') {
         return('');//A match Was never found, no modules loaded
      }
      if (extension == ext) {
         filename = slick_path_search(fn:+_macro_ext'x');
         if (filename=='') {
            filename = slick_path_search(fn:+_macro_ext)
         } else {
            path=strip_filename(filename,'P');
            name=file_match('-p 'maybe_quote_filename(path:+fn:+_macro_ext),1);
            if (name!='') {
               filename=name;
            }
         }
         if (filename == '') {
            _message_box(nls("Can't Find Support Module '%s'.",fn:+_macro_ext));
            return(1);
         }
         filename=maybe_quote_filename(filename);
         _load(filename,'u')     // Unload existing module.
         _macfile_add(filename,_macro_ext'x',0,1);
         message nls('making:')' 'filename
         filename=maybe_quote_filename(filename);
         status=_make(filename);
         if (status) {
            _message_box(nls("Unable to compile macro '%s'",filename));
            return(status);
         }
         clear_message
         status=_load(filename)  // Load module now
         if (status) {
            _message_box(nls("Can't Find Support Module '%s'.",fn:+_macro_ext));
            return(1);
         }
         _config_modify|=CFGMODIFY_LOADMACRO;
         index = find_index('def-setup-'ext, MISC_TYPE)
         return(0); //Module loaded ok
      }
   }
}


//static _ProcOnlySearch(_str &proc_name,findfirst,ext,seekpos,index)
//{
//   save_pos(p);
//   for (;;) {
//      proc_name='';
//      status=call_index(proc_name,findfirst,ext,seekpos,index);
//      if (status) {
//         restore_pos(p);
//         return(status);
//      }
//      //parse proc_name with name '(' idtype ')';
//      //if (idtype=='' || pos('proc',idtype) || pos("func",idtype) || pos("constr",idtype) || pos("destr",idtype)) {
//      //   return(0);
//      //}
//      tag_tree_decompose_tag(proc_name, name, dc, idtype, df);
//      if (tag_tree_type_is_func(idtype) /*&& (idtype:!='proto' || def_include_protos)*/) {
//         return(0);
//      }
//      findfirst=0;
//   }
//}

_command _str current_proc() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_REQUIRES_TAGGING)
{
   dosticky_message=arg(1);

   _UpdateContext(true);
   int context_id = tag_current_context();
   _str msg = 'function'
   if (context_id > 0) {
      tag_get_detail2(VS_TAGDETAIL_context_type, context_id, type_name);
      if (tag_tree_type_is_func(type_name)) {
         tag_get_context(context_id, proc_name, type_name, file_name, 
                         start_line_no, start_seekpos, 
                         scope_line_no, scope_seekpos,
                         end_line_no, end_seekpos,
                         class_name, tag_flags, signature, return_type);

         in_class = (class_name != '')? 1:0;
         caption = tag_tree_make_caption(proc_name, type_name, class_name, tag_flags, signature, false);
      } else {
         tag_get_detail2(VS_TAGDETAIL_context_name, context_id, caption);
         msg = type_name;
      }
   } else {
      caption = 'undefined.';
   }
   if (dosticky_message) {
      sticky_message('The current 'msg' is 'caption);
   }
   return(proc_name);

//   dosticky_message=arg(1);
//   save_pos(p);
//   _proc_found="";
//   status=prev_proc(!dosticky_message);
//   restore_pos(p);
//   //parse _proc_found with proc_name '('
//   tag_tree_decompose_tag(_proc_found, proc_name, dc, dt, df);
//   if (dc != '') {
//      proc_name = dc'::'proc_name;
//   }
//   if (dosticky_message) {
//      sticky_message('The current function is 'proc_name);
//   }
//   return(proc_name);
}
_command int next_proc() name_info(','VSARG2_EDITORCTL|VSARG2_READ_ONLY|VSARG2_REQUIRES_MDI_EDITORCTL|VSARG2_REQUIRES_TAGGING|VSARG2_REQUIRES_EDITORCTL)
{
   boolean quiet=arg(1)!='';
   boolean anytag=arg(2)!='';

   // No support for this extension?
   _str ext=p_extension;
   int index=find_index(ext'-proc-search',PROC_TYPE)
   if ( ! index_callable(index) ) {
      _message_box('Tagging not supported for files of this extension.  Make sure support module is loaded.')
      return(2);
   }

   // Update the complete context information and find nearest tag
   _UpdateContext(true);
   _str proc_name='x';
   int seekpos=_nrseek();
   int context_id = tag_nearest_context(p_RLine);
   if (!context_id) {
      context_id++;
   }

   // scan ahead for first function tag
   int num_tags = tag_get_num_of_context();
   for (; context_id<=num_tags; context_id++) {
      tag_get_detail2(VS_TAGDETAIL_context_start_seekpos, context_id, start_seekpos);
      tag_get_detail2(VS_TAGDETAIL_context_type, context_id, type_name);
      if (start_seekpos > seekpos && (anytag || tag_tree_type_is_func(type_name))) {
         tag_get_context(context_id, proc_name, type_name, file_name, 
                         start_line_no, start_seekpos, 
                         scope_line_no, scope_seekpos,
                         end_line_no, end_seekpos,
                         class_name, tag_flags, signature, return_type);
         p_line = scope_line_no;
         _nrseek(start_seekpos);
         _UpdateContext(true);
         _UpdateContextWindow(true);
         _proc_found = tag_tree_compose_tag(proc_name, class_name, type_name, tag_flags, signature, return_type);
         return(0);
      }
   }

   // no next procedure/tag
   if (!quiet) {
      message 'No next procedure'
   }
   return(1);

//   quiet=arg(1)!='';
//   ext=_modename2ext(p_mode_name,junk);
//   //ext=refer_ext(_file_case(get_extension(p_buf_name)),p_buf_name);
//   index=find_index(ext'-proc-search',PROC_TYPE)
//   if ( ! index_callable(index) ) {
//      _message_box('Tagging not supported for files of this extension.  Make sure support module is loaded.')
//      return(2);  //No support for this extension
//   }
//   save_pos(p);old_linenum=p_line;old_column=p_col;
//   proc_name=''
//   seekpos=_nrseek();
//   proc_name='';
//   status=_ProcOnlySearch(proc_name,1,ext,seekpos,index);
//   if (!status) _proc_found=proc_name;
//   while (!status && p_line==old_linenum && p_col==old_column) {
//      proc_name='';
//      status=_ProcOnlySearch(proc_name,0,ext,seekpos,index);
//      if (!status) _proc_found=proc_name;
//   }
//   if (status) {
//      if (!quiet) {
//         message 'No next procedure'
//      }
//      restore_pos(p);
//      return(1);
//   }
//   linenum=p_line;col=p_col;
//   // We want to go to new position from original position so screen scrolls as
//   // little as possible.
//   old_scroll_style=_scroll_style();_scroll_style('c');
//   restore_pos(p);
//   p_line=linenum;p_col=col
//   _scroll_style(old_scroll_style);
//
//   //line_to_top();
//   clear_message(); // Some proc_search functions don't use undocumented @ search quiet option
//   return(0);
}

_command int prev_proc() name_info(','VSARG2_EDITORCTL|VSARG2_READ_ONLY|VSARG2_REQUIRES_MDI_EDITORCTL|VSARG2_REQUIRES_TAGGING|VSARG2_REQUIRES_EDITORCTL)
{
   boolean quiet=arg(1)!='';
   boolean anytag=arg(2)!='';

   // No support for this extension?
   _str ext=p_extension;
   int index=find_index(ext'-proc-search',PROC_TYPE)
   if ( ! index_callable(index) ) {
      _message_box('Tagging not supported for files of this extension.  Make sure support module is loaded.')
      return(2);
   }

   // Update the complete context information and find nearest tag
   _UpdateContext(true);
   _str proc_name='x';
   int seekpos=_nrseek();
   int context_id = tag_nearest_context(p_RLine);


   // search backward for suitable tag
   for (; context_id > 0; context_id--) {
      tag_get_detail2(VS_TAGDETAIL_context_start_seekpos, context_id, start_seekpos);
      tag_get_detail2(VS_TAGDETAIL_context_type, context_id, type_name);
      if (start_seekpos < seekpos && (anytag || tag_tree_type_is_func(type_name))) {
         tag_get_context(context_id, proc_name, type_name, file_name, 
                         start_line_no, start_seekpos, 
                         scope_line_no, scope_seekpos,
                         end_line_no, end_seekpos,
                         class_name, tag_flags, signature, return_type);
         p_line = scope_line_no;
         _nrseek(start_seekpos);
         _UpdateContext(true);
         _UpdateContextWindow(true);
         _proc_found = tag_tree_compose_tag(proc_name, class_name, type_name, tag_flags, signature, return_type);
         return(0);
      }
   }

   // no previous proc/tag
   if (!quiet) {
      message 'No previous procedure'
   }
   return(1);



//   quiet=arg(1)!="";
//   // This may seem inefficient but this code works for all existing
//   // macro tagging.
//   ext=_modename2ext(p_mode_name,junk);
//   //ext=refer_ext(_file_case(get_extension(p_buf_name)),p_buf_name);
//   index=find_index(ext'-proc-search',PROC_TYPE);
//   if ( ! index_callable(index) ) {
//      _message_box('Tagging not supported for files of this extension.  Make sure support module is loaded.')
//      return(2);  //No support for this extension
//   }
//   old_linenum=p_line;old_col=p_col;
//   save_pos(p);
//   proc_name='';
//   new_line=p_line-500
//   if (new_line<1) {
//      new_line=1;
//   }
//   p_line=new_line;_begin_line();
//   seekpos=_nrseek();
//   status=_ProcOnlySearch(proc_name,1,ext,seekpos,index);
//   if (!status && p_line<old_linenum) {
//      prev_linenum=p_line;prev_col=p_col;prev_proc_name=proc_name;
//      for (;;) {
//         if (p_line>old_linenum || (p_line==old_linenum && p_col>=old_col)) {
//            break;
//         }
//         prev_linenum=p_line;prev_col=p_col;prev_proc_name=proc_name;
//         proc_name='';
//         status=_ProcOnlySearch(proc_name,0,ext,seekpos,index);
//         if (status) {
//            break;
//         }
//      }
//   } else {
//      top
//      seekpos=_nrseek();
//      proc_name='';
//      status=_ProcOnlySearch(proc_name,1,ext,seekpos,index);
//      prev_linenum='';
//      if (!status) {
//         for (;;) {
//            if (p_line>old_linenum || (p_line==old_linenum && p_col>=old_col)) {
//               break;
//            }
//            prev_linenum=p_line;prev_col=p_col;prev_proc_name=proc_name;
//            proc_name='';
//            status=_ProcOnlySearch(proc_name,0,ext,seekpos,index);
//            if (status) {
//               break;
//            }
//         }
//      }
//   }
//   if (prev_linenum=='') {
//      if (!quiet) {
//         message('No previous procedure');
//      }
//      restore_pos(p);
//      return(1);
//   }
//   // We want to go to new position from original position so screen scrolls as
//   // little as possible.
//   old_scroll_style=_scroll_style();_scroll_style('c');
//   restore_pos(p);
//   p_line=prev_linenum;p_col=prev_col
//   _scroll_style(old_scroll_style);
//   //line_to_top();
//   if (!quiet) {
//      clear_message(); // Some proc_search functions don't use undocumented @ search quiet option
//   }
//   _proc_found=prev_proc_name;
//   return(0);
}
_command tag_close_all() name_info(TAG_ARG',')
{
   tag_close_all_db();
}
int tag_close_db2(...)
{
   dbfilename=arg(1);
   if (dbfilename=='') {
      dbfilename=tag_current_db();
   }
   if (dbfilename=='') {
      return(0);
   }
   // Reopen this file for read access
   return(tag_read_db(dbfilename));
}
int tag_close_bsc()
{
#if !__UNIX__
   if (substr(machine(),1,2)=='NT' && _win32s()!=1) {
      refs_database = refs_filename();
      if (refs_database != '' && "."lowcase(get_extension(refs_database)) :== BSC_FILE_EXT) {
         //tag_read_db(refs_database);
         return tag_close_db(absolute(refs_database));
      }
   }
#endif
   return 0;
}
