/*
$VerboseHistory: stdprocs.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:10:16a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 10:16a
 * Comment:
 * Added support for editor control.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:35p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include "slick.sh"

#define MAX_ATSLICK_LINE_LEN 1024
#define MAX_RETRIEVE_LINES 600
#define COMPLETION_ARGS  ('file='FILE_ARG             " "'buffer='BUFFER_ARG:+' ':+\
                     'command='COMMAND_ARG       " "'object='FORM_ARG:+' ':+\
                     'picture='PICTURE_ARG       " "'module='MODULE_ARG:+' ':+\
                     'pc='PC_ARG                 " ":+\
                     'pcb-type='PCB_TYPE_ARG     " ":+\
                     'var='VAR_ARG               " "'env='ENV_ARG:+' ':+\
                     'menu='MENU_ARG             " "'help='HELP_ARG:+' ':+\
                     'help-type='HELP_TYPE_ARG   " "'help-class='HELP_CLASS_ARG:+' ':+\
                     'color-field='COLOR_FIELD_ARG " "'tag='TAG_ARG)

_str def_wide_ext

int def_maxcombohist=20;  // Default maximum combo box retrieval list
int def_maxdialoghist=10;  // Default maximum dialog box retrieval
#define CTLSEPARATOR  "\0"

//
//  Compare macro language identifiers case sensitive.
//
boolean name_eq(_str a,_str b)
{
   return a:==b
}
_str name_case(_str a)
{
   return(a)
}
boolean _modename_eq(_str a,_str b)
{
   return (stricmp(a,b)==0);
}
#if __PCDOS__
// _file_case should be used under rare cirumstances.
_str _file_case(_str a)
{
   return(lowcase(a));
}
_str file_eq(_str a,_str b)
{
   return (stricmp(a,b)==0);

}
_str attr_case(_str name)
{
  return(upcase(name));

}
_str env_case(_str name)
{
   return(upcase(name));
}
#else
// Use file_eq function instead of this function when possible.
_str _file_case(_str a)
{
   return(a);
}
_str file_eq(_str a,_str b)
{
   return a:==b
}

_str attr_case(_str name)
{
   return(name)
}
_str env_case(_str name)
{
   return(name)
}
#endif
no_code_swapping   /* Just in case there is an I/O error reading */
                   /* the slick.sta file, this will ensure user */
                   /* safe exit and save of files.  These commonly */
                   /* used procedures will not cause module swapping. */

void command_put(_str string)
{
   p_window_id=_cmdline;
   set_command(string,length(string)+1);
   _set_focus();
}
void cancel()
{
  message get_message(COMMAND_CANCELLED_RC)

}
boolean isnormal_char(_str key)
{

  index=eventtab_index(_default_keys,
             (p_view_id<0)?p_mode_eventtab: _edit_window().p_mode_eventtab,
                       event2index(key))
  return((! index && _asc(substr(key,1,1))>27) || isprint(key) ||
         key==TAB  ||
         name_name(index)=='normal-character'
        );

}
boolean isalnum(key)
{
   key=key2ascii(key)
   if ( length(key)>1 ) { return(0) }
   return((isalpha(key) || (key>='0' && key<='9')))

}
boolean isalpha(key)
{
  if ( length(key)>1 ) { return(0) }
#if __UNIX__
  if (machine()=='S390') {  //#if __EBCDIC__
     key=upcase(key)
     return((key>='A' && key<='I') || (key>='J' && key<='R') || (key>='S' && key<='Z'))
  }
#endif
  key=upcase(key)
  return(key>='A' && key<='Z')

}
boolean isdigit(key)
{
  if ( length(key)>1 ) { return(0) }
  return(key>='0' && key<='9')

}
#if 0
_str isinteger(number)
{
  number=strip(number)
  ch=substr(number,1,1)
  if ( ch=='-' || ch=='+' ) {
     number=substr(number,2)
  }
  return(! verify(strip(number),'01234567989') && number!='')

}
#endif
boolean isprint(key)
{
  if ( length(key)>1 ) return(0);
  return(event2index(key)>=30)

}
_command void abort() name_info(','VSARG2_READ_ONLY|VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL)
{
   if (command_state()) {
      _cmdline.set_command '',1,1
   }
   if ( command_state() && ! def_stay_on_cmdline ) { command_toggle }
   cancel();
   _deselect();
}
_str iscancel(key)
{

  index=eventtab_index(_default_keys,
              (p_view_id<0)?p_mode_eventtab: _edit_window().p_mode_eventtab,
                       event2index(key))
  return(key:==ESC || name_name(index)=='abort')

}
boolean islist_cancel(key)
{

  index=eventtab_index(_default_keys,
              (p_view_id<0)?p_mode_eventtab: _edit_window().p_mode_eventtab,
                   event2index(key))
  return(iscancel(key) || name_name(index)=='quit' || name_name(index)=='pquit')

}
void _maybe_reduce_retrieve()
{
   if (p_Noflines<=MAX_RETRIEVE_LINES) return;
   diff=p_Noflines-MAX_RETRIEVE_LINES;
   if (diff<10) {
      diff=10;
   }
   top
   for (i=1; i<=diff ; ++i) {
      _delete_line
   }
   bottom
}
void append_retrieve_command(command)
{
  get_view_id view_id
  activate_view  RETRIEVE_VIEW_ID
  bottom;
  if ( arg(2)!='' ) {
     insert_line command
  } else {
     get_line line
     if ( line=='' && p_line==1 ) {
       replace_line command
     } else {
       if ( line!=command ) {
         insert_line command
       }
     }
  }
  _maybe_reduce_retrieve();
  _cmdline.get_command command,col,left_edge
  _cmdline.set_command ''
  execute
  _cmdline.set_command command,col,left_edge
  activate_view view_id   /* activate top ring and empty file. */

}
_str strip_options(name,var options,...)
{
   StripLeadingOnly=arg(3)!="" && arg(3);
   if (StripLeadingOnly) {
      options='';
      result=name;
      for (;;) {
         parse result with option rest;
         if ( option=='' ) {
            return(strip(result));
         }
         ch=substr(option,1,1);
         if ( ch!='+' && ch!='-' && ch!='[' ) {
            return(strip(result));
         }
         if (options=="") {
            options=option;
         } else {
            options=options:+' 'option;
         }
         result=rest;
      }
   }
  options=''
  result=''
  for (;;) {
     if ( name=='' ) {
        return(strip(result))
     }
     // Skip leading spaces
     k=pos('[~ ]',name,1,"r");
     i=pos(' ',name,k);
     if (!i) {
        word=name;
        name="";
     } else {
        word=substr(name,1,i-1);
        name=substr(name,i);
     }
     //messageNwait("strip_options: word="word" name="name" len="length(spaces));
     //parse name with word name
     ch=substr(word,k,1)
     if ( ch!='+' && ch!='-' && ch!='[' ) {
        result=result:+word;
     } else {
        options=strip(options:+word);
     }
  }

}
boolean isunc_root(name,...)
{
#if __UNIX__
   return(0)
#elif __PCDOS__
   parse name with '\\' server '\' share_name '\' rest
   //  Test for existance option?
   if (0 && arg(2)!='') {
      if (file_match('-p +d \\'server'\'share_name'\'ALLFILES_RE,1)=='') {
         return(0);
      }
   }
   return(share_name:!='' && rest:=='')
#else
   What about this os
#endif

}
_str isdirectory(name)
{
  name=translate(name,FILESEP,FILESEP2)
  /* remove any options that are present in name */
  name=strip(strip_options(name,options,true),'B','"');
  if ( name=='' ) {
     return(options' ')
  }
  temp=strip_filename(name,'p');
  if (temp=='.' || temp=='..' ) {
     new_name=strip_filename(absolute(name:+FILESEP:+ALLFILES_RE),'n');
  } else {
     new_name=absolute(name);
  }
  if (new_name!='') name=new_name;
  if ( arg(2)=='1' ) {
    if ( last_char(name)!=FILESEP && ! isdrive(name) ) {
      return(strip(options " "name:+FILESEP))
    }
    return(strip(options " "name))
  }
  if ( isdrive(name) || name==FILESEP ||  /* d: or d:\ or \ or . or .. ? */
     (length(name)==3 &&
     substr(name,3,1):==FILESEP && 
     isdrive(substr(name,1,2))) || strip_filename(name,'p')=='.' || strip_filename(name,'p')=='..' ||
     isunc_root(name,1) ) {
    return(name)
  } else {
    name=strip(name)
    if ( last_char(name)==FILESEP ) {
      name=substr(name,1,length(name)-1)
    }
    if ( iswildcard(name) ) {
       return(0)
    }
    name=file_match('-p +h 'maybe_quote_filename(name),1)
    if ( name=='' || last_char(name):!=FILESEP ) {
      return(0)
    }
    return(strip(options " "maybe_quote_filename(name)))
  }


}
boolean isdrive(name)
{
#if __UNIX__
   return(0);
#else
   name=strip(name)
   return(_dbcsSubstr(name,2,1)==':' && length(name)==2)
#endif
}
/*  D=drive P=path and drive E=extension N=name and extension */
_str strip_filename(name,options)
{
   options=upcase(options)
   if ( pos('P',options) ) {
      name=substr(name,pathlen(name)+1)
   } else if ( pos('D',options) && _dbcsSubstr(name,2,1)==':') {
      name=substr(name,3)
   }
   if ( pos('N',options) ) {
      name=substr(name,1,pathlen(name))
   } else if ( pos('E',options) ) {
      after_path=substr(name,pathlen(name)+1);
      i=lastpos('.',after_path);
      if (i) {
         i=length(name)-length(after_path)+i;
         name=substr(name,1,i-1);
      }
   }
   return(name)

}
_str strip_names(_str filename,int count)
{
   while (count-->0) {
      if (last_char(filename)==FILESEP) {
         filename=substr(filename,1,length(filename)-1);
      }
      filename=strip_filename(filename,'N');
   }
   return(filename);
}
_str file_date(filename)
{
  return(file_list_field(filename,DIR_DATE_COL,DIR_DATE_WIDTH))

}
_str file_time(filename)
{
  return(file_list_field(filename,DIR_TIME_COL,DIR_TIME_WIDTH))

}
_str file_list_field(_str filename,int col,int width)
{
  /* list read only, directory, hidden, and system files*/
  line=file_match('-p +VRHSD 'maybe_quote_filename(filename),1)
  return(strip(substr(line,col,width)))

}
_str _dbcsSubstr(_str &string,int StartCol)
{
   Width=arg(3);
   if (Width=="" || Width== -1) {
      Width=length(string)-StartCol+1;
      if (Width<0) Width=0;
   }
   result=substr(string,StartCol,Width);
   if (!_dbcsStartOfDBCS(string,StartCol)) {
       result= _chr(0):+substr(result,2);
   }
   if(Width>=2 && !_dbcsStartOfDBCS(string,StartCol+Width-1)) {
      result=substr(result,1,length(result)-1):+_chr(0);
   }
   return(result);
}
boolean _dbcsStartOfDBCSCol(int col)
{
   if (!_dbcs()) return(true);
   if (col<=1 || col>_text_colc()) {
      return(true);
   }
   orig_col=p_col;
   p_col=col;

   int count;
   count=0;
   --p_col;if(_text_colc(p_col,'T')<0) left();
   ++count;
   // IF previous character is not a DBCS lead byte
   if (!_dbcsIsLeadByte(get_text())) {
      p_col=orig_col;
      return(1);
   }
   // While we have a lead byte.
   for (;;) {
      if (col<=1) {
         p_col=orig_col;
         return((count&1)?false:true);
      }
      --p_col;if(_text_colc(p_col,'T')<0) left();
      ++count;
      if (!_dbcsIsLeadByte(get_text())) {
         p_col=orig_col;
         return((count&1)?true:false);
      }
   }
}
boolean _dbcsStartOfDBCS(_str &string,int i)
{
   if (!_dbcs()) return(true);
   int count;
   count=0;
   if (i<=1 || i>length(string)) {
      return(true);
   }
   --i;++count;
   // IF previous character is not a DBCS lead byte
   if (!_dbcsIsLeadByte(substr(string,i,1))) {
      return(1);
   }
   // While we have a lead byte.
   for (;;) {
      if (i<=1) {
         return((count&1)?false:true);
      }
      --i;++count;
      if (!_dbcsIsLeadByte(substr(string,i,1))) {
         return((count&1)?true:false);
      }
   }
}
_str last_char(_str &string)
{
   if ( string:=='' ) { return('') }
   if (!_dbcsStartOfDBCS(string,length(string))) {
      return(_chr(0));
   }
   return(substr(string,length(string),1))

}
_str field(_str string,int width)
{
  if ( length(string)>=width ) {
    return(string:+' ')
  }
  return(substr(string,1,width))

}
_str eq_name2value(_str name,_str string)
{
  if ( name=='' ) return('');
  name=lowcase(name)
  string=lowcase(string)
  search_name=' 'name:+'='
  parse string with (search_name) number rest
  if ( number=='' ) {   /* could be first one. */
     parse string with first_name '=' number rest
     if ( first_name!=name ) {
        number=''
     }
  }
  return(number)

}
_str eq_value2name(_str nv,_str string)
{
  parse string with prefix_string ('='nv),'i' .
  i=lastpos(' ',prefix_string)
  if ( ! i ) { i=0 }
  return(substr(prefix_string,i+1,length(prefix_string)-i))
}
void _show_entire_form()
{
   _get_window(x,y,form_width,form_height);
   _lxy2dxy(p_xyscale_mode,x,y);
   _lxy2dxy(p_xyscale_mode,form_width,form_height);
   _GetVisibleScreen(screen_x,screen_y,screen_width,screen_height);
   orig_x=x;orig_y=y;
   if (x<0) {
      x=0;
   } else if (x+form_width>screen_width){
      adjust= x+form_width- screen_width;
      x-=adjust;
      // Move window left
      if (x<0) {
         // Center to screen
         x=(screen_width- form_width) intdiv 2
      }
   }
   if (y<0) {
      y=0;
   } else if (y+form_height>screen_height){
      adjust= y+form_height- screen_height;
      // Move window up
      y-=adjust;
      if (y<0) {
         // Center to screen
         y=(screen_height- form_height) intdiv 2;
      }
   }
   if (orig_x!=x || orig_y!=y) {
      _dxy2lxy(p_xyscale_mode,x,y);
      _dxy2lxy(p_xyscale_mode,form_width,form_height);
      _move_window(x,y,form_width,form_height);
   }
}
void _center_window()
{
   //messageNwait('p_object='p_object' parent='p_parent' w='p_window_id);
   _get_window(x,y,width,height);
   if (p_object!=OI_FORM && p_object!=OI_MDI_FORM) {
      parent_width=p_parent.p_client_width;
      parent_height=p_parent.p_client_height;
      _dxy2lxy(p_xyscale_mode,parent_width,parent_height);
      x=(parent_width- p_width) intdiv 2;
      y=(parent_height- p_height) intdiv 2;
      _move_window x,y,p_width,p_height
      return
   }
   if (p_object==OI_FORM) {
      if (arg(1)!='') {
         parent=arg(1);
      } else {
         parent= p_xyparent;
      }
   } else if (p_object==OI_MDI_FORM) {
      parent=0;
   }
   /*if (parent==_mdi && !(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW)) {
      parent=_desktop;
   } */
   if (parent && parent!=_desktop && parent!=_app) {
      parent._get_window(x,y,parent_width,parent_height);
      if (parent==_mdi && x==0 && y==0 && parent_width==0 && parent_height==0) {
         // Center to desktop
         /*
             By calling _get_window instead of checking for MDI_WINDOW
             support, we allow the capability to center a dialog
             to MDI without implementing full MDI_WINDOW support.
             Nobody does this yet.
         */
         parent_height=_screen_height();parent_width=_screen_width();
         _dxy2lxy(p_xyscale_mode,parent_width,parent_height);
         x=(parent_width- width) intdiv 2;
         y=(parent_height- height) intdiv 2;
      } else {
         done=0;
         // IF we have an editor control on a dialog box with
         //    out a center to parent, center to the editor control.
         if (parent.p_object==OI_EDITOR && !parent.p_parent &&
             !parent.p_mdi_child) {
            if (1) {
               parent._GetOuterMostWindow(x,y,parent_width,parent_height);
               //say('x='x' y='y' w='parent_width' h='parent_height' n='parent.p_name' mc='parent.p_mdi_child);
               //_lxy2dxy(p_xyscale_mode,x,y);
               _lxy2dxy(p_xyscale_mode,width,height);
               //say('parent_height='parent_height' height='height);
               x=x+(parent_width- width) intdiv 2;
               y=y+(parent_height- height) intdiv 2;
               //say('b44444 xx='x' yy='y);
               _dxy2lxy(p_xyscale_mode,x,y);
               _dxy2lxy(p_xyscale_mode,width,height);
               //say('xx='x' yy='y);
               done=1;
            } else {
               // Need to calculate adjustment for desktop.
               tx=ty=0;
               _map_xy(parent,0,tx,ty,parent.p_xyscale_mode);
               x+=tx;y+=ty;
            }
         }
         if (!done) {
            _lxy2lxy(parent.p_xyscale_mode,p_xyscale_mode,x,y);
            _lxy2lxy(parent.p_xyscale_mode,p_xyscale_mode,parent_width,parent_height);
            parent_xyscale_mode=parent.p_xyscale_mode;
            x=x+(parent_width- width) intdiv 2;
            y=y+(parent_height- height) intdiv 2;
            _map_xy(parent.p_xyparent,p_xyparent,x,y,parent.p_xyscale_mode);
         }
      }

   } else {
      parent_height=_screen_height();parent_width=_screen_width();
      _dxy2lxy(p_xyscale_mode,parent_width,parent_height);
      x=(parent_width- width) intdiv 2;
      y=(parent_height- height) intdiv 2;
   }
   _move_window(x,y,p_width,p_height);
   _show_entire_form();
}
boolean iswildcard(filename)
{
#if __PCDOS__
  return(verify(filename,'*?','M')!=0)
#elif __UNIX__
  /* :,+,@,#,$ sign not included because UNIX allows these chars. */
  return(verify(filename,'*?[]()^{}|\','M')!=0);
#else
  what are the wild card characters
#endif

}
void flush_keyboard()
{
  /* No refresh, Check physical keyboard. */
  /* Don't want to flush keyboard macro. */
  while ( test_event('RK'):!='') {
     get_event('RK');
  }

}
void flush_repeats(key)
{
   maxcount=100;
   if (arg(2)!='') {
      maxcount=arg(2);
   }
   count=0;
   while ( test_event('PRK'):==key && key:!='' && count<maxcount) {
      get_event('RK');++count;
   }

}
void read_ahead_flush_repeats(key)
{
  if ( block_was_read() ) {
    refresh
    if ( arg(2)=='' || arg(2)=='0' ) {
       read_ahead()
    } else {
       flush_repeats(key)
       read_ahead()
       flush_repeats(key)
    }
  }

}
void read_behind_flush_repeats(key)
{
  if ( block_was_read() ) {
    refresh
    if ( arg(2)=='' || arg(2)=='0' ) {
       read_behind()
    } else {
       flush_repeats(key)
       read_behind()
       flush_repeats(key)
    }
  }

}
read_ahead()
{
  if ( block_was_read() ) {
    old_rc=rc
    cursor_y= p_cursor_y;left_edge= p_left_edge;col=p_col
    text_point=point();line=point('L')
    down def_read_ahead_lines
    goto_point text_point,line
    set_scroll_pos left_edge,cursor_y;p_col=col
    rc=old_rc
    block_was_read(0)
    return(1)
  } else {
    return(0)
  }


}
read_behind()
{
  if ( block_was_read() ) {
    old_rc=rc
    load_files '+c +v'
    if ( rc ) {
       clear_message
       return(0)
    }
    up   def_read_ahead_lines
    _quit_view
    rc=old_rc
    block_was_read(0)
    return(1)
  } else {
    return(0)
  }


}
try_calling(index)
{
  if ( index_callable(index) ) {
     _macro('m',_macro())
     return(call_index(index))
  }
  return(0)

}
_str number2onoff(_str number)
{
   if ( number ) {
      result=nls('on')
   } else {
      result=nls('off')
   }
   return(result)

}
boolean setonoff(var number,_str string)
{
  on=nls('on')
  off=nls('off')
  if ( !stricmp(string,on) ) {
    number=1
    return(0)
  } else if ( !stricmp(string,off) ) {
    number=0
    return(0)
  }
  message nls('Please specify %s or %s',upcase(on),upcase(off))
  return(1)

}
boolean number2yesno(_str number)
{
   if ( number ) {
      result=nls('Y')
   } else {
      result=nls('N')
   }
   return(result)

}
void nls_yes_no(var nls_chars,var yes,var no)
{
   nls_strip_chars(nls_chars,nls('~YES ~NO'))
   yes=substr(nls_chars,1,1)
   no=substr(nls_chars,2,1)

}
boolean setyesno(var number,_str string)
{
  string=upcase(string)
  parse nls_strip_chars(nls_chars,nls('~YES ~NO')) with yes_msg no_msg
  msg=nls('Please specify %s or %s',yes_msg,no_msg)
  if ( string==substr(nls_chars,1,1) || string==upcase(yes_msg) ) {
    number=1
    return(0)
  } else if ( string==substr(nls_chars,2,1) || string==upcase(no_msg) ) {
    number=0
    return(0)
  }
  message msg
  return(1)
}
_str name_on_key(key)
{
   return(name_name(eventtab_index(_default_keys,_default_keys,event2index(key))))

}
pretrieve_next(retrieve_view_id,var first_retrieve)
{
   if ( retrieve_view_id=='' ) {
      return('')
   }
   get_view_id(view_id)
   activate_view retrieve_view_id
   down
   if ( rc ) {
      top
   }
   get_line line
   activate_view view_id
   first_retrieve=0
   return line

}
_str pretrieve_prev(retrieve_view_id,var first_retrieve)
{
   if ( retrieve_view_id=='' ) {
      return('')
   }
   get_view_id(view_id)
   activate_view(retrieve_view_id);
   if ( ! first_retrieve ) {
      up
      if ( rc ) {
         bottom
      }
   } else {
      bottom
   }
   get_line(line);
   activate_view(view_id);
   first_retrieve=0
   return line

}
void insert_retrieve(retrieve_view_id,var first_retrieve,line)
{
   if ( retrieve_view_id=='' ) {
      return;
   }
   get_view_id(view_id)
   activate_view retrieve_view_id
   bottom
   get_line last_line
   if ( last_line!=line && line!='' ) {
      insert_line line
      _maybe_reduce_retrieve();
   }
   first_retrieve=1
   activate_view view_id

}
_str count_lines_in_selection()
{
   orig_buf_id=p_buf_id;
   status=_get_selinfo(start_col,end_col,buf_id,arg(1));
   if (status) return(0);
   p_buf_id=buf_id;
   save_pos(orig_pos);
   status=_begin_select(arg(1));
   if ( status ) return(0);
   count=1
   for (;;) {
      down
      if ( rc || _end_select_compare(arg(1))>0 ) {
         break
      }
      count=count+1
   }
   restore_pos(orig_pos);
   p_buf_id=orig_buf_id
   return(count)

}

// Return the longest whole line in a selection
int longest_line_in_selection()
{
   if( arg(1)=='' && !select_active() ) {
      _message_box('No selection active');
      return(0);
   }
   save_pos(p);
   throw_out_last_line=0;
   if( _select_type()=='CHAR' ) {
      _get_selinfo(dummy,end_col,dummy);
      if( end_col==1 ) {
         // Throw out the last line of the character selection
         throw_out_last_line=1;
      }
   }
   status=_begin_select(arg(1));
   if( status ) return(0);
   get_line(line);
   len=length(expand_tabs(strip(line,'T')));
   for( ;; ) {
      if( down() ||
          _end_select_compare(arg(1))>0 ||
          (throw_out_last_line && !_end_select_compare(arg(1))) ) {
         break;
      }
      get_line(line);
      line=expand_tabs(strip(line,'T'));
      if( length(line)>len ) {
         len=length(line);
      }
   }
   restore_pos(p);
   return(len);
}

// Using array for DBCS support.
  static _str gkeytab[]= {
     PAD_SLASH,name2event('c-enter'),C_BACKSPACE,ENTER,TAB,BACKSPACE,ESC,
     PAD_PLUS,PAD_MINUS,PAD_STAR,S_END,S_DOWN,
     S_PGDN,S_LEFT,name2event('s-pad-5'),S_RIGHT,S_HOME,S_UP,
     S_PGUP,name2event('s-ins'),name2event('s-del')
  };
#define ASCII_CHAR2 ('/'_chr(10)_chr(127)_chr(13)_chr(9)_chr(8)_chr(27)'+-*1234567890.')

_str key2ascii(key)
{
   if ( length(key)<2 ) {
      return(key)
   }
   for (i=0;i<gkeytab._length();++i) {
      if (key:==gkeytab[i]) {
         break;
      }
   }
   if ( i<gkeytab._length()) {
      return(substr(ASCII_CHAR2,i+1,1));
   } else {
      return(key)  /* May not be an ascii key.  */
   }

}
_str indent_string(width)
{
   if ( ! p_indent_with_tabs ) {
      return(substr('',1,width))
   }
   return(expand_tabs(substr('',1,width,\t),1,width,'S'))

}
update_format_line()
{
   mark=_alloc_selection()
   if ( mark<0 ) {
      messageNwait(nls('Unable to allocate a mark.  Format line not updated.'))
      return(1)
   }
   col=p_col
   if ( ! _on_line0() ) {
      _select_char mark
   }
   top
   if (_line_length()>MAX_ATSLICK_LINE_LEN) {
      line='';
   } else {
      get_line line
   }
   parse upcase(line) with before '\@SLICK( |$)','ri' +0 at_slick
   if ( at_slick!='' && (arg(1)=='' || lastpos(',',line)<=length(before)) ) {   /* Format line present? */
      i=lastpos(',',line)
      if ( i>length(before) ) {
         after=substr(line,i+1)
      } else {
         after=substr(line,length(before)+7)
      }
      replace_line substr(line,1,length(before))'@SLICK MA='p_margins', TABS='p_tabs', WWS='p_word_wrap_style', IWT='p_indent_with_tabs', ST='p_ShowSpecialChars', IN='p_indent_style', WC='p_word_chars','after
   }
   if ( _select_type(mark)=='' ) {
      top;up;p_col=col
   } else {
     _begin_select mark
   }
   _free_selection mark

/* Returns true and set tabs and margins if format line is present. */
}
_str read_format_line()
{
  if ( p_buf_width ) {
     return(0)
  }
  p=point();line_num=point('l');
  left_edge=p_left_edge;cursor_y=p_cursor_y;col=p_col;
  top();
  if (_line_length()>MAX_ATSLICK_LINE_LEN) {
     line='';
  } else {
     get_line line
  }
  parse line with before '@SLICK','i' +0 at_slick 'MA='margins ',' 'TABS='tabs ',' 'WWS='word_wrap_style ',' 'IWT='indent_with_tabs ',' 'ST='show_tabs ',' 'IN='indent_style ',' 'WC='word_chars','
  status=(at_slick!='')
  if ( status ) {   /* Format line present? */
     if ( tabs!='' ) { p_tabs=tabs }
     if ( margins!='' ) { p_margins=margins }
     if ( word_wrap_style!='' ) {
        p_word_wrap_style=word_wrap_style;
        p_indent_with_tabs=indent_with_tabs;
        p_ShowSpecialChars=show_tabs;
     }
     if (indent_style!='') {
        p_indent_style=indent_style
     } else {
        p_indent_style=INDENT_SMART
     }
     if (word_chars!='') {
        p_word_chars=word_chars;
     }
  }
  goto_point p,line_num
  set_scroll_pos left_edge,cursor_y;p_col=col
  return(status)

}
_str save_selection(var mark)
{
   mark=_duplicate_selection('')
   new_mark=_duplicate_selection()
   if ( new_mark<0 ) {
      message get_message(TOO_MANY_SELECTIONS_RC)
      return(1)
   }
   _show_selection new_mark
   return(0)

}
void restore_selection(mark)
{
   cur_mark=_duplicate_selection('')
   _show_selection mark
   _free_selection cur_mark

}
_str stranslate(s,out_string,in_string,_str search_options="")
{
   i=1;
   for (;;) {
     i=pos(in_string,s,i,search_options)
     if ( ! i ) {
        break
     }
     in_len=pos('');
     if (!pos('[rubRUB]',search_options,1,'r')) {
        in_len=length(in_string);
     }
     s=substr(s,1,i-1):+out_string:+substr(s,i+in_len)
     i=i+length(out_string);
   }
   return(s)

}
_str get_completion_info(command)
{
   command=translate(name_case(command),'-','_')
   if ( substr(command,1,1)=='.' ) {
      if ( command!='.' ) {
         index=find_index(substr(command,2),COMMAND_TYPE)
         parse name_info(index) with completion_info ','
      } else {
         completion_info=''
      }
   } else {
      completion_info=eq_name2value(stranslate(command,'','*'),COMPLETION_ARGS)
      if ( completion_info=='' ) {
         completion_info=eq_name2value(command,def_user_args)
      }
      if ( completion_info!='' && pos('*',command) ) {
         completion_info=completion_info'*'
      }
   }
   return(completion_info)

}
_str _check_tabs(tabs,wid)
{
   old_tabs=wid.p_tabs;wid.p_tabs=tabs;status=rc;wid.p_tabs=old_tabs
   if (status) {
      _message_box('Invalid tab settings.');
   }
   return(status)

}
_str _check_margins(junk)
{
   left_ma=text1.p_text;
   right_ma=text2.p_text;
   newp_ma=text3.p_text;
   if (!isinteger(left_ma) || left_ma<1 || left_ma>MAX_LINE) {
      p_window_id=text1;_set_focus();
      _message_box('Invalid margin settings.');
      return(1);
   }
   if (!isinteger(right_ma) || right_ma<1 || right_ma>MAX_LINE) {
      p_window_id=text2;_set_focus();
      _message_box('Invalid margin settings.');
      return(1);
   }
   if (!isinteger(newp_ma) || newp_ma<1 || newp_ma>MAX_LINE) {
      p_window_id=text3;_set_focus();
      _message_box('Invalid margin settings.');
      return(1);
   }
   if (left_ma+2>right_ma) {
      p_window_id=text1;_set_focus();
      _message_box('Invalid margin settings.');
      return(1);
   }
   return(0);
}
// Returns referred extension for buffer name, using refer_ext
_str _bufname2ext(_str &buf_name)
{
   return refer_ext(_file_case(get_extension(buf_name)),buf_name);
}
// Returns extension of buffer name without dot unless arg(2) not ''
_str get_extension(_str &buf_name)
{
  i=lastpos('.',buf_name)
  if ( i  ) {
    extension=substr(buf_name,(arg(2)=='')?i+1:i)
    if ( verify(extension,'\/','M') ) {
      /* this is the extension of a directory name and not a filename */
      extension=''
    }
  } else {
    extension=''
  }
  return(strip(extension,'T','"'))
  /* messageNwait('extension='extension) */

}
_str maybe_quote_filename(_str filename)
{
   filename=stranslate(filename,'','"')
   if ( pos(' ',filename) ) {
      filename='"'filename'"'
   }
   return(filename);

}
void call_root_key(key)
{
   /* need this for when command_execute gets called later. */
   index=eventtab_index(_default_keys,
                           _default_keys,event2index(key))
   if ( ! index && length(key):==1 ) {
      keyin key
   }
   try_calling(index)

}
_str nls_letter_prompt(msg)
{
   msg=nls_strip_chars(nls_chars,msg)
   key=letter_prompt(msg,nls_chars)
   return(pos(key,nls_chars))

}
_str letter_prompt(msg)
{
   letters=upcase(arg(2))
   if ( letters=='' ) {
      nls_yes_no(letters,yes,no)
   }
   refresh
   message msg
   for (;;) {
      k=get_event()
      if ( length(k)==1 ) {
         k=upcase(k)
      }
      if ( (length(k)==1 && pos(k,letters)) || iscancel(k) ) {
         clear_message
         return(k)
      }
   }

}
_str _retrieve;

_str prompt()
{
   arg1=arg(1)
   msg=arg(2)
   cmd_name=name_name(last_index('','C'))
   if ( arg1!='' ) {
      return(arg1)
   }
   if ( ! def_prompt && ! _in_help ) {
      line=cmd_name' 'arg(3)
      command_put(line)
      if ( arg(4)!='' ) {
         set_command line' ',length(cmd_name)+2
      }
      stop();
   }
   if ( msg=='' ) {
      msg=cmd_name
      msg=upcase(substr(msg,1,1)):+substr(msg,2)
   }
   // Removed this because using alias_cd in Shell tab
   // changes focus to mdi window
   /*
   if ( ! def_stay_on_cmdline ) {
      cursor_data();
   } */
   _retrieve=arg()<3
   _macro_delete_line()
   status=get_string(line,msg': ','-.'cmd_name,arg(3))
   if ( status ) {
      if ( _in_help ) {
         line=''
      } else {
         stop
      }
   }
   _macro_call(translate(cmd_name,'_','-'),line)
   return(line)

}
/* Returns 0 if word is a valid abbreviation in word_list. */
_str min_abbrev(word,word_list,options)
{
   i=pos(' 'word,word_list)
   if ( ! i || pos(' ',word) || word=='' ) {
      return ''
   }
   if ( substr(word_list,i+length(word)+1,1):==' ' ) { /* Exact match? */
      return word
   }
   parse options with . . min_len .
   if ( length(word)<min_len ) {
      return ''
   }
   j=pos(' 'word,word_list,i+1)
   if ( j ) {  /* Not unique match? */
      /* return '' */
      orig_view_id=_create_temp_view(temp_view_id);
      if ( orig_view_id=='' ) return('')
      _delete_line
      width=0
      for (;;) {
         line=' 'substr(word_list,i+1,j -i-1)
         insert_line line
         if ( length(line)>width ) { width=length(line) }
         i=j;
         j=pos(' 'word,word_list,i+1)
         if ( ! j ) {
            line=' 'substr(word_list,i+1,pos(' ',word_list,i+1) -i-1)
            insert_line line
            if ( length(line)>width ) { width=length(line) }
            break
         }
      }
      activate_view orig_view_id
      result=show('_sellist_form -modal',
                  nls('Select a Keyword'),
                  SL_VIEWID|SL_SELECTCLINE,
                  temp_view_id,
                  '',                  // buttons
                  '',                  // help item name
                  ''                   // font
                 )
      activate_view orig_view_id
      return(strip(result))
   }
   return substr(word_list,i+1,pos(' ',word_list,i+1) -i-1)

}
//Returns 1 if string is an element in array.
static int _inarray(string,array)
{
   for (i=0;i<array._length();++i) {
      if (array[i]==string) return(1);
   }
   return 0;
}

static void add_to_array(var array, word)
{
   for (i=0;i<array._length();++i) {
      if (array[i]==word) return;//No need to really replace
   }
   array[i]=word;
}
static _str LangCase(_str word,boolean LangCaseSensitive)
{
   if (LangCaseSensitive) {
      return(word);
   }
   return(lowcase(word));
}

_str min_abbrev2(_str word,_str (&word_list)[],_str options,_str &aliasfilename)
{
/* I thought about sorting the array and doing a binary search.  With 30
   keywords tops, I'll see if its fast enough first.
*/
   LangCaseSensitive=p_LangCaseSensitive;
   LangCaseSensitiveStr=(LangCaseSensitive)?'':'i';
   cword=LangCase(word,LangCaseSensitive);
   len=length(word);
   inalias_file=0;
   aliasfilename='';
   ext=p_extension;
   index=find_index('def-alias-'ext,MISC_TYPE);
   if (index) {
      aliasfilename=name_info(index);
      aliasfilename=slick_path_search(aliasfilename);
      if (aliasfilename!='') aliasfilename=absolute(aliasfilename);
   }
   parse options with . . min_len .;
   if ( len<1 ) {
      return('');
   }
   if (last_event():!=' ') {
      min_len=MAXINT;
   } else {
      if (len>=min_len) {
         min_len=MAXINT;
      } else {
         min_len=len;
      }
   }
   //messageNwait('min_len='min_len);
   _str hitlist[];
   hitlist[0]=1;hitlist._deleteel(0,hitlist._length());
   count=0;
   for (i=0;i<word_list._length();++i) {
      if (cword==LangCase(word_list[i],LangCaseSensitive)) {
         hitlist._deleteel(0,hitlist._length());
         hitlist[0]=word;
         break;
      }else if (cword==substr(LangCase(word_list[i],LangCaseSensitive),1,len) &&
                length(word_list[i])<=min_len) {
         hitlist[count++]=word_list[i];
      }
   }
   orig_view_id=p_view_id;
   alias_info='';
   _str alias_hitlist[];
   alias_hitlist[0]=1;alias_hitlist._deleteel(0,alias_hitlist._length());
   alias_count=0;
   if (aliasfilename!='') {
      p_view_id=HIDDEN_VIEW_ID;
      inmem=1;
      status=load_files('+q +m +b 'aliasfilename);
      if (status) {
         inmem=0;
         status=load_files('+q +m 'maybe_quote_filename(aliasfilename));
         if (status==NEW_FILE_RC) {
            _delete_buffer();
         }
      }
      if (!status) {
         top();_begin_line();
         while (!search('^'_escape_re_chars(word),'@r'LangCaseSensitiveStr)) {
            if (alias_info=='') alias_info=p_line;
            //curword=cur_word(junk);//Fix this later
            get_line(line);
            p=pos('( |$|\()',line,1,'r');
            curword=substr(line,1,p-1);
            //messageNwait('curword='curword' cword='cword);
            if (LangCase(curword,LangCaseSensitive)==cword) {
               hitlist._deleteel(0,hitlist._length());
               alias_hitlist._deleteel(0,alias_hitlist._length());
               hitlist[0]=word;
               alias_hitlist[0]=word;
               //alias_hitlist[0]=word;
               //alias_count=0;//Probably not necessary
               break;
            }
            if (length(curword)<=min_len) {
               add_to_array(hitlist,curword);
               alias_hitlist[alias_count++]=curword;
            }
            if (down()) break;
            _begin_line();
         }
         if (!inmem) _delete_buffer();
      }
      p_view_id=orig_view_id;
   }
   hitlist._sort();

   /*if ( len<min_len ) {
      if (hitlist._length()!=1) {
         return('');
      }
   } */
   switch (hitlist._length()) {
   case 1:
      if (!_inarray(hitlist[0],alias_hitlist)) aliasfilename='';
      return(hitlist[0]);
   case 0:
      return('');
   default:
      result=show('_sellist_form -modal',
                  nls('Select a Keyword'),
                  SL_SELECTCLINE,
                  hitlist,
                  '',                  // buttons
                  '',                  // help item name
                  ''                   // font
                 )
      if (!_inarray(result,alias_hitlist)) aliasfilename='';
      if (result=='') return result;
      result=strip(result);
      return(result);
   }
}

void _on_got_focus()
{
   if (command_state()) {
      return;
   }
   switch_buffer('','W');
   //call_list('_gotfocus_');
}
void _on_lost_focus()
{
   if (command_state()) {
      return;
   }
   call_list('_lostfocus_');
}

void switch_buffer()
{
   _tbSetRefreshBy(VSTBREFRESHBY_SWITCHBUF);
   if (_in_exit_list) return;
   // Call all functions which start with _switchbuf_
   call_list('_switchbuf_',arg(1),arg(2));
}
void save_view(var view_id)
{
   get_view_id view_id
   /* activate the hidden window with temporary view. */
   activate_view HIDDEN_VIEW_ID

}
_str _bufnameNmode2ext(_str buf_name,_str buf_mode_name)
{
   ext=refer_ext(_file_case(get_extension(buf_name)),buf_name);
   //ext is current extension
   index=find_index('def-setup-'ext,MISC_TYPE);
   ni=name_info(index);
   parse ni with junk'MN='modename','
   //messageNwait('current extmodename='modename);
   if (modename != buf_mode_name) {
     // messageNwait('modes are not equal...searching');
      //wrong alias filename is being used, find which ext we need
      newext=_modename2ext(buf_mode_name,index)
      if (newext!='') {
         ext=newext;
      }
   }
   return(ext);
}
_str _modename2wildcards(_str mode)
{
   int setup_index;
   _str ext = _modename2ext(mode, setup_index);
   _str wildcards = '*.'ext;
   int index=name_match('def-setup-',1,MISC_TYPE)
   while (index != 0) {
      _str name=substr(name_name(index),11)
      if (ext:!=name && refer_ext(name):==ext) {
         wildcards = wildcards';*.'name;
      }
      index=name_match('def-setup-',0,MISC_TYPE)
   }
   return wildcards;
}
_str _modename2ext(_str mode,int &setup_index)
{
   setup_index=name_match('def-setup-',1,MISC_TYPE);
   for (;;) {
      if (!setup_index) {
         break;
      }
      ni=name_info(setup_index);
      if (substr(ni,1,1)!='@') {
         parse ni with junk'MN='modename','
         if (_modename_eq(modename,mode)) {
            //this is the one we want
            name=name_name(setup_index);
            parse name with 'def-setup-'real_ext;
            return(real_ext);
         } 
      }
      setup_index=name_match('def-setup-',0,MISC_TYPE);
   }
   return('');
}
_str nls(_str msg,...)
{
   result='';
   i=1
   arg_number=1;
   for (;;) {
      j=pos('%s([123456789]|)',msg,i,'r');
      if ( ! j ) {
        result=result:+substr(msg,i)
        return(result)
      }
      len=pos('');
      if (len>=3) {
         n=substr(msg,j+2,1);
      } else {
         n=arg_number;
      }
      if (arg(2)._varformat()==VF_ARRAY) {
         if(arg(2)[n]._varformat()==VF_EMPTY) {
            //say("Error in error message");
            //say(" ...Array not initialized");
            result=result:+substr(msg,i,j-i);
         } else {
            result=result:+substr(msg,i,j-i):+arg(2)[n];
         }
      } else {
         result=result:+substr(msg,i,j-i):+arg(n+1);
      }
      arg_number=arg_number+1;
      i=j+len;
   }

}
_str nls_strip_chars(_str &nls_chars,_str msg)
{
   nls_chars=''
   i=1
   for (;;) {
      i=pos('~',msg,i)
      if ( ! i ) {
         return(msg)
      }
      if ( substr(msg,i+1,1)=='~' ) {
         msg=substr(msg,1,i):+substr(msg,i+2)
         i=i+1
      } else {
         nls_chars=nls_chars:+upcase(substr(msg,i+1,1))
         msg=substr(msg,1,i-1):+substr(msg,i+1)
      }
   }
}
_str nls_selection_chars(_str msg)
{
   nls_chars=''
   i=1
   for (;;) {
      i=pos('&',msg,i)
      if ( ! i ) {
         return(nls_chars)
      }
      nls_chars=nls_chars:+upcase(substr(msg,i+1,1))
      i=i+2
   }
}
boolean _on_line0()
{
   parse point() with seekpos down_count
   if (down_count!='') {
      return(seekpos<0 && !down_count);
   }
   return(seekpos<0);
}
_str name_info_arg2(int command_index)
{
   parse name_info(command_index) with ',' flags ','
   if ( flags=='' ) {
      flags=0
   }
   return(flags)
}
void _macro_repeat()
{
   if (_macro()) {
      this_cmd=name_name(last_index('','C'))
      prev_cmd=name_name(prev_index('','C'))
      if (prev_cmd==this_cmd) {
         _macro_delete_line()     // Delete code generated for this command
         line=_macro_get_line()
         parse line with line '(' param ')'
         if (param=='') {
            param=2
         } else {
            ++param;
         }
         _macro_replace_line(translate(this_cmd,'_','-')'('param');')
      }
   }
}
/*
    If successful, returns name index of picture greater than 0.
    Otherwise, a negative error code is returned.
*/
int _update_picture(int index,_str filename)
{
   _config_modify|=CFGMODIFY_SYSRESOURCE|CFGMODIFY_RESOURCE;
   if (index<0) {
      /* Find existing picture. */
      index=find_index(strip_filename(filename,'p'),PICTURE_TYPE)
   }
   if (index) {
      index=replace_name(index,filename)
   } else {
      index=insert_name(filename,PICTURE_TYPE)
      if (!index) {
         index=rc;
      }
   }
   return(index)
}
int type2oi(int type)
{
   return((type&OBJECT_MASK)>>OBJECT_SHIFT)
}
int oi2type(int oi)
{
   return(OBJECT_TYPE|(oi<<OBJECT_SHIFT))
}
_str _escape_re_chars(_str filename)
{
   if (upcase(arg(2))=='U') {
      re_chars='$?+*(){}^[]|.';
   } else if (upcase(arg(2))=='B') {
      re_chars='*?@+{}[]|\<%>$';
   } else {
      re_chars='$?+#*@(){}~^[]|\:';
   }
   i=1
   for (;;) {
      i=verify(filename,re_chars,'m',i)
      if ( ! i ) {
         break
      }
      filename=substr(filename,1,i-1):+'\':+substr(filename,i)
      i=i+2
   }
   return(filename)
}
_str _parse_line(_str &lines)
{
   parse_ch=arg(2)
   if (parse_ch:!='') {
      i=pos(parse_ch,lines,1,'r')
   } else {
      // for DOS,UNIX, or MAC new line sequence
      i=pos('\13\10|\10|\13',lines,1,'r')
   }
   if (i) {
      result=substr(lines,1,i-1)
      lines=substr(lines,i+pos(''))
   } else {
      result=lines
      lines=''
   }
   return(result)
}
void _reset_retrieve()
{
   get_view_id view_id;activate_view RETRIEVE_VIEW_ID;bottom
   activate_view view_id;_cmdline.set_command '';execute
}

int _dialogs_view_id; // Initialized in stdcmds.e
/*
    form_name can be just a form name or form_name.control
    The later is used for combo box list data.
*/
static void add_dialog_data(_str form_name,_str data,int maxNoflinesThatFollow)
{
   get_view_id(orig_view_id);
   activate_view(_dialogs_view_id);
   top();
   status=search("^"form_name'\:',"@re");
   if (status) {
      bottom();
      insert_line(form_name':1 0');
      insert_line(" "data);
      activate_view(orig_view_id);
      return;
   }
   get_line(line);
   parse line with form_name':'NoflinesThatFollow NoflinesToCurRetrieve;
   if (!isinteger(NoflinesThatFollow)) {
      activate_view(orig_view_id);
      return;
   }
   save_pos(p);
   prev_data="";
   if (NoflinesThatFollow>0) {
      down();get_line(prev_data);up();
   }
   // IF the previous retrieve data matches this one, don't bother adding
   //    it again.
   if (substr(prev_data,2):==data || pos("\n",data)) {
      activate_view(orig_view_id);
      return;
   }
   insert_line(" "data);
   if (NoflinesThatFollow>=maxNoflinesThatFollow) {
      down(NoflinesThatFollow);
      _delete_line();
   } else {
      ++NoflinesThatFollow;
   }
   restore_pos(p);
   replace_line(form_name':'NoflinesThatFollow" "NoflinesToCurRetrieve);
   activate_view(orig_view_id);
}
void _append_retrieve(ctl_wid,value)
{
   ctl_name=arg(3);
   if (ctl_name=='') {
      ctl_name=ctl_wid.p_active_form.p_name'.'ctl_wid.p_name;
   } else if(!pos('.',ctl_name) && ctl_wid.p_object!=OI_FORM){
      ctl_name=ctl_wid.p_active_form.p_name'.'ctl_name;
   }
   dot_name=ctl_name;
   parse ctl_name with form_name"."ctl_name;
   if (!ctl_wid) {
      command= CTLSEPARATOR:+"da ":+ctl_name:+":":+value;
   } else {
      switch (ctl_wid.p_object) {
      case OI_TEXT_BOX:
         command= CTLSEPARATOR:+'te 'ctl_name':'value
         break;
      case OI_CHECK_BOX:
         command= CTLSEPARATOR:+'ch 'ctl_name':'value
         break;
      case OI_RADIO_BUTTON:
         if (!value) {
            return;
         }
         command= CTLSEPARATOR:+'ra 'ctl_name':'value
         break;
      case OI_HSCROLL_BAR:
         command= CTLSEPARATOR:+'hs 'ctl_name':'value
         break;
      case OI_VSCROLL_BAR:
         command= CTLSEPARATOR:+'vs 'ctl_name':'value
         break;
      case OI_COMBO_BOX:
         command= CTLSEPARATOR:+'cb 'ctl_name':'value
         break;
      case OI_PICTURE_BOX:
         command= CTLSEPARATOR:+'pi 'ctl_name':'value
         break;
      case OI_IMAGE:
         command= CTLSEPARATOR:+'im 'ctl_name':'value
         break;
      case OI_GAUGE:
         command= CTLSEPARATOR:+'ga 'ctl_name':'value
         break;
      case OI_SSTAB:
         command= CTLSEPARATOR:+"tb ":+ctl_name:+":":+value;
         break;
      default:
         return;
      }
   }
   add_dialog_data(dot_name,command,def_maxcombohist);
}
int _xsrg_dialogs()
{
   get_view_id(window_file_id);  /* should be $window.slk */
   mark=_alloc_selection();
   if ( mark<0 ) {
      return(mark);
   }
   if ( (arg(1)=='R' || arg(1)=='N') ) {
      parse arg(2) with Noflines .;
      down();_select_line(mark);
      down(Noflines-1);
      _select_line(mark);
      activate_view(_dialogs_view_id);
      _lbclear();
      _copy_to_cursor(mark);
      top();
   } else {
      activate_view(_dialogs_view_id);
      Noflines=p_Noflines;
      line_number=p_line;
      bottom();_end_line;
      activate_view(_dialogs_view_id);
      top;
      _select_line(mark);
      bottom;_select_line(mark);
      activate_view(window_file_id);
      insert_line('DIALOGS: 'Noflines);
      _copy_to_cursor(mark);
      _end_select(mark);
      activate_view(_dialogs_view_id);
      top();
   }
   _free_selection(mark);
   activate_view(window_file_id);
   return(0);
}
static _str gtempdata;
static int _save_fr2(int wid,_str form_name)
{
   if (wid.p_name=='' || wid.p_object==OI_FORM) return(0);
   ctl_name=wid.p_name;
   switch (wid.p_object) {
   case OI_TEXT_BOX:
      gtempdata=gtempdata:+CTLSEPARATOR:+ 'te 'ctl_name':'wid.p_text;
      break;
   case OI_CHECK_BOX:
      gtempdata=gtempdata:+CTLSEPARATOR:+ 'ch 'ctl_name':'wid.p_value;
      break;
   case OI_RADIO_BUTTON:
      if (!wid.p_value) {
         return(0);
      }
      gtempdata=gtempdata:+CTLSEPARATOR:+ 'ra 'ctl_name':'wid.p_value;
      break;
   case OI_HSCROLL_BAR:
      gtempdata=gtempdata:+CTLSEPARATOR:+ 'hs 'ctl_name':'wid.p_value;
      break;
   case OI_VSCROLL_BAR:
      gtempdata=gtempdata:+CTLSEPARATOR:+ 'vs 'ctl_name':'wid.p_value;
      break;
   case OI_COMBO_BOX:
      gtempdata=gtempdata:+CTLSEPARATOR:+ 'cb 'ctl_name':'wid.p_text;
      break;
   case OI_PICTURE_BOX:
      gtempdata=gtempdata:+CTLSEPARATOR:+ 'pi 'ctl_name':'wid.p_value;
      break;
   case OI_IMAGE:
      gtempdata=gtempdata:+CTLSEPARATOR:+ 'im 'ctl_name':'wid.p_value;
      break;
   case OI_GAUGE:
      gtempdata=gtempdata:+CTLSEPARATOR:+ 'ga 'ctl_name':'wid.p_value;
      break;
   case OI_SSTAB:
      gtempdata=gtempdata:+CTLSEPARATOR:+ 'tb 'ctl_name':'wid.p_ActiveTab;
      break;
   }
   return(0);
}
void _save_form_response()
{
   form_wid=p_active_form;
   form_name=form_wid.p_name
   if (form_name=='') return;
   gtempdata="";
   wid=_for_each_control(form_wid,
                     _save_fr2,'H',form_name);

   add_dialog_data(form_name,gtempdata,def_maxdialoghist);
}
static _str _set_retrieve_value(form_wid,wid,ctl_data)
{
   done=0;
   parse ctl_data with ctltype ctl_name':'value
   if (ctl_name=='') return(1);
   if (wid=='') {
      wid=form_wid._find_control(ctl_name)
   }
   switch (ctltype) {
   case 'te':
      if (wid) wid.p_text=value;
      break;
   case 'ch':
      if (wid) {
         wid.p_value=value;
         wid.call_event(wid,LBUTTON_UP)
      }
      break;
   case 'ra':
      if (wid) {
         wid.p_value=value;
         wid.call_event(wid,LBUTTON_UP)
      }
      break;
   case 'hs':
      if (wid) wid.p_value=value;
      break;
   case 'vs':
      if (wid) wid.p_value=value;
      break;
   case 'cb':
      if (wid) wid.p_text=value;
      break;
   case 'pi':
      if (wid) {
         wid.p_value=value;
         wid.call_event(wid,LBUTTON_UP)
      }
      break;
   case 'im':
      if (wid) {
         wid.p_value=value;
         wid.call_event(wid,LBUTTON_UP)
      }
      break;
   case 'ga':
      if (wid) wid.p_value=value;
      break;
   case 'tb':
      if (wid) wid.p_ActiveTab=value;
      break;
   default:
      done=1;
   }
   return(done);
}
int _retrieve_prev_form()
{
   return(_retrieve_next_form('-'));
}
int _retrieve_next_form()
{
   direction=arg(1);
   form_wid=p_active_form;
   form_name=form_wid.p_name
   if (form_name=='') return(1);
   get_view_id(view_id);
   activate_view(_dialogs_view_id);
   top();
   status=search("^"form_name'\:',"@re");
   if (status) {
      activate_view(view_id);
      return(status);
   }
   get_line(line);
   parse line with form_name':'NoflinesThatFollow NoflinesToCurRetrieve;
   if (form_wid.p_user2=='') {
      NoflinesToCurRetrieve=0; // Start retrieving from first dialog
      form_wid.p_user2=1;
   }
   if (direction=='-') {
      if (NoflinesToCurRetrieve>=NoflinesThatFollow) {
         activate_view(view_id);
         return(1);
      }
      ++NoflinesToCurRetrieve;
   } else {
      if (NoflinesToCurRetrieve<=1 || NoflinesThatFollow<=0) {
         activate_view(view_id);
         return(1);
      }
      --NoflinesToCurRetrieve;
   }
   save_pos(p);
   down(NoflinesToCurRetrieve);
   get_line(data);
   done=0;
   for (;;) {
      parse data with (CTLSEPARATOR) ctl_data (CTLSEPARATOR) +0 data;
      if (ctl_data=="") break;
      //messageNwait("_retrieve_next_form: ctl_data="ctl_data);
      done=_set_retrieve_value(form_wid,'',ctl_data);
      if (done) break;
   }
   restore_pos(p);
   replace_line(form_name':'NoflinesThatFollow' 'NoflinesToCurRetrieve);
   activate_view(view_id);
   if (arg(2)!='' && (p_object==OI_TEXT_BOX || p_object==OI_COMBO_BOX)) {
      _set_sel(1,length(p_text)+1)
   }
   return(rc);
}
_str def_retrieve_up=0;
void _retrieve_list(_str object_name='')/*,int noDuplicates=false)*/
{
   form_wid=p_active_form;
   form_name=form_wid.p_name
   ctl_name=p_name;
   if (p_cb) {
      ctl_name=p_cb.p_name;
   }
   if (object_name!='') {
      if(pos('.',object_name)){
         parse object_name with form_name '.' ctl_name
      } else {
         ctl_name=object_name;
      }
   }
   if (form_name=='' || ctl_name=='') {
      return;
   }
   get_view_id(view_id);
   output_wid=p_window_id
   if (output_wid.p_object==OI_COMBO_BOX) {
      output_wid=output_wid.p_cb_list_box;
   }
   activate_view(_dialogs_view_id);
   top();
   status=search("^"form_name"."ctl_name'\:',"@re");
   if (status) {
      status=search("^"form_name'\:',"@re");
   }
   if (status) {
      activate_view(view_id);
      return;
   }
   get_line(line);
   parse line with form_name':'NoflinesThatFollow NoflinesToCurRetrieve;
   if (def_retrieve_up) {
      down(NoflinesThatFollow);
   } else {
      down();
   }
   last_value='';
   while(NoflinesThatFollow--){
      get_line(data);
      for (;;) {
         parse data with (CTLSEPARATOR) ctl_data (CTLSEPARATOR) +0 data;
         if (ctl_data=="") break;
         parse ctl_data with dctl_type dctl_name':' value;
         if (dctl_name:==ctl_name) {
            if (value:!=last_value && value!="") {
               output_wid._lbtop();
               if(output_wid._lbsearch(value)){
                  output_wid._lbbottom();
                  output_wid._lbadd_item(value)
               }
               last_value=value;
            }
         }
      }
      //if (find_last_only) break;
      if (def_retrieve_up) {
         up();
      } else {
         down();
      }
   }
   activate_view(view_id);
   //if (find_last_only) return(value);
   if (p_cb) {
      // Try to find current text value in list
      status=p_cb._cbi_search('','$')
      if (!status) {
         output_wid._lbselect_line();
      }
   }
}

_str _retrieve_value()
{
   form_wid=p_active_form;
   form_name=form_wid.p_name
   ctl_name=p_name;
   if (arg(1)!='') {
      if(pos('.',arg(1))){
         parse arg(1) with form_name '.' ctl_name
      } else {
         ctl_name=arg(1);
      }
   }
   if (form_name=='' || ctl_name=='') return("");
   get_view_id view_id
   output_wid=p_window_id;
   activate_view(_dialogs_view_id);
   top();
   status=search("^"form_name"."ctl_name'\:',"@re");
   if (status) {
      status=search("^"form_name'\:',"@re");
   }
   if (status) {
      activate_view(view_id);
      return("");
   }
   get_line(line);
   parse line with form_name':'NoflinesThatFollow NoflinesToCurRetrieve;
   if (NoflinesThatFollow<=0) {
      activate_view(view_id);
      return("");
   }
   down();
   get_line(data);
   result="";
   for (;;) {
      parse data with (CTLSEPARATOR) ctl_data (CTLSEPARATOR) +0 data;
      if (ctl_data=="") break;
      parse ctl_data with dctl_type dctl_name':' value;
      if (dctl_name:==ctl_name) {
         result=value;
         _set_retrieve_value(form_wid,'',ctl_data);
         break;
      }
   }
   activate_view(view_id);
   //if (find_last_only) return(value);
   if (p_cb) {
      // Try to find current text value in list
      status=p_cb._cbi_search('','$')
      if (!status) {
         p_cb_list_box._lbselect_line();
      }
   }
   return(result);
}
void _DialogClearRetrieval(_str ObjectName)
{
   get_view_id(orig_view_id);
   activate_view(_dialogs_view_id);
   top();
   status=search('^'ObjectName'\:','r@');
   if (!status) {
      get_line(line);
      parse line with form_name':'NoflinesThatFollow NoflinesToCurRetrieve;
      if (isinteger(NoflinesThatFollow) && NoflinesThatFollow>0) {
         _delete_line();
         while (NoflinesThatFollow--) {
            _delete_line();
         }
      }
   }
   activate_view(orig_view_id);
}
_str _form_parent()
{
  wid=p_active_form.p_parent;
  if (!wid) {
     return(_mdi.p_child)
  }
  return(wid)
}

int _buf_transfer(int src_buf_id /*[,start_linenum [,end_linenum [,start_col [,end_col]]]]*/)
{
   if (src_buf_id<0) {
      get_view_id orig_view_id
      activate_view src_buf_id
      src_buf_id=p_buf_id
      activate_view orig_view_id
   }
   start_linenum=arg(2);end_linenum=arg(3)
   start_col=arg(4);end_col=arg(5);
   mark=_alloc_selection()
   if (mark<0) {
      _message_box('Unable to transfer data.  'get_message(TOO_MANY_SELECTIONS_RC))
      return(TOO_MANY_SELECTIONS_RC)
   }
   orig_buf_id=p_buf_id;

   p_buf_id=src_buf_id
   if (start_linenum=='') {
      top();
      // If there is no data to copy
      if (_on_line0()) {
         p_buf_id=orig_buf_id
         return(0);
      }
   } else {
      p_line=start_linenum;_begin_line
   }
   if (start_col=='' && end_col=='') {
      _select_line(mark);
      if (end_linenum=='') {
         bottom;
      } else {
         p_line=end_linenum;
      }
      _select_line(mark);
   } else {
      if (start_col!='') p_col=start_col;
      _select_char(mark);
      if (end_linenum=='') {
         bottom;
      } else {
         p_line=end_linenum;
      }
      if (end_col!='') p_col=end_col;
      _select_char(mark);
   }
   p_buf_id=orig_buf_id;
   _copy_to_cursor(mark);_end_select(mark);
   _free_selection(mark);
   return(0);
}
void _lxy2lxy(int in_scale,int out_scale,int &x,int &y)
{
   _lxy2dxy(in_scale,x,y)
   _dxy2lxy(out_scale,x,y)
}
int _lx2lx(int in_scale,int out_scale,int x)
{
   y=0;
   _lxy2dxy(in_scale,x,y)
   _dxy2lxy(out_scale,x,y)
   return(x);
}
int _ly2ly(int in_scale,int out_scale,int y)
{
   x=0;
   _lxy2dxy(in_scale,x,y)
   _dxy2lxy(out_scale,x,y)
   return(y);
}
int _dx2lx(int scale,int x)
{
   y=0;
   _dxy2lxy(scale,x,y)
   return(x);
}
int _dy2ly(int scale,int y)
{
   x=0;
   _dxy2lxy(scale,x,y)
   return(y);
}
int _lx2dx(int scale,int x)
{
   y=0;
   _lxy2dxy(scale,x,y)
   return(x);
}
_str _ly2dy(scale,y)
{
   x=0;
   _lxy2dxy(scale,x,y)
   return(y);
}
/*
   Switching buffers while the hidden window is active can cause the following
   problems:

   *  If a view other than the HIDDEN_VIEW_ID is active, and the original buffer
      is not restored, a system macro may start modifying a buffer the user is
      editing.

   *  If the hidden window already has a buffer that the user is editing active, the old
      buffer position information may get destroyed.


*/
void _safe_hidden_window()
{
   if (p_window_flags & HIDE_WINDOW_OVERLAP) {
      activate_view HIDDEN_VIEW_ID
      // The +m option preserves the old buffer position information for the current buffer
      load_files '+m +bi 'RETRIEVE_BUF_ID
   }
}
#if 0
_TagFileModified_test1()
{
   say('modify 1='arg(1)' 2='arg(2)' 3='arg(3));
}
_TagFileAddRemove_test1()
{
   say('addrem 1='arg(1)' 2='arg(2)' 3='arg(3));
}
_TagFileRefresh_test1()
{
   say('refresh 1='arg(1)' 2='arg(2)' 3='arg(3));
}
#endif
/*
    This function only supports CHAR or LINE type selections.
*/
_str _QSelection()
{
   MustBeOneLine=arg(1)!="" && arg(1);
   MaximumNumberOfBytes=arg(2);
   if (MaximumNumberOfBytes=='') {
      MaximumNumberOfBytes=256000;
   }
   if(!select_active() ) return("");
   if (_select_type()=='BLOCK') {
      return("");
   }
   _get_selinfo(start_col,end_col,buf_id);
   save_pos(p);
   mark_locked=0;
   if (_select_type('','S')=='C') {
      mark_locked=1;
      _select_type('','S','E');
   }
   _begin_select();
   if (_select_type()=='LINE') {
      _begin_line();
   }
   start_offset=_nrseek()
   _end_select();
   if (_select_type()=='CHAR' && _select_type('','I')) {
      if (get_text()=="\r") {
         _end_line();p_col+=2;
      } else {
         right();
      }
   }
   if (_select_type()=='LINE') {
      _end_line();p_col+=2;
   }
   end_offset=_nrseek();
   //_begin_select();
   //messageNwait('start='start_offset' end='end_offset);
   text=get_text(end_offset-start_offset,start_offset);
   restore_pos(p);
   if (mark_locked) {
      _select_type('','S','C');
   }
   return(text);
}

int _no_child_windows()
{
   return(_mdi.p_child.p_window_flags &HIDE_WINDOW_OVERLAP);
}
boolean _isEditorCtl()
{
   return(p_view_id<0 && 
          (p_object==OI_EDITOR || 
            (p_object==OI_FORM && !(p_window_flags &HIDE_WINDOW_OVERLAP))
          )
         );
}
void _exit_scroll()
{
   if(p_scroll_left_edge>=0) p_scroll_left_edge=-1;
}
