/*
$VerboseHistory: softb.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:10:13a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 10:13a
 * Comment:
 * Change message box to display question mark icon.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:35p
 * Updated in \vault\vsship30\
 * Last Modified: 10/09/1997 02:27p
 * Comment:
 * Adding new 3.0 stuff
*/
#include "slick.sh"

/*
   Some notes
      Configuring VS to be the default SoftBench editor
      Edit the file
            /usr/softbench/config/softinitsrc/class-defaults/softbenchinit
                             OR
            /opt/softbench/config/softinitsrc/class-defaults/softbenchinit

      Insert # before line which looks like the one below
              EDIT      TOOL    NET    *          %Local%    softeditsrv -scope net -types %Types%
      Add line
              EDIT      TOOL    NET    *          %Local%    /usr/bin/vs

*/

   typeless def_sbwarn_reload_modify;  // Effects RELOAD-FILE request
   typeless _sbversion;                // Softbench version. Global for debugging
   static typeless _hostname;
   static typeless _sbbufinfo_view_id
   static typeless _sballow_read;
   static typeless _canon_path

   // These variables are not static to allow for reloading during
   // macro developement.
   typeless _softmclient_infh,_softmclient_outfh;
   typeless _softmclient_pid=0;
   typeless _softbench_msgnum=1;

   typeless _canon_infh,_canon_outfh;
   typeless _canon_pid=0;
   typeless _canon_cwd


   typeless _sbmark_list;    // Space delimited list of mark ids allocated by SET-MARK
   typeless _sbmake_triple;  // Last Make/Compile target triple

_softbench_running()
{
   return(_softmclient_pid);
}
definit()
{
   if (arg(1)!='L') {
      _sbmake_triple='';
      _softmclient_pid= 0;
      _softbench_msgnum=1;
      _sbmark_list='';
   }
   if ((machine()!='HP9000' && machine()!='SPARCSOLARIS') || (get_env('VSLICKNOSOFTBENCH') && rc==0)) {
      rc=0;
      return;
   }
   softmclient_path=path_search("softmclient","PATH",'P');
   if (softmclient_path=='') {
      rc=0;
      return;
   }
   softmclient_path=absolute(softmclient_path);
   _canon_path=path_search("canon","PATH",'P');
   if (_canon_path=='') {
      // Assume we are running SoftBench 4.0 and run the canon program
      // shipped with Visual SlickEdit
      if (machine()=='HP9000') {
         _canon_path=slick_path_search("canon4");
      } else {
         _canon_path=slick_path_search("canon.solaris");
      }
      if (_canon_path=='') {
         rc=0;
         return;
      }
      _canon_path=absolute(_canon_path);
   }
   //  IF definit called because editor was started

   get_view_id old_view_id
   activate_view HIDDEN_VIEW_ID
   status=find_view('.sbbufinfo')
   if ( status ) {
      /* Create buffer in hidden window group called .bookmark */
      load_files '+c +t'
      if ( rc ) {
         messageNwait(nls('Could not create bookmark buffer'))
         return
      }
      p_buf_name='.sbbufinfo';_delete_line;rc=0
      p_buf_flags= THROW_AWAY_CHANGES|HIDE_BUFFER|KEEP_ON_QUIT
   }
   /* Note: ELSE case can not empty bookmark buffer unless mark ids */
   /* are freed.  Might as well leave them. */
   get_view_id _sbbufinfo_view_id
   activate_view old_view_id

   _sballow_read=1;
   _hostname=_gethostname();
   if (!_softmclient_pid) {
      _canon_cwd="";
      callback_index=find_index('_hpsbprocess_callback',PROC_TYPE);
      status=_pipe_process(_softmclient_infh,_softmclient_outfh,_softmclient_pid,softmclient_path" VSLICK",'',callback_index);
      //status=_pipe_process(_softmclient_infh,_softmclient_outfh,_softmclient_pid,"echo this is a test",callback_index);
      if (status) {
         _softmclient_pid=0;
         if (status==FILE_NOT_FOUND_RC) {
            _message_box("Could not find softmclient program");
         } else {
            _message_box("Could not start softmclient program");
         }
         return;
      }
      // Determine softbench version and set _sbversion variable
      filename=strip_filename(softmclient_path,'N');
      if (last_char(filename)=='/') {
         // strip bin directory
         filename=substr(filename,1,length(filename)-1);
         filename=strip_filename(filename,'N');
      }
      if (last_char(filename)!='/') filename=filename:+'/';
      _sbversion=4;
      filename=filename:+"config/products/softbench";
      status=_open_temp_view(filename,temp_view_id,orig_view_id);
      if (status) {
         filename2=filename'.cxx';
         status=_open_temp_view(filename,temp_view_id,orig_view_id);
         if (status) {
            filename2=filename'.HPMFCobol';
            status=_open_temp_view(filename,temp_view_id,orig_view_id);
         }
      }
      if (!status) {
         get_line(line);
         parse line with 'Revision' '.0#','r' _sbversion '.'
         _delete_temp_view(temp_view_id);
         activate_view(orig_view_id);
      }
#if 0
      // original testing code.
      _broadcast_message("R MSG-SERVER ACCEPT * * R EDIT START * * *\n");
      _broadcast_message("R MSG-SERVER ACCEPT * * R EDIT STOP * * *\n");
      _broadcast_message("R MSG-SERVER ACCEPT * * R EDIT VIEW * * *\n");
      _broadcast_message("R MSG-SERVER ACCEPT * * R EDIT WINDOW * * *\n");
      _broadcast_message("R MSG-SERVER ACCEPT * * R EDIT SET-CONTEXT * * *\n");
      _broadcast_message("R MSG-SERVER ACCEPT * * N * FILE-MODIFIED * * *\n");
#endif

      // Accept iconifiy app
      _broadcast_message("R MSG-SERVER ACCEPT * * R - ICONIFY - - -\n");
      // Accept normalize app
      _broadcast_message("R MSG-SERVER ACCEPT * * R - NORMALIZE - - -\n");
      // Accept stop app
      _broadcast_message("R MSG-SERVER ACCEPT * * R - STOP - - -\n");
      // Accept app status
      _broadcast_message("R MSG-SERVER ACCEPT * * R - STATUS - - -\n");
      // Accept file modified notify
      _broadcast_message("R MSG-SERVER ACCEPT * * N * FILE-MODIFIED * * *\n");

      // When the editor starts we request the status of the build tool
      // because for some reason if the editor is not running and you execute the
      // error commands in the BUILD tool, the editor does not get notified.
      // The N ???-ERRROR message is sent but we don't see it.
      // Unfortunately we may start talking to the wrong build tool if more than
      // one is up.
      _broadcast_message("R MSG-SERVER ACCEPT * * N BUILD STATUS * * *\n");
      // Can't just request the BUILD tool status because that would start one
      // running.
      _broadcast_message("R - STATUS - - - -\n");

      // Catch ????-ERROR notification so we know which BUILD tool the editor
      // error commands are talking to.
      _broadcast_message("R MSG-SERVER ACCEPT * * N BUILD FIRST-ERROR * * *\n");
      _broadcast_message("R MSG-SERVER ACCEPT * * N BUILD LAST-ERROR * * *\n");
      _broadcast_message("R MSG-SERVER ACCEPT * * N BUILD NEXT-ERROR * * *\n");
      _broadcast_message("R MSG-SERVER ACCEPT * * N BUILD PREVIOUS-ERROR * * *\n");

      //We need to know when users starts build from build tool.
      _broadcast_message("R MSG-SERVER ACCEPT * * F * BUILD-TARGET * * *\n");

      //We need to know when users sets the build directory (SET-CONTEXT) from
      // the build tool
      _broadcast_message("R MSG-SERVER ACCEPT * * N BUILD SET-CONTEXT * * *\n");

      //_broadcast_message("R MSG-SERVER ACCEPT * * F BUILD NEXT-ERROR * * *\n");
      //_broadcast_message("R MSG-SERVER ACCEPT * * F BUILD PREVIOUS-ERROR * * *\n");

      // Accept any command you can type on the VS command line.
      // return status of command followed by seek-pos,linenum, and column are
      // returned.
      _broadcast_accept('VSCOMMAND');
      _broadcast_accept('ICONIFY');
      _broadcast_accept('NORMALIZE');
      _broadcast_accept('STOP');
      //_broadcast_accept('RESTART');
      _broadcast_accept('START');
      _broadcast_accept('VIEW');
      _broadcast_accept('WINDOW');
      //_broadcast_accept('MESSAGE');
      _broadcast_accept('SET-CONTEXT');
      _broadcast_accept('SAVE-FILE');
      _broadcast_accept('RELOAD-FILE');
      _broadcast_accept('INSERT');
      _broadcast_accept('INSERT-FILE');
      _broadcast_accept('DELETE');
      _broadcast_accept('DELETE-FORWARD-CHAR');
      _broadcast_accept('TEXT-REPLACE');
      _broadcast_accept('CLEAR');
      _broadcast_accept('NEW-LINE');
      _broadcast_accept('OPEN-LINE');
      _broadcast_accept('END-OF-LINE');
      _broadcast_accept('BEG-OF-LINE');
      _broadcast_accept('END-OF-BUFFER');
      _broadcast_accept('BEG-OF-BUFFER');
      _broadcast_accept('FORWARD-CHAR');
      _broadcast_accept('BACKWARD-CHAR');
      _broadcast_accept('FORWARD-WORD');
      _broadcast_accept('BACKWARD-WORD');
      _broadcast_accept('GO-TO-POS');
      _broadcast_accept('GO-TO-LINE');
      _broadcast_accept('NEXT-LINE');
      _broadcast_accept('PREV-LINE');
      _broadcast_accept('NEXT-PAGE');
      _broadcast_accept('PREV-PAGE');
      _broadcast_accept('CURRENT-POSITION');
      _broadcast_accept('CLEAR-SELECTION');
      _broadcast_accept('SET-SELECTION');
      _broadcast_accept('DELETE-SELECTION');
      _broadcast_accept('CUT');
      _broadcast_accept('PASTE');
      _broadcast_accept('COPY');
      _broadcast_accept('UNDO');
      _broadcast_accept('BEG-OF-BLOCK');
      _broadcast_accept('END-OF-BLOCK');
      _broadcast_accept('SELECT-BLOCK');
      _broadcast_accept('PREVIOUS-PRECEDURE');
      _broadcast_accept('NEXT-PROCEDURE');
      _broadcast_accept('SELECT-PROCEDURE');
      //_broadcast_accept('BACKWARD-STATEMENT');
      //_broadcast_accept('FORWARD-STATEMENT');
      //_broadcast_accept('SELECT-STATEMENT');
      //_broadcast_accept('BACKWARD-TOKEN');
      //_broadcast_accept('FORWARD-TOKEN');
      //_broadcast_accept('SELECT-TOKEN');
      //_broadcast_accept('DELETE-BACKWARD-TOKEN');
      //_broadcast_accept('DELETE-FORWARD-TOKEN');
      _broadcast_accept('INDENT-SELECTION');
      //_broadcast_accept('FIXED-INDENT');  VSCOMMAND INDENT-SELECTION does not use global indent variable
      //_broadcast_accept('FIXED-UNINDENT'); VSCOMMAND UNINDENT-SELECTION does not use global indent variable
      _broadcast_accept('POSITION-INFO');
      _broadcast_accept('SAVE-FILE-AS');
      _broadcast_accept('SET-MARK');
      _broadcast_accept('CLEAR-MARK');
      _broadcast_accept('GO-TO-MARK');
      //_broadcast_accept('BEGIN-INDENT');   Don't know what this does
      //_broadcast_accept('INDENT');         Don't know what this does
      //_broadcast_accept('SUBSTATEMENT-INDENT');   Don't know what this does
      //_broadcast_accept('TAB-SIZE');  VS tabs and indent are separate.  Can't modify indent for current buffer only.
      //_broadcast_accept('SHOW-MATCH');  Don't know what this does
      //_broadcast_accept('AUTO-INDENT');  Don't know what this does
      //_broadcast_accept('AUTO-SET-SELECTION');  Don't know what this does
      //_broadcast_accept('AUTO-CLEAR-SELECTION');  Don't know what this does
      //_broadcast_accept('FORCE-NEW-STACK');   Doubt we need this.
      _broadcast_message("N EDIT STATUS * * * * READY\n");
   }
}

static int _broadcast_accept(string)
{
   return(_broadcast_message("R MSG-SERVER ACCEPT * * R EDIT "string" * * *\n"));
}
int _broadcast_message(string)
{
   //messageNwait('_softmclient_outfh='_softmclient_outfh' hostname='_hostname' string='string);
    _file_write(_softmclient_outfh,new_request_id()' 'string);
    return(_softbench_msgnum);
}
static int _broadcast_notify(request_id,string)
{
   //messageNwait('_softmclient_outfh='_softmclient_outfh' hostname='_hostname' string='string);
    _file_write(_softmclient_outfh,request_id' 'string);
    return(_softbench_msgnum);
}

static _sbactivate_path(path,var orig_view_id)
{
   get_view_id(orig_view_id);
   p_window_id=_mdi.p_child;
   if (p_buf_name==path) return(0);
   wid=window_match(path,1,'xn');
   if (wid) {
      p_window_id=wid;
      return(0);
   }
   activate_view(HIDDEN_VIEW_ID);
   // Don't pick cursor informat for current buffer.
   // The +m option preserves the old buffer position information for the current buffer
   load_files('+m +bi 'RETRIEVE_BUF_ID);
   status=load_files('+q +b 'path);
   if (status) {
      activate_view(orig_view_id);
      _safe_hidden_window();
      return(status);
   }
   return(0);
}
static new_request_id()
{
   request_id=_softbench_msgnum"-"_softmclient_pid"-"_hostname;
   ++_softbench_msgnum;
   return(request_id);
}
void _cbsave_softbench()
{
   if (!_softbench_running()) return;
   triple=get_bufinfo(p_buf_id);
   //say('_cbquit_softbench p_buf_name='p_buf_name' triple='triple);
   if (triple!='') {
      _broadcast_notify('*', "N EDIT FILE-MODIFIED "triple"\n");
   }
}
void _cbquit_softbench()
{
   if (!_softbench_running()) return;
   // Don't do this (name might have changed)-->if (substr(p_buf_name,1,1)!=FILESEP) return;
   triple=get_bufinfo(p_buf_id);
   //say('_cbquit_softbench p_buf_name='p_buf_name' triple='triple);
   if (triple!='') {
      sbstop_server(triple,0);
   }

}
static typeless notify_buf_name
static typeless notify_request_id;
static typeless notify_triple;
void _switchbuf_softbench(old_buffer_name)
{
   if (!_softbench_running()) return;
   //say('_switchbuf_softbench: p_buf_name='p_buf_name);
   if (substr(p_buf_name,1,1)!=FILESEP) return;
   info=get_bufinfo(p_buf_id);
   //messageNwait('info='info' p_buf_name='p_buf_name' nb='notify_buf_name);
   if (info=='') {
      if (notify_buf_name!='' && p_buf_name==notify_buf_name) {
         //notify_request_id=;
      } else {
         request_id=new_request_id();
         notify_request_id=request_id;
         notify_triple=_sbbufname_to_triple(p_buf_name);
      }
      request_id=new_request_id();
      if (lowcase(p_mode_name)=='read only') {
         _broadcast_notify(notify_request_id, "N EDIT VIEW "notify_triple"\n");
      } else {
         _broadcast_notify(notify_request_id, "N EDIT WINDOW "notify_triple"\n");
      }
      _broadcast_notify(request_id, "N EDIT START "notify_triple"\n");
      set_bufinfo(p_buf_id,notify_triple);
      notify_buf_name='';
   }
   //say('_switchbuf_softbench out');
}
static process_server_message(var line)
{
   //say(line);
   parse line with sender request_id message_type tool_class message_name host dir file data
   if (message_type=='R' && tool_class=='EDIT') {
      triple=_sbhdo_to_triple(host,dir,file);
      switch (message_name) {
      case 'SET-CONTEXT':
         path=_sbtriple_to_path(data);
         p_window_id=_mdi;
         status=edit(maybe_quote_filename(path));
         if (status) {
            _broadcast_notify(request_id, "F EDIT "message_name" "triple" failed to load file. "get_message(status)"\n");
            break;
         } else {
            _broadcast_notify(request_id, "N EDIT "message_name" "triple" "data"\n");
         }
         _mdi._set_foreground_window();
         break;
      case 'STOP':
         sbstop_server(host' 'dir' 'file,1);
         break;
      case 'ICONIFY':
         _mdi.p_window_state='I'
         //sbstop_server(host' 'dir' 'file,1);
         _broadcast_notify(request_id, "N EDIT "message_name" "triple"\n");
         break;
      case 'NORMALIZE':
         _mdi.p_window_state='N'
         //sbstop_server(host' 'dir' 'file,1);
         _broadcast_notify(request_id, "N EDIT "message_name" "triple"\n");
         break;
      case 'SET-MARK':
         path=_sbhdo_to_path(host,dir,file);
         if(_sbactivate_path(path,old_view_id)) {
            old_view_id='';
            notify_buf_name=path;notify_request_id=request_id;
            notify_triple=host" "dir" "file;
            //messageNwait('path='path);
            p_window_id=_mdi;
            status=edit(maybe_quote_filename(path));
            notify_buf_name='';
            if (status) {
               _broadcast_notify(request_id, "F EDIT "message_name" "triple" failed to load file. "get_message(status)"\n");
               break;
            }
            _mdi._set_foreground_window();
         }
         status=_sbset_mark(data,msg);
         if (status) {
            _broadcast_notify(request_id, "F EDIT "message_name" "triple" failed to set-marks.  "get_message(status)"\n");
         } else {
            _broadcast_notify(request_id, "N EDIT "message_name" "triple" "msg"\n");
         }
         _mdi.p_window_state='N';
         if (old_view_id!='') {
            activate_view(old_view_id);_safe_hidden_window();
         }
         break;
      case 'GO-TO-MARK':
      case 'WINDOW':
         //_sbstatus_busy();
         path=_sbhdo_to_path(host,dir,file);
         notify_buf_name=path;notify_request_id=request_id;
         notify_triple=host" "dir" "file;
         //messageNwait('path='path);
         p_window_id=_mdi;
         status=edit(path);
         if (status==NEW_FILE_RC) status=0;
         // IF command succeeded and we did not notify sender of success
         if (!status && notify_buf_name!='' && message_name=='WINDOW') {
            _broadcast_notify(notify_request_id, "N EDIT WINDOW "notify_triple"\n");
         }
         _mdi.p_window_state='N';
         notify_buf_name='';
         if (status) {
            _broadcast_notify(request_id, "F EDIT "message_name" "triple" failed to load file. "get_message(status)"\n");
            break;
         }
         //_sbstatus_ready();
         switch (message_name) {
         case 'GO-TO-MARK':
            status=_sbgo_to_mark(data);
            if (status) {
               _broadcast_notify(request_id, "F EDIT "message_name" "triple" Unable to go to mark.  "get_message(status)"\n");
            } else {
               _mdi._set_foreground_window();
               _broadcast_notify(request_id, "N EDIT "message_name" "triple" "_sbpos_info()"\n");
            }
            break;
         case 'WINDOW':
            if (data!='') _sbgo_to_pos('* 'data,'');
            _mdi._set_foreground_window();
            break;
         }
         break;
      case 'VIEW':
         path=_sbhdo_to_path(host,dir,file);
         //messageNwait('path='path);
         p_window_id=_mdi;
         notify_buf_name=path;notify_request_id=request_id;
         notify_triple=host" "dir" "file;
         status=edit(path);
         if (status==NEW_FILE_RC) status=0;
         if (!status) {
            read_only_mode();
         }
         // IF command succeeded and we did not notify sender of success
         if (!status && notify_buf_name!='') {
            _broadcast_notify(notify_request_id, "N EDIT VIEW "notify_triple"\n");
         }
         _mdi.p_window_state='N';
         notify_buf_name='';
         if (status) {
            _broadcast_notify(request_id, "F EDIT "message_name" "triple" failed to load file. "get_message(status)"\n");
            break;
         }
         if (data!='') _sbgo_to_pos('* 'data,'');
         _mdi._set_foreground_window();
         break;
      case 'CLEAR-MARK':
         status=_sbclear_mark(data,msg);
         if (status) {
            _broadcast_notify(request_id, "F EDIT "message_name" "triple" failed to clear-mark.  "get_message(status)"\n");
         } else {
            _broadcast_notify(request_id, "N EDIT "message_name" "triple" "_sbpos_info()" "msg"\n");
         }
         break;
      default:
         path=_sbhdo_to_path(host,dir,file);
         if(_sbactivate_path(path,old_view_id)) {
            _broadcast_notify(request_id, "F EDIT "message_name" "triple" file not being edited\n");
            break;
         }
         msg="";
         switch (message_name) {
         case 'SAVE-FILE':
            _sbstatus_busy();   // This function may display a message box
            status=save();
            if (status) {
               msg="Unable to save file. "get_message(status);
            }
            _sbstatus_ready();
            break;
         case 'RELOAD-FILE':
            _sbstatus_busy();   // This function may display a message box
            status=_sbreload_file(path,0);
            if (status) {
               msg="Unable to reload file. "get_message(status);
            }
            _sbstatus_ready();
            break;
         case 'INSERT':
            _sbinsert(data);
            status=0;
            msg=_sbpos_info();
            break;
         case 'INSERT-FILE':
            status=_insert_file(_sbtriple_to_path(data),1);
            if (status) {
               msg="Unable to insert file. "get_message(status);
            } else {
               msg=_sbpos_info();
            }
            break;
         case 'DELETE':
         case 'DELETE-FORWARD-CHAR':
            _sbdelete(data);
            status=0;
            msg=_sbpos_info();
            break;
         case 'CLEAR':
            _lbclear();
            status=0;
            msg=_sbpos_info();
            break;
         case 'NEW-LINE':
            _sbnew_line(data);
            status=0;
            msg=_sbpos_info();
            break;
         case 'OPEN-LINE':
            _sbopen_line(data);
            status=0;
            msg=_sbpos_info();
            break;
         case 'END-OF-LINE':
            _end_line();
            status=0;
            msg=_sbpos_info();
            break;
         case 'BEG-OF-LINE':
            _begin_line();
            status=0;
            msg=_sbpos_info();
            break;
         case 'END-OF-BUFFER':
            bottom();
            status=0;
            msg=_sbpos_info();
            break;
         case 'BEG-OF-BUFFER':
            top();
            status=0;
            msg=_sbpos_info();
            break;
         case 'FORWARD-CHAR':
            _sbforward_char(data);
            status=0;
            msg=_sbpos_info();
            break;
         case 'BACKWARD-CHAR':
            _sbbackward_char(data);
            status=0;
            msg=_sbpos_info();
            break;
         case 'FORWARD-WORD':
            _sbforward_word(data);
            status=0;
            msg=_sbpos_info();
            break;
         case 'BACKWARD-WORD':
            _sbbackward_word(data);
            status=0;
            msg=_sbpos_info();
            break;
         case 'GO-TO-POS':
            _sbgo_to_pos(data,'');
            status=0;msg=_sbpos_info();
            break;
         case 'GO-TO-LINE':
            if (isinteger(data)) {
               status=0;
               p_line=data;
               msg=_sbpos_info();
            } else {
               status=INVALID_ARGUMENT_RC;
               msg=get_message(status);
            }
            break;
         case 'NEXT-LINE':
         case 'PREV-LINE':
         case 'NEXT-PAGE':
         case 'PREV-PAGE':
            _sbnextprev_pageline(data,message_name);
            msg=_sbpos_info();status=0;
            break;
         case 'CURRENT-POSITION':
         case 'POSITION-INFO':
            msg=_sbpos_info();status=0;
            break;
         case 'CLEAR-SELECTION':
            // IF we want to emulate the softbench editor, we could do
            // and _end_select() call here.
            _deselect();
            break;
         case 'TEXT-REPLACE':
            parse data with start_seek end_seek text
            // We may want to preserve the active selection instead of
            // destroying it.
            status=_sbset_selection(start_seek,end_seek);
            if (status) {
               msg=get_message(status);
            } else {
               _begin_select();
               _delete_selection();
               _sbinsert(text);
               status=0;msg=_sbpos_info();
            }
            break;
         case 'SET-SELECTION':
            parse data with start_seek end_seek
            status=_sbset_selection(start_seek,end_seek);
            if (status) {
               msg=get_message(status);
            } else {
               status=0;msg=_sbpos_info();
            }
            break;
         case 'DELETE-SELECTION':
            if (_select_type()=='') {
               status=TEXT_NOT_SELECTED_RC;
               msg=get_message(status);
            } else {
               _begin_select();_delete_selection();
               msg=_sbpos_info();status=0;
            }
            break;
         case 'CUT':
            cut();
            msg=_sbpos_info();status=0;
            break;
         case 'PASTE':
            paste();
            msg=_sbpos_info();status=0;
            break;
         case 'COPY':
            copy_to_clipboard();
            msg=_sbpos_info();status=0;
            break;
         case 'UNDO':
            undo();
            msg=_sbpos_info();status=0;
            break;
         case 'BEG-OF-BLOCK':
            status=_sbbeg_of_block(data);
            if (status) {
               msg="Unable to find beginning of block. "get_message(status);
            } else {
               msg=_sbpos_info();
            }
            break;
         case 'END-OF-BLOCK':
            status=_sbend_of_block(data);
            if (status) {
               msg="Unable to find end of block. "get_message(status);
            } else {
               msg=_sbpos_info();
            }
            break;
         case 'SELECT-BLOCK':
            status=_sbbeg_of_block(data);
            if (!status) {
               _select_char('','C');
               status=find_matching_paren();
               if (status) {
                  _deselect();
               } else {
                  right();
               }
            }
            if (status) {
               msg="Unable to select block. "get_message(status);
            } else {
               msg=_sbpos_info();
            }
            break;
         case 'NEXT-PROCEDURE':
            status=next_proc(data);
            if (status) {
               msg="Unable to select procedure. "get_message(status);
            } else {
               msg=_sbpos_info();
            }
            break;
         case 'PREVIOUS-PROCEDURE':
            status=prev_proc(data);
            if (status) {
               msg="Unable to select procedure. "get_message(status);
            } else {
               msg=_sbpos_info();
            }
            break;
         case 'SELECT-PROCEDURE':
            status=select_proc(data);
            if (status) {
               msg="Unable to select procedure. "get_message(status);
            } else {
               msg=_sbpos_info();
            }
            break;
         case 'FIXED-INDENT':
            if (_select_type()=='') {
               move_text_tab();
               msg=_sbpos_info();status=0;
            } else {
               indent_selection();
               msg=_sbpos_info();status=0;
            }
            break;
         case 'FIXED-UNINDENT':
            if (_select_type()=='') {
               move_text_backtab();
               msg=_sbpos_info();status=0;
            } else {
               unindent_selection();
               msg=_sbpos_info();status=0;
            }
            break;
         case 'SAVE-FILE-AS':
            status=save(_sbtriple_to_path(data),SV_OVERWRITE/* overwrite without prompting. */);
            if (status) {
               msg="Unable to save file. "get_message(status);
            } else {
               msg=data;
            }
            break;
         case 'VSCOMMAND':
            status=execute(data);
            msg=status' '_sbpos_info();
            break;
         default:
            msg='UNKNOWN COMMAND';
         }
         // Ensure that each command is a separate undoable step
         _undo('s');
         // Set the old cursor(view) information for the current buffer.
         _next_buffer('H');_prev_buffer('H');
         if (status) {
            _broadcast_notify(request_id, "F EDIT "message_name" "triple" ":+msg"\n");
         } else {
            _broadcast_notify(request_id, "N EDIT "message_name" "triple" ":+msg"\n");
         }
         activate_view(old_view_id);_safe_hidden_window();
      }
   } else if (message_type=='R' && file=='-' && message_name=='ICONIFY') {
      _mdi.p_window_state='I';
   } else if (message_type=='R' && file=='-' && message_name=='NORMALIZE') {
      _mdi.p_window_state='N';
   } else if (message_type=='R' && file=='-' && message_name=='STOP') {
      _sbstatus_busy();
      safe_exit();
      _sbstatus_ready();
   } else if (message_type=='F' && tool_class=='BUILD') {
      triple=_sbhdo_to_triple(host,dir,file);
      switch (message_name) {
      case 'FIRST-ERROR':
      case 'LAST-ERROR':
      case 'NEXT-ERROR':
      case 'PREVIOUS-ERROR':
         parse data with loudness more;
         loudness=upcase(loudness);
         if (loudness=='QUIET' || loudness=='NOT-QUIET') {
            data=more;
         }
         _post_call(find_index('popup_message',COMMAND_TYPE),data);
         break;
      case 'BUILD-TARGET':
         _beep();
         _sbmake_triple=triple;
         command='next-error'
         msg=_mdi.p_child.where_is('next-error',1);
         parse msg with . . bound . keys ','
         if (bound=='bound') {
            sticky_message("Press "keys" to check for compilation errors");
         } else {
            sticky_message("From the Project menu select Next Error... to check for compilation errors");
         }
      }
   } else if (message_type=='N' && message_name=='FILE-MODIFIED') {
      if (file=='*' || file=='-') {
         // Suppress reload prompt --> (def_actapp&4)
         old_def_actapp=def_actapp;
         def_actapp=1+4;  // Turn auto-reload, suppress reload prompt
         if (def_sbwarn_reload_modify) {
            def_actapp=1|(old_def_actapp&4);    // Remove supress reload prompt
            def_actapp|=8;     //Warn if file is modified.  Otherwise no prompt.
         }
         _on_activate_app(1);
         def_actapp=old_def_actapp;
      } else {
         path=_sbhdo_to_path(host,dir,file);
         buf_name=buf_match(path,1,'X');
         if (buf_name!='') {
            if(!_sbactivate_path(path,old_view_id)) {
               _sbstatus_busy();   // This function may display a message box
               status=_sbreload_file(path,1);
               if (status) {
                  msg="Unable to reload file. "get_message(status);
               }
               _sbstatus_ready();
               activate_view(old_view_id);_safe_hidden_window();
            }
         }
      }
   } else if (message_type=='N' && tool_class=='CM') {
      path=_sbhdo_to_path(host,dir,file);
      switch (message_name) {
      case 'VERSION-CHECK-OUT':
         p_window_id=_mdi;
         status=edit(maybe_quote_filename(path));
         break;
      }
   } else if (message_type=='N' && tool_class=='BUILD') {
      triple=_sbhdo_to_triple(host,dir,file);
      switch (message_name) {
      case 'FIRST-ERROR':
      case 'LAST-ERROR':
      case 'NEXT-ERROR':
      case 'PREVIOUS-ERROR':
         // 5.0 only
         parse data with loadness srchost srcdir srcfile lineno . msg
         sticky_message(msg);
         if (_sbversion>=5) {
            path=_sbhdo_to_path(srchost,srcdir,srcfile);
            p_window_id=_mdi;
            status=edit(path);
            if (!status && isinteger(lineno)) {
               _sbgo_to_pos('* 'lineno,'');
            }
            _mdi._set_foreground_window();
            break;
         }
      case 'STATUS':     // This should only occur when the editor starts
         _sbmake_triple=triple;
         break;
      case 'SET-CONTEXT':
         _sbmake_triple=data;
         break;
      }
   } else if (message_type=='N' && tool_class=='STATIC') {
      triple=_sbhdo_to_triple(host,dir,file);
      switch (message_name) {
      case 'SHOW-DEFINITION':
         parse data with quiet . . . . keyword Nofhits canontmpfile .
         if (keyword=='FILE') {
            _sbstatic_show_list('Select a Tag',_sbcanon_to_path(canontmpfile),1);
         }
         break;
      }
   } else if (message_type=='F' && tool_class=='STATIC') {
      triple=_sbhdo_to_triple(host,dir,file);
      switch (message_name) {
      case 'SHOW-DEFINITION':
         parse data with . msg
         _post_call(find_index('popup_message',COMMAND_TYPE),msg);
         break;
      }
   } else if (message_type=='F' && tool_class=='CM') {
      triple=_sbhdo_to_triple(host,dir,file);
      switch (message_name) {
      case 'VERSION-CHECK-IN':
      case 'VERSION-CHECK-OUT':
         msg=data;
         _post_call(find_index('popup_message',COMMAND_TYPE),msg);
         break;
      }
   }
   if (message_type=='R' && message_name=='STATUS') {
      // This broadcast request status or just edit tool_class
      _broadcast_notify(new_request_id(),"N EDIT STATUS * * * * READY\n");
      if (host=='*' || host=='-') {
         get_view_id(old_view_id);
         activate_view(_sbbufinfo_view_id);
         top();up();
         for (;;) {
            if (down()) break;
            get_line(triple);
            if (triple!='') {
               _broadcast_notify(new_request_id(), "N EDIT START "triple"\n");
            }
         }
         activate_view(old_view_id);
      }
   }
}
static typeless gbuffer;
int _hpsbprocess_callback(reason,infh,outfh,pid)
{
   if (reason ) {
      _softmclient_pid=0;
      _softbench_msgnum=1;
      //_message_box('softmclient exited');
      return(0);
   }
   if (!_mdi.p_enabled) return(0);
   if (!_sballow_read) return(0);
   len=_file_read(infh,more,1024);
   if (len>=0) {
      gbuffer=gbuffer:+more;
      //say 'gbuffer='gbuffer' more='more
      for (;;) {
         i=pos("\n",gbuffer);
         if (!i) break;
         parse gbuffer with line "\n" gbuffer;
         //say('line='line);
         process_server_message(line);
      }
   }
   return(0);
}
static void sbstop_server(triple,doquit)
{
   //say('sbstop_server 'triple' doquit='doquit);
   triple=arg(1);
   if (_softmclient_pid) {
      parse triple with host .
      if (host=='*' || host=='-') {
         _sbremove_all_marks();
         // stop every editor buffer.
         // Don't need to quit buffers because we know we are exiting the editor
         // unless we are debugging

         get_view_id(old_view_id);
         activate_view(_sbbufinfo_view_id);
         top();up();
         for (i=1;i<=p_Noflines;++i) {
            p_line=i;
            get_line(line);
            if (line!='') {
               sbstop_server(line,0);
            }
         }
         _lbclear();
         activate_view(old_view_id);
         _broadcast_message("N EDIT STOP * * *\n");
         _kill(_softmclient_pid);
         for (;;) {
            _process_info('R');
            if (!_softmclient_pid) {
               break;
            }
         }
         return;
      }
      get_view_id(old_view_id);
      activate_view(_sbbufinfo_view_id);
      top();
      status=search(_escape_re_chars(triple)"$",'@r');
      if (status) {
         activate_view(old_view_id);
         _message_box('could not find triple <'triple'>');
      } else {
         buf_id=p_line;

         stbufinfo_buf_id=p_buf_id;

         p_buf_id=buf_id;

         buf_name=p_buf_name;

         p_buf_id=stbufinfo_buf_id;
         activate_view(old_view_id);
         //messageNwait('buf_name='buf_name' buf_id='buf_id ' sb='stbufinfo_buf_id);
         if (doquit) {
            _save_non_active(buf_name,1);
            //if (!status) {
            //   _broadcast_message("N EDIT STOP "triple"\n");
            //}
         } else {
            _sbremove_marks(buf_id);
            _broadcast_message("N EDIT STOP "triple"\n");
         }
         get_view_id(old_view_id);
         activate_view(_sbbufinfo_view_id);
         p_line=buf_id;
         replace_line('');
         activate_view(old_view_id);
      }
   }
}
_exit_softbench()
{
   if (!_softbench_running()) return(0);
   sbstop_server('-',0);
   _kill(_canon_pid);
}
/* There is no problem if nother request comes in before we are
   finished processing this one, because we won't read the request until
   we are done processing this one anyway.
*/
_sbstatus_busy()
{
   if (_softmclient_pid) {
      _sballow_read=0;
      _broadcast_message("N EDIT STATUS * * * * BUSY\n");
   }
}
_sbstatus_ready()
{
   if (_softmclient_pid) {
      _sballow_read=1;
      _broadcast_message("N EDIT STATUS * * * * READY\n");
   }
}
static get_bufinfo(buf_id)
{
   get_view_id(old_view_id);
   activate_view(_sbbufinfo_view_id);
   if (buf_id>p_Noflines) {
      activate_view(old_view_id);
      return('');
   }
   p_line=buf_id;
   get_line(line);
   activate_view(old_view_id);
   return(line);
}
static set_bufinfo(buf_id,line)
{
   //say('buf_id='buf_id' line='line);
   get_view_id(old_view_id);
   activate_view(_sbbufinfo_view_id);
   while (buf_id>p_Noflines) {
      bottom;
      insert_line('');
   }
   p_line=buf_id;
   replace_line(line);
   activate_view(old_view_id);
   return(line);
}
static _sbreload_file(buf_name,modified_msg)
{
   /*
      WARNING!!!!! _message_box and messageNwait can cause another
      buffer to become active, so you can't use these to debug this.
   */
   // Save position info using line number
   save_pos(p,'L');
   if(def_sbwarn_reload_modify && p_modify) {
      old_actapp=def_actapp;
      def_actapp=0;   // Don't want auto-reload to happen here
      if (modified_msg) {
         result=_message_box(nls("Another application has modified the file\n\n '%s'\n\nwhich you have modified.  Do you want to reload it?\n\nThe command \"set-var def_sbwarn_reload_modify 0\" will avoid this message box.",buf_name),'',MB_YESNOCANCEL|MB_ICONQUESTION);
      } else {
         result=_message_box(nls("Another application has requested to reload the file\n\n '%s'\n\nwhich you have modified.  Do you want to reload it anyway?\n\nThe command \"set-var def_sbwarn_reload_modify 0\" will avoid this message box.",buf_name),'',MB_YESNOCANCEL|MB_ICONQUESTION);
      }
      def_actapp=old_actapp;
      // Message box can cause another buffer to become active
      // Reactivate this file.
      _sbactivate_path(buf_name,old_view_id);
   } else {
      result=IDYES;
   }
   if (result==IDYES) {
      // Use def_load_options for network,spill, and undo options. */
      options=''
      if (p_buf_width==1) {
         options='+LW'
      } else if (p_buf_width) {
         options='+'p_buf_width
      }
      if (p_buf_name!=buf_name) {
         _message_box('shit');
         return(FILE_NOT_FOUND_RC);
      }
      status=load_files(def_load_options:+' +q +d +r +lf ':+options' ':+maybe_quote_filename(buf_name));
      if (status) {
         if (status==NEW_FILE_RC) {
            status=FILE_NOT_FOUND_RC;
            _delete_buffer();
            p_file_date=_file_date(p_buf_name,'B');;
         }
         _message_box(nls("Unable to reload %s",buf_name)"\n\n"get_message(status));
         return(status);
      } else {
         restore_pos(p);
         // Update old buffer information
         _next_buffer('H');_prev_buffer('H');
      }
   }
   return(0);
}

static void _sbinsert(data)
{
   if (_on_line0()) {
      status=down();_begin_line();
      if (status) insert_line('');
   }
#if __VERSION__>=1.9
   // This does not do word wrap
   _insert_text(data,0,"\r\n");
#else
   old_state=_insert_state();
   if (!old_state) _insert_toggle();
   // This does word wrap and is slow.
   keyin(data);
   if (old_state!=_insert_state()) _insert_toggle();
#endif
}
/*
    This function does not start with _sb because we may want to
    make it available to all macros.

    This function does not handle a file where the last line does not
    end with some new-line sequence.  This will work just fine under
    version 2.0 and will not need any changes.
*/
static _insert_file(filename,goto_end_of_selection)
{
   if (_on_line0()) {
      status=down();_begin_line();
      if (status) insert_line('');
   }
   mark_id=_alloc_selection();
   if (mark_id=='') return(TOO_MANY_SELECTIONS_RC);
   status=_open_temp_view(filename,temp_view_id,orig_view_id);
   if (status) return(status);
   // IF this file has 0 bytes of data in it
   if (_on_line0()) {
      _delete_temp_view(temp_view_id);
      activate_view(orig_view_id);
      return(0);
   }
   top();
   _select_char(mark_id);
   _nrseek(p_buf_size);
   _select_char(mark_id);
   activate_view(orig_view_id);
   _copy_to_cursor(mark_id);
   if(goto_end_of_selection) _end_select(mark_id);
   _delete_temp_view(temp_view_id);
   return(0);
}
static _sbdelete(data)
{
   if (!isinteger(data)) data=1;
   for (i=1;i<=data;++i) {
      linewrap_delete_char();
   }
}

static _sbnew_line(data)
{
   if (!isinteger(data)) data=1;
   for (i=1;i<=data;++i) {
      split_insert_line();
   }
}
static _sbopen_line(data)
{
   if (!isinteger(data)) data=1;
   for (i=1;i<=data;++i) {
      split_line();
   }
}

static _sbforward_char(data)
{
   if (!isinteger(data)) data=1;
   // Temporarily turn of word wrap
   wrap=p_word_wrap_style&WORD_WRAP_WWS;
   p_word_wrap_style&= ~WORD_WRAP_WWS;
   for (i=1;i<=data;++i) {
      wordwrap_right(1);
   }
   p_word_wrap_style|=wrap;
}

static _sbbackward_char(data)
{
   if (!isinteger(data)) data=1;
   // Temporarily turn of word wrap
   wrap=p_word_wrap_style&WORD_WRAP_WWS;
   p_word_wrap_style&= ~WORD_WRAP_WWS;
   for (i=1;i<=data;++i) {
      wordwrap_left(1);
   }
   p_word_wrap_style|=wrap;
}
static _sbnextprev_pageline(data,option)
{
   if (!isinteger(data)) data=1;
   // We coud force VS to work like the softbench editor, but I don't think
   // this makes sense.

   //old_updown_col=def_updown_col;
   //def_updown_col=1;prev_index(0);
   for (i=1;i<=data;++i) {
      switch (option) {
      case 'NEXT-LINE':
         cursor_down();
         break;
      case 'PREV-LINE':
         cursor_up();
         break;
      case 'NEXT-PAGE':
         page_down();
         break;
      case 'PREV-PAGE':
         page_up();
         break;
      }
   }
   //def_updown_col=old_updown_col;
}

_sbpos_info()
{
   return(_nrseek()' 'p_line' 'p_col);
}
static _sbforward_word(data)
{
   if (!isinteger(data)) data=1;
   for (i=1;i<=data;++i) {
      search('[^ \t]','r');
      search('[ \t]|$','r');
   }
}
static _sbbackward_word(data)
{
   if (!isinteger(data)) data=1;
   for (i=1;i<=data;++i) {
      if (p_col==1) {
         if(up()) break;
         _end_line;
      } else {
         search('[ \t]','r-');
      }
      search('[^ \t]','r-');
      search('(^[^ \t])|([ \t]\c[^ \t])','r-');
   }
}
/*
    This supports {} and () only and not mult-line comments.  The editor
    needs to provide a different comment color for multi-line comments.  In
    addition, it would helpful if the editor would return the begin/end comment
    info for a mlcomment index.
*/
static _sbbeg_of_block(data)
{
   if (!isinteger(data)) data=1;
   status=_sbend_of_block(data);
   if (!status) {
      left;find_matching_paren();
   }
   return(status);
}
static _sbend_of_block(data)
{
   if (!isinteger(data)) data=1;
   color=_clex_find(0,'g');
   if (color!=CFG_COMMENT && color!=CFG_STRING) {
      color='';
   }
   nesting= data;
   save_pos(p);
   status=search('[\(\{\)\}]','@r');
   for (;;) {
      if (status) {
         break;
      }
      tcolor=_clex_find(0,'g');
      if (tcolor!=CFG_COMMENT && tcolor!=CFG_STRING) {
         tcolor='';
      }
      if (color!=tcolor) {
         status=repeat_search();
         continue;
      }
      if (pos(get_text(),'{(')) {
         ++nesting;
      } else {
         --nesting;
         if (nesting<= 0) {
            right();
            break;
         }
      }
      status=repeat_search();
   }
   if (status) {
      restore_pos(p);
   }
   return(status);
}
static _sbset_selection(start_seek,end_seek)
{
   if (isinteger(start_seek) && isinteger(end_seek)) {
      _nrseek(start_seek);
      _deselect();
      _select_char('','C');
      _nrseek(end_seek);
      status=0;
   } else {
      status=INVALID_ARGUMENT_RC;
   }
   return(status);
}
_command sbprofile()
{
   filename=arg(1);
   if (filename=='') {
      _message_box('sbprofile command requires a filename');
      return(1);
   }
   filename=absolute(filename);
   triple=_sbbufname_to_triple(filename);
   // message_type tool_class message_name   host       dir file data
   _broadcast_message("R PROFILE START "triple"\n");
   return(0);
}
_command sbcheck_syntax()
{
   filename=arg(1);
   if (filename=='') {
      _message_box('sbcheck_syntax command requires a filename');
      return(1);
   }
   filename=absolute(filename);
   triple=_sbbufname_to_triple(filename);
   _sbmake_triple=triple;
   // message_type tool_class message_name   host       dir file data
   _broadcast_message("R BUILD COMPILE-FILE "triple" - SYNTAX -\n");
   return(0);
}

_command sbdebug()  name_info(','VSARG2_ICON|VSARG2_READ_ONLY)
{
   bufname=arg(1);
   if (bufname=='') {
      triple=_sbrelfile_to_triple('a.out');
   } else {
      bufname=absolute(bufname);
      triple=_sbbufname_to_triple(bufname);
   }
   _sbmake_triple=triple;
   // message_type tool_class message_name   host       dir file data
   _broadcast_message("R DEBUG LOAD "triple"\n");
}
_command sbmake()  name_info(','VSARG2_ICON|VSARG2_READ_ONLY)
{
   bufname=arg(1);
   if (bufname=='') {
      triple=_sbrelfile_to_triple('*');
   } else {
      bufname=absolute(bufname);
      triple=_sbbufname_to_triple(bufname);
   }
   _sbmake_triple=triple;
   // message_type tool_class message_name   host       dir file data
   _broadcast_message("R BUILD BUILD-TARGET "triple" - -\n");
}
_command sbcm()  name_info(','VSARG2_ICON|VSARG2_READ_ONLY)
{
   parse arg(1) with cmd bufname params
   if (bufname=='') {
      triple=_sbrelfile_to_triple('*');
   } else {
      bufname=absolute(bufname);
      triple=_sbbufname_to_triple(bufname);
   }
   _sbmake_triple=triple;
   // message_type tool_class message_name   host       dir file data
   if (params=='') {
      _broadcast_message("R CM "cmd" "triple:+"\n");
   } else {
      _broadcast_message("R CM "cmd" "triple" "params"\n");
   }
   return(0);
}
static _sbset_mark(data,var new_mark_id_list)
{
   save_pos(p);
   new_mark_id_list='';
   for (;;) {
      parse data with start_seek linenum col data
      // Ignore focus=??? option
      if (pos("=",start_seek)) {
         data=linenum" "col" "data;
         continue;
      }
      if (start_seek=='') {
         status=0;
         break;
      }
      if (start_seek!='*') {
         _nrseek(start_seek);
      } else {
         p_line=linenum;p_col=col;
      }
      mark_id=_alloc_selection('b');
      if (mark_id=='') {
         // VS has no limit so this is very unlikely to happen.
         // Performance will get really bad before we run out of MEMORY
         restore_pos(p);
         status=TOO_MANY_SELECTIONS_RC;
         break;
      }
      _select_char(mark_id);
      new_mark_id_list=new_mark_id_list' 'mark_id
      // Here we are assuming that these are compiler error marks
      // that will traversed in order
#if __VERSION__>=1.9
      // Version 1.9 or higher does not have a string length limit
      _sbmark_list=_sbmark_list' 'mark_id
#else
      // Version <=1.7 has a string length limit 1024
      if (length(_sbmark_list)+length(mark_id)+1>=1024) {
#if 1
         //Remove first 10 marks and do not notify any app
         typeless i;
         for (i=1;i<10;++i) {
            parse _sbmark_list with id _sbmark_list
            _free_selection(id);
         }
#else
         // Give up and notify user.
         restore_pos(p);
         // String too long
         _post_call(find_index('popup_message',COMMAND_TYPE),nls('bookmark ID list string too long'));
         status=1;
         break;
#endif
      }
      _sbmark_list=_sbmark_list' 'mark_id
#endif
   }
   new_mark_id_list=strip(new_mark_id_list);
   _sbmark_list=strip(_sbmark_list);
   if (status) {
      // Free all marks that were successfully allocated.
      for (;;) {
         parse new_mark_id_list with mark_id new_mark_id_list
         if (mark_id=='') break;
         _free_selection(mark_id);
      }
   }
   restore_pos(p);
   return(status);

}
static _sbgo_to_mark(data)
{
   parse data with data option
   if (!isinteger(data)) {
      return(INVALID_ARGUMENT_RC);
   }
   // IF this mark id is valid
   if (pos(" "data" "," "_sbmark_list" ")) {
      _sbgo_to_pos('',data);
      return(0);
   }
   status=INVALID_SELECTION_HANDLE_RC;
   return(status);
}
static _sbclear_mark(data,var cleared_mark_list)
{
   cleared_mark_list='';
   status=0;
   for (;;) {
      parse data with mark_id data;
      if (mark_id=='') break;
      if (!isinteger(mark_id)) {
         continue;
      }
      i=pos('(^| )\c'mark_id'($| )',_sbmark_list,1,'r');
      if (i) {
         j=pos(' ',_sbmark_list,i);
         if (!j) {
            j=length(_sbmark_list)+1;
         }
         _sbmark_list=substr(_sbmark_list,1,i-1):+substr(_sbmark_list,j+1);
         _sbmark_list=strip(_sbmark_list);
         _free_selection(mark_id);status=rc;
      } else {
         status=INVALID_SELECTION_HANDLE_RC;
      }
      if (!status) {
         cleared_mark_list=cleared_mark_list' 'mark_id;
      }
   }
   cleared_mark_list=strip(cleared_mark_list);
   if (cleared_mark_list=='') {
      return(status);
   }
   return(0);
}
_sbgo_to_pos(offsetNline,mark_id)
{
   save_pos(p);
   parse offsetNline with offset line col
   if (offset!='') {
      if (!isinteger(offset)) {
         if (!isinteger(col)) {
            col=1;
         }
         if (!isinteger(line)) line=1;   // Caller has messed up if this happens
         p_line=line;p_col=col;
      } else {
         _nrseek(offset);
      }
   } else {
      _begin_select(mark_id);
   }
#if 1
   // Here we select to end of line
   linenum=p_line;
   col=p_col;
   _deselect();
   _end_line();
   _select_char('','C');
   //_begin_line();
   restore_pos(p);
   p_line=linenum;p_col=col;
   _select_char('','C');
#endif
}
static void _sbremove_marks(buf_id)
{
   list=_sbmark_list;
   cleared_at_least_one=0;
   for (;;) {
      parse list with mark_id list;
      if (mark_id=='') break;
      _get_selinfo(start_col,end_col,mark_buf_id,mark_id);
      if (mark_buf_id==buf_id) {
         cleared_at_least_one=1;
         _sbclear_mark(mark_id,junk);
      }
   }
   if (cleared_at_least_one) {
      triple=get_bufinfo(buf_id);
      _broadcast_notify(new_request_id(), "N EDIT MARKS-REMOVED "triple"\n");
   }
}
static void _sbremove_all_marks()
{
   list=_sbmark_list;
   for (;;) {
      parse list with mark_id list;
      if (mark_id=='') return;
      _get_selinfo(start_col,end_col,mark_buf_id,mark_id);
      _sbremove_marks(mark_buf_id);
      list=_sbmark_list;
   }
}

_command sbnext_error() name_info(','VSARG2_READ_ONLY|VSARG2_ICON)
{
   if (_sbmake_triple=='') {
      _message_box('Must execute sbmake command first to create errors');
      return(1);
   }
   // message_type tool_class message_name   host       dir file data
   _broadcast_message("R BUILD NEXT-ERROR "_sbmake_triple" - -\n");
   return(0);
}

_command sbprev_error() name_info(','VSARG2_READ_ONLY|VSARG2_ICON)
{
   if (_sbmake_triple=='') {
      _message_box('Must execute sbmake command first to create errors');
      return(1);
   }
   // message_type tool_class message_name   host       dir file data
   _broadcast_message("R BUILD PREVIOUS-ERROR "_sbmake_triple" - -\n");
   return(0);
}
_sbhas_errors()
{
   if (_sbmake_triple=='') {
      return(0);
   }
   return(1);
}
/*
   Called from reset_next_error() command.
   This allows the user to bypass SoftBench build messages and use the concurrent
   process buffer instead.
*/
_sbreset_next_error()
{
   _sbmake_triple='';
}

_command sbpush_tag() name_info(TAG_ARG','VSARG2_ICON|VSARG2_READ_ONLY)
{
   param=arg(1);
   if (param=='') {
      if (p_view_id>0) {
         popup_message(nls("This command must operate on a buffer"));
         return(1);
      }
      /* Try to find the procedure at the cursor. */
      status=_sbget_show_param(param)
      if (status) return(status);
      ext=get_extension(p_buf_name)
      if ( lowcase(p_mode_name)=="slick-c" &&
          (file_eq('.'ext,_macro_ext) || file_eq(ext,'cmd')) ) {
         return(find_proc(param))
      }
      parse _sbbufname_to_triple(p_buf_name) with host dir file
      triple=host' 'dir'  *';
   } else {
      triple=_getshow_triple();
   }
   // message_type tool_class message_name   host       dir file data
   _broadcast_message("R STATIC SHOW-DEFINITION "triple" QUIET "param"\n");
   return(0);
}
static _sbstatic_show_list(dlgbox_title,filename,do_push_bookmark)
{
   if (filename=='') return(INVALID_ARGUMENT_RC);
   status=_open_temp_view(filename,temp_view_id,orig_view_id,'+lf');
   if (status) return(status);
   delete_file(filename);
   top();up();
   max_filename_len=0;
   for (;;) {
      if (down()) break;
      get_line(line);
      if (substr(line,1,1)=='#') {
         if(_delete_line()) break;
         up();
         continue;
      }
      parse line with canonfile"\t"
      filename=relative(_sbcanon_to_path(canonfile));
      if (length(filename)>max_filename_len) {
         max_filename_len=length(filename);
      }
   }
   top();up();
   for (;;) {
      if (down()) break;
      get_line(line);
      parse line with canonfile"\t"function"\t"linenum"\t"col"\t"linecontents
      _lbset_item(field(relative(_sbcanon_to_path(canonfile)),max_filename_len):+
                  "("linenum"): "linecontents);
   }
   if (p_Noflines<=0) return('');
   if (p_Noflines==1) {
      get_line(result);
      _delete_temp_view(temp_view_id);
      activate_view(orig_view_id);
   } else {
      activate_view(orig_view_id);
      _sbstatus_busy();
      result=show('-modal _sellist_form -reinit',
               dlgbox_title,
               SL_VIEWID|SL_SELECTCLINE,
               temp_view_id,
               '', // buttons
               '', // help item name
               '',              // font
               ''               // Call back function
              );
      _sbstatus_ready();
      if (result=='') {
         return(COMMAND_CANCELLED_RC);
      }
   }
   parse result with path data;
   parse data with '('linenum'):'
   if (do_push_bookmark && !_no_child_windows()) {
      status=_mdi.p_child.push_bookmark();
      if (status) return(status);
   }
   status=edit(path);
   if (!status) {
      _deselect();
      p_line=linenum;
      p_col=1;
   }
   return(status);
}
static _getshow_triple()
{
   if (p_mdi_child) {
      parse _sbbufname_to_triple(p_buf_name) with host dir file
      triple=host' 'dir'  *';
   } else {
      // Assume we are operating on the current directory
      // We may want to change this to be
      triple=_sbrelfile_to_triple('*');
   }
   return(triple);
}
static _sbget_show_param(var param)
{
   // IF there is selected text.
   if (_select_type()!='') {
      /* duplicate the current marked area to preserve mark type. */
      mark_status=save_selection(old_mark)
      if ( mark_status ) {
         clear_message   /* Not serious error */
      }
      filter_init()
      linenum=p_line;col=p_col;
      param='';
      for (Noflines=0;;++Noflines) {
         status= filter_get_string(string); // get the string
         if ( status ) break;       // Done yet?
         if (Noflines>1) break;
         param=string;
      }
      if (Noflines>1) {
         _post_call(find_index('popup_message',COMMAND_TYPE),nls("Selection can not span multiple lines"));
         return(1);
      }
      if (pos(' ',param)) {
         _post_call(find_index('popup_message',COMMAND_TYPE),nls("Selection can not contain spaces"));
         return(1);
      }
      filter_restore_pos()
      if ( ! mark_status ) {
         restore_selection(old_mark)
      }
      // We are not sure whether the STATIC tool needs a physical column
      // or imaginary column.  The column is not very important.
      // We might need to fix this later.
      param=param' 'strip_filename(p_buf_name,'P')' 'linenum' 'col;
   } else {
      // We are not sure whether the STATIC tool needs a physical column
      // or imaginary column.  The column is not very important.
      // We might need to fix this later.
      param=cur_word(col);
      if ( param=='' ) {
         _post_call(find_index('popup_message',COMMAND_TYPE),nls('No word at cursor'));
         return(1);
      }
      param=param' 'strip_filename(p_buf_name,'P')' 'p_line' 'col;
   }
   return(0);
}
_command sbshow() name_info(','VSARG2_ICON|VSARG2_READ_ONLY)
{
   parse arg(1) with show_suffixcmd param

   triple=_getshow_triple();
   // message_type tool_class message_name   host       dir file data
   if (param=='') {
      // This SHOW command does not requre a parameter
      _broadcast_message("R STATIC SHOW-"upcase(show_suffixcmd)" "triple" NOT_QUIET\n");
      return(0);
   }
   if (param=='()') {
      if (p_view_id>0) {
         popup_message(nls("This command must operate on a buffer"));
         return(1);
      }
      status=_sbget_show_param(param);
      if (status) return(status);
   }
   _broadcast_message("R STATIC SHOW-"upcase(show_suffixcmd)" "triple"  NOT_QUIET "param"\n");
   return(0);
}
#if 0
static host_to_qualified_host(host)
{

}
#endif

static typeless _canon_buffer;
static _file_readln(infh,var buffer,bufsize)
{
   //say('file_readln');
   for (;;) {
      i=pos("\n",buffer);
      if (i) {
         parse buffer with line "\n" buffer;
         //say('line='line' len='length(line));
         return(line);
      }
      len=_file_read(infh,more,bufsize);
      buffer=buffer:+more;
      //say 'buffer='buffer' more='more
      //say('looping');
   }
}
static canon_getstring(command,var line)
{
   //say('command='command);
   if (_canon_cwd!=getcwd()) {
      // Restart canon to give it new current directory
      if (_canon_cwd!='') {
         _kill(_canon_pid);
      }
      status=_pipe_process(_canon_infh,_canon_outfh,_canon_pid,_canon_path,'P');
      if (status) {
         if (status==FILE_NOT_FOUND_RC) {
            _message_box("Could not find canon program");
         } else {
            _message_box("Could not start canon program");
         }
         parse command with pgmname .
         line='/'pgmname'/failed';
         return(status);
      }
      _canon_cwd=getcwd();
   }
#if 1
   //say('h2');
   _file_write(_canon_outfh,command"\n");
   //say('h3');
   line=_file_readln(_canon_infh,_canon_buffer,1024);
   //say('h4');
   //messageNwait('line='line);
   parse line with ':' ' error ' +0 error 'in'
   if (error=='error') {
      parse command with pgmname .
      line='/'pgmname'/failed';
      return(1);
   }
   return(0);
#else
   parse command with pgmname .
   tempfile=_mdi.p_child.mktemp();
   cmdshell='/bin/sh';
   status=shell(command' >'tempfile,'',cmdshell);
   if (status) {
      delete_file(tempfile);
      if (status==FILE_NOT_FOUND_RC) {
         _post_call(find_index('popup_message',COMMAND_TYPE),'Could not find 'pgmname' program.');
      } else {
         _post_call(find_index('popup_message',COMMAND_TYPE),'Could not execute 'pgmname' program. 'get_message(status));
      }
      line='/'pgmname'/failed';
      return(1);
   }
   status=_open_temp_view(tempfile,temp_view_id,orig_view_id);
   delete_file(tempfile);
   if (status) {
      _post_call(find_index('popup_message',COMMAND_TYPE),'Could not open 'pgmname' output temp file.');
      _delete_temp_view(temp_view_id);
      activate_view(orig_view_id);
      line='/'pgmname'/failed';
      return(1);
   }
   get_line(line);
   //say('line='line);
   _delete_temp_view(temp_view_id);
   activate_view(orig_view_id);
   return(0);
#endif
}
_sbcanon_to_path(canonfile)
{
#if 1
   //messageNwait('_sbcanon_to_path');
   status=canon_getstring('canon_to_path 'canonfile,line);
   if (status) {
      return('/_sbcanon_to_path/failed');
   }
   return(line);
#endif
}
_sbtriple_to_path(data)
{
   parse data with host dir file
   return(_sbhdo_to_path(host,dir,file));
}
static _sbhdo_to_triple(host,dir,file)
{
   return(host' 'dir' 'file);
}
_sbhdo_to_path(host,dir,file)
{
#if 1
   //messageNwait('_sbhdo_to_path');
   status=canon_getstring('hdo_to_path 'host' 'dir' 'file,line);
   if (status) {
      return('/_sbhdo_to_path/failed');
   }
   return(line);
#else
   //messageNwait('_hdo_to_path');

   // Check if we are talking to a buffer by this exact triple
   get_view_id(old_view_id);
   activate_view(_sbbufinfo_view_id);
   top();
   status=search(_escape_re_chars(_sbhdo_to_triple(host,dir,file))"$",'@r');
   if (status) {
      activate_view(old_view_id);
   } else {
      buf_id=p_line;
      status=load_files("+q +c +bi "buf_id);
      bufname=p_buf_name;
      if (!status) {
         _quit_view();
      }
      activate_view(old_view_id);
      if (!status) {
         return(bufname);
      }
   }
   //messageNwait('_sbhdo_to_path');
   status=canon_getstring('hdo_to_path 'host' 'dir' 'file,line);
   if (status) {
      return('/_sbhdo_to_path/failed');
   }
   return(line);
#endif
}
_sbbufname_to_triple(buf_name)
{

   //messageNwait('_sbbufname_to_triple');
   parse buf_match(buf_name,1,'xv') with buf_id .
   if (buf_id!='') {
      triple=get_bufinfo(buf_id);
      if (triple!='') {
         //messageNwait('_sbbufname_to_triple quick path');
         return(triple);
      }
   }
   if (_sbversion<=4) {
      // We might want to support an option here.
      return(_hostname' 'getcwd()' 'relative(buf_name));
      // This will reduce the number of tools started.
      //return(_hostname' / 'buf_name);
   }
   status=canon_getstring('choose_host_and_dir NULL NULL',hostNdir);
   if (status) {
      hostNdir='choose_host_and_dir.failed  choose_host_and_dir.failed/';
   }
   status=canon_getstring('path_to_operand 'hostNdir' 'buf_name,file);
   if (status) {
      file='/path_to_operand/failed';
   }
   triple=hostNdir' 'file;
   return(triple);
}
_sbrelfile_to_triple(filename)
{
   //messageNwait('_sbrelfile_to_triple');
   if (_sbversion<=4) {
      if (filename=='*') {
         return(_hostname' 'getcwd()'  'filename);
      }
      filename=absolute(filename);
      return(_hostname' 'getcwd()'  'relative(filename));
   }
   status=canon_getstring('choose_host_and_dir NULL NULL',hostNdir);
   if (status) {
      hostNdir='choose_host_and_dir.failed  choose_host_and_dir.failed/';
   }
   triple=hostNdir' 'filename;
   return(triple);
}
