/*
$VerboseHistory: proctree.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:49a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:48a
 * Comment:
 * Added support for Explorer style open dialog.
 * Change message box to display question mark icon.
 * Added support for editor control.
 *
 * *****************  Version 2  *****************
 * User: Clark       Date: 10/14/1997  Time:09:40a
 * Updated in \vault\vsship30\
 * Last Modified: 10/14/1997 09:40a
 * Comment:
 * Fixed problem that cause the editor to count all
 * lines up to the cursor.  This only had a noticable
 * effect when editing files over about 4 megabytes.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/09/1997 02:26p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'
defeventtab _tbproject_form

#define PROC_TREE_SORT_FUNCTION   0x1
#define PROC_TREE_SORT_LINENUMBER 0x2
#define PROC_TREE_AUTO_EXPAND     0x4
#define PROC_TREE_ONLY_TAGGABLE   0x8

int def_proc_tree_options=PROC_TREE_AUTO_EXPAND|PROC_TREE_SORT_FUNCTION;

//Trying to keep these together since we cant tag'em
#define PROJECT_TB_FORM_NAME_STRING '_tbproject_form'
#define PROC_TREE_NAME '_proc_tree'
//#define PROC_TAB_CAPTION_STRING 'Procs'
#define FILE_DEPTH     1
#define FUNCTION_DEPTH 2
#define TreeInitialized _proc_tree.p_user

//////////////////////////////////////////////////////////////////////////////
// Timer used for delaying updates after change-selected events,
// allowing you to quickly scroll through the items in the proc-tree
// It is safer for this to global instead of static.
//
int gProcTreeFocusTimerId=-1; 


//////////////////////////////////////////////////////////////////////////////
// Called when this module is loaded (before defload).  Used to
// initialize the timer variable and window IDs.
// 
definit()
{
   // IF editor is initalizing from invocation
   if (arg(1)!='L') {
      gProcTreeFocusTimerId=-1;
   }
}

static boolean IsSpecialFile(_str a)
{
   a=strip(a,'b','"');
   return(a=='' || 
          a=='.process' || 
          substr(a,1,7)=="List of" || 
          substr(a,1,12)=="Directory of");
}

static int FindNode(_str Caption,int bufid)
{
   Caption=strip(Caption,'B','"');
   return(_TreeSearch(TREE_ROOT_INDEX,Caption,_fpos_case,bufid));
}

static void StoreSortOptions(_str Path,_str BufferOptions)
{
   _str OptionsTable:[];
   OptionsTable=_TreeGetUserInfo(TREE_ROOT_INDEX);
   int temp;
   temp=(int)BufferOptions;
   temp&=~(PROC_TREE_AUTO_EXPAND|PROC_TREE_ONLY_TAGGABLE);
   Path=strip(Path,'B','"');
   OptionsTable:[Path]=temp;
   _TreeSetUserInfo(TREE_ROOT_INDEX,OptionsTable);
}

static _str GetOptions(_str Path)
{
   Path=strip(Path,'B','"');
   _str OptionsTable:[];
   OptionsTable=_TreeGetUserInfo(TREE_ROOT_INDEX);
   if (OptionsTable._varformat()!=VF_HASHTAB) {
      return('');
   }
   if (OptionsTable._indexin(Path)) {
      return(OptionsTable:[Path]);
   }else{
      return('');
   }
}

static void SortProcTree(int ParentIndex,int Options)
{
   if (Options&PROC_TREE_SORT_FUNCTION) {
      _TreeSortCaption(ParentIndex,'i','N');
   }else if (Options&PROC_TREE_SORT_LINENUMBER) {
      _TreeSortUserInfo(ParentIndex,'N');
   }
#if 0
   Path=_TreeGetUserInfo(ParentIndex);
   StoreSortOptions(Path,Options);
#endif
}

//Arg(2)!='' means just add the file
static int MaybeAddFilename(_str BufName,int bufid)
{
   filename=strip_filename(BufName,'P');
   filename=strip(filename,'B','"');
   path=BufName;
   if (BufName=='') return(-1);
   ext=_mdi.p_child._buf2ext();
   if (IsSpecialFile(BufName)) {
      filename=path;
   }
   Taggable=find_index(ext'_proc_search',PROC_TYPE);
   index=FindNode(filename,bufid);
   if (index>-1) {
      //Look to see if the mode has changed
      _TreeGetInfo(index,state,bmindex,bmindex2);
      //if (Taggable && bmindex==_pic_sm_file_d) {
      //   _TreeSetInfo(index,state,_pic_sm_file,_pic_sm_file);
      //}else if (!Taggable && bmindex==_pic_sm_file) {
      //   _TreeSetInfo(index,state,_pic_sm_file_d,_pic_sm_file_d);
      //   if (_TreeGetFirstChildIndex(index)>=0) _TreeDelete(index,'C');
      //}
      if (Taggable && bmindex==_pic_file_d) {
         _TreeSetInfo(index,state,_pic_file,_pic_file);
      }else if (!Taggable && bmindex==_pic_file) {
         _TreeSetInfo(index,state,_pic_file_d,_pic_file_d);
         if (_TreeGetFirstChildIndex(index)>=0) _TreeDelete(index,'C');
      }
   }else if (index<0) {
      InitState=(!(!(def_proc_tree_options&PROC_TREE_AUTO_EXPAND)) && TreeInitialized);
      if (Taggable || !(def_proc_tree_options&PROC_TREE_ONLY_TAGGABLE)) {
         //pic_index=Taggable?_pic_sm_file:_pic_sm_file_d;
         pic_index=Taggable?_pic_file:_pic_file_d;
         index=_TreeAddItem(TREE_ROOT_INDEX,//Relative Index
                            filename,       //Caption
                            TREE_ADD_AS_CHILD|TREE_ADD_SORTED_FILENAME, //Flags
                            pic_index,   //Collapsed Bitmap Index
                            pic_index,   //Expanded Bitmap Index
                            InitState);             //Initial State
         _TreeSetUserInfo(index,bufid/*maybe_quote_filename(path)*/);
         StoreSortOptions(bufid/*maybe_quote_filename(path)*/,def_proc_tree_options);
      }
      //say "Inserting file: "filename
   }
   CaptionName=ctlcurpath._ShrinkFilename(stranslate(BufName,'&&','&'),_proc_tree.p_width);
   if (CaptionName!=ctlcurpath.p_caption) {
      ctlcurpath.p_caption=CaptionName;
   }
   return(index);
}

static int GetProcTreeWID()
{
   static int LastTreeWID;

   if (_iswindow_valid(LastTreeWID) && 
       LastTreeWID.p_object==OI_TREE_VIEW &&
       !LastTreeWID.p_edit &&
       LastTreeWID.p_name==PROC_TREE_NAME){
      wid=LastTreeWID;
   }else{
      wid=_find_formobj(PROJECT_TB_FORM_NAME_STRING,'N');
      if (wid) {
         wid=wid._proc_tree;
      }else{
         wid=0;
      }
      LastTreeWID=wid;
   }
   return(wid);
   //return(wid._find_control('_proc_tree'));
}

void _document_renamed_proc_tree(int buf_id,_str old_bufname,_str new_bufname,int buf_flags)
{
   _buffer_renamed_proc_tree(buf_id,old_bufname,new_bufname,buf_flags);
}
void _buffer_renamed_proc_tree(int buf_id,_str old_bufname,_str new_bufname,int buf_flags)
{
   if (buf_flags & HIDE_BUFFER) {
      return;
   }
   if (old_bufname=='') {
      //Came form _document_renamed_proc_tree and just used the old docname, which 
      //was blank
      orig_view_id=p_view_id;
      p_view_id=HIDDEN_VIEW_ID;
      _safe_hidden_window();
      status=load_files('+bi 'buf_id);
      if (status) {
         return;//We can't find it....
      }
      old_bufname=p_buf_name;
      p_view_id=orig_view_id;
   }
   treewid=GetProcTreeWID();
   if (!treewid) return;
   filename=old_bufname;
   if (!IsSpecialFile(filename)) {
      filename=strip_filename(old_bufname,'P');
   }
   index=treewid.FindNode(filename,buf_id);
   if (index>=0) {
      treewid._TreeDelete(index);
      //treewid._TreeSetCaption(index,strip_filename(new_bufname,'P'));
      //treewid._TreeSetUserInfo(index,maybe_quote_filename(new_bufname));
   }
   #if 0
   newfilename=new_bufname;
   if (!IsSpecialFile(newfilename)) {
      newfilename=maybe_quote_filename(newfilename);
   }
   treewid.MaybeAddFilename(newfilename);
   #else
   treewid.MaybeAddFilename(new_bufname,buf_id);
   #endif 
}


void _buffer_add_proc_tree()
{
   if (arg(3) && HIDE_BUFFER) {
      return;
   }
   filename=maybe_quote_filename(arg(2));
   treewid=GetProcTreeWID();
   if (!treewid) {
      return;
   }
   wid=p_window_id;
   treewid.p_visible=0;
   //_UpdateCurrentTag();
   if (!IsSpecialFile(filename)) {
      filename=absolute(filename);
   }
   int orig_autotag_flags = def_autotag_flags2;
   def_autotag_flags2 = 0;
   treewid.MaybeAddFilename(filename,arg(1));
   def_autotag_flags2 = orig_autotag_flags;
   treewid.p_visible=1;
   p_window_id=wid;
}

void _cbmdibuffer_hidden_()
{
   _cbquit_proc_tree(p_buf_id,p_buf_name,p_DocumentName,p_buf_flags);
}

#if 1
void _cbquit_proc_tree(int buf_id,_str buf_name,_str DocumentName,int buf_flags)
{
   if (DocumentName!="") {
      buf_name=DocumentName;
   }
   treewid=GetProcTreeWID();
   if (!treewid) return;
   filename=buf_name;
   if (!IsSpecialFile(filename)) {
      filename=strip_filename(buf_name,'P');
   }
   index=treewid.FindNode(filename,buf_id);
   if (index>=0) {
      treewid._TreeDelete(index);
   }
}
#else
void _switchbuf_proc_tree()
{
   treewid=GetProcTreeWID();
   if (treewid) {
      if (arg(2)=='') {
#if 0
         oldfilename=strip_filename(arg(1),'P');
         index=treewid.FindNode(oldfilename,arg(1));
         if (index>=0) {
            if (def_proc_tree_options&PROC_TREE_AUTO_EXPAND) {
               treewid._TreeSetInfo(index,0);
            }
         }
         if (!(p_buf_flags&HIDE_BUFFER)) {
            //filename=strip_filename(p_buf_name,'P')"\t"p_buf_name;
            index=treewid.MaybeAddFilename(p_buf_name);
            if (index>=0) treewid._TreeSetCurIndex(index);
         }
#endif
      }else if (arg(2)=='Q') {
         path=arg(1);
         filename=strip_filename(path,'P');
         if (IsSpecialFile(path)) {
            filename=path;
         }
         index=treewid.FindNode(filename,_mdi.p_child.p_buf_id);
         if (index>=0) {
            treewid._TreeDelete(index);
         }
      }
   }
}
#endif
static _str _GetDocumentName()
{
   if (p_DocumentName!='') {
      return(p_DocumentName);
   }
   return(p_buf_name);
}

_proc_tree.on_create()
{
   def_autotag_flags2 |= AUTOTAG_CURRENT_CONTEXT;
   ctlcurpath.p_caption='';
   ctlcurpath.p_width=0;
   if (TreeInitialized=='') {
      TreeInitialized=0;
      return('');
   }else if (!TreeInitialized) {
      first=_mdi.p_child.p_buf_id;
      index=0;
      max=0;
      longest=0;
      mou_hour_glass(1);
      for (;;) {
            _mdi.p_child._next_buffer('HR');
            restore_filename=editor_name('p'):+_WINDOW_CONFIG_FILE;
            if (!(_mdi.p_child.p_buf_flags&HIDE_BUFFER) && 
                !(file_eq(strip_filename(_mdi.p_child._GetDocumentName(),'P'),_WINDOW_CONFIG_FILE))) {
                  index=MaybeAddFilename(_mdi.p_child._GetDocumentName(),_mdi.p_child.p_buf_id);
            }
            if (_mdi.p_child.p_buf_id==first) break;
      }
      if (index>=0) {
         _TreeSetCurIndex(index);
      }
      TreeInitialized=1;
      mou_hour_glass(0);
   }
   refresh();
}

//Arg(1)!='' means do not add tags
void _UpdateCurrentTag(boolean AlwaysUpdate=false)
{
   // check arguments
   if (!(def_autotag_flags2 & AUTOTAG_CURRENT_CONTEXT)) {
      return;
   }

   // bail out if focus in in the proctree
   treewid=GetProcTreeWID();
   focuswid=_get_focus();
   if (!treewid || !focuswid || focuswid==treewid) {
      return;
   }

   // no child windows, then bail out of here
   if (_no_child_windows()) {
      treewid.ctlcurpath.p_caption='';
      treewid.ctlcurpath.p_width=0;
      return;
   }

   //If the proc tab is not current, do not update
   tabwid=treewid.p_parent.p_parent;
   if (tabwid.p_ActiveTab!=PROJTOOLTAB_PROCS || tabwid.p_ActiveEnabled==FALSE) {
      return;
   }

   // tree not initialized yet?
   if (!treewid.TreeInitialized) {
      treewid.call_event(treewid,ON_CREATE);
   }

   // find the index of the current buffer
   filename=strip_filename(_mdi.p_child._GetDocumentName(),'P');
   if (IsSpecialFile(maybe_quote_filename(_mdi.p_child._GetDocumentName()))) {
      filename=maybe_quote_filename(_mdi.p_child._GetDocumentName());
   }
   //Cannot get here if no child windows, so this is ok
   index=treewid.FindNode(filename,_mdi.p_child.p_buf_id);

   // get file extension (mode name)
   ext=_mdi.p_child.p_extension;

   // no current tree index, then bail out?
   curIndex=treewid._TreeCurIndex();
   if (curIndex < 0) {
      return;
   }

   // not a hidden buffer, maybe add the filename
   if (!(_mdi.p_child.p_buf_flags&HIDE_BUFFER)) {
      index=treewid.MaybeAddFilename(_mdi.p_child._GetDocumentName(),_mdi.p_child.p_buf_id);
   }
   if (index<0) {
      return;
   }

   // set the current filename caption on top of proc tree
   orig_wid=p_window_id;
   p_window_id=treewid;
   #if 0
   path=_TreeGetUserInfo(index);
   CaptionName=ctlcurpath._ShrinkFilename(path,_proc_tree.p_width);
   if (ctlcurpath.p_caption!=CaptionName) {
      ctlcurpath.p_caption=CaptionName;
   }
   #endif 

   // get the index of the current function and parent
   OpenIndex=_TreeCurIndex();
   if (_TreeGetDepth(OpenIndex)==FUNCTION_DEPTH) {
      OpenIndex=_TreeGetParentIndex(OpenIndex);
   }
   OrigParentIndex=OpenIndex;

   // get complete file path and options
   NewPath=_TreeGetUserInfo(index);
   sortop=GetOptions(NewPath);
   _TreeGetInfo(index,state);
   OrigNumDown=-1;
   AddedTags=0;
   origCap=_TreeGetCaption(_TreeCurIndex());
   if ((AlwaysUpdate || (!(_mdi.p_child.p_ModifyFlags&MODIFYFLAG_PROCTREE_UPDATED) 
       && _idle_time_elapsed()>=300)) &&
       (state>0||def_proc_tree_options&PROC_TREE_AUTO_EXPAND)) {

      // add the tags, simply transfer over from context tree
      _mdi.p_child._UpdateContext(true);
      //say("_UpdateCurrentTag");
      _TreeBeginUpdate(index);
      cb_prepare_expand(p_active_form,p_window_id,index);
      tag_tree_insert_context(p_window_id, index, def_proctree_flags, 1, -1, 0);
      _TreeEndUpdate(index);
      SortProcTree(index,def_proc_tree_options);
      _mdi.p_child.p_ModifyFlags|=MODIFYFLAG_PROCTREE_UPDATED;
      p_window_id=orig_wid;
      return;

   } else if ((sortop & def_proc_tree_options) &&
              (def_proc_tree_options&PROC_TREE_AUTO_EXPAND) && 
             (!(_mdi.p_child.p_ModifyFlags&MODIFYFLAG_PROCTREE_UPDATED) && 
              !AlwaysUpdate)) {
      p_window_id=orig_wid;
      return;
   }
   
   _TreeGetInfo(index,FileNodeState);
   if (!(def_proc_tree_options&PROC_TREE_AUTO_EXPAND) && !FileNodeState) {
      _TreeSetCurIndex(index);
      //say('2 '_TreeGetCaption(index));
   } else {
      _mdi.p_child._UpdateContext(true);
      //say("_UpdateCurrentTag");
      int EditorLN = _mdi.p_child.p_RLine;
      context_id = tag_nearest_context(EditorLN);
      tag_get_detail2(VS_TAGDETAIL_context_line, context_id, line_num);
      int nearLine   = 0;
      int nearIndex  = index;
      int tagIndex   = _TreeGetFirstChildIndex(index);
      while (tagIndex > 0) {
         tagLineNum = _TreeGetUserInfo(tagIndex);
         if (tagLineNum == line_num) {
            nearIndex = tagIndex;
            break;
         }
         if (tagLineNum <= EditorLN && tagLineNum > nearLine) {
            nearIndex = tagIndex;
            nearLine  = tagLineNum;
         }
         tagIndex = _TreeGetNextSiblingIndex(tagIndex);
      }
      _TreeSetCurIndex(nearIndex);
      //if (nearIndex >= 0) {
      //   _TreeSetCurIndex(nearIndex);
      //} else {
      //   _TreeSetCurIndex(index);
      //}
   }

   // collapse old file node if it was left open
   CurIndex=_TreeCurIndex();
   if (OpenIndex!=CurIndex &&
       OpenIndex!=_TreeGetParentIndex(CurIndex) &&
       def_proc_tree_options&PROC_TREE_AUTO_EXPAND) {
      _TreeSetInfo(OpenIndex,0);
   }
   // expand current file index if autoexpand
   if (_TreeGetParentIndex(CurIndex)==TREE_ROOT_INDEX &&
       (def_proc_tree_options&PROC_TREE_AUTO_EXPAND)) {
      _TreeSetInfo(CurIndex,1);
   }

   p_window_id=orig_wid;
}

_proc_tree.lbutton_double_click()
{
   index=_TreeCurIndex();
   if (_TreeGetDepth(index)==FILE_DEPTH) {
      if (!(def_proc_tree_options&PROC_TREE_AUTO_EXPAND)) {
         bufid=_TreeGetUserInfo(index);
         fid=p_active_form;
         status=edit('+bi 'bufid);
         fid._proc_tree.call_event(find_index('_ul2_tree',EVENTTAB_TYPE),LBUTTON_DOUBLE_CLICK,'E');
         return('');
      }
   }
   call_event(find_index('_ul2_tree',EVENTTAB_TYPE),LBUTTON_DOUBLE_CLICK,'E');
}

void _proc_tree.' '()
{
   index=_TreeCurIndex();
   if (_TreeGetDepth(index)==FUNCTION_DEPTH) {
      ParentIndex=_TreeGetParentIndex(index);
      orig_wid=p_window_id;
#if 1
      if (_no_child_windows()) {
         return;
      }
      _mdi.p_child.push_bookmark();
#else
//11:18am 8/5/1998
//I don't think this makes sense
      if (!_no_child_windows()) {
         _mdi.p_child.push_bookmark();
         return;
      }
#endif
      if (ParentIndex>=0) {
         bufid=_TreeGetUserInfo(ParentIndex);
         edit('+bi 'bufid);
         p_window_id=orig_wid;
      }
      LineNumber=_TreeGetUserInfo(index);
      ParentIndex=_TreeGetParentIndex(index);
      path=_TreeGetCaption(ParentIndex);
      CaptionName=ctlcurpath._ShrinkFilename(stranslate(path,'&&','&'),_proc_tree.p_width);
      if (ctlcurpath.p_caption!=CaptionName) {
         ctlcurpath.p_caption=CaptionName;
      }
      _mdi.p_child.p_line=LineNumber;

      if (_mdi.p_child.p_scroll_left_edge>=0) {
         _mdi.p_child.p_scroll_left_edge= -1
      }
      _mdi.p_child.center_line();
   }
}

//////////////////////////////////////////////////////////////////////////////
// This is the timer callback.  Whenever the current index (cursor position)
// for the proc tree is changed, a timer is started/reset.  If no
// activity occurs within a set amount of time, this function is called to
// update the output window.
//
static void _ProcTreeFocusTimerCallback()
{
   // kill the timer
   _kill_timer(gProcTreeFocusTimerId);
   gProcTreeFocusTimerId=-1;

   // get the class browser form window id
   int f;
   f=_find_formobj(PROJECT_TB_FORM_NAME_STRING,'N');
   if (!f) {
      return;
   }
   _nocheck _control _proc_tree;

   // find the tag name, file and line number  
   index = f._proc_tree._TreeCurIndex();
   LineNumber=f._proc_tree._TreeGetUserInfo(index);
   ParentIndex=f._proc_tree._TreeGetParentIndex(index);
   if (!ParentIndex) {
      return;
   }
   bid=f._proc_tree._TreeGetUserInfo(ParentIndex);
   orig_view_id=p_view_id;
   orig_wid=p_window_id;
   p_view_id=HIDDEN_VIEW_ID;
   _safe_hidden_window();
   _str path='';
   status=load_files('+q +bi 'bid);
   if (!status) {
      path=p_buf_name;
   }
   p_view_id=orig_view_id;
   p_window_id=orig_wid;
   caption = f._proc_tree._TreeGetCaption(index);
   parse caption with caption "\t" rest;
   if (pos('()(', caption)) {
      parse caption with proc_name '()(' rest;
      proc_name = proc_name '()';
   }
   else {
      parse caption with proc_name '(' rest;
   }
   if (pos('operator ', proc_name)==1) {
      proc_name = substr(proc_name, 10);
   }

   // find the output tagwin and update it
   _nocheck _control ctltagname;
   f = _GetTagwinWID();
   if (f && proc_name != '') {    
      //_message_box(path'\t'LineNumber'\t'proc_name);
      f.ctltagname.p_user = path "\t" LineNumber "\tJUST_GO_THERE";
      f.ctltagname.p_text = proc_name;
   }

   // update the properties toolbar
   struct VS_TAG_BROWSE_INFO cm;
   if (_GetContextTagInfo(cm, '', proc_name, path, LineNumber)) {
      cb_refresh_property_view(cm);
   }
}

//_str _proc_tree.on_change(int reason,int index)
_str _proc_tree.on_change(int reason,int index)
{
   if (!(def_autotag_flags2 & AUTOTAG_CURRENT_CONTEXT)) {
      return('');
   }
   if (reason==CHANGE_SCROLL) return('');

   int depth=_TreeGetDepth(index);
   //say("depth="depth" index="index" reason="reason);
   if (depth==FILE_DEPTH && (reason==CHANGE_EXPANDED || reason==CHANGE_LEAF_ENTER)) {
      NewFile=_TreeGetCaption(index);
      bufid=_TreeGetUserInfo(index);
      sortop=GetOptions(bufid);
#if 0
      if (file_eq(NewPath,_mdi.p_child._GetDocumentName()) && _TreeGetFirstChildIndex(index)>=0) {
         _TreeSetInfo(index,1);
         return('');
      }
#endif
      //Find old tree node and close it
      OldPath=_mdi.p_child._GetDocumentName();
      OldIndex=FindNode(strip_filename(_mdi.p_child._GetDocumentName(),'P'),_mdi.p_child.p_buf_id);
      if (OldIndex>-1) {
         _TreeSetInfo(OldIndex,0);
      }
      //Open file that we clicked on
      treewid=p_window_id;
      buf_option='';
#if 0
      path=strip(NewPath,'b','"');
      SpecialFile=IsSpecialFile(path);
      if (SpecialFile) {
         buf_option='+b';
         NewPath=strip(NewPath,'b','"');
      }
      if (buf_match(strip(NewPath,'B','"'),1,'E')!='') {
         buf_option='+b';
      }
      status=edit(buf_option' 'strip(NewPath,'B','"'));
#else
      status=edit('+bi 'bufid);
#endif
      p_window_id=treewid;
      new_index='';
      if (_TreeGetFirstChildIndex(index)<0) {
         if (0/*SpecialFile*/) {
            return('');
         }else{
            ext=_mdi.p_child._buf2ext();
         }
         _UpdateCurrentTag(true);
         //LTIndex=find_index('vs'ext'_list_tags',PROC_TYPE);
         //PSIndex=0;
         //if (!LTIndex) PSIndex=find_index(ext'_proc_search',PROC_TYPE);
         //if (!PSIndex && !LTIndex) return('');
         //if (!(_mdi.p_child.p_ModifyFlags&MODIFYFLAG_PROCTREE_UPDATED)) {
         //   AddTags(index,LTIndex,PSIndex);
         //   new_index=index;
         //}else if (!(sortop&def_proc_tree_options)) {
         //   SortProcTree(index,def_proc_tree_options);
         //   //_TreeSetUserInfo(index,NewPath/*' 'def_proc_tree_options*/);
         //   StoreSortOptions(NewPath,def_proc_tree_options);
         //}
      }
      _mdi.p_child._set_focus();
      return(new_index);
   }else if (depth==FUNCTION_DEPTH && reason==CHANGE_LEAF_ENTER) {
      ParentIndex=_TreeGetParentIndex(index);
      if (!_no_child_windows()) {
         _mdi.p_child.push_bookmark();
      }
      if (ParentIndex>=0) {
         bufferid=_TreeGetUserInfo(ParentIndex);
         if (1/*!file_eq(filename,_mdi.p_child._GetDocumentName())*/) {
            wid=p_window_id;
            status=edit('+bi 'bufferid);
            p_window_id=wid;
         }
      }
      int LineNumber=_TreeGetUserInfo(index);
      _str cap=_TreeGetCaption(index);
      ParentIndex=_TreeGetParentIndex(index);
      path=_TreeGetCaption(ParentIndex);
      CaptionName=ctlcurpath._ShrinkFilename(stranslate(path,'&&','&'),_proc_tree.p_width);
      if (ctlcurpath.p_caption!=CaptionName) {
         ctlcurpath.p_caption=CaptionName;
      }
      p_window_id=_mdi.p_child;
      p_line=LineNumber;

      if (p_scroll_left_edge>=0) {
         p_scroll_left_edge= -1
      }
      center_line();
      _set_focus();
   }else if (depth==FUNCTION_DEPTH && reason==CHANGE_SELECTED) {

      // kill the existing timer
      if (gProcTreeFocusTimerId!= -1) {
         _kill_timer(gProcTreeFocusTimerId);
         gProcTreeFocusTimerId=-1;
      }
      // don't create a new timer unless there is something to update
      if ((_GetTagwinWID() || _GetCBrowserPropsWID()) && _get_focus()==p_window_id) {
         gProcTreeFocusTimerId=_set_timer(50,_ProcTreeFocusTimerCallback);
      }
   }
   return('');
}

void _proc_tree.on_destroy()
{
   p_window_id=_mdi.p_child;
   first=p_buf_id;
   for (;;) {
      p_ModifyFlags&=~MODIFYFLAG_PROCTREE_UPDATED;
      _next_buffer('HR');
      if (p_buf_id==first) break;
   }
}

_proc_tree.rbutton_up()
{
   // kill the refresh timer, prevents delays before the menu comes
   // while the refreshes are finishing up.
   if (gProcTreeFocusTimerId!= -1) {
      _kill_timer(gProcTreeFocusTimerId);
      gProcTreeFocusTimerId=-1;
   }

   int orig_autotag_flags = def_autotag_flags2;
   def_autotag_flags2 = 0;
   _proc_tree.call_event(_proc_tree,LBUTTON_DOWN);
   index=find_index("_tagbookmark_menu",oi2type(OI_MENU));
   menu_handle=_mdi._menu_load(index,'P');
   index=_proc_tree._TreeCurIndex();
   if (def_proc_tree_options&PROC_TREE_SORT_FUNCTION) {
      _menu_set_state(menu_handle,"sortfunc",MF_CHECKED,'C');
   }else if (def_proc_tree_options&PROC_TREE_SORT_LINENUMBER) {
      _menu_set_state(menu_handle,"sortlinenum",MF_CHECKED,'C');
   }
   if (def_proc_tree_options&PROC_TREE_AUTO_EXPAND) {
      _menu_set_state(menu_handle,"autoexpand",MF_CHECKED,'C');
   }else{
      _menu_set_state(menu_handle,"autoexpand",MF_UNCHECKED,'C');
   }
   if (def_proc_tree_options&PROC_TREE_ONLY_TAGGABLE) {
      _menu_set_state(menu_handle,"nontaggable",MF_UNCHECKED,'C');
   }else{
      _menu_set_state(menu_handle,"nontaggable",MF_CHECKED,'C');
   }

   // configure the display filtering flags
   pushTgConfigureMenu(menu_handle, def_proctree_flags, 1);

   mou_get_xy(x,y);
   _KillToolTipMessages();
   TreeDisablePopup(DelaySetting);
   status=_menu_show(menu_handle,VPM_RIGHTBUTTON,x-1,y-1);
   def_autotag_flags2 = orig_autotag_flags;
   _menu_destroy(menu_handle);
   TreeEnablePopup(DelaySetting);
}

static void DeleteUntaggableFileNodes(int index)
{
   filename=_TreeGetCaption(index);

   //We don't want to delete files that that have a taggable mode different
   //from the extension
   status=_open_temp_view(_TreeGetUserInfo(index),temp_view_id,orig_view_id,'+b');
   if (status) return;
   ext=_buf2ext();
   p_view_id=orig_view_id;
   _delete_temp_view(temp_view_id);
   if (find_index('vs'ext'_list_tags',PROC_TYPE)) return;
   if (find_index(ext'_proc_search',PROC_TYPE)) return;
   _TreeDelete(index);
}

static void AddUntaggableFiles()
{
   first=_mdi.p_child.p_buf_id;
   index=0;
   max=0;
   longest=0;
   for (;;) {
      _mdi.p_child._next_buffer('HR');
      restore_filename=editor_name('p'):+_WINDOW_CONFIG_FILE;
      if (!(_mdi.p_child.p_buf_flags&HIDE_BUFFER) && 
          !(file_eq(strip_filename(_mdi.p_child._GetDocumentName(),'P'),_WINDOW_CONFIG_FILE))) {
         index=MaybeAddFilename(_mdi.p_child._GetDocumentName(),_mdi.p_child.p_buf_id);
      }
      if (_mdi.p_child.p_buf_id==first) break;
   }
   if (index>=0) {
      _TreeSetCurIndex(index);
   }
}

static void CollapseAll(int index)
{
   _TreeSetInfo(index,0); 
}

static void ExpandAll(int index)
{
   _TreeSetInfo(index,1);
}

static void TraverseFiles(typeless pfn)
{
   index=_TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   for (;;) {
      if (index<0) break;
      nextindex=_TreeGetNextSiblingIndex(index);
      (*pfn)(index);
      index=nextindex;
   }
}

_command ProcTreeRunMenu() name_info(','VSARG2_CMDLINE)
{
   if (arg(1)=='') {
      return('');
   }
   olddef_proc_tree_sort=def_proc_tree_options;
   switch (lowcase(arg(1))) {
   case 'sortfunc':
      def_proc_tree_options|=PROC_TREE_SORT_FUNCTION;
      def_proc_tree_options&=~PROC_TREE_SORT_LINENUMBER;
      break;
   case 'sortlinenum':
      def_proc_tree_options|=PROC_TREE_SORT_LINENUMBER;
      def_proc_tree_options&=~PROC_TREE_SORT_FUNCTION;
      break;
   case 'autoexpand':
      if (def_proc_tree_options&PROC_TREE_AUTO_EXPAND) {
         def_proc_tree_options&=~PROC_TREE_AUTO_EXPAND;
         TraverseFiles(CollapseAll);
      }else{
         def_proc_tree_options|=PROC_TREE_AUTO_EXPAND;
         filename=strip_filename(_mdi.p_child._GetDocumentName(),'P');
         path=_mdi.p_child._GetDocumentName();
         if (IsSpecialFile(path)) filename=path;
         index=FindNode(filename,_mdi.p_child.p_buf_id);
         if (index!=_TreeCurIndex() && index>=0) {
            TraverseFiles(CollapseAll);
            _TreeSetCurIndex(index);
            _TreeSetInfo(index,1);
         }
      }
      break;
   case 'nontaggable':
      if (def_proc_tree_options&PROC_TREE_ONLY_TAGGABLE) {
         def_proc_tree_options&=~PROC_TREE_ONLY_TAGGABLE;
         AddUntaggableFiles();
      }else{
         def_proc_tree_options|=PROC_TREE_ONLY_TAGGABLE;
         TraverseFiles(DeleteUntaggableFileNodes);
      }
      break;
   }
   if (olddef_proc_tree_sort!=def_proc_tree_options &&
       !_no_child_windows()) {
      _config_modify|=CFGMODIFY_DEFVAR;
      index=FindNode(strip_filename(_mdi.p_child._GetDocumentName(),'P'),_mdi.p_child.p_buf_id);
      if (index>=0) {
         SortProcTree(index,def_proc_tree_options);
      }
   }
   _macro('m',_macro('s'))
   _macro_append("def_proc_tree_options="def_proc_tree_options";");
   _mdi.p_child._set_focus();
}

void _proctree_on_expose()
{
   //If the form is just coming up, this stuff will get taken care of
   if (!p_active_form.p_visible) {
      return;
   }
   if (p_ActiveTab==PROJTOOLTAB_PROCS && p_ActiveEnabled==TRUE) {
      _UpdateCurrentTag(true);
      //_mdi.p_child._switchbuf_proc_tree();
   }
}
_str _buf2ext()
{
   if (p_index) {
      parse name_name(p_index) with 'def-options-' ext;
      return(ext);
   }
   return(_bufnameNmode2ext(p_buf_name,p_mode_name));
}
